(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9843,        346]
NotebookOptionsPosition[      6169,        245]
NotebookOutlinePosition[      8223,        289]
CellTagsIndexPosition[      8180,        286]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Display of Numbers", "GuideTitle",
 CellID->23392],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides flexible mechanisms for full typeset formatting of numbers of any \
magnitude and precision, to optimize readability, portability and external \
compatibility."
}], "GuideAbstract",
 CellID->148028434],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general control of number display"
}], "GuideText",
 CellID->4084],

Cell[TextData[{
 Cell[TextData[ButtonBox["PaddedForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PaddedForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "insert padding to align numbers"
}], "GuideText",
 CellID->10075],

Cell["\t", "GuideDelimiter",
 CellID->18786],

Cell[TextData[{
 Cell[TextData[ButtonBox["ScientificForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ScientificForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "scientific notation"
}], "GuideText",
 CellID->15498],

Cell[TextData[{
 Cell[TextData[ButtonBox["EngineeringForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EngineeringForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "engineering notation"
}], "GuideText",
 CellID->24970],

Cell[TextData[{
 Cell[TextData[ButtonBox["InputForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputForm"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["OutputForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OutputForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plain text versions of numbers"
}], "GuideText",
 CellID->6287],

Cell[TextData[{
 Cell[TextData[ButtonBox["CForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CForm"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FortranForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FortranForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "C and Fortran-like \"E\" notation"
}], "GuideText",
 CellID->23847],

Cell[TextData[{
 Cell[TextData[ButtonBox["AccountingForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AccountingForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " negative numbers in ",
 Cell[BoxData["("], "InlineFormula"],
 Cell[BoxData[
  StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
 Cell[BoxData[")"], "InlineFormula"],
 ", etc."
}], "GuideText",
 CellID->32604],

Cell["\t", "GuideDelimiter",
 CellID->503],

Cell[TextData[{
 Cell[TextData[ButtonBox["BaseForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BaseForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " display in base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->21221],

Cell["\t", "GuideDelimiter",
 CellID->22663],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberMarks",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberMarks"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " option to include precision information with ",
 Cell[BoxData["`"], "InlineFormula"],
 " marks"
}], "GuideText",
 CellID->5706],

Cell[TextData[{
 Cell[TextData[ButtonBox["$NumberMarks",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$NumberMarks"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " globally determine whether to use ",
 Cell[BoxData["`"], "InlineFormula"],
 " marks for number portability"
}], "GuideText",
 CellID->2363],

Cell["\t", "GuideDelimiter",
 CellID->9010],

Cell[TextData[{
 Cell[TextData[ButtonBox["N",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/N"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " compute to specified precision"
}], "GuideText",
 CellID->319101892]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->18240],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "GuideTutorial",
 CellID->12164],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "GuideTutorial",
 CellID->25542]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->7619],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "GuideMoreAbout",
 CellID->20913],

Cell[TextData[ButtonBox["Math Typesetting Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathTypesettingOptionsAndTweaking"]], "GuideMoreAbout",
 CellID->7591]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->391283908],

Cell[TextData[{
 ButtonBox["Demonstrations related to Display of Numbers",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
AccountingForm+OR+BaseForm+OR+CForm+OR+EngineeringForm+OR+FortranForm+OR+\
InputForm+OR+NumberForm+OR+NumberMarks+OR+OutputForm+OR+PaddedForm+OR+\
ScientificForm+OR+$NumberMarks)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->1434428]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Display of Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 55.9515004}", "context" -> "", 
    "keywords" -> {
     "1D format", "accounting form", "accounting number format", 
      "alignment of decimal points", "alignment of numbers in columns", 
      "alignment of numbers in tables", "approximate numbers", 
      "approximations", "ascii 2D output", "ascii input syntax", 
      "ascii output", "back-tick in numbers", "base form", "binary numbers", 
      "C language", "decimal", "decimal places", "engineering form", 
      "engineering notation", "exponential notation", "Fortran", 
      "Fortran form", "Fortran output", "hexadecimal numbers", "input form", 
      "linear formatting", "linear input", "number base", "number form", 
      "number formatting", "number marks", "octal numbers", "output form", 
      "padded form", "padded formatting", "padded numeric formatting", 
      "scientific form", "scientific notation", "standard form", 
      "string 2D output", "two-dimensional format", "two-dimensional output"},
     "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica provides flexible mechanisms for full typeset formatting of \
numbers of any magnitude and precision, to optimize readability, portability \
and external compatibility.", "synonyms" -> {}, "title" -> 
    "Display of Numbers", "type" -> "Guide", "uri" -> 
    "guide/DisplayOfNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->23392],
Cell[678, 28, 278, 7, 70, "GuideAbstract",
 CellID->148028434],
Cell[959, 37, 261, 9, 70, "GuideText",
 CellID->4084],
Cell[1223, 48, 260, 9, 70, "GuideText",
 CellID->10075],
Cell[1486, 59, 44, 1, 70, "GuideDelimiter",
 CellID->18786],
Cell[1533, 62, 256, 9, 70, "GuideText",
 CellID->15498],
Cell[1792, 73, 259, 9, 70, "GuideText",
 CellID->24970],
Cell[2054, 84, 387, 13, 70, "GuideText",
 CellID->6287],
Cell[2444, 99, 385, 13, 70, "GuideText",
 CellID->23847],
Cell[2832, 114, 406, 13, 70, "GuideText",
 CellID->32604],
Cell[3241, 129, 42, 1, 70, "GuideDelimiter",
 CellID->503],
Cell[3286, 132, 293, 10, 70, "GuideText",
 CellID->21221],
Cell[3582, 144, 44, 1, 70, "GuideDelimiter",
 CellID->22663],
Cell[3629, 147, 319, 10, 70, "GuideText",
 CellID->5706],
Cell[3951, 159, 333, 10, 70, "GuideText",
 CellID->2363],
Cell[4287, 171, 43, 1, 70, "GuideDelimiter",
 CellID->9010],
Cell[4333, 174, 240, 8, 70, "GuideText",
 CellID->319101892]
}, Open  ]],
Cell[CellGroupData[{
Cell[4610, 187, 58, 1, 70, "GuideTutorialsSection",
 CellID->18240],
Cell[4671, 190, 164, 3, 70, "GuideTutorial",
 CellID->12164],
Cell[4838, 195, 152, 3, 70, "GuideTutorial",
 CellID->25542]
}, Open  ]],
Cell[CellGroupData[{
Cell[5027, 203, 58, 1, 70, "GuideMoreAboutSection",
 CellID->7619],
Cell[5088, 206, 138, 3, 70, "GuideMoreAbout",
 CellID->20913],
Cell[5229, 211, 172, 4, 70, "GuideMoreAbout",
 CellID->7591]
}, Open  ]],
Cell[CellGroupData[{
Cell[5438, 220, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->391283908],
Cell[5510, 223, 617, 17, 70, "GuideRelatedLinks",
 CellID->1434428]
}, Open  ]],
Cell[6142, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

