(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12655,        386]
NotebookOptionsPosition[      9208,        290]
NotebookOutlinePosition[     11012,        331]
CellTagsIndexPosition[     10969,        328]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Dynamic Interactivity Language", "GuideTitle",
 CellID->18584],

Cell[TextData[{
 "Fundamental to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s dynamic interactivity capabilities is a new form of symbolic dynamic \
language. With a very small number of highly powerful primitives that mix \
freely with other language constructs, you can write a program in a direct \
symbolic style, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically track dependencies to make controls and output of any \
kind update dynamically."
}], "GuideAbstract",
 CellID->9515],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display as a dynamically updated settable expression of any kind"
}], "GuideText",
 CellID->17913],

Cell[TextData[{
 Cell[TextData[ButtonBox["DynamicModule",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DynamicModule"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "localize dynamic constructs"
}], "GuideText",
 CellID->16142],

Cell[TextData[{
 Cell[TextData[ButtonBox["With",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/With"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "insert static content into a dynamic object"
}], "GuideText",
 CellID->31196],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Control Objects \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ControlObjects"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->21948],

Cell[TextData[{
 Cell[TextData[ButtonBox["Slider",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Slider"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Checkbox",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Checkbox"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PopupMenu",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupMenu"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Locator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Locator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Manipulator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ControlObjects"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->25072],

Cell["\t", "GuideDelimiterSubsection",
 CellID->20426]
}, Open  ]],

Cell[CellGroupData[{

Cell["Low-Level Functions", "GuideFunctionsSubsection",
 CellID->213275285],

Cell[TextData[{
 Cell[TextData[ButtonBox["CurrentValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CurrentValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Refresh",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Refresh"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Clock",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Clock"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EmitSound",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EmitSound"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ControlActive",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControlActive"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->288918699]
}, Open  ]],

Cell[CellGroupData[{

Cell["System Interface", "GuideFunctionsSubsection",
 CellID->304812702],

Cell[TextData[{
 Cell[TextData[ButtonBox["FinishDynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FinishDynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$DynamicEvaluation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/$DynamicEvaluation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$ControlActiveSetting",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$ControlActiveSetting"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->88231521],

Cell[TextData[StyleBox[ButtonBox["Dynamic Updating Enabled",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ref/menuitem/DynamicUpdatingEnabled"], "MenuName"]], \
"InlineGuideFunctionListing",
 CellID->100852907]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->20626],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "GuideTutorial",
 CellID->29812],

Cell[TextData[ButtonBox["Introduction to Manipulate",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToManipulate"]], "GuideTutorial",
 CellID->518038385],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "GuideTutorial",\

 CellID->19375],

Cell[TextData[ButtonBox["Advanced Manipulate Functionality",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AdvancedManipulateFunctionality"]], "GuideTutorial",
 CellID->60121182]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->30093],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "GuideMoreAbout",
 CellID->16565],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "GuideMoreAboutSub",
 CellID->29141],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "GuideMoreAbout",
 CellID->627958272]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dynamic Interactivity Language - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 59.8422250}", "context" -> "", 
    "keywords" -> {
     "animator", "checkbox", "control active", "current value", 
      "dynamic evaluation", "dynamic module", "emit sound", "finish dynamic", 
      "grip", "handle", "knob", "manipulate control", "manipulator", 
      "movable thumb", "observer", "playing a slider", "popup menu", 
      "scrollbar", "slider", "switch", "thumb", "toggle", 
      "update dynamically", "update value", "watch changes", 
      "reactive programming"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Fundamental to Mathematica's dynamic interactivity capabilities is a new \
form of symbolic dynamic language. With a very small number of highly \
powerful primitives that mix freely with other language constructs, you can \
write a program in a direct symbolic style, and Mathematica will \
automatically track dependencies to make controls and output of any kind \
update dynamically.", "synonyms" -> {}, "title" -> 
    "Dynamic Interactivity Language", "type" -> "Guide", "uri" -> 
    "guide/DynamicInteractivityLanguage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 68, 1, 70, "GuideTitle",
 CellID->18584],
Cell[690, 28, 525, 13, 70, "GuideAbstract",
 CellID->9515],
Cell[1218, 43, 432, 12, 70, "GuideText",
 CellID->17913],
Cell[1653, 57, 407, 12, 70, "GuideText",
 CellID->16142],
Cell[2063, 71, 260, 9, 70, "GuideText",
 CellID->31196],
Cell[CellGroupData[{
Cell[2348, 84, 213, 5, 70, "GuideFunctionsSubsection",
 CellID->21948],
Cell[2564, 91, 1954, 50, 70, "InlineGuideFunctionListing",
 CellID->25072],
Cell[4521, 143, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->20426]
}, Open  ]],
Cell[CellGroupData[{
Cell[4612, 149, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->213275285],
Cell[4690, 152, 1757, 44, 70, "InlineGuideFunctionListing",
 CellID->288918699]
}, Open  ]],
Cell[CellGroupData[{
Cell[6484, 201, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->304812702],
Cell[6559, 204, 949, 23, 70, "InlineGuideFunctionListing",
 CellID->88231521],
Cell[7511, 229, 209, 5, 70, "InlineGuideFunctionListing",
 CellID->100852907]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7769, 240, 58, 1, 70, "GuideTutorialsSection",
 CellID->20626],
Cell[7830, 243, 159, 3, 70, "GuideTutorial",
 CellID->29812],
Cell[7992, 248, 169, 3, 70, "GuideTutorial",
 CellID->518038385],
Cell[8164, 253, 175, 4, 70, "GuideTutorial",
 CellID->19375],
Cell[8342, 259, 185, 4, 70, "GuideTutorial",
 CellID->60121182]
}, Open  ]],
Cell[CellGroupData[{
Cell[8564, 268, 59, 1, 70, "GuideMoreAboutSection",
 CellID->30093],
Cell[8626, 271, 169, 3, 70, "GuideMoreAbout",
 CellID->16565],
Cell[8798, 276, 167, 3, 70, "GuideMoreAboutSub",
 CellID->29141],
Cell[8968, 281, 198, 4, 70, "GuideMoreAbout",
 CellID->627958272]
}, Open  ]],
Cell[9181, 288, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

