(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16569,        518]
NotebookOptionsPosition[     12031,        396]
NotebookOutlinePosition[     14286,        443]
CellTagsIndexPosition[     14243,        440]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Dynamic Visualization", "GuideTitle",
 CellID->5994],

Cell[TextData[{
 "Building on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s integrated symbolic architecture it becomes easy to introduce powerful \
dynamic behavior into any aspect of visualization",
 ". ",
 "Single ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbolic functions are all it takes to set up full interactive parameter \
explorations, animations, dynamic annotation or drill-down information \
viewers."
}], "GuideAbstract",
 CellID->664480540],

Cell[TextData[{
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "dynamically manipulate parameters in graphics"
}], "GuideText",
 CellID->1355],

Cell[TextData[{
 Cell[TextData[ButtonBox["Animate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Animate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "animate as a function of one or more parameters"
}], "GuideText",
 CellID->21015],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListAnimate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListAnimate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "animate a list of graphics or other objects"
}], "GuideText",
 CellID->1131],

Cell["\t", "GuideDelimiter",
 CellID->18230],

Cell[TextData[{
 Cell[TextData[ButtonBox["TabView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TabView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make any list of objects be selectable with tabs"
}], "GuideText",
 CellID->17841],

Cell[TextData[{
 Cell[TextData[ButtonBox["SlideView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SlideView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "view any list of objects as a sequence of slides"
}], "GuideText",
 CellID->14625],

Cell[TextData[{
 Cell[TextData[ButtonBox["FlipView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FlipView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "flip between displaying two or more objects"
}], "GuideText",
 CellID->2011],

Cell[TextData[{
 Cell[TextData[ButtonBox["MenuView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MenuView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OpenerView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/OpenerView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PopupView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->522],

Cell["\t", "GuideDelimiter",
 CellID->4186],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tooltip",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tooltip"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "attach any tooltip to any object"
}], "GuideText",
 CellID->19690],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mouseover",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Mouseover"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify what to show when the mouse is over an object"
}], "GuideText",
 CellID->1650],

Cell[TextData[{
 Cell[TextData[ButtonBox["StatusArea",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StatusArea"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "put a string in the window status area"
}], "GuideText",
 CellID->5662],

Cell[TextData[{
 Cell[TextData[ButtonBox["Annotation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Annotation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "attach a general annotation to an object"
}], "GuideText",
 CellID->21634],

Cell[TextData[{
 Cell[TextData[ButtonBox["PopupWindow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupWindow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "attach a popup window to any object"
}], "GuideText",
 CellID->16076661],

Cell["\t", "GuideDelimiter",
 CellID->10893],

Cell[TextData[{
 Cell[TextData[ButtonBox["Locator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Locator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "an object to move around in a graphic"
}], "GuideText",
 CellID->10353],

Cell[TextData[{
 Cell[TextData[ButtonBox["Slider",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Slider"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Slider2D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Slider2D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ColorSlider",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorSlider"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LocatorPane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LocatorPane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ClickPane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ClickPane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ControllerState",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerState"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->486375914],

Cell["\t", "GuideDelimiter",
 CellID->43796591],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControlActive",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControlActive"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify \"preview\" settings when controls are active"
}], "GuideText",
 CellID->32186107]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->13452],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "GuideTutorial",
 CellID->445434225],

Cell[TextData[ButtonBox["Introduction to Manipulate",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToManipulate"]], "GuideTutorial",
 CellID->518038385],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "GuideTutorial",\

 CellID->558945376],

Cell[TextData[ButtonBox["Advanced Manipulate Functionality",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AdvancedManipulateFunctionality"]], "GuideTutorial",
 CellID->60121182],

Cell[TextData[ButtonBox["Views",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Views"]], "GuideTutorial",
 CellID->684899832]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->22233],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "GuideMoreAbout",
 CellID->35391382],

Cell[TextData[ButtonBox["Viewers & Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "GuideMoreAbout",
 CellID->16303],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "GuideMoreAbout",
 CellID->16634],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "GuideMoreAboutSub",
 CellID->14256],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "GuideMoreAboutSub",
 CellID->148],

Cell[TextData[ButtonBox["Gamepad & Device Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GamepadAndDeviceInterface"]], "GuideMoreAboutSub",
 CellID->187473136],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60VisualizationAndGraphics"]], "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dynamic Visualization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 0.3109870}", "context" -> "", 
    "keywords" -> {
     "animate sequence of expressions", "applets", "applet window", 
      "balloon help", "click-interactive", "click-interactive panels", 
      "click pane", "click view", "control active", "controller state", 
      "controls", "cycling between views", "direct manipulation", 
      "event handling", "flip view", "gamepad", "graphical user interface", 
      "grip", "handle", "hit testing", "image map", "imagemap", "interactive",
       "interactive panels", "interface builder", "joystick", "knob", 
      "list animate", "list of frames", "locator pane", "menu view", 
      "mouse interactive", "mouse over", "movable thumb", "multilocator", 
      "opener view", "open viewer", "popup box", "popup view", "popup window",
       "screen tip", "ScreenTip", "scrollbar", "slider", "slider pane", 
      "slide sequence", "slide show", "slide view", "status area", 
      "tab selector", "tab view", "tab view control", "thumb", "thumbs", 
      "user interfaces"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Building on Mathematica's integrated symbolic architecture it becomes \
easy to introduce powerful dynamic behavior into any aspect of visualization. \
Single Mathematica symbolic functions are all it takes to set up full \
interactive parameter explorations, animations, dynamic annotation or \
drill-down information viewers.", "synonyms" -> {}, "title" -> 
    "Dynamic Visualization", "type" -> "Guide", "uri" -> 
    "guide/DynamicVisualization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->5994],
Cell[680, 28, 481, 14, 70, "GuideAbstract",
 CellID->664480540],
Cell[1164, 44, 418, 12, 70, "GuideText",
 CellID->1355],
Cell[1585, 58, 415, 12, 70, "GuideText",
 CellID->21015],
Cell[2003, 72, 418, 12, 70, "GuideText",
 CellID->1131],
Cell[2424, 86, 44, 1, 70, "GuideDelimiter",
 CellID->18230],
Cell[2471, 89, 416, 12, 70, "GuideText",
 CellID->17841],
Cell[2890, 103, 420, 12, 70, "GuideText",
 CellID->14625],
Cell[3313, 117, 412, 12, 70, "GuideText",
 CellID->2011],
Cell[3728, 131, 1039, 26, 70, "InlineGuideFunctionListing",
 CellID->522],
Cell[4770, 159, 43, 1, 70, "GuideDelimiter",
 CellID->4186],
Cell[4816, 162, 400, 12, 70, "GuideText",
 CellID->19690],
Cell[5219, 176, 424, 12, 70, "GuideText",
 CellID->1650],
Cell[5646, 190, 411, 12, 70, "GuideText",
 CellID->5662],
Cell[6060, 204, 414, 12, 70, "GuideText",
 CellID->21634],
Cell[6477, 218, 414, 12, 70, "GuideText",
 CellID->16076661],
Cell[6894, 232, 44, 1, 70, "GuideDelimiter",
 CellID->10893],
Cell[6941, 235, 405, 12, 70, "GuideText",
 CellID->10353],
Cell[7349, 249, 1977, 50, 70, "InlineGuideFunctionListing",
 CellID->486375914],
Cell[9329, 301, 47, 1, 70, "GuideDelimiter",
 CellID->43796591],
Cell[9379, 304, 436, 12, 70, "GuideText",
 CellID->32186107]
}, Open  ]],
Cell[CellGroupData[{
Cell[9852, 321, 58, 1, 70, "GuideTutorialsSection",
 CellID->13452],
Cell[9913, 324, 163, 3, 70, "GuideTutorial",
 CellID->445434225],
Cell[10079, 329, 169, 3, 70, "GuideTutorial",
 CellID->518038385],
Cell[10251, 334, 179, 4, 70, "GuideTutorial",
 CellID->558945376],
Cell[10433, 340, 185, 4, 70, "GuideTutorial",
 CellID->60121182],
Cell[10621, 346, 129, 3, 70, "GuideTutorial",
 CellID->684899832]
}, Open  ]],
Cell[CellGroupData[{
Cell[10787, 354, 59, 1, 70, "GuideMoreAboutSection",
 CellID->22233],
Cell[10849, 357, 163, 3, 70, "GuideMoreAbout",
 CellID->35391382],
Cell[11015, 362, 153, 3, 70, "GuideMoreAbout",
 CellID->16303],
Cell[11171, 367, 159, 3, 70, "GuideMoreAbout",
 CellID->16634],
Cell[11333, 372, 145, 3, 70, "GuideMoreAboutSub",
 CellID->14256],
Cell[11481, 377, 144, 3, 70, "GuideMoreAboutSub",
 CellID->148],
Cell[11628, 382, 171, 3, 70, "GuideMoreAboutSub",
 CellID->187473136],
Cell[11802, 387, 187, 4, 70, "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],
Cell[12004, 394, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

