(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14522,        465]
NotebookOptionsPosition[      9552,        342]
NotebookOutlinePosition[     12536,        398]
CellTagsIndexPosition[     12493,        395]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Elementary Functions", "GuideTitle",
 CellID->11124],

Cell[TextData[{
 "Using the latest platform-optimized code, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " not only delivers high-efficiency machine-precision evaluation of \
elementary functions, but also\[LongDash]using a number of original \
algorithms\[LongDash]provides the world's fastest arbitrary-precision \
evaluation. A sophisticated web of symbolic functions and transformations \
allows ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to perform exact numerical and algebraic operations on elementary \
functions\[LongDash]effortlessly obtaining results that in the past would \
have been viewed as major mathematical accomplishments."
}], "GuideAbstract",
 CellID->956829674],

Cell[TextData[{
 Cell[TextData[ButtonBox["Log",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Log"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " base-",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " logarithm (",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   RowBox[{
    StyleBox["b", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " uses base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->29200],

Cell[TextData[{
 Cell[TextData[ButtonBox["Exp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exp"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " exponential"
}], "GuideText",
 CellID->21080],

Cell[TextData[{
 Cell[TextData[ButtonBox["Power",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Power"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["^",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Power"]], "InlineFunctionSans"],
 ") \[LongDash] power (entered as a superscript using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->21318],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sqrt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sqrt"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " square root (entered using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->16858],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Trigonometric Functions  \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/TrigonometricFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->24050],

Cell[TextData[{
 Cell[TextData[ButtonBox["Degree",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Degree"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[Degree]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Degree"]], "InlineFunctionSans"],
 ") \[LongDash] constant for converting to degrees"
}], "GuideText",
 CellID->24155],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sin"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cos",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cos"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tan"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->31361],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArcSin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcSin"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcCos",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcCos"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcTan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcTan"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->15264],

Cell[TextData[Cell[TextData[ButtonBox["Sinc",
 BaseStyle->"NewInVersionLink",
 ButtonData->"paclet:ref/Sinc"]], "InlineFunctionSans",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]]]], "InlineGuideFunctionListing",
 CellID->11903]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Hyperbolic Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/HyperbolicFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->3676],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sinh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sinh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cosh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cosh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tanh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tanh"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->29643],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArcSinh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcSinh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcCosh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcCosh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcTanh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcTanh"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26909],

Cell["\t", "GuideDelimiter",
 CellID->14902],

Cell[TextData[{
 Cell[TextData[ButtonBox["N",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/N"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numerical evaluation to any precision"
}], "GuideText",
 CellID->3561],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand in terms of simpler functions or smaller arguments"
}], "GuideText",
 CellID->28489],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply full symbolic simplification "
}], "GuideText",
 CellID->24948],

Cell[TextData[{
 Cell[TextData[ButtonBox["Series",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Series"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " series expansion"
}], "GuideText",
 CellID->1282]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->13653],

Cell[TextData[ButtonBox["Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Arithmetic"]], "GuideTutorial",
 CellID->200214354],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "GuideTutorial",
 CellID->2220],

Cell[TextData[{
 ButtonBox["Numerical Mathematics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalMathematicsInMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalMathematicsInMathematica"],
  FontSlant->"Italic"]
}], "GuideTutorial",
 CellID->30674]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->5402],

Cell[TextData[ButtonBox["Arithmetic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ArithmeticFunctions"]], "GuideMoreAboutSub",
 CellID->3878],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "GuideMoreAboutSub",
 CellID->20259]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1302128943],

Cell[TextData[{
 ButtonBox["Demonstrations related to Elementary Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
ArcCos+OR+ArcCosh+OR+ArcSin+OR+ArcSinh+OR+ArcTan+OR+ArcTanh+OR+Cos+OR+Cosh+OR+\
Degree+OR+Exp+OR+FullSimplify+OR+FunctionExpand+OR+Log+OR+N+OR+Power+OR+\
Series+OR+Sin+OR+Sinc+OR+Sinh+OR+Sqrt+OR+Tan+OR+Tanh)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->633833711]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Elementary Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 6.1548866}", "context" -> "", 
    "keywords" -> {
     "acos", "acosh", "alog", "angle", "angle measure", "angle measurement", 
      "angular measure", "antilg", "antilog", "antilogarithm", "arc", "arcch",
       "arc cos", "arc cosh", "arccosine", "arcdegree", "arch", "arcosh", 
      "arcsh", "arc sin", "arcsine", "arc sinh", "arcsinus", "arc tan", 
      "arctangent", "arc tanh", "arctg", "arcth", "arcus cosinus", 
      "arcus sinus", "arcus tangens", "area cosinus hyperbolicus", "argsinh", 
      "arsh", "arsinh", "artanh", "arth", "asin", "asinh", "atan", "atanh", 
      "caret", "ch", "cubed", "decimal places", "degree", "degree of arc", 
      "exponenta", "exponential", "frlog", "gamma function", "hyperbolic cos",
       "hyperbolic cosine", "hyperbolic sine", "hyperbolic sinus", 
      "hyperbolic tan", "hyperbolic tangent", "hypsin", "hyptan", 
      "identities", "ilog", "inverse cosine", "inverse cosine hyperbolic", 
      "inverse hyperbolic tangent", "inverse sin", "inverse sine", 
      "inverse sine hyperbolic function", "inverse sinh", 
      "inverse tan function", "inverse tangent", "inverse tanh", "inverse th",
       "inverse trigonometric function", "ld", "ldexp", "lg", "ln", "log10", 
      "logarithm", "natural logarithm", "plane angle", "pow", "pow10", "pow2",
       "power", "power10", "power2", "radian", "radic", "radical", 
      "raise to a power", "sen", "senh", "sh", "sin", "sine", "sinh", "sinus",
       "special functions", "sqrt", "sqt", "tan", "tangent", "tanh", "tg", 
      "tgh", "th"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Using the latest platform-optimized code, Mathematica not only delivers \
high-efficiency machine-precision evaluation of elementary functions, but \
also--using a number of original algorithms--provides the world's fastest \
arbitrary-precision evaluation. A sophisticated web of symbolic functions and \
transformations allows Mathematica to perform exact numerical and algebraic \
operations on elementary functions--effortlessly obtaining results that in \
the past would have been viewed as major mathematical accomplishments.", 
    "synonyms" -> {}, "title" -> "Elementary Functions", "type" -> "Guide", 
    "uri" -> "guide/ElementaryFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->11124],
Cell[680, 28, 704, 15, 70, "GuideAbstract",
 CellID->956829674],
Cell[1387, 45, 574, 23, 70, "GuideText",
 CellID->29200],
Cell[1964, 70, 221, 8, 70, "GuideText",
 CellID->21080],
Cell[2188, 80, 437, 14, 70, "GuideText",
 CellID->21318],
Cell[2628, 96, 341, 12, 70, "GuideText",
 CellID->16858],
Cell[CellGroupData[{
Cell[2994, 112, 232, 6, 70, "GuideFunctionsSubsection",
 CellID->24050],
Cell[3229, 120, 342, 10, 70, "GuideText",
 CellID->24155],
Cell[3574, 132, 570, 17, 70, "InlineGuideFunctionListing",
 CellID->31361],
Cell[4147, 151, 588, 17, 70, "InlineGuideFunctionListing",
 CellID->15264],
Cell[4738, 170, 311, 6, 70, "InlineGuideFunctionListing",
 CellID->11903]
}, Open  ]],
Cell[CellGroupData[{
Cell[5086, 181, 222, 5, 70, "GuideFunctionsSubsection",
 CellID->3676],
Cell[5311, 188, 576, 17, 70, "InlineGuideFunctionListing",
 CellID->29643],
Cell[5890, 207, 594, 17, 70, "InlineGuideFunctionListing",
 CellID->26909],
Cell[6487, 226, 44, 1, 70, "GuideDelimiter",
 CellID->14902],
Cell[6534, 229, 242, 8, 70, "GuideText",
 CellID->3561],
Cell[6779, 239, 289, 8, 70, "GuideText",
 CellID->28489],
Cell[7071, 249, 263, 8, 70, "GuideText",
 CellID->24948],
Cell[7337, 259, 231, 8, 70, "GuideText",
 CellID->1282]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7617, 273, 58, 1, 70, "GuideTutorialsSection",
 CellID->13653],
Cell[7678, 276, 139, 3, 70, "GuideTutorial",
 CellID->200214354],
Cell[7820, 281, 185, 4, 70, "GuideTutorial",
 CellID->2220],
Cell[8008, 287, 328, 9, 70, "GuideTutorial",
 CellID->30674]
}, Open  ]],
Cell[CellGroupData[{
Cell[8373, 301, 58, 1, 70, "GuideMoreAboutSection",
 CellID->5402],
Cell[8434, 304, 154, 3, 70, "GuideMoreAboutSub",
 CellID->3878],
Cell[8591, 309, 159, 3, 70, "GuideMoreAboutSub",
 CellID->20259]
}, Open  ]],
Cell[CellGroupData[{
Cell[8787, 317, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1302128943],
Cell[8860, 320, 650, 17, 70, "GuideRelatedLinks",
 CellID->633833711]
}, Open  ]],
Cell[9525, 340, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

