(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18544,        573]
NotebookOptionsPosition[     13085,        439]
NotebookOutlinePosition[     16110,        498]
CellTagsIndexPosition[     16067,        495]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Elements of Lists", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a carefully chosen set of functions for accessing elements of \
lists either using indices or positions, or using patterns or criteria for \
their values. "
}], "GuideAbstract",
 CellID->311974586],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["list",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"], "TI"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["...",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 ") \[LongDash] parts of lists, resettable with ",
 Cell[BoxData["="], "InlineFormula"]
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Span",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Span"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " (",
 Cell[TextData[ButtonBox[";;",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Span"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " general specification for spans or blocks of elements"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["First",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/First"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Last",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Last"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rest"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Most",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Most"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Take",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Take"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Drop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Drop"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TakeWhile",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TakeWhile"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->432093640],

Cell["\t", "GuideDelimiter",
 CellID->22102447],

Cell[TextData[{
 Cell[TextData[ButtonBox["Append",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Append"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Prepend",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Prepend"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Insert"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Delete",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Delete"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AppendTo",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AppendTo"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrependTo",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrependTo"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->86320512],

Cell["\t", "GuideDelimiter",
 CellID->126521977],

Cell[TextData[{
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find positions of elements matching a pattern"
}], "GuideText",
 CellID->267106897],

Cell[TextData[{
 Cell[TextData[ButtonBox["Extract",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Extract"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MapAt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapAt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArrayRules",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayRules"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Ordering",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Ordering"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->639690367],

Cell["\t", "GuideDelimiter",
 CellID->144924800],

Cell[TextData[{
 Cell[TextData[ButtonBox["Length",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Length"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dimensions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dimensions"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArrayDepth",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayDepth"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LengthWhile",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LengthWhile"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->117165821],

Cell["\t", "GuideDelimiter",
 CellID->290632994],

Cell[TextData[{
 Cell[TextData[ButtonBox["Select",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Select"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " select elements that satisfy a criterion"
}], "GuideText",
 CellID->25619],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " give elements that match a pattern"
}], "GuideText",
 CellID->16081],

Cell[TextData[{
 Cell[TextData[ButtonBox["Pick",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pick"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeleteCases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DeleteCases"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinLists",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinLists"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Count",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Count"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->68254924],

Cell["\t", "GuideDelimiter",
 CellID->260743569],

Cell[TextData[{
 Cell[TextData[ButtonBox["MemberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemberQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an element is a member of a list"
}], "GuideText",
 CellID->31542322],

Cell[TextData[{
 Cell[TextData[ButtonBox["FreeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FreeQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArrayQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VectorQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/VectorQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MatrixQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->780930880]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Manipulating Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingElementsOfLists"]], "GuideTutorial",\

 CellID->527953687],

Cell[TextData[ButtonBox["Adding, Removing and Modifying List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AddingRemovingAndModifyingListElements"]], "GuideTutorial",\

 CellID->806871991],

Cell[TextData[ButtonBox["Getting Pieces of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GettingPiecesOfLists"]], "GuideTutorial",
 CellID->282940106],

Cell[TextData[ButtonBox["Testing and Searching List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TestingAndSearchingListElements"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingListsByTheirIndices"]], "GuideTutorial",
 CellID->469874936]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RearrangingAndRestructuringLists"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "GuideMoreAboutSub",
 CellID->323869103],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "GuideMoreAboutSub",
 CellID->408533914]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->2022782071],

Cell[TextData[{
 ButtonBox["Demonstrations related to Elements of Lists",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
Append+OR+AppendTo+OR+ArrayDepth+OR+ArrayQ+OR+ArrayRules+OR+BinLists+OR+Cases+\
OR+Count+OR+Delete+OR+DeleteCases+OR+Dimensions+OR+Drop+OR+Extract+OR+First+\
OR+FreeQ+OR+Insert+OR+Last+OR+Length+OR+LengthWhile+OR+MapAt+OR+MatrixQ+OR+\
MemberQ+OR+Most+OR+Ordering+OR+Part+OR+Pick+OR+Position+OR+Prepend+OR+\
PrependTo+OR+ReplacePart+OR+Rest+OR+Select+OR+Span+OR+Take+OR+TakeWhile+OR+\
VectorQ)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->571248510]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Elements of Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 7.2330392}", "context" -> "", 
    "keywords" -> {
     "absent from list", "appending", "append to", "array depth", 
      "array dimensions", "array rules", "arrays", "array shape", 
      "array size", "array subscript", "array subscripting", 
      "beginning of list", "block matrices", "categorizing data", "cdr", 
      "changing parts", "choose elements", "compress in APL", 
      "concatenation of lists", "delete cases", "deleting elements", 
      "discard elements", "discard list elements", "drop first element", 
      "drop last", "element of a list", "element positions", "elements", 
      "expressions ordering", "extraction of sublists", "filtering lists", 
      "full arrays", "insert element in list", "join lists", "length of list",
       "length while", "levels", "list append", "list as matrix", 
      "list member", "lists", "lists as vectors", "map at", "matrices", 
      "matrix dimensions", "membership test", "multiple parts", 
      "number of elements", "number of occurrences", "number of terms", 
      "numerical matrices", "order in lists", "order statistics", "parts", 
      "patterns", "pick elements", "picking elements of lists", 
      "picking out sequences of elements in lists", 
      "prepend elements to lists", "prepending to list", "prepend to", 
      "present in list", "ranking", "remove fist element in list", 
      "removing elements from lists", 
      "removing elements that match a pattern", "replacements", 
      "replace part", "rows", "segments of lists", "sequence of elements", 
      "shortening lists", "size of array", "slice", "smallest element", 
      "sorting", "specify elements in sparse array", "stride", "submatrices", 
      "subscript range", "tail of list", "take while", "tensors", 
      "test for elements in lists", "test if vector", "testing for matrices", 
      "testing for numerical vectors", "testing for presence", 
      "testing for vectors", "truncate list"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica provides a carefully chosen set of functions for accessing \
elements of lists either using indices or positions, or using patterns or \
criteria for their values. ", "synonyms" -> {}, "title" -> 
    "Elements of Lists", "type" -> "Guide", "uri" -> 
    "guide/ElementsOfLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 59, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[681, 28, 274, 7, 70, "GuideAbstract",
 CellID->311974586],
Cell[958, 37, 768, 28, 70, "GuideText",
 CellID->203374175],
Cell[1729, 67, 538, 16, 70, "GuideText",
 CellID->1463276848],
Cell[2270, 85, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2321, 88, 1537, 44, 70, "InlineGuideFunctionListing",
 CellID->432093640],
Cell[3861, 134, 47, 1, 70, "GuideDelimiter",
 CellID->22102447],
Cell[3911, 137, 1215, 35, 70, "InlineGuideFunctionListing",
 CellID->86320512],
Cell[5129, 174, 48, 1, 70, "GuideDelimiter",
 CellID->126521977],
Cell[5180, 177, 274, 9, 70, "GuideText",
 CellID->267106897],
Cell[5457, 188, 1022, 29, 70, "InlineGuideFunctionListing",
 CellID->639690367],
Cell[6482, 219, 48, 1, 70, "GuideDelimiter",
 CellID->144924800],
Cell[6533, 222, 967, 26, 70, "InlineGuideFunctionListing",
 CellID->117165821],
Cell[7503, 250, 48, 1, 70, "GuideDelimiter",
 CellID->290632994],
Cell[7554, 253, 256, 8, 70, "GuideText",
 CellID->25619],
Cell[7813, 263, 248, 8, 70, "GuideText",
 CellID->16081],
Cell[8064, 273, 948, 26, 70, "InlineGuideFunctionListing",
 CellID->68254924],
Cell[9015, 301, 48, 1, 70, "GuideDelimiter",
 CellID->260743569],
Cell[9066, 304, 271, 9, 70, "GuideText",
 CellID->31542322],
Cell[9340, 315, 798, 23, 70, "InlineGuideFunctionListing",
 CellID->780930880]
}, Open  ]],
Cell[CellGroupData[{
Cell[10175, 343, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[10240, 346, 178, 4, 70, "GuideTutorial",
 CellID->527953687],
Cell[10421, 352, 206, 5, 70, "GuideTutorial",
 CellID->806871991],
Cell[10630, 359, 162, 3, 70, "GuideTutorial",
 CellID->282940106],
Cell[10795, 364, 189, 4, 70, "GuideTutorial",
 CellID->1885805579],
Cell[10987, 370, 188, 4, 70, "GuideTutorial",
 CellID->469874936]
}, Open  ]],
Cell[CellGroupData[{
Cell[11212, 379, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[11277, 382, 150, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[11430, 387, 155, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[11588, 392, 189, 4, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[11780, 398, 155, 3, 70, "GuideMoreAboutSub",
 CellID->323869103],
Cell[11938, 403, 163, 3, 70, "GuideMoreAboutSub",
 CellID->408533914]
}, Open  ]],
Cell[CellGroupData[{
Cell[12138, 411, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->2022782071],
Cell[12211, 414, 832, 20, 70, "GuideRelatedLinks",
 CellID->571248510]
}, Open  ]],
Cell[13058, 437, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

