(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19720,        595]
NotebookOptionsPosition[     14275,        460]
NotebookOutlinePosition[     17341,        518]
CellTagsIndexPosition[     17298,        515]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["External Operations", "GuideTitle",
 CellID->14708],

Cell[TextData[{
 "Tightly integrated into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s core language is a rich set of primitives for interacting with external \
environments. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic architecture makes possible powerful symbolic representations \
for external constructs and functionality\[LongDash]allowing immediate \
application of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s sophisticated algorithms and advanced programming paradigms. "
}], "GuideAbstract",
 CellID->1055280587],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Import & Export \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ImportingAndExporting"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->465337922],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "import, export from files, pipes, URLs in hundreds of formats"
}], "GuideText",
 CellID->687963574]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["File & Stream Operations \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Files"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->189901960],

Cell[TextData[{
 Cell[TextData[ButtonBox["Put",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Put"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Put"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Get",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Get"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["<<",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Get"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OpenRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OpenRead"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Read",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Read"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Write",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Write"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinaryRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryRead"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Find",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Find"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Files"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->2003337]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["File System Operations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FileOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->387621550],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileNames",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileNames"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FileDate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileDate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FileHash",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileHash"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CreateDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CreateDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FileOperations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->393385022]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["System Information \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SystemInformation"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->725972361],

Cell[TextData[{
 Cell[TextData[ButtonBox["$CommandLine",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$CommandLine"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AbsoluteTime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DateList",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DateList"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$UserName",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserName"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MachineDomains",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/$MachineDomains"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SystemInformation"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->381809976],

Cell["\t", "GuideDelimiterSubsection",
 CellID->125348529]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["External Programs \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CallingExternalPrograms"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->14473404],

Cell[TextData[{
 Cell[TextData[ButtonBox["Run",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Run"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Install",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Install"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["LoadJavaClass",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/LoadJavaClass"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LoadNETType",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InstallService",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/InstallService"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CallingExternalPrograms"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1055466916]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"], "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 StyleBox[ButtonBox[" API \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"], "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->28486],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkCreate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkCreate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinkRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkRead"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinkWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkWrite"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinkPatterns",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkPatterns"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21196],

Cell["\t", "GuideDelimiterSubsection",
 CellID->18238]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Device Control \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LowLevelInterfaceControl"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->425135723],

Cell[TextData[{
 Cell[TextData[ButtonBox["CurrentValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CurrentValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ControllerState",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerState"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MousePosition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MousePosition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelInterfaceControl"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->238359056]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->18392],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "GuideTutorial",
 CellID->89363054],

Cell[TextData[ButtonBox["Finding and Manipulating Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingAndManipulatingFiles"]], "GuideTutorial",\

 CellID->52295254],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "GuideTutorial",
 CellID->487993801],

Cell[TextData[ButtonBox["Global System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GlobalSystemInformation"]], "GuideTutorial",
 CellID->875517063],

Cell[TextData[ButtonBox["External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExternalPrograms"]], "GuideTutorial",
 CellID->169264501]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->10647],

Cell[TextData[ButtonBox["Parallel Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "GuideMoreAbout",
 CellID->15847762],

Cell[TextData[ButtonBox["XML",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLImportAndExport"]], "GuideMoreAboutSub",
 CellID->827742],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "GuideMoreAboutSub",
 CellID->677944211],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "GuideMoreAboutSub",
 CellID->4098]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"External Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 15.1082408}", "context" -> "", 
    "keywords" -> {
     "absolute time", "account name", "add external function", "argc", "argv",
       "binary read", "bind name", "cd", "change directory", "checksum", 
      "clock", "command line", "command-line arguments", "command prompt", 
      "computer time", "controller state", "create directory", 
      "create folder", "create link", "data", "data input", "date", "decode", 
      "dir", "execute external command", "exit code", "exporting graphics", 
      "exporting sounds", "extend functions", "external data", "fileattrib", 
      "file attributes", "file date", "file hash", "file names", "files", 
      "find in Unix", "fork", "ftp", "get data from Mathlink", "http", 
      "information about Mathlink program", "install external program", 
      "install service", "link create", "link patterns", "link read", 
      "link write", "listen on link", "load file", "login name", 
      "low-level data", "ls", "machine domains", "Mathlink program usage", 
      "modification date", "new directory", "new folder", "NTP", 
      "open file for reading", "opening input streams", 
      "opening streams for input", "open read", "operating system command", 
      "output", "overwriting files", "pipes", "publish link", "put data", 
      "raw data", "reading binary data", "reading expression from Mathlink", 
      "read-mode", "real-time clock", "register link", 
      "running external programs", "saving file", "screen name", 
      "send data via Mathlink", "sequential reading from files", 
      "set directory", "shell command", "shell escape", "sign-in name", 
      "standard time", "subprocess", "system time", "time", "timestamp", 
      "URLs", "user name", "web", "web import", "write data to Mathlink", 
      "writing files"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Tightly integrated into Mathematica's core language is a rich set of \
primitives for interacting with external environments. Mathematica's symbolic \
architecture makes possible powerful symbolic representations for external \
constructs and functionality--allowing immediate application of Mathematica's \
sophisticated algorithms and advanced programming paradigms. ", 
    "synonyms" -> {}, "title" -> "External Operations", "type" -> "Guide", 
    "uri" -> "guide/ExternalOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 57, 1, 70, "GuideTitle",
 CellID->14708],
Cell[679, 28, 566, 15, 70, "GuideAbstract",
 CellID->1055280587],
Cell[CellGroupData[{
Cell[1270, 47, 224, 5, 70, "GuideFunctionsSubsection",
 CellID->465337922],
Cell[1497, 54, 409, 13, 70, "GuideText",
 CellID->687963574]
}, Open  ]],
Cell[CellGroupData[{
Cell[1943, 72, 219, 6, 70, "GuideFunctionsSubsection",
 CellID->189901960],
Cell[2165, 80, 1804, 57, 70, "InlineGuideFunctionListing",
 CellID->2003337]
}, Open  ]],
Cell[CellGroupData[{
Cell[4006, 142, 224, 5, 70, "GuideFunctionsSubsection",
 CellID->387621550],
Cell[4233, 149, 1400, 38, 70, "InlineGuideFunctionListing",
 CellID->393385022]
}, Open  ]],
Cell[CellGroupData[{
Cell[5670, 192, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->725972361],
Cell[5896, 199, 1556, 41, 70, "InlineGuideFunctionListing",
 CellID->381809976],
Cell[7455, 242, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->125348529]
}, Open  ]],
Cell[CellGroupData[{
Cell[7550, 248, 227, 5, 70, "GuideFunctionsSubsection",
 CellID->14473404],
Cell[7780, 255, 1378, 38, 70, "InlineGuideFunctionListing",
 CellID->1055466916]
}, Open  ]],
Cell[CellGroupData[{
Cell[9195, 298, 349, 9, 70, "GuideFunctionsSubsection",
 CellID->28486],
Cell[9547, 309, 1030, 29, 70, "InlineGuideFunctionListing",
 CellID->21196],
Cell[10580, 340, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->18238]
}, Open  ]],
Cell[CellGroupData[{
Cell[10671, 346, 226, 5, 70, "GuideFunctionsSubsection",
 CellID->425135723],
Cell[10900, 353, 1646, 42, 70, "InlineGuideFunctionListing",
 CellID->238359056]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12595, 401, 58, 1, 70, "GuideTutorialsSection",
 CellID->18392],
Cell[12656, 404, 171, 3, 70, "GuideTutorial",
 CellID->89363054],
Cell[12830, 409, 177, 4, 70, "GuideTutorial",
 CellID->52295254],
Cell[13010, 415, 200, 4, 70, "GuideTutorial",
 CellID->487993801],
Cell[13213, 421, 167, 3, 70, "GuideTutorial",
 CellID->875517063],
Cell[13383, 426, 152, 3, 70, "GuideTutorial",
 CellID->169264501]
}, Open  ]],
Cell[CellGroupData[{
Cell[13572, 434, 59, 1, 70, "GuideMoreAboutSection",
 CellID->10647],
Cell[13634, 437, 158, 3, 70, "GuideMoreAbout",
 CellID->15847762],
Cell[13795, 442, 138, 3, 70, "GuideMoreAboutSub",
 CellID->827742],
Cell[13936, 447, 157, 3, 70, "GuideMoreAboutSub",
 CellID->677944211],
Cell[14096, 452, 137, 3, 70, "GuideMoreAboutSub",
 CellID->4098]
}, Open  ]],
Cell[14248, 458, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

