(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18083,        556]
NotebookOptionsPosition[     12597,        421]
NotebookOutlinePosition[     15759,        481]
CellTagsIndexPosition[     15716,        478]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["File Operations", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "In addition to a rich set of standard file operations, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s unified symbolic architecture makes it easy to apply algorithmic \
approaches and efficient higher-level programming to many file and system \
administration tasks."
}], "GuideAbstract",
 CellID->107928565],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileNames",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileNames"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list names of files or directories at any depth in the file system"
}], "GuideText",
 CellID->841407198],

Cell[TextData[{
 Cell[TextData[ButtonBox["CopyFile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CopyFile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RenameFile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RenameFile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeleteFile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DeleteFile"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->161849350],

Cell[CellGroupData[{

Cell["File Properties", "GuideFunctionsSubsection",
 CellID->588553931],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileDate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileDate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FileByteCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileByteCount"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetFileDate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetFileDate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FileType",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileType"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FileHash",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileHash"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FileFormat",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileFormat"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->391219363]
}, Open  ]],

Cell[CellGroupData[{

Cell["File Utilities", "GuideFunctionsSubsection",
 CellID->574964612],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "search for strings in lists of files"
}], "GuideText",
 CellID->91060424],

Cell[TextData[{
 Cell[TextData[ButtonBox["Splice",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Splice"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "splice ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results into a file"
}], "GuideText",
 CellID->144797663],

Cell[TextData[{
 Cell[TextData[ButtonBox["FilePrint",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FilePrint"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display the raw contents of a file"
}], "GuideText",
 CellID->264929347]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Directory Operations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DirectoriesAndDirectoryOperations"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->51464835],

Cell[TextData[{
 Cell[TextData[ButtonBox["CreateDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CreateDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CopyDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CopyDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeleteDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DeleteDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->201330314]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["File Name Constructors \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DirectoriesAndDirectoryOperations"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->231395373],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToFileName",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToFileName"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DirectoryName",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DirectoryName"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ParentDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ParentDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$HomeDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$HomeDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->12670217]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Reading & Writing Files \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Files"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->262134532],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Get",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Get"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["<<",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Get"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Put",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Put"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Put"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReadList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReadList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinaryReadList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryReadList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Files"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->256678113]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Low-Level File Operations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LowLevelFileOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->111630649],

Cell[TextData[{
 Cell[TextData[ButtonBox["OpenRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OpenRead"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OpenWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OpenWrite"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Streams",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Streams"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Read",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Read"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Skip",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Skip"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelFileOperations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->355092749]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Finding and Manipulating Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingAndManipulatingFiles"]], "GuideTutorial",\

 CellID->455502382],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "GuideTutorial",
 CellID->76820519],

Cell[TextData[ButtonBox["Manipulating Files and Directories",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingFilesAndDirectories"]], "GuideTutorial",
 CellID->83680271],

Cell[TextData[ButtonBox["Searching Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SearchingFiles"]], "GuideTutorial",
 CellID->667034964]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Systems Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SystemsInterfacesAndDeploymentOverview"]], "GuideMoreAbout",
 CellID->431270840],

Cell[TextData[ButtonBox["Language-Level External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Importing & Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Databases",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DatabaseConnectivity"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60DataHandlingAndDataSources"]], "GuideMoreAbout",
 CellID->929199252]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"File Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 16.0613902}", "context" -> "", 
    "keywords" -> {
     "binary read list", "cat", "cd", "change directory", "checksum", 
      "clobbering files", "convert to file name", "copy directory", 
      "copy file", "create directory", "create folder", "del DOS command", 
      "delete directory", "delete file", "dir", "directories", 
      "directory name", "duplicating files", "erasing files", "external data",
       "external programs", "fileattrib", "file attributes", 
      "file byte count", "file contents", "file date", "file format", 
      "file hash", "file name", "file name parts", "file names", "file path", 
      "file print", "files", "file size", "file type", "find in Unix", 
      "find list", "home directory", "input", "input from data file", 
      "insertion into external files", "list of open files", 
      "list of open streams", "load file", "ls", "ls -l Unix command", 
      "modification date", "move file", "new directory", "new folder", 
      "open file for reading", "open file for writing", 
      "opening input streams", "opening output streams", 
      "opening streams for input", "opening streams for writing", "open read",
       "open write", "output", "output in external files", 
      "overwriting files", "parent directory", "pipes", "purging directories",
       "put", "reading", "reading arrays from data files", 
      "reading data files", "reading data from external programs", 
      "reading data from files", "reading data from pipes", 
      "reading data from programs", "reading data from spreadsheets", 
      "reading data from streams", "reading matrices from data files", 
      "read list", "read-mode", "records", "removing files", "rename file", 
      "rmdir command", "rm Unix command", "saving", "search", "searching", 
      "sequential reading from files", "set directory", "set file date", 
      "splicing into files", "splicing Mathematica output", "to file name", 
      "turning files into strings", "types of files", "user directory", 
      "write-mode", "writing"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "In addition to a rich set of standard file operations, Mathematica's \
unified symbolic architecture makes it easy to apply algorithmic approaches \
and efficient higher-level programming to many file and system administration \
tasks.", "synonyms" -> {}, "title" -> "File Operations", "type" -> "Guide", 
    "uri" -> "guide/FileOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 57, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[679, 28, 336, 8, 70, "GuideAbstract",
 CellID->107928565],
Cell[1018, 38, 297, 9, 70, "GuideText",
 CellID->841407198],
Cell[1318, 49, 612, 17, 70, "InlineGuideFunctionListing",
 CellID->161849350],
Cell[CellGroupData[{
Cell[1955, 70, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->588553931],
Cell[2029, 73, 1538, 41, 70, "InlineGuideFunctionListing",
 CellID->391219363]
}, Open  ]],
Cell[CellGroupData[{
Cell[3604, 119, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->574964612],
Cell[3677, 122, 264, 9, 70, "GuideText",
 CellID->91060424],
Cell[3944, 133, 306, 12, 70, "GuideText",
 CellID->144797663],
Cell[4253, 147, 410, 12, 70, "GuideText",
 CellID->264929347]
}, Open  ]],
Cell[CellGroupData[{
Cell[4700, 164, 240, 5, 70, "GuideFunctionsSubsection",
 CellID->51464835],
Cell[4943, 171, 1091, 30, 70, "InlineGuideFunctionListing",
 CellID->201330314]
}, Open  ]],
Cell[CellGroupData[{
Cell[6071, 206, 243, 5, 70, "GuideFunctionsSubsection",
 CellID->231395373],
Cell[6317, 213, 1084, 30, 70, "InlineGuideFunctionListing",
 CellID->12670217]
}, Open  ]],
Cell[CellGroupData[{
Cell[7438, 248, 216, 5, 70, "GuideFunctionsSubsection",
 CellID->262134532],
Cell[7657, 255, 1620, 51, 70, "InlineGuideFunctionListing",
 CellID->256678113]
}, Open  ]],
Cell[CellGroupData[{
Cell[9314, 311, 237, 6, 70, "GuideFunctionsSubsection",
 CellID->111630649],
Cell[9554, 319, 1223, 35, 70, "InlineGuideFunctionListing",
 CellID->355092749]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10826, 360, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[10891, 363, 178, 4, 70, "GuideTutorial",
 CellID->455502382],
Cell[11072, 369, 163, 3, 70, "GuideTutorial",
 CellID->76820519],
Cell[11238, 374, 186, 4, 70, "GuideTutorial",
 CellID->83680271],
Cell[11427, 380, 148, 3, 70, "GuideTutorial",
 CellID->667034964]
}, Open  ]],
Cell[CellGroupData[{
Cell[11612, 388, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[11677, 391, 189, 4, 70, "GuideMoreAbout",
 CellID->431270840],
Cell[11869, 397, 170, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[12042, 402, 164, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[12209, 407, 150, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[12362, 412, 193, 4, 70, "GuideMoreAbout",
 CellID->929199252]
}, Open  ]],
Cell[12570, 419, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

