(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17921,        590]
NotebookOptionsPosition[     12289,        443]
NotebookOutlinePosition[     15162,        499]
CellTagsIndexPosition[     15119,        496]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Files", "GuideTitle",
 CellID->658],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides convenient and efficient system-independent functions for \
handling file-related constructs at all levels."
}], "GuideAbstract",
 CellID->229],

Cell[TextData[{
 Cell[BoxData["\"\<file\>\""], "InlineCode"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ordinary named file"
}], "GuideText",
 CellID->19569],

Cell[TextData[{
 Cell[BoxData["\"\<!program\>\""], "InlineCode"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " pipe"
}], "GuideText",
 CellID->8638],

Cell[TextData[{
 Cell[BoxData["\"\<http:...\>\""], "InlineCode"],
 ", etc. \[LongDash] web-type URL"
}], "GuideText",
 CellID->27663],

Cell["\t", "GuideDelimiterSubsection",
 CellID->32695898],

Cell[CellGroupData[{

Cell["Complete Files", "GuideFunctionsSubsection",
 CellID->631062674],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " import and export in hundreds of formats"
}], "GuideText",
 CellID->315750133],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReadList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReadList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "read unstructured data from a file"
}], "GuideText",
 CellID->104072768],

Cell[TextData[{
 Cell[TextData[ButtonBox["FilePrint",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FilePrint"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display the raw contents of a file"
}], "GuideText",
 CellID->264929347]
}, Open  ]],

Cell[CellGroupData[{

Cell["File Searching", "GuideFunctionsSubsection",
 CellID->461952572],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find strings in lists of files"
}], "GuideText",
 CellID->23146],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileNames",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileNames"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find files by name"
}], "GuideText",
 CellID->78328075]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Low-Level File Operations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LowLevelFileOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->17878305],

Cell[TextData[{
 Cell[TextData[ButtonBox["OpenRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OpenRead"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["OpenWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OpenWrite"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " open files"
}], "GuideText",
 CellID->288628463],

Cell[TextData[{
 Cell[TextData[ButtonBox["Read",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Read"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Write",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Write"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["WriteString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WriteString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "read and write individual data elements"
}], "GuideText",
 CellID->383471019],

Cell[TextData[{
 Cell[TextData[ButtonBox["Find",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Find"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Skip",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Skip"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetStreamPosition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetStreamPosition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelFileOperations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->315451264]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaExpressionsInFiles"], 
  "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 StyleBox[ButtonBox[" Expression Files \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaExpressionsInFiles"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->548676850],

Cell[TextData[{
 Cell[TextData[ButtonBox["Get",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Get"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["<<",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Get"]], "InlineFunctionSans"],
 ") \[LongDash] get ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions from a file (.m file)"
}], "GuideText",
 CellID->639832165],

Cell[TextData[{
 Cell[TextData[ButtonBox["Put",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Put"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Put"]], "InlineFunctionSans"],
 "), ",
 Cell[TextData[ButtonBox["PutAppend",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PutAppend"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[">>>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PutAppend"]], "InlineFunctionSans"],
 ") \[LongDash] put ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions into a file (.m file)"
}], "GuideText",
 CellID->64425960],

Cell[TextData[{
 Cell[TextData[ButtonBox["Save",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Save"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Splice",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Splice"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DumpSave",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DumpSave"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Encode",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Encode"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->368830873]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Binary Data \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/BinaryData"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->429355333],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinaryReadList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryReadList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinaryRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryRead"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinaryWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryWrite"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/BinaryData"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->596759038],

Cell["\t", "GuideDelimiterSubsection",
 CellID->333006744]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["File Properties & Operations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FileOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->6422305],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileDate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileDate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FileByteCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileByteCount"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FileNames",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileNames"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FileHash",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileHash"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CopyFile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CopyFile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FileOperations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->412431978]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->24515],

Cell[TextData[ButtonBox["Importing and Exporting Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingFiles"]], "GuideTutorial",
 CellID->27145772],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "GuideTutorial",
 CellID->320013056],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"]
}], "GuideTutorial",
 CellID->17138144],

Cell[TextData[ButtonBox["Finding and Manipulating Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingAndManipulatingFiles"]], "GuideTutorial",\

 CellID->417308750],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "GuideTutorial",
 CellID->358412617],

Cell[TextData[ButtonBox["Binary Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BinaryFiles"]], "GuideTutorial",
 CellID->22871172]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->15615],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAbout",
 CellID->13234],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "GuideMoreAboutSub",\

 CellID->905],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Files - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 16.8114094}", "context" -> "", 
    "keywords" -> {
     "appending", "append mode", "append to file", "binary read", 
      "binary read list", "binary save", "binary write", "copy file", "CRC", 
      "dir", "dump save", "duplicating files", "external data", 
      "external programs", "fileattrib", "file attributes", "file byte count",
       "file contents", "file date", "file hash", "file names", 
      "file pointer position", "file print", "files", "file size", 
      "find in Unix", "find list", "grep", "hash", "hash code", "hashcode", 
      "hashing", "input from data file", "insertion into external files", 
      "load file", "low-level data", "ls", "ls -l Unix command", "MD2", "MD5",
       "modification date", "open file for reading", "open file for writing", 
      "opening input streams", "opening output streams", 
      "opening streams for input", "opening streams for writing", "open read",
       "open write", "output", "output in external files", 
      "overwriting files", "pipes", "printing expressions", "put", 
      "put append", "random access", "random access to files", "raw data", 
      "raw output", "reading files", "reading arrays from data files", 
      "reading binary data", "reading data files", 
      "reading data from external programs", "reading data from files", 
      "reading data from pipes", "reading data from programs", 
      "reading data from spreadsheets", "reading data from streams", 
      "reading matrices from data files", "read list", "read-mode", 
      "save definitions", "save dump", "saving file", "search files", 
      "searching in file", "seek", "sequential reading from files", 
      "sequential searching", "set stream position", "splicing into files", 
      "splicing Mathematica output", "turning files into strings", 
      "write-mode", "write string", "writing files", "writing binary files"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica provides convenient and efficient system-independent \
functions for handling file-related constructs at all levels.", 
    "synonyms" -> {}, "title" -> "Files", "type" -> "Guide", "uri" -> 
    "guide/Files"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 41, 1, 70, "GuideTitle",
 CellID->658],
Cell[663, 28, 220, 6, 70, "GuideAbstract",
 CellID->229],
Cell[886, 36, 165, 6, 70, "GuideText",
 CellID->19569],
Cell[1054, 44, 153, 6, 70, "GuideText",
 CellID->8638],
Cell[1210, 52, 133, 4, 70, "GuideText",
 CellID->27663],
Cell[1346, 58, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->32695898],
Cell[CellGroupData[{
Cell[1428, 63, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->631062674],
Cell[1501, 66, 383, 12, 70, "GuideText",
 CellID->315750133],
Cell[1887, 80, 263, 9, 70, "GuideText",
 CellID->104072768],
Cell[2153, 91, 410, 12, 70, "GuideText",
 CellID->264929347]
}, Open  ]],
Cell[CellGroupData[{
Cell[2600, 108, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->461952572],
Cell[2673, 111, 255, 9, 70, "GuideText",
 CellID->23146],
Cell[2931, 122, 248, 9, 70, "GuideText",
 CellID->78328075]
}, Open  ]],
Cell[CellGroupData[{
Cell[3216, 136, 236, 6, 70, "GuideFunctionsSubsection",
 CellID->17878305],
Cell[3455, 144, 363, 12, 70, "GuideText",
 CellID->288628463],
Cell[3821, 158, 514, 17, 70, "GuideText",
 CellID->383471019],
Cell[4338, 177, 825, 23, 70, "InlineGuideFunctionListing",
 CellID->315451264]
}, Open  ]],
Cell[CellGroupData[{
Cell[5200, 205, 411, 11, 70, "GuideFunctionsSubsection",
 CellID->548676850],
Cell[5614, 218, 388, 13, 70, "GuideText",
 CellID->639832165],
Cell[6005, 233, 640, 21, 70, "GuideText",
 CellID->64425960],
Cell[6648, 256, 796, 23, 70, "InlineGuideFunctionListing",
 CellID->368830873]
}, Open  ]],
Cell[CellGroupData[{
Cell[7481, 284, 209, 5, 70, "GuideFunctionsSubsection",
 CellID->429355333],
Cell[7693, 291, 833, 23, 70, "InlineGuideFunctionListing",
 CellID->596759038],
Cell[8529, 316, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->333006744]
}, Open  ]],
Cell[CellGroupData[{
Cell[8624, 322, 230, 6, 70, "GuideFunctionsSubsection",
 CellID->6422305],
Cell[8857, 330, 1388, 38, 70, "InlineGuideFunctionListing",
 CellID->412431978]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10294, 374, 58, 1, 70, "GuideTutorialsSection",
 CellID->24515],
Cell[10355, 377, 173, 3, 70, "GuideTutorial",
 CellID->27145772],
Cell[10531, 382, 157, 3, 70, "GuideTutorial",
 CellID->320013056],
Cell[10691, 387, 436, 12, 70, "GuideTutorial",
 CellID->17138144],
Cell[11130, 401, 178, 4, 70, "GuideTutorial",
 CellID->417308750],
Cell[11311, 407, 200, 4, 70, "GuideTutorial",
 CellID->358412617],
Cell[11514, 413, 141, 3, 70, "GuideTutorial",
 CellID->22871172]
}, Open  ]],
Cell[CellGroupData[{
Cell[11692, 421, 59, 1, 70, "GuideMoreAboutSection",
 CellID->15615],
Cell[11754, 424, 155, 3, 70, "GuideMoreAbout",
 CellID->13234],
Cell[11912, 429, 173, 4, 70, "GuideMoreAboutSub",
 CellID->905],
Cell[12088, 435, 159, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[12262, 441, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

