(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18869,        588]
NotebookOptionsPosition[     12195,        424]
NotebookOutlinePosition[     16000,        493]
CellTagsIndexPosition[     15957,        490]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Formula Manipulation", "GuideTitle",
 CellID->20289],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " handles formulas of all types, from polynomials with millions of terms to \
complex combinations of higher mathematical functions",
 ". ",
 "It provides powerful general transformation and simplification functions \
that automatically call on thousands of rules and algorithms\[LongDash]many \
original to Wolfram Research."
}], "GuideAbstract",
 CellID->8419],

Cell[TextData[{
 Cell[TextData[ButtonBox["Simplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Simplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " simplify, perhaps with assumptions about variables"
}], "GuideText",
 CellID->2609],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply full simplification procedures"
}], "GuideText",
 CellID->11064],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand in terms of more elementary functions"
}], "GuideText",
 CellID->9166],

Cell["\t", "GuideDelimiter",
 CellID->13509],

Cell[TextData[{
 Cell[TextData[ButtonBox["Expand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Expand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand out algebraic expressions"
}], "GuideText",
 CellID->16216],

Cell[TextData[{
 Cell[TextData[ButtonBox["Factor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factor"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " factor algebraic expressions"
}], "GuideText",
 CellID->31450],

Cell["\t", "GuideDelimiter",
 CellID->11638731],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " reduce out equations and inequalities"
}], "GuideText",
 CellID->30300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Series",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Series"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find a series approximation"
}], "GuideText",
 CellID->19695],

Cell["\t", "GuideDelimiterSubsection",
 CellID->28354409],

Cell[CellGroupData[{

Cell["Extracting Parts of Formulas", "GuideFunctionsSubsection",
 CellID->9573],

Cell[TextData[{
 Cell[TextData[ButtonBox["Coefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Coefficient"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Exponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exponent"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Numerator",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Numerator"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Denominator",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Denominator"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->15589]
}, Open  ]],

Cell[CellGroupData[{

Cell["Formula Rearrangement", "GuideFunctionsSubsection",
 CellID->13161],

Cell[TextData[{
 Cell[TextData[ButtonBox["Collect",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Collect"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Together",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Together"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Apart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cancel",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cancel"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->31172]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Algebraic Transformations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AlgebraicTransformations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->17968],

Cell[TextData[{
 Cell[TextData[ButtonBox["PowerExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PowerExpand"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ComplexExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ComplexExpand"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TrigExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigExpand"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RootReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RootReduce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlgebraicTransformations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->549478749]
}, Open  ]],

Cell[CellGroupData[{

Cell["Formula Testing", "GuideFunctionsSubsection",
 CellID->208647531],

Cell[TextData[{
 Cell[TextData[ButtonBox["Equal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["==",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Element",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Element"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PossibleZeroQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PossibleZeroQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->340075770],

Cell["\t", "GuideDelimiterSubsection",
 CellID->598318843]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Assumptions & Domains \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AssumptionsAndDomains"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->693104728],

Cell[TextData[{
 Cell[TextData[ButtonBox["Refine",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Refine"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Assuming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Assuming"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ForAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ForAll"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Integers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integers"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Reals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reals"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AssumptionsAndDomains"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->380262605],

Cell["\t", "GuideDelimiter",
 CellID->16893],

Cell[TextData[{
 Cell[TextData[ButtonBox["TraditionalForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TraditionalForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " display a formula in traditional math notation"
}], "GuideText",
 CellID->16074]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->26268],

Cell[TextData[ButtonBox["Simplification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Simplification"]], "GuideTutorial",
 CellID->166738831],

Cell[TextData[ButtonBox["Simplifying Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SimplifyingAlgebraicExpressions"]], "GuideTutorial",
 CellID->6364431],

Cell[TextData[ButtonBox["Simplifying with Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingWithAssumptions"]], "GuideTutorial",
 CellID->138820746],

Cell[TextData[ButtonBox["Picking Out Pieces of Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"]], "GuideTutorial",\

 CellID->598300675],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "GuideTutorial",
 CellID->365878450],

Cell[TextData[ButtonBox["Structural Operations on Rational Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnRationalExpressions"]], \
"GuideTutorial",
 CellID->320207631]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->10422],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "GuideMoreAbout",
 CellID->30774],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "GuideMoreAbout",
 CellID->8779],

Cell[TextData[ButtonBox["Pattern Matching",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "GuideMoreAbout",
 CellID->30910],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "GuideMoreAboutSub",
 CellID->4182]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->101207568],

Cell[TextData[{
 ButtonBox["Demonstrations related to Formula Manipulation",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(Apart+\
OR+Assuming+OR+Cancel+OR+Coefficient+OR+Collect+OR+ComplexExpand+OR+\
Denominator+OR+Element+OR+Equal+OR+Expand+OR+Exponent+OR+Factor+OR+ForAll+OR+\
FullSimplify+OR+FunctionExpand+OR+Integers+OR+Numerator+OR+Part+OR+\
PossibleZeroQ+OR+PowerExpand+OR+Reals+OR+Reduce+OR+Refine+OR+RootReduce+OR+\
Series+OR+Simplify+OR+Together+OR+TraditionalForm+OR+TrigExpand)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->283975456]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Formula Manipulation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 22.2959248}", "context" -> "", 
    "keywords" -> {
     "algebraic simplification", "aliquant", "arc trig expansion", 
      "artificial intelligence", "assertions", "assume", "assumptions", 
      "asymptotic expansions", "Bessel function simplification", "cancel out",
       "classical notation", "cleaning up expressions", 
      "collecting over common denominators", "collecting terms", 
      "combinatorial explosion", "combinatorial simplification", 
      "combining radicals", "common denominator", "common factors", 
      "complete simplification", "compress expression", "concise form", 
      "constraints", "domain assumptions", "domain membership", "domains", 
      "domains for variables", "equal", "equality testing", "equivalence", 
      "equivalence testing", "evaluate using assumptions", 
      "evaluation using assumptions", "expanding", 
      "expanding into polar form", "expanding into real and imaginary parts", 
      "expanding special constants", "expanding special functions", 
      "expanding special sequences", "expansion", "factorial simplification", 
      "factoring", "factoring over extension fields", "formula typesetting", 
      "full simplify", "function expand", "global assumptions", 
      "greatest common divisor", "Groebner basis", "grouping terms", 
      "Hensel lifting", "heuristics", "identical expressions", "identities", 
      "irreducibility", "Laurent series", "leading coefficient", 
      "leading term", "logarithm expansion", "Maclaurin series", 
      "mathematical equivalence", "modular factorization", "multiple parts", 
      "polynomial equations", "polynomial factorization", "power expand", 
      "powers", "power series", "prime elements", "radicals", 
      "radical simplification", "rearrange expression", 
      "rearranging polynomials", "reducing inequalities", "reducing radicals",
       "reduction formulas", "refine", "refine using assumptions", "regions", 
      "reordering terms", "same expressions", "sequence of elements", 
      "series expansions", "shortest form", "simplest forms", 
      "simplification", "simplifying radicals", "smallest form", 
      "special function simplification", "squash expression", "Taylor series",
       "testing equality", "textbook notation", "theorem proving", 
      "transcendental equations", "transcendental inequalities", 
      "transformations", "trig expand", "trigonometric expansion", 
      "trigonometric simplification", "type assumptions", 
      "unique factorization domain", "universal quantifier", 
      "universal quantor", "variables"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica handles formulas of all types, from polynomials with \
millions of terms to complex combinations of higher mathematical functions. \
It provides powerful general transformation and simplification functions that \
automatically call on thousands of rules and algorithms--many original to \
Wolfram Research.", "synonyms" -> {}, "title" -> "Formula Manipulation", 
    "type" -> "Guide", "uri" -> "guide/FormulaManipulation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->20289],
Cell[680, 28, 428, 10, 70, "GuideAbstract",
 CellID->8419],
Cell[1111, 40, 269, 8, 70, "GuideText",
 CellID->2609],
Cell[1383, 50, 264, 8, 70, "GuideText",
 CellID->11064],
Cell[1650, 60, 275, 8, 70, "GuideText",
 CellID->9166],
Cell[1928, 70, 44, 1, 70, "GuideDelimiter",
 CellID->13509],
Cell[1975, 73, 248, 8, 70, "GuideText",
 CellID->16216],
Cell[2226, 83, 244, 8, 70, "GuideText",
 CellID->31450],
Cell[2473, 93, 47, 1, 70, "GuideDelimiter",
 CellID->11638731],
Cell[2523, 96, 253, 8, 70, "GuideText",
 CellID->30300],
Cell[2779, 106, 243, 8, 70, "GuideText",
 CellID->19695],
Cell[3025, 116, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->28354409],
Cell[CellGroupData[{
Cell[3107, 121, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->9573],
Cell[3189, 124, 1022, 29, 70, "InlineGuideFunctionListing",
 CellID->15589]
}, Open  ]],
Cell[CellGroupData[{
Cell[4248, 158, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->13161],
Cell[4324, 161, 796, 23, 70, "InlineGuideFunctionListing",
 CellID->31172]
}, Open  ]],
Cell[CellGroupData[{
Cell[5157, 189, 235, 6, 70, "GuideFunctionsSubsection",
 CellID->17968],
Cell[5395, 197, 1060, 30, 70, "InlineGuideFunctionListing",
 CellID->549478749]
}, Open  ]],
Cell[CellGroupData[{
Cell[6492, 232, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->208647531],
Cell[6566, 235, 856, 25, 70, "InlineGuideFunctionListing",
 CellID->340075770],
Cell[7425, 262, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->598318843]
}, Open  ]],
Cell[CellGroupData[{
Cell[7520, 268, 230, 5, 70, "GuideFunctionsSubsection",
 CellID->693104728],
Cell[7753, 275, 1224, 35, 70, "InlineGuideFunctionListing",
 CellID->380262605],
Cell[8980, 312, 44, 1, 70, "GuideDelimiter",
 CellID->16893],
Cell[9027, 315, 280, 8, 70, "GuideText",
 CellID->16074]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9356, 329, 58, 1, 70, "GuideTutorialsSection",
 CellID->26268],
Cell[9417, 332, 147, 3, 70, "GuideTutorial",
 CellID->166738831],
Cell[9567, 337, 184, 4, 70, "GuideTutorial",
 CellID->6364431],
Cell[9754, 343, 173, 3, 70, "GuideTutorial",
 CellID->138820746],
Cell[9930, 348, 205, 5, 70, "GuideTutorial",
 CellID->598300675],
Cell[10138, 355, 198, 4, 70, "GuideTutorial",
 CellID->365878450],
Cell[10339, 361, 210, 5, 70, "GuideTutorial",
 CellID->320207631]
}, Open  ]],
Cell[CellGroupData[{
Cell[10586, 371, 59, 1, 70, "GuideMoreAboutSection",
 CellID->10422],
Cell[10648, 374, 148, 3, 70, "GuideMoreAbout",
 CellID->30774],
Cell[10799, 379, 147, 3, 70, "GuideMoreAbout",
 CellID->8779],
Cell[10949, 384, 145, 3, 70, "GuideMoreAbout",
 CellID->30910],
Cell[11097, 389, 139, 3, 70, "GuideMoreAboutSub",
 CellID->4182]
}, Open  ]],
Cell[CellGroupData[{
Cell[11273, 397, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->101207568],
Cell[11345, 400, 808, 19, 70, "GuideRelatedLinks",
 CellID->283975456]
}, Open  ]],
Cell[12168, 422, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

