(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9752,        334]
NotebookOptionsPosition[      6696,        252]
NotebookOutlinePosition[      8535,        293]
CellTagsIndexPosition[      8492,        290]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Functional Iteration", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Long used in its simplest form in mathematics, functional iteration is an \
elegant way to represent repeated operations. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic architecture makes powerful general forms of functional \
iteration immediately accessible."
}], "GuideAbstract",
 CellID->295679268],

Cell[TextData[{
 Cell[TextData[ButtonBox["NestList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " successively nest a function: ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]"}], ",", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["x", "TI"], "]"}], "]"}], ",", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], "]"}], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"]
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Nest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Nest"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " give the result of nesting a function: ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]"}], "]"}], "]"}]], "InlineFormula"],
 " etc."
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["FoldList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FoldList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " successively fold in a list of values: ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["1", "TR"]}], "]"}], ",", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["1", "TR"]}], "]"}], ",", 
      StyleBox["2", "TR"]}], "]"}], ",", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["f", "TI"], "\[InvisibleSpace]", "[", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["1", "TR"]}], "]"}], ",", 
        StyleBox["2", "TR"]}], "]"}], ",", 
      StyleBox["3", "TR"]}], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"]
}], "GuideText",
 CellID->31118429],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fold",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fold"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " give the result of folding in a list of values: ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "\[InvisibleSpace]", "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["1", "TR"]}], "]"}], ",", 
      StyleBox["2", "TR"]}], "]"}], ",", 
    StyleBox["3", "TR"]}], "]"}]], "InlineFormula"],
 " etc."
}], "GuideText",
 CellID->42180157],

Cell["\t", "GuideDelimiter",
 CellID->127923459],

Cell[TextData[{
 Cell[TextData[ButtonBox["FixedPoint",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FixedPoint"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FixedPointList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FixedPointList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "nest until a fixed point is reached"
}], "GuideText",
 CellID->221674799],

Cell[TextData[{
 Cell[TextData[ButtonBox["NestWhile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestWhile"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NestWhileList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestWhileList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "nest while a condition is satisfied"
}], "GuideText",
 CellID->92954072],

Cell["\t", "GuideDelimiter",
 CellID->53483754],

Cell[TextData[{
 Cell[TextData[ButtonBox["TakeWhile",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TakeWhile"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "take from a list while a condition is satisfied"
}], "GuideText",
 CellID->19121391],

Cell[TextData[{
 Cell[TextData[ButtonBox["LengthWhile",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LengthWhile"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the length while a condition is satisfied"
}], "GuideText",
 CellID->31526161]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "GuideTutorial",\

 CellID->22069068]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "GuideMoreAbout",
 CellID->14725488]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Functional Iteration - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 23.3428266}", "context" -> "", 
    "keywords" -> {
     "conditional iteration", "cumulative sums", "cycle detection", 
      "data driven iteration", "dynamic system", "fixed point", 
      "fixed point iteration", "fixed point list", "fold list", 
      "functional composition", "functional while operation", 
      "function iteration", "iterated functions", "iterated operations", 
      "iteration of unary operators", "least fixed point", "length while", 
      "nesting of functions", "nest list", "nest while", "nest while list", 
      "Newton's approximation", "prefix operation", "take while", 
      "unary operators", "until", "while", "looping", 
      "repetitive function application"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Long used in its simplest form in mathematics, functional iteration is \
an elegant way to represent repeated operations. Mathematica's symbolic \
architecture makes powerful general forms of functional iteration immediately \
accessible.", "synonyms" -> {}, "title" -> "Functional Iteration", "type" -> 
    "Guide", "uri" -> "guide/FunctionalIteration"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 62, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[684, 28, 339, 8, 70, "GuideAbstract",
 CellID->295679268],
Cell[1026, 38, 810, 28, 70, "GuideText",
 CellID->203374175],
Cell[1839, 68, 476, 17, 70, "GuideText",
 CellID->1463276848],
Cell[2318, 87, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2369, 90, 1163, 40, 70, "GuideText",
 CellID->31118429],
Cell[3535, 132, 660, 23, 70, "GuideText",
 CellID->42180157],
Cell[4198, 157, 48, 1, 70, "GuideDelimiter",
 CellID->127923459],
Cell[4249, 160, 407, 13, 70, "GuideText",
 CellID->221674799],
Cell[4659, 175, 402, 13, 70, "GuideText",
 CellID->92954072],
Cell[5064, 190, 47, 1, 70, "GuideDelimiter",
 CellID->53483754],
Cell[5114, 193, 422, 12, 70, "GuideText",
 CellID->19121391],
Cell[5539, 207, 420, 12, 70, "GuideText",
 CellID->31526161]
}, Open  ]],
Cell[CellGroupData[{
Cell[5996, 224, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6061, 227, 176, 4, 70, "GuideTutorial",
 CellID->22069068]
}, Open  ]],
Cell[CellGroupData[{
Cell[6274, 236, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6339, 239, 161, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6503, 244, 151, 3, 70, "GuideMoreAbout",
 CellID->14725488]
}, Open  ]],
Cell[6669, 250, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

