(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18398,        610]
NotebookOptionsPosition[     13464,        479]
NotebookOutlinePosition[     16119,        533]
CellTagsIndexPosition[     16076,        530]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Functional Programming", "GuideTitle",
 CellID->15495],

Cell[TextData[{
 "Long viewed as an important theoretical idea, functional programming \
finally became truly convenient and practical with the introduction of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic language. Treating expressions like ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " as both symbolic data and the application of a function ",
 Cell[BoxData["f"], "InlineFormula"],
 " provides a uniquely powerful way to integrate structure and function\
\[LongDash]and an efficient, elegant representation of many common \
computations. "
}], "GuideAbstract",
 CellID->74745822],

Cell[TextData[{
 Cell[TextData[ButtonBox["Function",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Function"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["&",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Function"]], "InlineFunctionSans"],
 ") \[LongDash] specify a pure function (e.g. ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"#", "+", 
     StyleBox["1", "TR"]}], ")"}], "&"}]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->28255],

Cell[TextData[{
 Cell[TextData[ButtonBox["#",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Slot"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["##",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SlotSequence"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " slots for variables in a pure function"
}], "GuideText",
 CellID->4460],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Applying Functions to Lists \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ApplyingFunctionsToLists"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->474],

Cell[TextData[{
 Cell[TextData[ButtonBox["Map",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["/@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 ") \[LongDash] map across a list:  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "/@", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["z", "TI"]}], "}"}]}], "\[LongRightArrow]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["x", "TI"], "]"}], ",", 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["y", "TI"], "]"}], ",", 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["z", "TI"], "]"}]}], "}"}]}]], "InlineFormula"]
}], "GuideText",
 CellID->6972],

Cell[TextData[{
 Cell[TextData[ButtonBox["Apply",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["@@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["@@@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 ") \[LongDash] apply to a list: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "@@", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["z", "TI"]}], "}"}]}], "\[LongRightArrow]", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "]"}]}]], "InlineFormula"]
}], "GuideText",
 CellID->26821],

Cell[TextData[{
 Cell[TextData[ButtonBox["MapIndexed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapIndexed"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " map with index information: ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["1", "TR"], "}"}]}], "]"}], ",", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      StyleBox["y", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["2", "TR"], "}"}]}], "]"}], ",", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      StyleBox["z", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["3", "TR"], "}"}]}], "]"}]}], "}"}]], "InlineFormula"]
}], "GuideText",
 CellID->26122],

Cell[TextData[{
 Cell[TextData[ButtonBox["MapThread",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapThread"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MapAt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapAt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MapAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapAll"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Scan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Scan"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->25547]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Iteratively Applying Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionalIteration"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->21577],

Cell[TextData[{
 Cell[TextData[ButtonBox["Nest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Nest"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NestList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " nest a function: ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]"}], "]"}], "]"}]], "InlineFormula"],
 " etc."
}], "GuideText",
 CellID->9789],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fold",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fold"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FoldList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FoldList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " fold in a list of values: ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["1", "TR"]}], "]"}], ",", 
      StyleBox["2", "TR"]}], "]"}], ",", 
    StyleBox["3", "TR"]}], "]"}]], "InlineFormula"],
 " etc."
}], "GuideText",
 CellID->30195],

Cell[TextData[{
 Cell[TextData[ButtonBox["FixedPoint",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FixedPoint"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FixedPointList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FixedPointList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "repeatedly nest until a fixed point"
}], "GuideText",
 CellID->27594],

Cell[TextData[{
 Cell[TextData[ButtonBox["NestWhile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestWhile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NestWhileList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestWhileList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TakeWhile",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TakeWhile"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LengthWhile",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LengthWhile"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FunctionalIteration"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->7950]
}, Open  ]],

Cell[CellGroupData[{

Cell["List-Oriented Functions", "GuideFunctionsSubsection",
 CellID->16343],

Cell[TextData[{
 Cell[TextData[ButtonBox["Select",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Select"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " select from a list according to a function"
}], "GuideText",
 CellID->754],

Cell[TextData[{
 Cell[TextData[ButtonBox["Array",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " create an array from a function"
}], "GuideText",
 CellID->2481],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sort"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Split",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Split"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "sort, split according to a function"
}], "GuideText",
 CellID->479588675]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functional Composition Operations", "GuideFunctionsSubsection",
 CellID->57736022],

Cell[TextData[{
 Cell[TextData[ButtonBox["Identity",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Identity"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Composition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Composition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Operate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Operate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Through",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Through"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Distribute",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Distribute"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->53319327]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->1012],

Cell[TextData[ButtonBox["Pure Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PureFunctions"]], "GuideTutorial",
 CellID->444719777],

Cell[TextData[ButtonBox["Variables in Pure Functions and Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/VariablesInPureFunctionsAndRules"]], "GuideTutorial",
 CellID->18386687],

Cell[TextData[ButtonBox["Applying Functions to Lists and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToListsAndOtherExpressions"]], \
"GuideTutorial",
 CellID->394973314],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "GuideTutorial",
 CellID->55398090],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "GuideTutorial",\

 CellID->22069068],

Cell[TextData[ButtonBox["Selecting Parts of Expressions with Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SelectingPartsOfExpressionsWithFunctions"]], \
"GuideTutorial",
 CellID->706682969],

Cell[TextData[ButtonBox["Working with Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WorkingWithOperators"]], "GuideTutorial",
 CellID->206218356]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->13428],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "GuideMoreAbout",
 CellID->9762],

Cell[TextData[ButtonBox["Rule-Based Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "GuideMoreAbout",
 CellID->888291168],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "GuideMoreAbout",
 CellID->260515510]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Functional Programming - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 23.6709600}", "context" -> "", 
    "keywords" -> {
     "ampersand", "anonymous functions", "apply function to all parts", 
      "applying functions", "applying functions to elements of lists", 
      "applying functions to lists of expressions", 
      "applying functions to parts of expression", 
      "applying functions to parts of expressions", 
      "applying functions to parts with indices", 
      "applying functions with multiple arguments", 
      "applying indexed functions", "apply to every part", 
      "Compose (Version 1 function)", "composition of functions", 
      "distribution of operations", "distributive property", "expressions", 
      "fixed point", "fixed point iteration", "fixed point list", "fold list",
       "functional composition", "function iteration", "iterated functions", 
      "iterated operations", "iteration of unary operators", 
      "lambda expression", "length while", "lists", "lists ordering", "map", 
      "mapcar", "map all", "map at", "map indexed", "map thread", 
      "nesting of functions", "numbered parts of expressions", 
      "performing operations on heads", "prefix operation", "pure function", 
      "simultaneous application", "take while", "tree walking", 
      "unary operators", "unnamed function", "until", 
      "walking through expressions", "while"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Long viewed as an important theoretical idea, functional programming \
finally became truly convenient and practical with the introduction of \
Mathematica's symbolic language. Treating expressions like f(x) as both \
symbolic data and the application of a function f provides a uniquely \
powerful way to integrate structure and function--and an efficient, elegant \
representation of many common computations. ", "synonyms" -> {}, "title" -> 
    "Functional Programming", "type" -> "Guide", "uri" -> 
    "guide/FunctionalProgramming"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->15495],
Cell[682, 28, 655, 15, 70, "GuideAbstract",
 CellID->74745822],
Cell[1340, 45, 469, 16, 70, "GuideText",
 CellID->28255],
Cell[1812, 63, 371, 12, 70, "GuideText",
 CellID->4460],
Cell[CellGroupData[{
Cell[2208, 79, 235, 6, 70, "GuideFunctionsSubsection",
 CellID->474],
Cell[2446, 87, 854, 30, 70, "GuideText",
 CellID->6972],
Cell[3303, 119, 838, 29, 70, "GuideText",
 CellID->26821],
Cell[4144, 150, 803, 29, 70, "GuideText",
 CellID->26122],
Cell[4950, 181, 1016, 30, 70, "InlineGuideFunctionListing",
 CellID->25547]
}, Open  ]],
Cell[CellGroupData[{
Cell[6003, 216, 235, 6, 70, "GuideFunctionsSubsection",
 CellID->21577],
Cell[6241, 224, 575, 21, 70, "GuideText",
 CellID->9789],
Cell[6819, 247, 741, 27, 70, "GuideText",
 CellID->30195],
Cell[7563, 276, 403, 13, 70, "GuideText",
 CellID->27594],
Cell[7969, 291, 1333, 35, 70, "InlineGuideFunctionListing",
 CellID->7950]
}, Open  ]],
Cell[CellGroupData[{
Cell[9339, 331, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->16343],
Cell[9417, 334, 256, 8, 70, "GuideText",
 CellID->754],
Cell[9676, 344, 244, 8, 70, "GuideText",
 CellID->2481],
Cell[9923, 354, 377, 13, 70, "GuideText",
 CellID->479588675]
}, Open  ]],
Cell[CellGroupData[{
Cell[10337, 372, 88, 1, 70, "GuideFunctionsSubsection",
 CellID->57736022],
Cell[10428, 375, 1025, 29, 70, "InlineGuideFunctionListing",
 CellID->53319327]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11502, 410, 57, 1, 70, "GuideTutorialsSection",
 CellID->1012],
Cell[11562, 413, 146, 3, 70, "GuideTutorial",
 CellID->444719777],
Cell[11711, 418, 190, 4, 70, "GuideTutorial",
 CellID->18386687],
Cell[11904, 424, 216, 5, 70, "GuideTutorial",
 CellID->394973314],
Cell[12123, 431, 200, 4, 70, "GuideTutorial",
 CellID->55398090],
Cell[12326, 437, 176, 4, 70, "GuideTutorial",
 CellID->22069068],
Cell[12505, 443, 209, 5, 70, "GuideTutorial",
 CellID->706682969],
Cell[12717, 450, 161, 3, 70, "GuideTutorial",
 CellID->206218356]
}, Open  ]],
Cell[CellGroupData[{
Cell[12915, 458, 59, 1, 70, "GuideMoreAboutSection",
 CellID->13428],
Cell[12977, 461, 145, 3, 70, "GuideMoreAbout",
 CellID->9762],
Cell[13125, 466, 155, 3, 70, "GuideMoreAbout",
 CellID->888291168],
Cell[13283, 471, 139, 3, 70, "GuideMoreAbout",
 CellID->260515510]
}, Open  ]],
Cell[13437, 477, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

