(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13553,        425]
NotebookOptionsPosition[      8753,        298]
NotebookOutlinePosition[     11366,        350]
CellTagsIndexPosition[     11323,        347]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Functions for Separable Coordinate Systems", "GuideTitle",
 CellID->1908],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Cartesian Coordinates", "GuideFunctionsSubsection",
 CellID->29486],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sin"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cos",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cos"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Exp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exp"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->4319]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polar Coordinates", "GuideFunctionsSubsection",
 CellID->958],

Cell[TextData[{
 Cell[TextData[ButtonBox["BesselJ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselJ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselY",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselY"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HankelH2",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HankelH2"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->5945]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elliptical Coordinates", "GuideFunctionsSubsection",
 CellID->26806],

Cell[TextData[{
 Cell[TextData[ButtonBox["MathieuS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MathieuC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuC"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8166]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spherical Coordinates", "GuideFunctionsSubsection",
 CellID->18700],

Cell[TextData[{
 Cell[TextData[ButtonBox["SphericalHarmonicY",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SphericalHarmonicY"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LegendreP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LegendreP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalBesselJ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalBesselJ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalBesselY",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalBesselY"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalHankelH2",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalHankelH2"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LaguerreL",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LaguerreL"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->11367]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ultraspherical Coordinates", "GuideFunctionsSubsection",
 CellID->17692],

Cell[TextData[{
 Cell[TextData[ButtonBox["GegenbauerC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GegenbauerC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hypergeometric2F1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21787]
}, Open  ]],

Cell[CellGroupData[{

Cell["Toroidal Coordinates", "GuideFunctionsSubsection",
 CellID->28532],

Cell[TextData[{
 Cell[TextData[ButtonBox["LegendreQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LegendreQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LegendreP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LegendreP"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->30556]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spheroidal Coordinates", "GuideFunctionsSubsection",
 CellID->30974],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpheroidalPS",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalPS"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalS1",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalS1"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->3447]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->5021],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->16541]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->29331],

Cell[TextData[ButtonBox["Vector Analysis",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VectorAnalysis/guide/VectorAnalysisPackage"]], "GuideMoreAbout",
 CellID->78040636],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAbout",
 CellID->14700],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "GuideMoreAboutSub",
 CellID->21766],

Cell[TextData[ButtonBox["Functions Used In Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsUsedInQuantumMechanics"]], "GuideMoreAbout",
 CellID->16141],

Cell[TextData[ButtonBox["Spheroidal & Related Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SpheroidalAndRelatedFunctions"]], "GuideMoreAboutSub",
 CellID->12723],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "GuideMoreAbout",
 CellID->373399802]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->58445345],

Cell[TextData[{
 ButtonBox["Demonstrations related to Functions for Separable Coordinate \
Systems",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
BesselJ+OR+BesselY+OR+Cos+OR+Exp+OR+GegenbauerC+OR+HankelH2+OR+\
Hypergeometric2F1+OR+LaguerreL+OR+LegendreP+OR+LegendreQ+OR+MathieuC+OR+\
MathieuS+OR+Sin+OR+SphericalBesselJ+OR+SphericalBesselY+OR+SphericalHankelH2+\
OR+SphericalHarmonicY+OR+SpheroidalPS+OR+SpheroidalS1)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->38605533]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Functions for Separable Coordinate Systems - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 24.1553474}", "context" -> "", 
    "keywords" -> {
     "2F1", "alog", "antilg", "antilog", "antilogarithm", 
      "band structure calculations", "band\\[Hyphen]limited functions", 
      "Bessel functions", "Bessel J", "Blanch's Newton method", "CE", 
      "conical functions", "cylindrical functions", "differential equations", 
      "electron wave functions", "elliptical geometries", "exponenta", 
      "exponential", "Gauss hypergeometric function", "Gauss series", 
      "Gegenbauer functions", "Gegenbauer polynomials", 
      "Hankel function of the second kind", "Hankel functions", "Hankel H2", 
      "Hill's equation", "hypergeometric 2F1", "hypergeometric functions", 
      "hyperspherical polynomials", "Kummer series", "Laguerre functions", 
      "ldexp", "Legendre function of second kind", "Legendre functions", 
      "Legendre polynomials", "Mathieu function C", "Mathieu function S", 
      "MathieuS", "Neumann function", "parametric amplifiers", "Paul traps", 
      "penning traps", "Penning traps", "periodic potentials", 
      "Riemann P function", "ring functions", "Schrodinger equation", 
      "Schroedinger", "Schro\"dinger equation", "SE", "sen", "sin", "sine", 
      "sinus", "solid-state physics", "spherical bessel", "spherical Bessel", 
      "spherical Bessel function", "spherical Bessel J", "spherical Bessel Y",
       "spherical Hankel function", "spherical Hankel H2", 
      "spherical harmonic", "spherical harmonics", "spherical harmonic Y", 
      "spheroidal functions", "spheroidal harmonics", "spheroidal s1", 
      "toroidal functions", "ultraspherical polynomials", "Weber functions"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "Functions for Separable Coordinate Systems",
     "type" -> "Guide", "uri" -> 
    "guide/FunctionsForSeparableCoordinateSystems"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 79, 1, 70, "GuideTitle",
 CellID->1908],
Cell[701, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[782, 33, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->29486],
Cell[858, 36, 569, 17, 70, "InlineGuideFunctionListing",
 CellID->4319]
}, Open  ]],
Cell[CellGroupData[{
Cell[1464, 58, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->958],
Cell[1534, 61, 740, 20, 70, "InlineGuideFunctionListing",
 CellID->5945]
}, Open  ]],
Cell[CellGroupData[{
Cell[2311, 86, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->26806],
Cell[2388, 89, 391, 11, 70, "InlineGuideFunctionListing",
 CellID->8166]
}, Open  ]],
Cell[CellGroupData[{
Cell[2816, 105, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->18700],
Cell[2892, 108, 1733, 44, 70, "InlineGuideFunctionListing",
 CellID->11367]
}, Open  ]],
Cell[CellGroupData[{
Cell[4662, 157, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->17692],
Cell[4743, 160, 416, 11, 70, "InlineGuideFunctionListing",
 CellID->21787]
}, Open  ]],
Cell[CellGroupData[{
Cell[5196, 176, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->28532],
Cell[5271, 179, 396, 11, 70, "InlineGuideFunctionListing",
 CellID->30556]
}, Open  ]],
Cell[CellGroupData[{
Cell[5704, 195, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->30974],
Cell[5781, 198, 697, 17, 70, "InlineGuideFunctionListing",
 CellID->3447]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6527, 221, 57, 1, 70, "GuideTutorialsSection",
 CellID->5021],
Cell[6587, 224, 148, 3, 70, "GuideTutorial",
 CellID->16541]
}, Open  ]],
Cell[CellGroupData[{
Cell[6772, 232, 59, 1, 70, "GuideMoreAboutSection",
 CellID->29331],
Cell[6834, 235, 170, 4, 70, "GuideMoreAbout",
 CellID->78040636],
Cell[7007, 241, 146, 3, 70, "GuideMoreAbout",
 CellID->14700],
Cell[7156, 246, 161, 3, 70, "GuideMoreAboutSub",
 CellID->21766],
Cell[7320, 251, 182, 4, 70, "GuideMoreAbout",
 CellID->16141],
Cell[7505, 257, 178, 4, 70, "GuideMoreAboutSub",
 CellID->12723],
Cell[7686, 263, 179, 3, 70, "GuideMoreAbout",
 CellID->373399802]
}, Open  ]],
Cell[CellGroupData[{
Cell[7902, 271, 68, 1, 70, "GuideRelatedLinksSection",
 CellID->58445345],
Cell[7973, 274, 738, 19, 70, "GuideRelatedLinks",
 CellID->38605533]
}, Open  ]],
Cell[8726, 296, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

