(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15197,        466]
NotebookOptionsPosition[     10081,        334]
NotebookOutlinePosition[     12948,        389]
CellTagsIndexPosition[     12905,        386]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Functions Used in Quantum Mechanics", "GuideTitle",
 CellID->16828],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Harmonic Oscillator", "GuideFunctionsSubsection",
 CellID->17612],

Cell[TextData[{
 Cell[TextData[ButtonBox["HermiteH",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HermiteH"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LaguerreL",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LaguerreL"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->18703]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hydrogen Atom", "GuideFunctionsSubsection",
 CellID->11027],

Cell[TextData[{
 Cell[TextData[ButtonBox["SphericalHarmonicY",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SphericalHarmonicY"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LaguerreL",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LaguerreL"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hypergeometric1F1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WhittakerM",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/WhittakerM"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->11408]
}, Open  ]],

Cell[CellGroupData[{

Cell["Linear Potential", "GuideFunctionsSubsection",
 CellID->5545],

Cell[TextData[{
 Cell[TextData[ButtonBox["AiryAi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AiryAi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryAiPrime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryBi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AiryBi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryAiZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AiryAiZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryBiZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AiryBiZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->9508]
}, Open  ]],

Cell[CellGroupData[{

Cell["Periodic Potential", "GuideFunctionsSubsection",
 CellID->7185],

Cell[TextData[{
 Cell[TextData[ButtonBox["MathieuS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MathieuC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MathieuCharacteristicExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuCharacteristicExponent"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->30238]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spheroidal Geometries", "GuideFunctionsSubsection",
 CellID->24237],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpheroidalPS",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalPS"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalS1",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalS1"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalEigenvalue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalEigenvalue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->26443]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scattering Theory", "GuideFunctionsSubsection",
 CellID->21313],

Cell[TextData[{
 Cell[TextData[ButtonBox["LegendreP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LegendreP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalBesselJ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalBesselJ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LegendreQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LegendreQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->22501]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dirac Equation Solutions", "GuideFunctionsSubsection",
 CellID->8850],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hypergeometric1F1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselK",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselK"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->25128]
}, Open  ]],

Cell[CellGroupData[{

Cell["Angular Momentum", "GuideFunctionsSubsection",
 CellID->2111],

Cell[TextData[{
 Cell[TextData[ButtonBox["ClebschGordan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ClebschGordan"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ThreeJSymbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ThreeJSymbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SixJSymbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SixJSymbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiP"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->23650]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->28149],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->16541]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->15869],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAboutSub",
 CellID->3967],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "GuideMoreAboutSub",
 CellID->21766],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "GuideMoreAbout",
 CellID->471342786],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "GuideMoreAbout",
 CellID->373399802]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1588117574],

Cell[TextData[{
 ButtonBox["Demonstrations related to Functions Used in Quantum Mechanics",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
AiryAi+OR+AiryAiPrime+OR+AiryAiZero+OR+AiryBi+OR+AiryBiZero+OR+BesselK+OR+\
ClebschGordan+OR+HermiteH+OR+Hypergeometric1F1+OR+JacobiP+OR+LaguerreL+OR+\
LegendreP+OR+LegendreQ+OR+MathieuC+OR+MathieuCharacteristicExponent+OR+\
MathieuS+OR+SixJSymbol+OR+SphericalBesselJ+OR+SphericalHarmonicY+OR+\
SpheroidalEigenvalue+OR+SpheroidalPS+OR+SpheroidalS1+OR+ThreeJSymbol+OR+\
WhittakerM)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->24758231]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Functions Used in Quantum Mechanics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 25.4991318}", "context" -> "", 
    "keywords" -> {
     "1F1", "3j", "3-j symbols", "6j", "6-j symbols", "ai", "airy", "Airy Ai",
       "Airy Ai prime", "Airy Ai zero", "Airy Bi", "Airy Bi zero", 
      "Airy derivative", "Airy functions", "band structure calculations", 
      "band\\[Hyphen]limited functions", "Bateman functions", "bi", 
      "Blanch's Newton method", "CE", "Clebsch-Gordan", "Clebsch Gordan", 
      "confluent hypergeometric function", "conical functions", 
      "Coulomb wave function", "Cunningham function", "cylindrical functions",
       "eigenvalue", "electron wave functions", "elliptical geometries", 
      "Floquet solution", "Hermite functions", "Hermite H", "Hill's equation",
       "hypergeometric 1F1", "hypergeometric functions", "Jacobi functions", 
      "Jacobi polynomial", "Jacobi polynomials", "Kummer function", 
      "Laguerre functions", "Legendre function of second kind", 
      "Legendre functions", "Legendre polynomials", 
      "Mathieu characteristic exponent", "Mathieu function C", 
      "Mathieu function S", "Mathieu functions", "MathieuS", 
      "parabolic cylinder functions", "parametric amplifiers", "Paul traps", 
      "penning traps", "Penning traps", "periodic potentials", 
      "Poisson-Charlier polynomials", "Racah coefficients", "ring functions", 
      "Schrodinger equation", "Schro\"dinger equation", "SE", "sixj", 
      "six j symbol", "six symbol", "solid-state physics", "spherical bessel",
       "spherical Bessel function", "spherical Bessel J", 
      "spherical harmonic", "spherical harmonics", "spherical harmonic Y", 
      "spheroidal eigenvalue", "spheroidal functions", "spheroidal harmonics",
       "spheroidal s1", "three-j symbol", "three symbol", 
      "toroidal functions", "Whittaker functions", "Wigner 3j-symbol", 
      "Wigner 6j-symbol", "Wigner coefficients", "zero of airy function", 
      "zero of Airy function"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> "", "synonyms" -> {}, "title" -> 
    "Functions Used in Quantum Mechanics", "type" -> "Guide", "uri" -> 
    "guide/FunctionsUsedInQuantumMechanics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 73, 1, 70, "GuideTitle",
 CellID->16828],
Cell[695, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[776, 33, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->17612],
Cell[850, 36, 394, 11, 70, "InlineGuideFunctionListing",
 CellID->18703]
}, Open  ]],
Cell[CellGroupData[{
Cell[1281, 52, 65, 1, 70, "GuideFunctionsSubsection",
 CellID->11027],
Cell[1349, 55, 997, 26, 70, "InlineGuideFunctionListing",
 CellID->11408]
}, Open  ]],
Cell[CellGroupData[{
Cell[2383, 86, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->5545],
Cell[2453, 89, 1311, 35, 70, "InlineGuideFunctionListing",
 CellID->9508]
}, Open  ]],
Cell[CellGroupData[{
Cell[3801, 129, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->7185],
Cell[3873, 132, 645, 18, 70, "InlineGuideFunctionListing",
 CellID->30238]
}, Open  ]],
Cell[CellGroupData[{
Cell[4555, 155, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->24237],
Cell[4631, 158, 1075, 26, 70, "InlineGuideFunctionListing",
 CellID->26443]
}, Open  ]],
Cell[CellGroupData[{
Cell[5743, 189, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->21313],
Cell[5815, 192, 765, 20, 70, "InlineGuideFunctionListing",
 CellID->22501]
}, Open  ]],
Cell[CellGroupData[{
Cell[6617, 217, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->8850],
Cell[6695, 220, 408, 11, 70, "InlineGuideFunctionListing",
 CellID->25128]
}, Open  ]],
Cell[CellGroupData[{
Cell[7140, 236, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->2111],
Cell[7210, 239, 828, 23, 70, "InlineGuideFunctionListing",
 CellID->23650]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8087, 268, 58, 1, 70, "GuideTutorialsSection",
 CellID->28149],
Cell[8148, 271, 148, 3, 70, "GuideTutorial",
 CellID->16541]
}, Open  ]],
Cell[CellGroupData[{
Cell[8333, 279, 59, 1, 70, "GuideMoreAboutSection",
 CellID->15869],
Cell[8395, 282, 148, 3, 70, "GuideMoreAboutSub",
 CellID->3967],
Cell[8546, 287, 161, 3, 70, "GuideMoreAboutSub",
 CellID->21766],
Cell[8710, 292, 200, 4, 70, "GuideMoreAbout",
 CellID->471342786],
Cell[8913, 298, 179, 3, 70, "GuideMoreAbout",
 CellID->373399802]
}, Open  ]],
Cell[CellGroupData[{
Cell[9129, 306, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1588117574],
Cell[9202, 309, 837, 20, 70, "GuideRelatedLinks",
 CellID->24758231]
}, Open  ]],
Cell[10054, 332, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

