(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17519,        505]
NotebookOptionsPosition[     12033,        379]
NotebookOutlinePosition[     15658,        444]
CellTagsIndexPosition[     15615,        441]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Functions Used in Statistics", "GuideTitle",
 CellID->18634],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s sophisticated algorithms for handling higher mathematical functions to \
arbitrary precision\[LongDash]and in symbolic form\[LongDash]immediately \
brings a new level of accuracy\[LongDash]and analytical \
capability\[LongDash]to statistical computation."
}], "GuideAbstract",
 CellID->284324045],

Cell[TextData[{
 Cell[TextData[ButtonBox["Erf",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Erf"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Erfc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Erfc"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " integrals of the normal distribution"
}], "GuideText",
 CellID->28442],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseErf",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseErf"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["InverseErfc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseErfc"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " confidence intervals of the normal distribution"
}], "GuideText",
 CellID->5177],

Cell["\t", "GuideDelimiter",
 CellID->13877],

Cell[TextData[{
 Cell[TextData[ButtonBox["BetaRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BetaRegularized"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " CDF of Student ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " distribution"
}], "GuideText",
 CellID->25770],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseBetaRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseBetaRegularized"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " quantiles of Student ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " and beta distributions"
}], "GuideText",
 CellID->1381],

Cell[TextData[{
 Cell[TextData[ButtonBox["GammaRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GammaRegularized"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "CDF of gamma distribution"
}], "GuideText",
 CellID->233513758],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseGammaRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " quantiles of gamma and related distributions"
}], "GuideText",
 CellID->14364],

Cell["\t", "GuideDelimiter",
 CellID->16590],

Cell[TextData[{
 Cell[TextData[ButtonBox["Binomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Binomial"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Multinomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Multinomial"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Beta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Beta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Gamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Gamma"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Exp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exp"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Log",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Log"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Floor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Floor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Factorial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["!",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 ")"
}], "InlineGuideFunctionListing",
 CellID->8823],

Cell[TextData[{
 Cell[TextData[ButtonBox["HypergeometricPFQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hypergeometric1F1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hypergeometric2F1Regularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric2F1Regularized"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->290651869],

Cell["\t", "GuideDelimiterSubsection",
 CellID->487122110],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Statistical Distributions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StatisticalDistributions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->760545978],

Cell[TextData[{
 Cell[TextData[ButtonBox["NormalDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NormalDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChiSquareDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChiSquareDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StudentTDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogNormalDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogNormalDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BetaDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BetaDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExtremeValueDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExtremeValueDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StatisticalDistributions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->49235723],

Cell[TextData[{
 Cell[TextData[ButtonBox["PoissonDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PoissonDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinomialDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinomialDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HypergeometricDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HypergeometricDistribution"]], "InlineFunctionSans",
  
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StatisticalDistributions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->279746668]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->2237],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "GuideTutorial",
 CellID->8023],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "GuideTutorial",
 CellID->32179],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "GuideTutorial",
 CellID->708720992],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "GuideTutorial",
 CellID->896230699]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->16595],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAboutSub",
 CellID->3967],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAboutSub",
 CellID->31310]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->417817655],

Cell[TextData[{
 ButtonBox["Demonstrations related to Functions Used in Statistics",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(Beta+\
OR+BetaDistribution+OR+BetaRegularized+OR+Binomial+OR+BinomialDistribution+OR+\
ChiSquareDistribution+OR+Erf+OR+Erfc+OR+Exp+OR+ExtremeValueDistribution+OR+\
Factorial+OR+Floor+OR+Gamma+OR+GammaRegularized+OR+Hypergeometric1F1+OR+\
Hypergeometric2F1Regularized+OR+HypergeometricDistribution+OR+\
HypergeometricPFQ+OR+InverseBetaRegularized+OR+InverseErf+OR+InverseErfc+OR+\
InverseGammaRegularized+OR+Log+OR+LogNormalDistribution+OR+Multinomial+OR+\
NormalDistribution+OR+PoissonDistribution+OR+StudentTDistribution)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->40757487]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Functions Used in Statistics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 26.1397732}", "context" -> "", 
    "keywords" -> {
     "0F0", "1F0", "1F1", "1F2", "2F1 regularized", "2F2", "2F3", "3F2", 
      "4F3", "5F4", "6F5", "alog", "antilg", "antilog", "antilogarithm", 
      "bang", "Barnes extended hypergeometric function", "Bateman functions", 
      "beta distribution", "beta function", "beta regularized", "binom", 
      "binomial distribution", "binomials", "binomial trials", 
      "chi squared distribution", "chi square distribution", "choose", 
      "coin tossing", "comb", "combinations", "complementary error function", 
      "confidence intervals", "confluent hypergeometric function", 
      "Coulomb wave function", "Cunningham function", "entier", "entire", 
      "error", "error function", "Euler beta function", 
      "Euler gamma function", "exclamation point", "exponenta", "exponential",
       "extreme-value distribution", "extreme value distribution", "fact", 
      "factorial", "factorial function", "Fisher-Tippett distribution", 
      "frlog", "gamma function", "gamma regularized", "Gaussian distribution",
       "Gaussian integral", "Gaussian random numbers", "Gauss integral", 
      "generalized hypergeometric function", "greatest integer function", 
      "hypergeom", "hypergeometric 1F1", "hypergeometric2 f1 regularized", 
      "hypergeometric distribution", "hypergeometric functions", "ilog", 
      "incomplete beta function", "incomplete gamma function", 
      "infrequent events", "inverse beta regularized", "inverse erf", 
      "inverse erfc", "inverse gamma regularized", 
      "inverse regularized beta function", "inverse regularized gamma", 
      "Kummer function", "law of big numbers", "ld", "ldexp", "lg", "ln", 
      "log10", "logarithm", "lognormal", "log normal distribution", 
      "lognormal distribution", "log\\[Hyphen]Weibull distribution", 
      "multinomial", "multinomial coefficients", "natural logarithm", 
      "n-choose-k", "nchoosek", "nCk", "nearest integer function", 
      "non-frequent events", "normal distribution", "number of partitions", 
      "parabolic cylinder functions", "Pearson chi square", 
      "Pearson chi squared", "pfq", "Poisson-Charlier polynomials", 
      "Poisson distribution", "Poisson process", "rare events", "round down", 
      "rounddown", "sampling without replacement", "shriek", 
      "standard normal distribution", "statistics", "student distribution", 
      "t distribution", "urn problem", "Whittaker functions"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's sophisticated algorithms for handling higher mathematical \
functions to arbitrary precision--and in symbolic form--immediately brings a \
new level of accuracy--and analytical capability--to statistical \
computation.", "synonyms" -> {}, "title" -> "Functions Used in Statistics", 
    "type" -> "Guide", "uri" -> "guide/FunctionsUsedInStatistics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 66, 1, 70, "GuideTitle",
 CellID->18634],
Cell[688, 28, 366, 8, 70, "GuideAbstract",
 CellID->284324045],
Cell[1057, 38, 365, 12, 70, "GuideText",
 CellID->28442],
Cell[1425, 52, 403, 12, 70, "GuideText",
 CellID->5177],
Cell[1831, 66, 44, 1, 70, "GuideDelimiter",
 CellID->13877],
Cell[1878, 69, 331, 11, 70, "GuideText",
 CellID->25770],
Cell[2212, 82, 360, 11, 70, "GuideText",
 CellID->1381],
Cell[2575, 95, 270, 9, 70, "GuideText",
 CellID->233513758],
Cell[2848, 106, 294, 8, 70, "GuideText",
 CellID->14364],
Cell[3145, 116, 44, 1, 70, "GuideDelimiter",
 CellID->16590],
Cell[3192, 119, 1734, 52, 70, "InlineGuideFunctionListing",
 CellID->8823],
Cell[4929, 173, 683, 18, 70, "InlineGuideFunctionListing",
 CellID->290651869],
Cell[5615, 193, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->487122110],
Cell[CellGroupData[{
Cell[5698, 198, 239, 6, 70, "GuideFunctionsSubsection",
 CellID->760545978],
Cell[5940, 206, 2465, 60, 70, "InlineGuideFunctionListing",
 CellID->49235723],
Cell[8408, 268, 1348, 34, 70, "InlineGuideFunctionListing",
 CellID->279746668]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9805, 308, 57, 1, 70, "GuideTutorialsSection",
 CellID->2237],
Cell[9865, 311, 145, 3, 70, "GuideTutorial",
 CellID->8023],
Cell[10013, 316, 160, 3, 70, "GuideTutorial",
 CellID->32179],
Cell[10176, 321, 162, 3, 70, "GuideTutorial",
 CellID->708720992],
Cell[10341, 326, 166, 3, 70, "GuideTutorial",
 CellID->896230699]
}, Open  ]],
Cell[CellGroupData[{
Cell[10544, 334, 59, 1, 70, "GuideMoreAboutSection",
 CellID->16595],
Cell[10606, 337, 148, 3, 70, "GuideMoreAboutSub",
 CellID->3967],
Cell[10757, 342, 155, 3, 70, "GuideMoreAboutSub",
 CellID->31310]
}, Open  ]],
Cell[CellGroupData[{
Cell[10949, 350, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->417817655],
Cell[11021, 353, 970, 21, 70, "GuideRelatedLinks",
 CellID->40757487]
}, Open  ]],
Cell[12006, 377, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

