(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10561,        333]
NotebookOptionsPosition[      7260,        244]
NotebookOutlinePosition[      9091,        284]
CellTagsIndexPosition[      9048,        281]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Gamepad & Device Interface", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "As soon as you connect almost any kind of controller or input device to \
your computer, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will immediately let you use it to control ",
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", 3D graphics, etc. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also provides a symbolic representation that makes it uniquely easy to \
incorporate support for sophisticated interface devices in any program",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides special support for the Wolfram Research 2+12 degree-of-freedom \
gamepad. \n"
}], "GuideAbstract",
 CellID->537545411],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControllerInformation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerInformation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "dynamically updated information on all connected controllers"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControllerState",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerState"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "states of particular controls"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->16942755],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControllerManipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerManipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "interactively manipulate anything using external controllers"
}], "GuideText",
 CellID->2728839],

Cell[TextData[{
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " manipulate anything, with controls visible on the screen"
}], "GuideText",
 CellID->503986332],

Cell[TextData[{
 Cell[TextData[ButtonBox["Graphics3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Graphics3D"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Plot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plot3D"]], "InlineFunctionSans"],
 ", ",
 Cell[BoxData["..."], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " use joysticks etc. to rotate 3D graphics"
}], "GuideText",
 CellID->557083550],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControllerLinking",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerLinking"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " when to make a controller operate on a displayed object"
}], "GuideText",
 CellID->692906207],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControllerMethod",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerMethod"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "how to set up default controls for an object"
}], "GuideText",
 CellID->662792806],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControllerPath",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerPath"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify preference order for external controllers"
}], "GuideText",
 CellID->282685967],

Cell[TextData[{
 Cell[TextData[ButtonBox["LocalizeVariables",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LocalizeVariables"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "whether to allow controllers to have global effects "
}], "GuideText",
 CellID->74059982],

Cell["\t", "GuideDelimiter",
 CellID->293778372],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControlActive",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControlActive"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify \"preview\" settings when controls are active"
}], "GuideText",
 CellID->80705541]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "GuideTutorial",
 CellID->29812],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "GuideTutorial",\

 CellID->19375]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Interactive 3D Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Interactive3DControl"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Sound & Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "GuideMoreAbout",
 CellID->627958272]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Gamepad & Device Interface - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 31.1086504}", "context" -> "", 
    "keywords" -> {
     "applets", "click-interactive panels", "control active", 
      "controller information", "controller linking", "controller manipulate",
       "controller method", "controller path", "controller state", "controls",
       "direct manipulation", "gamepad", "graphical user interface", "GUI", 
      "HID", "interactive", "interactive panels", "interface builder", 
      "joystick", "mouse interactive", "user interfaces"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "As soon as you connect almost any kind of controller or input device to \
your computer, Mathematica will immediately let you use it to control \
Manipulate, 3D graphics, etc. Mathematica also provides a symbolic \
representation that makes it uniquely easy to incorporate support for \
sophisticated interface devices in any program. Mathematica provides special \
support for the Wolfram Research 2+12 degree-of-freedom gamepad. ", 
    "synonyms" -> {}, "title" -> "Gamepad & Device Interface", "type" -> 
    "Guide", "uri" -> "guide/GamepadAndDeviceInterface"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 68, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[690, 28, 887, 23, 70, "GuideAbstract",
 CellID->537545411],
Cell[1580, 53, 460, 12, 70, "GuideText",
 CellID->203374175],
Cell[2043, 67, 418, 12, 70, "GuideText",
 CellID->1463276848],
Cell[2464, 81, 47, 1, 70, "GuideDelimiter",
 CellID->16942755],
Cell[2514, 84, 456, 12, 70, "GuideText",
 CellID->2728839],
Cell[2973, 98, 429, 11, 70, "GuideText",
 CellID->503986332],
Cell[3405, 111, 444, 14, 70, "GuideText",
 CellID->557083550],
Cell[3852, 127, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[3903, 130, 442, 11, 70, "GuideText",
 CellID->692906207],
Cell[4348, 143, 434, 12, 70, "GuideText",
 CellID->662792806],
Cell[4785, 157, 435, 12, 70, "GuideText",
 CellID->282685967],
Cell[5223, 171, 443, 12, 70, "GuideText",
 CellID->74059982],
Cell[5669, 185, 48, 1, 70, "GuideDelimiter",
 CellID->293778372],
Cell[5720, 188, 436, 12, 70, "GuideText",
 CellID->80705541]
}, Open  ]],
Cell[CellGroupData[{
Cell[6193, 205, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6258, 208, 159, 3, 70, "GuideTutorial",
 CellID->29812],
Cell[6420, 213, 175, 4, 70, "GuideTutorial",
 CellID->19375]
}, Open  ]],
Cell[CellGroupData[{
Cell[6632, 222, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6697, 225, 160, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6860, 230, 157, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[7020, 235, 198, 4, 70, "GuideMoreAbout",
 CellID->627958272]
}, Open  ]],
Cell[7233, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

