(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7621,        271]
NotebookOptionsPosition[      4656,        181]
NotebookOutlinePosition[      5959,        214]
CellTagsIndexPosition[      5916,        211]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Geospatial Formats", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can import common terrain elevation files and render them as topographic \
maps. It can also import geospatial information formats that combine layers \
of raster, vector, and textual information."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["Terrain Elevation Formats", "GuideFunctionsSubsection",
 CellID->1201979730],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"USGSDEM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/USGSDEM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " USGS ASCII DEM digital elevation file (.dem)"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"GTOPO30\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GTOPO30"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "USGS global topographic data (.dem)"
}], "GuideText",
 CellID->1025340820],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"CDED\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CDED"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Canadian digital elevation data (.dem)"
}], "GuideText",
 CellID->1575849173],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SDTS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SDTS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " SDTS digital elevation files"
}], "GuideText",
 CellID->188781977]
}, Open  ]],

Cell[CellGroupData[{

Cell["GIS Formats", "GuideFunctionsSubsection",
 CellID->1425194119],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SDTS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SDTS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " SDTS DLG spatial data transfer standard"
}], "GuideText",
 CellID->204959395],

Cell["\t", "GuideDelimiterSubsection",
 CellID->8546]
}, Open  ]],

Cell[CellGroupData[{

Cell["Common Elements", "GuideFunctionsSubsection",
 CellID->20474],

Cell["\<\
\"Data\" \[LongDash] array of elevation samples\
\>", "GuideText",
 CellID->382775788],

Cell[TextData[{
 "\"Graphics\" \[LongDash] topographic data rendered as a ",
 Cell[TextData[ButtonBox["ReliefPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ReliefPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "GuideText",
 CellID->180645367],

Cell["\<\
\"Rules\" \[LongDash] rules for all elements\
\>", "GuideText",
 CellID->8880],

Cell["\<\
\"Elements\" \[LongDash] all available elements\
\>", "GuideText",
 CellID->11500518]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "GuideTutorial",
 CellID->207014367],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->76300026]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "GuideMoreAbout",
 CellID->479778287],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAboutSub",
 CellID->19396],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60VisualizationAndGraphics"]], "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Geospatial Formats - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 32.8586952}", "context" -> "", 
    "keywords" -> {
     "bas-relief", "cartography", "digital elevation data", "embossing", 
      "GIS data", "mapping", "relief plot", "relief shading", "terrain"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica can import common terrain elevation files and render them as \
topographic maps. It can also import geospatial information formats that \
combine layers of raster, vector, and textual information.", "synonyms" -> {},
     "title" -> "Geospatial Formats", "type" -> "Guide", "uri" -> 
    "guide/GeospatialFormats"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[682, 28, 307, 7, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1014, 39, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->1201979730],
Cell[1099, 42, 277, 8, 70, "GuideText",
 CellID->203374175],
Cell[1379, 52, 274, 9, 70, "GuideText",
 CellID->1025340820],
Cell[1656, 63, 266, 8, 70, "GuideText",
 CellID->1575849173],
Cell[1925, 73, 255, 8, 70, "GuideText",
 CellID->188781977]
}, Open  ]],
Cell[CellGroupData[{
Cell[2217, 86, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->1425194119],
Cell[2288, 89, 266, 8, 70, "GuideText",
 CellID->204959395],
Cell[2557, 99, 53, 1, 70, "GuideDelimiterSubsection",
 CellID->8546]
}, Open  ]],
Cell[CellGroupData[{
Cell[2647, 105, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->20474],
Cell[2717, 108, 96, 3, 70, "GuideText",
 CellID->382775788],
Cell[2816, 113, 381, 9, 70, "GuideText",
 CellID->180645367],
Cell[3200, 124, 88, 3, 70, "GuideText",
 CellID->8880],
Cell[3291, 129, 95, 3, 70, "GuideText",
 CellID->11500518]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3435, 138, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[3500, 141, 172, 3, 70, "GuideTutorial",
 CellID->207014367],
Cell[3675, 146, 173, 3, 70, "GuideTutorial",
 CellID->76300026]
}, Open  ]],
Cell[CellGroupData[{
Cell[3885, 154, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3950, 157, 152, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[4105, 162, 158, 3, 70, "GuideMoreAbout",
 CellID->479778287],
Cell[4266, 167, 158, 3, 70, "GuideMoreAboutSub",
 CellID->19396],
Cell[4427, 172, 187, 4, 70, "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],
Cell[4629, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

