(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11404,        384]
NotebookOptionsPosition[      7656,        279]
NotebookOutlinePosition[      9503,        319]
CellTagsIndexPosition[      9460,        316]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Graphics Interactivity & Drawing", "GuideTitle",
 CellID->12737],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s unified symbolic graphics architecture makes possible powerful mixing of \
programmatic graphics generation with interactive editing and control. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 StyleBox["Drawing", "DialogElementName"],
 " palette makes it straightforward to modify existing plots or illustrations\
\[LongDash]or to create free-form ones from scratch. "
}], "GuideAbstract",
 CellID->850833151],

Cell[CellGroupData[{

Cell["Direct Interactive Drawing & Editing", "GuideFunctionsSubsection",
 CellID->20556],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["1", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " create a new empty graphic"
}], "GuideText",
 CellID->470797579],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["D", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " bring up the ",
 StyleBox["Drawing Tools", "DialogElementName"],
 " palette"
}], "GuideText",
 CellID->16060],

Cell[TextData[{
 StyleBox["Multi Click", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " select subparts of groups and insets"
}], "GuideText",
 CellID->447393428],

Cell[TextData[{
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Drag", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " resize changing aspect ratio"
}], "GuideText",
 CellID->418984810],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["G", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " bring up the graphics inspector"
}], "GuideText",
 CellID->206584097],

Cell["\t", "GuideDelimiterSubsection",
 CellID->21901]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Programmatic Interactive Graphics \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ClickInteractivePanels"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->58267697],

Cell[TextData[{
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create a complete framework for interactive graphics"
}], "GuideText",
 CellID->807621954],

Cell[TextData[{
 Cell[TextData[ButtonBox["Locator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Locator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " interactively movable control point ",
 Cell[BoxData[
  GraphicsBox[LocatorBox[Scaled[{0.36363636363636365`, 0.5909090909090909}]],
   ImageSize->{22., Automatic},
   PlotRange->1]]]
}], "GuideText",
 CellID->28074],

Cell[TextData[{
 Cell[TextData[ButtonBox["LocatorPane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LocatorPane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ClickPane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ClickPane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EventHandler",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EventHandler"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ClickInteractivePanels"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->71688709],

Cell["\t", "GuideDelimiterSubsection",
 CellID->58942774]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Interactive 3D Control \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Interactive3DControl"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->8793],

Cell[TextData[{
 StyleBox["Drag", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " rotate a 3D graphic"
}], "GuideText",
 CellID->3432],

Cell[TextData[{
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Drag", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " zoom"
}], "GuideText",
 CellID->2136],

Cell["\t", "GuideDelimiterSubsection",
 CellID->536867978]
}, Open  ]],

Cell[CellGroupData[{

Cell["Imported Graphics", "GuideFunctionsSubsection",
 CellID->485780743],

Cell[TextData[{
 StyleBox[ButtonBox["Cell",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CellMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Convert To",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ConvertTo"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["StandardForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/StandardForm"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make a copied graphic evaluatable"
}], "GuideText",
 CellID->88800246]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->8719],

Cell[TextData[{
 ButtonBox["Editing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
  FontSlant->"Italic"],
 ButtonBox[" Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"]
}], "GuideTutorial",
 CellID->60508230],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "GuideTutorial",
 CellID->912269080],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "GuideTutorial",
 CellID->28810171]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->30041],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "GuideMoreAbout",
 CellID->8329]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graphics Interactivity & Drawing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 39.6401188}", "context" -> "", 
    "keywords" -> {
     "applets", "applet window", "click-interactive", 
      "click-interactive panels", "click pane", "controls", "diagrams", 
      "direct manipulation", "event handler", "event handling", "gamepad", 
      "graphical user interface", "grip", "GUI", "handle", "hit testing", 
      "image map", "imagemap", "interactive", "interactive panels", 
      "interface builder", "joystick", "knob", "locator pane", 
      "mouse interactive", "movable thumb", "multilocator", "painting", 
      "slider", "slider pane", "thumb", "thumbs", "user interfaces"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's unified symbolic graphics architecture makes possible \
powerful mixing of programmatic graphics generation with interactive editing \
and control. The Mathematica Drawing palette makes it straightforward to \
modify existing plots or illustrations--or to create free-form ones from \
scratch. ", "synonyms" -> {}, "title" -> "Graphics Interactivity & Drawing", 
    "type" -> "Guide", "uri" -> "guide/GraphicsInteractivityAndDrawing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 70, 1, 70, "GuideTitle",
 CellID->12737],
Cell[692, 28, 495, 12, 70, "GuideAbstract",
 CellID->850833151],
Cell[CellGroupData[{
Cell[1212, 44, 88, 1, 70, "GuideFunctionsSubsection",
 CellID->20556],
Cell[1303, 47, 226, 8, 70, "GuideText",
 CellID->470797579],
Cell[1532, 57, 271, 10, 70, "GuideText",
 CellID->16060],
Cell[1806, 69, 182, 6, 70, "GuideText",
 CellID->447393428],
Cell[1991, 77, 236, 8, 70, "GuideText",
 CellID->418984810],
Cell[2230, 87, 231, 8, 70, "GuideText",
 CellID->206584097],
Cell[2464, 97, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->21901]
}, Open  ]],
Cell[CellGroupData[{
Cell[2555, 103, 244, 6, 70, "GuideFunctionsSubsection",
 CellID->58267697],
Cell[2802, 111, 430, 12, 70, "GuideText",
 CellID->807621954],
Cell[3235, 125, 544, 15, 70, "GuideText",
 CellID->28074],
Cell[3782, 142, 1273, 32, 70, "InlineGuideFunctionListing",
 CellID->71688709],
Cell[5058, 176, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->58942774]
}, Open  ]],
Cell[CellGroupData[{
Cell[5152, 182, 225, 5, 70, "GuideFunctionsSubsection",
 CellID->8793],
Cell[5380, 189, 153, 6, 70, "GuideText",
 CellID->3432],
Cell[5536, 197, 207, 8, 70, "GuideText",
 CellID->2136],
Cell[5746, 207, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->536867978]
}, Open  ]],
Cell[CellGroupData[{
Cell[5841, 213, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->485780743],
Cell[5917, 216, 595, 16, 70, "GuideText",
 CellID->88800246]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6561, 238, 57, 1, 70, "GuideTutorialsSection",
 CellID->8719],
Cell[6621, 241, 409, 12, 70, "GuideTutorial",
 CellID->60508230],
Cell[7033, 255, 166, 3, 70, "GuideTutorial",
 CellID->912269080],
Cell[7202, 260, 160, 3, 70, "GuideTutorial",
 CellID->28810171]
}, Open  ]],
Cell[CellGroupData[{
Cell[7399, 268, 59, 1, 70, "GuideMoreAboutSection",
 CellID->30041],
Cell[7461, 271, 153, 3, 70, "GuideMoreAbout",
 CellID->8329]
}, Open  ]],
Cell[7629, 277, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

