(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13406,        438]
NotebookOptionsPosition[      9603,        331]
NotebookOutlinePosition[     11513,        373]
CellTagsIndexPosition[     11470,        370]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Graphics Shape & Size", "GuideTitle",
 CellID->11785],

Cell[TextData[{
 "Of particular importance in handling high-throughput programmatic graphics \
are ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s sophisticated mechanisms for controlling graphics size and shape\
\[LongDash]allowing immediate aesthetically optimized integration into \
complex documents, user interfaces and information displays."
}], "GuideAbstract",
 CellID->112750584],

Cell[TextData[{
 Cell[TextData[ButtonBox["AspectRatio",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AspectRatio"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "ratio of overall height to width (",
 Cell[TextData[ButtonBox["Automatic",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Automatic"]], "InlineFunctionSans"],
 " to use raw coordinate values)"
}], "GuideText",
 CellID->18271],

Cell[TextData[{
 StyleBox["Drag", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " resize a graphic, maintaining aspect ratio"
}], "GuideText",
 CellID->15813],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Drag", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " change aspect ratio"
}], "GuideText",
 CellID->27415],

Cell["\t", "GuideDelimiter",
 CellID->6085],

Cell[TextData[{
 Cell[TextData[ButtonBox["BoxRatios",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BoxRatios"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "3D overall box shape (ratios of box side lengths)"
}], "GuideText",
 CellID->318],

Cell[TextData[{
 Cell[TextData[ButtonBox["SphericalRegion",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SphericalRegion"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "whether to make a 3D graphic rotatable without changing size"
}], "GuideText",
 CellID->3580],

Cell["\t", "GuideDelimiter",
 CellID->1331],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageSize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImageSize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "absolute overall image size"
}], "GuideText",
 CellID->7267],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tiny",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tiny"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Small",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Small"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Medium",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Medium"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Large",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Large"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->8387],

Cell[TextData[{
 Cell[TextData[ButtonBox["Full",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Full"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "full width of window, etc."
}], "GuideText",
 CellID->13444],

Cell[TextData[{
 Cell[TextData[ButtonBox["Scaled",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Scaled"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "scaled relative to window, etc."
}], "GuideText",
 CellID->23186],

Cell["\t", "GuideDelimiter",
 CellID->14507],

Cell[TextData[{
 Cell[TextData[ButtonBox["Magnify",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Magnify"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display a graphic or any other expression magnified"
}], "GuideText",
 CellID->4360],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageSizeMultipliers",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ImageSizeMultipliers"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "how to rescale graphics appearing inside lists, text, etc."
}], "GuideText",
 CellID->17827],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageSizeAction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ImageSizeAction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to rescale text etc. when changing the region it is in"
}], "GuideText",
 CellID->28074],

Cell["\t", "GuideDelimiter",
 CellID->26431],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageMargins",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImageMargins"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "margins to leave around the outside of the image"
}], "GuideText",
 CellID->7152],

Cell[TextData[{
 Cell[TextData[ButtonBox["PixelConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PixelConstrained"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "whether to constrain a raster to align with screen pixels"
}], "GuideText",
 CellID->30271],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Image Region Details \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PlottingAndImageRegions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->268753936],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlotRangePadding",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PlotRangeClipping",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PlotRangeClipping"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ImageScaled",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ImageScaled"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PlottingAndImageRegions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->247677536]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->10268],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "GuideTutorial",
 CellID->220177105]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->337],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "GuideMoreAbout",
 CellID->31311],

Cell[TextData[ButtonBox["Graphics Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "GuideMoreAbout",
 CellID->17604],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "GuideMoreAboutSub",
 CellID->406],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "GuideMoreAbout",
 CellID->367325343]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graphics Shape & Size - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 41.7651732}", "context" -> "", 
    "keywords" -> {
     "align pixels", "aspect ratio", "box ratios", "centering in 3D", 
      "centering of three-dimensional object", "circumscribing sphere", 
      "distortion", "elongation", "graphics size", "height of plots", 
      "image margins", "image pixels", "image scaled", "image size", 
      "image size action", "image size multipliers", "medium size", 
      "orientation of 3D object", "picture size", "pixel aligned", 
      "pixel constrained", "plot range clipping", "relative coordinates", 
      "resize image", "rotation of 3D coordinates", "scaled coordinates", 
      "shape", "shrink image", "size", "spherical region", "squashing", 
      "width", "zoom"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Of particular importance in handling high-throughput programmatic \
graphics are Mathematica's sophisticated mechanisms for controlling graphics \
size and shape--allowing immediate aesthetically optimized integration into \
complex documents, user interfaces and information displays.", 
    "synonyms" -> {}, "title" -> "Graphics Shape & Size", "type" -> "Guide", 
    "uri" -> "guide/GraphicsShapeAndSize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 59, 1, 70, "GuideTitle",
 CellID->11785],
Cell[681, 28, 397, 9, 70, "GuideAbstract",
 CellID->112750584],
Cell[1081, 39, 422, 13, 70, "GuideText",
 CellID->18271],
Cell[1506, 54, 177, 6, 70, "GuideText",
 CellID->15813],
Cell[1686, 62, 222, 8, 70, "GuideText",
 CellID->27415],
Cell[1911, 72, 43, 1, 70, "GuideDelimiter",
 CellID->6085],
Cell[1957, 75, 274, 9, 70, "GuideText",
 CellID->318],
Cell[2234, 86, 298, 9, 70, "GuideText",
 CellID->3580],
Cell[2535, 97, 43, 1, 70, "GuideDelimiter",
 CellID->1331],
Cell[2581, 100, 253, 9, 70, "GuideText",
 CellID->7267],
Cell[2837, 111, 1491, 39, 70, "InlineGuideFunctionListing",
 CellID->8387],
Cell[4331, 152, 388, 12, 70, "GuideText",
 CellID->13444],
Cell[4722, 166, 252, 9, 70, "GuideText",
 CellID->23186],
Cell[4977, 177, 44, 1, 70, "GuideDelimiter",
 CellID->14507],
Cell[5024, 180, 418, 12, 70, "GuideText",
 CellID->4360],
Cell[5445, 194, 452, 12, 70, "GuideText",
 CellID->17827],
Cell[5900, 208, 441, 11, 70, "GuideText",
 CellID->28074],
Cell[6344, 221, 44, 1, 70, "GuideDelimiter",
 CellID->26431],
Cell[6391, 224, 280, 9, 70, "GuideText",
 CellID->7152],
Cell[6674, 235, 298, 9, 70, "GuideText",
 CellID->30271],
Cell[CellGroupData[{
Cell[6997, 248, 231, 5, 70, "GuideFunctionsSubsection",
 CellID->268753936],
Cell[7231, 255, 1299, 32, 70, "InlineGuideFunctionListing",
 CellID->247677536]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8579, 293, 58, 1, 70, "GuideTutorialsSection",
 CellID->10268],
Cell[8640, 296, 146, 3, 70, "GuideTutorial",
 CellID->220177105]
}, Open  ]],
Cell[CellGroupData[{
Cell[8823, 304, 57, 1, 70, "GuideMoreAboutSection",
 CellID->337],
Cell[8883, 307, 164, 3, 70, "GuideMoreAbout",
 CellID->31311],
Cell[9050, 312, 159, 3, 70, "GuideMoreAbout",
 CellID->17604],
Cell[9212, 317, 144, 3, 70, "GuideMoreAboutSub",
 CellID->406],
Cell[9359, 322, 202, 4, 70, "GuideMoreAbout",
 CellID->367325343]
}, Open  ]],
Cell[9576, 329, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

