(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22981,        685]
NotebookOptionsPosition[     16184,        527]
NotebookOutlinePosition[     20362,        602]
CellTagsIndexPosition[     20319,        599]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Handling Arrays of Data", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " routinely handles huge arrays of numeric, symbolic, textual or any other \
data, with any dimension or structure",
 ". ",
 "Arrays are fully integrated into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s powerful core symbolic language, making possible extremely high-level \
array operations that are both elegant and efficient. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Structural Array Analysis \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->55934856],

Cell[TextData[{
 Cell[TextData[ButtonBox["Length",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Length"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dimensions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dimensions"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Union",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Union"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Count",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Count"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicalAndCountingOperationsOnLists"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->95474239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Parts of Arrays \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ElementsOfLists"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->204598990],

Cell[TextData[{
 Cell[TextData[ButtonBox["Select",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Select"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cases"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeleteCases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DeleteCases"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ElementsOfLists"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->812638808],

Cell[TextData[{
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[{
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["..",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]
 }], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " extract or reset elements, row, columns, blocks, etc."
}], "GuideText",
 CellID->352022284],

Cell[TextData[{
 Cell[TextData[ButtonBox["Take",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Take"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Drop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Drop"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Append",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Append"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Join",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Join"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ElementsOfLists"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->477263745]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Rearranging Arrays \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RearrangingAndRestructuringLists"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->35966789],

Cell[TextData[{
 Cell[TextData[ButtonBox["Flatten",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Flatten"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Partition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Partition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Transpose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Transpose"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArrayFlatten",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sort"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->169073490]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Operations on Arrays \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ApplyingFunctionsToLists"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->248569102],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["{",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"],
  ButtonBox["}",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"],
  ButtonBox["+",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"],
  ButtonBox["{",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"],
  ButtonBox["}",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]
 }], "InlineFunctionSans"],
 ", etc. \[LongDash] automatically operate on corresponding elements"
}], "GuideText",
 CellID->100047184],

Cell[TextData[{
 Cell[TextData[ButtonBox["Map",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Apply",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Join",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Join"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->109904041]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Array Visualization \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DataVisualization"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->764737079],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArrayPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayPlot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListDensityPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Grid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Grid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataVisualization"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->14382897]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Algorithmic Array Operations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Statistics"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->135820882],

Cell[TextData[{
 Cell[TextData[ButtonBox["MovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListConvolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListConvolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Statistics"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->467006466]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Creating Arrays \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConstructingLists"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->218631661],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Array",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Array"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SparseArray"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ConstructingLists"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->590460971]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "GuideTutorial",
 CellID->214558882],

Cell[TextData[ButtonBox["Basic Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicMatrixOperations"]], "GuideTutorial",
 CellID->458471559],

Cell[TextData[ButtonBox["Making Tables of Values",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingTablesOfValues"]], "GuideTutorial",
 CellID->283436164],

Cell[TextData[ButtonBox["Grouping and Combining Elements of Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GroupingAndCombiningElementsOfLists"]], "GuideTutorial",
 CellID->86685724],

Cell[TextData[ButtonBox["Partitioning and Padding Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningAndPaddingLists"]], "GuideTutorial",\

 CellID->371029688]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SparseArrays"]], "GuideMoreAbout",
 CellID->255961515],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "GuideMoreAboutSub",
 CellID->307192818],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Handling Arrays of Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 46.9684314}", "context" -> "", 
    "keywords" -> {
     "appending", "arrange", "array", "array flatten", "array plot", "arrays",
       "array shape", "array size", "ascending order", 
      "band-diagonal matrices", "banded matrices", "bin counts", "binning", 
      "blocking lists", "block matrices", "canonical order", 
      "category counts", "catenating lists", "changing parts", 
      "choose elements", "circulant matrix multiplication", 
      "circular partitioning", "cluster", "cluster analysis", "clustering", 
      "clustering of data", "collapse", "combining lists", 
      "comma-separated values", "compress in APL", "concatenating lists", 
      "convolutions", "CSV format", "cyclic partitioning", "data", 
      "data filter", "data filtering", "data smoother", "data smoothing", 
      "decreasing order", "delete cases", "deleting elements", 
      "descending order", "discard elements", "discard list elements", 
      "distinct elements in lists", "excel format", "external data", 
      "extraction of sublists", "files", "filtering", "filtering lists", 
      "find clusters", "first occurrence", "flat list", "flatten matrix", 
      "gather", "gathering elements in lists", "grade in APL", 
      "grouping of data", "histogram", "increasing order", 
      "join block matrices", "join lists", "length of list", "levels", 
      "linear moving average", "list convolve", "list density plot", 
      "list ordering", "MAT format", "matrices", "matrix dimensions", 
      "matrix Market format", "matrix structure plot", "matrix transpose", 
      "merging lists", "moving average", "moving mean", "multiple parts", 
      "multiplicities", "number of elements", "number of occurrences", 
      "number of terms", "one-dimensional list", "overhangs", 
      "partitioning lists", "partitioning of data", "parts", 
      "permutation of indices", "picking elements of lists", 
      "picking out elements in lists", "position-value pairs", "range counts",
       "ravel in APL", "reading", "remove duplicates", 
      "removing elements from lists", 
      "removing elements that match a pattern", "repeating expressions", 
      "replacements", "replace part", "reshape in APL", "segments of lists", 
      "sequence of elements", "simple moving average", "size of array", 
      "sorting of lists", "sparse array", "sparse matrix", 
      "sparse representation", "sparse vector", "splicing", "splitting lists",
       "spread-sheet", "spreadsheet", "spreadsheets", "squash", "stride", 
      "subexpressions", "sublists", "submatrices", "tab-delimited data", 
      "table", "tables", "tabular data", "tabular layout", "tabulation", 
      "tabulation of values", "tally", "transpose of matrices", 
      "transposition of lists", "TSV format", "unflatten", "union of sets", 
      "uniq", "unique elements in lists", "unravel", 
      "weighted moving average", "wraparound partitioning", "XBitmap format", 
      "XLS format", "XML"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica routinely handles huge arrays of numeric, symbolic, textual \
or any other data, with any dimension or structure. Arrays are fully \
integrated into Mathematica's powerful core symbolic language, making \
possible extremely high-level array operations that are both elegant and \
efficient. ", "synonyms" -> {}, "title" -> "Handling Arrays of Data", "type" -> 
    "Guide", "uri" -> "guide/HandlingArraysOfData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[687, 28, 451, 12, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1163, 44, 254, 6, 70, "GuideFunctionsSubsection",
 CellID->55934856],
Cell[1420, 52, 1949, 54, 70, "InlineGuideFunctionListing",
 CellID->95474239]
}, Open  ]],
Cell[CellGroupData[{
Cell[3406, 111, 218, 5, 70, "GuideFunctionsSubsection",
 CellID->204598990],
Cell[3627, 118, 1026, 29, 70, "InlineGuideFunctionListing",
 CellID->812638808],
Cell[4656, 149, 697, 27, 70, "GuideText",
 CellID->352022284],
Cell[5356, 178, 996, 29, 70, "InlineGuideFunctionListing",
 CellID->477263745]
}, Open  ]],
Cell[CellGroupData[{
Cell[6389, 212, 237, 5, 70, "GuideFunctionsSubsection",
 CellID->35966789],
Cell[6629, 219, 1399, 39, 70, "InlineGuideFunctionListing",
 CellID->169073490]
}, Open  ]],
Cell[CellGroupData[{
Cell[8065, 263, 232, 5, 70, "GuideFunctionsSubsection",
 CellID->248569102],
Cell[8300, 270, 536, 20, 70, "GuideText",
 CellID->100047184],
Cell[8839, 292, 804, 24, 70, "InlineGuideFunctionListing",
 CellID->109904041]
}, Open  ]],
Cell[CellGroupData[{
Cell[9680, 321, 224, 5, 70, "GuideFunctionsSubsection",
 CellID->764737079],
Cell[9907, 328, 1178, 32, 70, "InlineGuideFunctionListing",
 CellID->14382897]
}, Open  ]],
Cell[CellGroupData[{
Cell[11122, 365, 228, 6, 70, "GuideFunctionsSubsection",
 CellID->135820882],
Cell[11353, 373, 1478, 38, 70, "InlineGuideFunctionListing",
 CellID->467006466]
}, Open  ]],
Cell[CellGroupData[{
Cell[12868, 416, 220, 5, 70, "GuideFunctionsSubsection",
 CellID->218631661],
Cell[13091, 423, 1016, 29, 70, "InlineGuideFunctionListing",
 CellID->590460971]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14156, 458, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[14221, 461, 157, 3, 70, "GuideTutorial",
 CellID->214558882],
Cell[14381, 466, 163, 3, 70, "GuideTutorial",
 CellID->458471559],
Cell[14547, 471, 162, 3, 70, "GuideTutorial",
 CellID->283436164],
Cell[14712, 476, 196, 4, 70, "GuideTutorial",
 CellID->86685724],
Cell[14911, 482, 178, 4, 70, "GuideTutorial",
 CellID->371029688]
}, Open  ]],
Cell[CellGroupData[{
Cell[15126, 491, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[15191, 494, 150, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[15344, 499, 151, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[15498, 504, 142, 3, 70, "GuideMoreAbout",
 CellID->255961515],
Cell[15643, 509, 148, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[15794, 514, 165, 3, 70, "GuideMoreAboutSub",
 CellID->307192818],
Cell[15962, 519, 180, 3, 70, "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],
Cell[16157, 525, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

