(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11622,        360]
NotebookOptionsPosition[      7512,        261]
NotebookOutlinePosition[     10300,        315]
CellTagsIndexPosition[     10257,        312]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Hyperbolic Functions", "GuideTitle",
 CellID->30221],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports hyperbolic functions everywhere in the complex \
plane\[LongDash]with careful attention to branch cuts\[LongDash]and provides \
an extensive web of exact and algebraic transformations, together with \
efficient arbitrary-precision numerical evaluation. "
}], "GuideAbstract",
 CellID->417688928],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sinh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sinh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cosh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cosh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tanh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tanh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Csch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Csch"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sech",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sech"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Coth",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Coth"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->3656],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArcSinh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcSinh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcCosh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcCosh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcTanh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcTanh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcCsch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcCsch"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcSech",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcSech"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcCoth",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcCoth"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->3343],

Cell["\t", "GuideDelimiter",
 CellID->22593],

Cell[TextData[{
 Cell[TextData[ButtonBox["I",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[ImaginaryI]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 ", entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ii\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " (\"imaginary i\")"
}], "GuideText",
 CellID->27080],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " simplify hyperbolic function expressions"
}], "GuideText",
 CellID->16080],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " reduce to algebraic forms or simpler arguments"
}], "GuideText",
 CellID->14868],

Cell["\t", "GuideDelimiter",
 CellID->21411],

Cell[TextData[{
 Cell[TextData[ButtonBox["TrigToExp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigToExp"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ExpToTrig",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpToTrig"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert between hyperbolic and exponential functions"
}], "GuideText",
 CellID->20968],

Cell[TextData[{
 Cell[TextData[ButtonBox["ComplexExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ComplexExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand into real and imaginary parts"
}], "GuideText",
 CellID->3251],

Cell[TextData[{
 Cell[TextData[ButtonBox["TrigExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigExpand"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TrigFactor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigFactor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TrigReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigReduce"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->13713]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->27216],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->16541]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->17040],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "GuideMoreAbout",
 CellID->31531],

Cell[TextData[ButtonBox["Elementary Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "GuideMoreAbout",
 CellID->12933]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->759347117],

Cell[TextData[{
 ButtonBox["Demonstrations related to Hyperbolic Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22hyperbolic+functions%22+content%3AArcCosh+OR+ArcCoth+OR+ArcCsch+OR+ArcSech+\
OR+ArcSinh+OR+ArcTanh+OR+ComplexExpand+OR+Cosh+OR+Coth+OR+Csch+OR+ExpToTrig+\
OR+FullSimplify+OR+FunctionExpand+OR+I+OR+Sech+OR+Sinh+OR+Tanh+OR+TrigExpand+\
OR+TrigFactor+OR+TrigReduce+OR+TrigToExp"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->140315768]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hyperbolic Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 48.2184634}", "context" -> "", 
    "keywords" -> {
     "acosh", "acoth", "acsch", "arcch", "arc cosh", "arc coth", "arc csch", 
      "arccth", "arch", "arcosech", "arcosh", "arcoth", "arcsch", "arc sech", 
      "arcsh", "arc sinh", "arc tanh", "arcth", "area cosinus hyperbolicus", 
      "argsinh", "arsech", "arsh", "arsinh", "artanh", "arth", "asech", 
      "asinh", "atanh", "ch", "circular functions", "complex expand", 
      "complex exponentials", "complex powers", "compound arguments", 
      "cosech", "de Moivre's Theorem", "Euler's formula", 
      "expanding into polar form", "expanding into real and imaginary parts", 
      "expanding special functions", "exp to trig", "hyperbolic arccosecant", 
      "hyperbolic arccotagnent", "hyperbolic cos", "hyperbolic cosecant", 
      "hyperbolic cosine", "hyperbolic csc", "hyperbolic functions", 
      "hyperbolic secant", "hyperbolic sine", "hyperbolic sinus", 
      "hyperbolic tan", "hyperbolic tangent", "hypsec", "hypsin", "hyptan", 
      "identities", "imaginary unit", "inverse cosine hyperbolic", 
      "inverse csch", "inverse hyperbolic cosecant", 
      "inverse hyperbolic secant", "inverse hyperbolic tangent", 
      "inverse sech", "inverse sine hyperbolic function", "inverse sinh", 
      "inverse tanh", "inverse th", "multiple angle formulas", "polar angle", 
      "sech", "senh", "sh", "sinh", "special functions", 
      "special function simplification", "tanh", "tgh", "th", "trig expand", 
      "trig factor", "trigonometric expansion", "trigonometric functions", 
      "trigonometric simplification", "trig reduce", "trig to exp"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica supports hyperbolic functions everywhere in the complex \
plane--with careful attention to branch cuts--and provides an extensive web \
of exact and algebraic transformations, together with efficient \
arbitrary-precision numerical evaluation. ", "synonyms" -> {}, "title" -> 
    "Hyperbolic Functions", "type" -> "Guide", "uri" -> 
    "guide/HyperbolicFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->30221],
Cell[680, 28, 372, 8, 70, "GuideAbstract",
 CellID->417688928],
Cell[1055, 38, 1175, 35, 70, "InlineGuideFunctionListing",
 CellID->3656],
Cell[2233, 75, 1211, 35, 70, "InlineGuideFunctionListing",
 CellID->3343],
Cell[3447, 112, 44, 1, 70, "GuideDelimiter",
 CellID->22593],
Cell[3494, 115, 590, 22, 70, "GuideText",
 CellID->27080],
Cell[4087, 139, 268, 8, 70, "GuideText",
 CellID->16080],
Cell[4358, 149, 278, 8, 70, "GuideText",
 CellID->14868],
Cell[4639, 159, 44, 1, 70, "GuideDelimiter",
 CellID->21411],
Cell[4686, 162, 403, 12, 70, "GuideText",
 CellID->20968],
Cell[5092, 176, 265, 8, 70, "GuideText",
 CellID->3251],
Cell[5360, 186, 612, 17, 70, "InlineGuideFunctionListing",
 CellID->13713]
}, Open  ]],
Cell[CellGroupData[{
Cell[6009, 208, 58, 1, 70, "GuideTutorialsSection",
 CellID->27216],
Cell[6070, 211, 148, 3, 70, "GuideTutorial",
 CellID->16541]
}, Open  ]],
Cell[CellGroupData[{
Cell[6255, 219, 59, 1, 70, "GuideMoreAboutSection",
 CellID->17040],
Cell[6317, 222, 158, 3, 70, "GuideMoreAbout",
 CellID->31531],
Cell[6478, 227, 165, 3, 70, "GuideMoreAbout",
 CellID->12933]
}, Open  ]],
Cell[CellGroupData[{
Cell[6680, 235, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->759347117],
Cell[6752, 238, 718, 18, 70, "GuideRelatedLinks",
 CellID->140315768]
}, Open  ]],
Cell[7485, 259, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

