(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47657,       1465]
NotebookOptionsPosition[     37550,       1207]
NotebookOutlinePosition[     41907,       1284]
CellTagsIndexPosition[     41864,       1281]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Importing & Exporting", "GuideTitle",
 CellID->29105],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically handles hundreds of data formats and \
subformats\[LongDash]all coherently integrated through ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s uniform use of symbolic expressions. For each particular format, the \
correspondence between representations inside and outside ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be specified at any level of detail using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s general data elements mechanism."
}], "GuideAbstract",
 CellID->24791],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "import from files and URLs"
}], "GuideText",
 CellID->24033],

Cell[TextData[{
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "export data, graphics, expressions to files"
}], "GuideText",
 CellID->32029],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImportString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImportString"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ExportString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExportString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " import, export string data"
}], "GuideText",
 CellID->27196],

Cell["\t", "GuideDelimiterSubsection",
 CellID->15987],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Basic Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/BasicFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->9324847],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Table\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Table"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"List\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/List"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"String\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/String"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Text\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Text"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Binary\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Binary"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/BasicFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->187267101],

Cell["\t", "GuideDelimiterSubsection",
 CellID->125530861]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Raster Image Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RasterImageFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->31063],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"GIF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GIF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"JPEG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JPEG"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"TIFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TIFF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"PNG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PNG"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"BMP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/BMP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"PICT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PICT"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"WMF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WMF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SCT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SCT"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RasterImageFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->7229]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Vector Graphics Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/VectorGraphicsFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->4769],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SVG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SVG"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"WMF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WMF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"EPS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/EPS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"PDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"DXF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DXF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/VectorGraphicsFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->627261287]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["3D Geometry & Modeling Formats \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/3DGeometryAndModelingFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->15005],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PLY\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PLY"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"OFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/OFF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"OBJ\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/OBJ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"X3D\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/X3D"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Maya\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Maya"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"POV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/POV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"LWO\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/LWO"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"STL\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/STL"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->112541382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Audio Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AudioFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->1594],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"WAV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WAV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"AIFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AIFF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MIDI\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MIDI"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SND\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SND"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"FLAC\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FLAC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Wave64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Wave64"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AudioFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21487]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Multimedia Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MultimediaFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->24326],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"AVI\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AVI"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"FLV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FLV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"QuickTime\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/QuickTime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SWF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SWF"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->3276],

Cell["\t", "GuideDelimiterSubsection",
 CellID->255683718]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Tabular & Spreadsheet Formats \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/TabularAndSpreadsheetFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->256571278],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Table\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Table"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"CSV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CSV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"TSV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TSV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"XLS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XLS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"ODS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ODS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SXC\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SXC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/TabularAndSpreadsheetFormats"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->331466020]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Database Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ImportingAndExportingDatabaseFormats"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->35285909],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MDB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MDB"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"DBF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DBF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"DIF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DIF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"XLS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XLS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ImportingAndExportingDatabaseFormats"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1877376],

Cell["\t", "GuideDelimiterSubsection",
 CellID->233674815]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Scientific & Medical Data Formats \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ScientificAndMedicalDataFormats"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->29221],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"HDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"CDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"FITS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FITS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"DICOM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DICOM"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"EDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/EDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MOL\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MOL"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"PDB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PDB"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"FASTA\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FASTA"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ScientificAndMedicalDataFormats"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->104427022]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Geospatial Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GeospatialFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->84895815],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"USGSDEM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/USGSDEM"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"GTOPO30\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GTOPO30"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"CDED\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CDED"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SDTS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SDTS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GeospatialFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->451232885]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Numerical Data Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalDataFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->29271],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XPORT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XPORT"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MAT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MAT"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MTX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MTX"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"HarwellBoeing\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HarwellBoeing"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MPS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MPS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumericalDataFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->463690322]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Mathematical Data Formats \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalDataFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->443147314],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Graph6\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Graph6"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Sparse6\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Sparse6"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicalDataFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->200509678],

Cell["\t", "GuideDelimiterSubsection",
 CellID->327919022]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Document Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DocumentFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->21323],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"HTML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HTML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"NB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/NB"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"RTF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/RTF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"TeX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TeX"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Text\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Text"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DocumentFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->238557385]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Web Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/WebFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->954530582],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"HTML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HTML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"GIF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GIF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"JPEG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JPEG"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SWF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SWF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"XHTML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XHTML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"X3D\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/X3D"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/WebFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8491929]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Print Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PrintFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->205727822],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"EPS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/EPS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"TeX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TeX"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SCT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SCT"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"ACO\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ACO"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PrintFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->348199690],

Cell["\t", "GuideDelimiterSubsection",
 CellID->166319143]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["XML Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/XMLFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->32588],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"XHTML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XHTML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MathML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MathML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SVG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SVG"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"X3D\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/X3D"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"ODS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ODS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/XMLFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->98111418]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Systems & Utility Formats \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SystemsAndUtilityFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->23955],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Directory\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Directory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"ApacheLog\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ApacheLog"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MBOX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MBOX"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"VCF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/VCF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"RSS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/RSS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SystemsAndUtilityFormats"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->129839034]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Compression & Archive Formats \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CompressionAndArchiveFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->229132251],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Base64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Base64"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"BZIP2\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/BZIP2"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"GZIP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GZIP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"TAR\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TAR"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"UUE\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/UUE"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"ZIP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ZIP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"WDX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WDX"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CompressionAndArchiveFormats"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->306075708],

Cell["\t", "GuideDelimiterSubsection",
 CellID->22257383]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Binary Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/BinaryData"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->20183],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Bit\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Bit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Byte\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Byte"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Integer16\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Integer16"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Real32\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Real32"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"TerminatedString\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TerminatedString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/BinaryData"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->23589],

Cell["\t", "GuideDelimiter",
 CellID->128276393],

Cell[TextData[{
 Cell[TextData[ButtonBox["$ImportFormats",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$ImportFormats"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["$ExportFormats",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$ExportFormats"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " lists of supported formats"
}], "GuideText",
 CellID->753237679],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileFormat",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileFormat"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["StringFormat",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StringFormat"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test for formats of files, strings"
}], "GuideText",
 CellID->528515933],

Cell["\t", "GuideDelimiterSubsection",
 CellID->24779]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lower-Level Functions", "GuideFunctionsSubsection",
 CellID->23487],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReadList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReadList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Write",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Write"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinaryReadList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryReadList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinaryWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryWrite"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->178724424]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->19779],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "GuideTutorial",
 CellID->415146110],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->191929661],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->310182235],

Cell[TextData[ButtonBox["Importing and Exporting Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingFiles"]], "GuideTutorial",
 CellID->535839085],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "GuideTutorial",
 CellID->90141082]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->24962],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "GuideMoreAbout",
 CellID->479778287],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "GuideMoreAbout",
 CellID->18965],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "GuideMoreAboutSub",
 CellID->147414215],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60DataHandlingAndDataSources"]], "GuideMoreAbout",
 CellID->929199252]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Importing & Exporting - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 54.2186170}", "context" -> "", 
    "keywords" -> {
     "AIFF format", "animations", "astronomical data", "audio", "AU format", 
      "AutoCAD format", "AVI", "binary read list", "binary write", 
      "biomedical image format", "bitmap graphics formats", "BMP", "CAD", 
      "capturing images", "comma-separated values", "computer-aided design", 
      "conversions", "converting", "CSV format", "data", "data formats", 
      "data mining", "ddf format", "desktop publishing", "devices", "DICOM", 
      "DIF format", "drawing format", "draw programs", "DXF format", 
      "Encapsulated PostScript", "EPS", "EPSF", "EPSI", "EPSTIFF", 
      "excel format", "Excel format", "export filters", "export formats", 
      "exporting data", "exporting graphics", "exporting sounds", 
      "export string", "ExpressionML", "expressions", "external data", 
      "file format", "files", "FITS format", 
      "Flexible Image Transport System", "foreign data", "formats", "ftp", 
      "geometry data", "GIF", "GIS data", "Harwell-Boeing format", "HDF", 
      "Hierarchical Data Format", "http", "image capture", "image processing",
       "images", "import data from string", "import filters", 
      "import formats", "importing data", "import string", 
      "input from data file", "interchange format", "interoperability", 
      "JFIF", "JPEG", "lithography", "lithography format", 
      "Lotus 1-2-3 format", "Macintosh PICT", "MAT format", 
      "Matrix Market format", "medical imaging", "metafile format", 
      "Metafile format", "MGF graphics format", "Microsoft metafile format", 
      "Microsoft wave format", "MPS", "MTX format", "mu law format", 
      "NotebookML", "PBM graphics format", "PCX", "PGM graphics format", 
      "PICT", "pictures", "pixmap graphics format", "PNG", 
      "PNM graphics format", "portable anymap format", 
      "portable bitmap format", "portable graymap format", 
      "portable pixmap format", "PPM graphics format", "processing images", 
      "radiology formats", "raster", "raster conversion", 
      "read data from string", "read formatted string", 
      "reading arrays from data files", "reading data", "reading data files", 
      "reading data from external programs", "reading data from files", 
      "reading data from pipes", "reading data from programs", 
      "reading data from spreadsheets", "reading data from streams", 
      "reading matrices from data files", "read list", "read string", 
      "scalable vector graphics", "SDTS importing", "SND format", 
      "solid object modeling", "sounds", "spreadsheets", "stereo-lithography",
       "stereolithography format", "STL format", "string format", 
      "string import", "SVG", "SymbolicXML", "tab-delimited data", 
      "tabular data", "terrain data", "three-dimensional graphics", "TIFF", 
      "translation of formats", "TSV format", "turning files into strings", 
      "URLs", "WAV format", "web", "web import", "Windows metafile format", 
      "WMF", "writing binary files", "XBitmap format", "XLS format", "XML", 
      "X Windows graphics format"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica automatically handles hundreds of data formats and \
subformats--all coherently integrated through Mathematica's uniform use of \
symbolic expressions. For each particular format, the correspondence between \
representations inside and outside Mathematica can be specified at any level \
of detail using Mathematica's general data elements mechanism.", 
    "synonyms" -> {}, "title" -> "Importing & Exporting", "type" -> "Guide", 
    "uri" -> "guide/ImportingAndExporting"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 59, 1, 70, "GuideTitle",
 CellID->29105],
Cell[681, 28, 590, 16, 70, "GuideAbstract",
 CellID->24791],
Cell[1274, 46, 247, 9, 70, "GuideText",
 CellID->24033],
Cell[1524, 57, 264, 9, 70, "GuideText",
 CellID->32029],
Cell[1791, 68, 389, 12, 70, "GuideText",
 CellID->27196],
Cell[2183, 82, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->15987],
Cell[CellGroupData[{
Cell[2262, 87, 211, 5, 70, "GuideFunctionsSubsection",
 CellID->9324847],
Cell[2476, 94, 1254, 35, 70, "InlineGuideFunctionListing",
 CellID->187267101],
Cell[3733, 131, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->125530861]
}, Open  ]],
Cell[CellGroupData[{
Cell[3828, 137, 222, 5, 70, "GuideFunctionsSubsection",
 CellID->31063],
Cell[4053, 144, 1868, 53, 70, "InlineGuideFunctionListing",
 CellID->7229]
}, Open  ]],
Cell[CellGroupData[{
Cell[5958, 202, 227, 5, 70, "GuideFunctionsSubsection",
 CellID->4769],
Cell[6188, 209, 1243, 35, 70, "InlineGuideFunctionListing",
 CellID->627261287]
}, Open  ]],
Cell[CellGroupData[{
Cell[7468, 249, 244, 6, 70, "GuideFunctionsSubsection",
 CellID->15005],
Cell[7715, 257, 1882, 54, 70, "InlineGuideFunctionListing",
 CellID->112541382]
}, Open  ]],
Cell[CellGroupData[{
Cell[9634, 316, 208, 5, 70, "GuideFunctionsSubsection",
 CellID->1594],
Cell[9845, 323, 1451, 41, 70, "InlineGuideFunctionListing",
 CellID->21487]
}, Open  ]],
Cell[CellGroupData[{
Cell[11333, 369, 219, 5, 70, "GuideFunctionsSubsection",
 CellID->24326],
Cell[11555, 376, 823, 23, 70, "InlineGuideFunctionListing",
 CellID->3276],
Cell[12381, 401, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->255683718]
}, Open  ]],
Cell[CellGroupData[{
Cell[12476, 407, 247, 6, 70, "GuideFunctionsSubsection",
 CellID->256571278],
Cell[12726, 415, 1466, 42, 70, "InlineGuideFunctionListing",
 CellID->331466020]
}, Open  ]],
Cell[CellGroupData[{
Cell[14229, 462, 239, 5, 70, "GuideFunctionsSubsection",
 CellID->35285909],
Cell[14471, 469, 1050, 30, 70, "InlineGuideFunctionListing",
 CellID->1877376],
Cell[15524, 501, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->233674815]
}, Open  ]],
Cell[CellGroupData[{
Cell[15619, 507, 250, 6, 70, "GuideFunctionsSubsection",
 CellID->29221],
Cell[15872, 515, 1893, 54, 70, "InlineGuideFunctionListing",
 CellID->104427022]
}, Open  ]],
Cell[CellGroupData[{
Cell[17802, 574, 222, 5, 70, "GuideFunctionsSubsection",
 CellID->84895815],
Cell[18027, 581, 1050, 29, 70, "InlineGuideFunctionListing",
 CellID->451232885]
}, Open  ]],
Cell[CellGroupData[{
Cell[19114, 615, 226, 5, 70, "GuideFunctionsSubsection",
 CellID->29271],
Cell[19343, 622, 1266, 35, 70, "InlineGuideFunctionListing",
 CellID->463690322]
}, Open  ]],
Cell[CellGroupData[{
Cell[20646, 662, 238, 6, 70, "GuideFunctionsSubsection",
 CellID->443147314],
Cell[20887, 670, 632, 17, 70, "InlineGuideFunctionListing",
 CellID->200509678],
Cell[21522, 689, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->327919022]
}, Open  ]],
Cell[CellGroupData[{
Cell[21617, 695, 215, 5, 70, "GuideFunctionsSubsection",
 CellID->21323],
Cell[21835, 702, 1448, 41, 70, "InlineGuideFunctionListing",
 CellID->238557385]
}, Open  ]],
Cell[CellGroupData[{
Cell[23320, 748, 209, 5, 70, "GuideFunctionsSubsection",
 CellID->954530582],
Cell[23532, 755, 1447, 41, 70, "InlineGuideFunctionListing",
 CellID->8491929]
}, Open  ]],
Cell[CellGroupData[{
Cell[25016, 801, 213, 5, 70, "GuideFunctionsSubsection",
 CellID->205727822],
Cell[25232, 808, 1234, 35, 70, "InlineGuideFunctionListing",
 CellID->348199690],
Cell[26469, 845, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->166319143]
}, Open  ]],
Cell[CellGroupData[{
Cell[26564, 851, 205, 5, 70, "GuideFunctionsSubsection",
 CellID->32588],
Cell[26772, 858, 1450, 41, 70, "InlineGuideFunctionListing",
 CellID->98111418]
}, Open  ]],
Cell[CellGroupData[{
Cell[28259, 904, 235, 6, 70, "GuideFunctionsSubsection",
 CellID->23955],
Cell[28497, 912, 1275, 36, 70, "InlineGuideFunctionListing",
 CellID->129839034]
}, Open  ]],
Cell[CellGroupData[{
Cell[29809, 953, 247, 6, 70, "GuideFunctionsSubsection",
 CellID->229132251],
Cell[30059, 961, 1683, 48, 70, "InlineGuideFunctionListing",
 CellID->306075708],
Cell[31745, 1011, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->22257383]
}, Open  ]],
Cell[CellGroupData[{
Cell[31839, 1017, 208, 5, 70, "GuideFunctionsSubsection",
 CellID->20183],
Cell[32050, 1024, 1274, 35, 70, "InlineGuideFunctionListing",
 CellID->23589],
Cell[33327, 1061, 48, 1, 70, "GuideDelimiter",
 CellID->128276393],
Cell[33378, 1064, 401, 12, 70, "GuideText",
 CellID->753237679],
Cell[33782, 1078, 692, 19, 70, "GuideText",
 CellID->528515933],
Cell[34477, 1099, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->24779]
}, Open  ]],
Cell[CellGroupData[{
Cell[34568, 1105, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->23487],
Cell[34644, 1108, 824, 23, 70, "InlineGuideFunctionListing",
 CellID->178724424]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35517, 1137, 58, 1, 70, "GuideTutorialsSection",
 CellID->19779],
Cell[35578, 1140, 172, 3, 70, "GuideTutorial",
 CellID->415146110],
Cell[35753, 1145, 174, 3, 70, "GuideTutorial",
 CellID->191929661],
Cell[35930, 1150, 174, 3, 70, "GuideTutorial",
 CellID->310182235],
Cell[36107, 1155, 174, 3, 70, "GuideTutorial",
 CellID->535839085],
Cell[36284, 1160, 199, 4, 70, "GuideTutorial",
 CellID->90141082]
}, Open  ]],
Cell[CellGroupData[{
Cell[36520, 1169, 59, 1, 70, "GuideMoreAboutSection",
 CellID->24962],
Cell[36582, 1172, 158, 3, 70, "GuideMoreAbout",
 CellID->479778287],
Cell[36743, 1177, 142, 3, 70, "GuideMoreAbout",
 CellID->18965],
Cell[36888, 1182, 159, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[37050, 1187, 262, 9, 70, "GuideMoreAboutSub",
 CellID->147414215],
Cell[37315, 1198, 193, 4, 70, "GuideMoreAbout",
 CellID->929199252]
}, Open  ]],
Cell[37523, 1205, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

