(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23634,        680]
NotebookOptionsPosition[     16863,        524]
NotebookOutlinePosition[     21334,        603]
CellTagsIndexPosition[     21291,        600]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Integer Functions", "GuideTitle",
 CellID->17421],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " contains hundreds of original algorithms for computing integer functions \
involving integers of any size."
}], "GuideAbstract",
 CellID->617709603],

Cell[CellGroupData[{

Cell["Division-Related Functions", "GuideFunctionsSubsection",
 CellID->15022],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PowerMod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PowerMod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quotient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Quotient"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["QuotientRemainder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/QuotientRemainder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GCD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GCD"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LCM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LCM"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Divisible",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Divisible"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CoprimeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CoprimeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EvenQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EvenQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OddQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OddQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrimeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrimeQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->31812]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Combinatorial Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CombinatorialFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->29151],

Cell[TextData[{
 Cell[TextData[ButtonBox["Factorial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["!",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Binomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Binomial"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Multinomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Multinomial"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CatalanNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CatalanNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StirlingS1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StirlingS1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PartitionsP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PartitionsP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BellB",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BellB"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FrobeniusNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FrobeniusNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CombinatorialFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->23015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Recurrence and Sum Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RecurrenceAndSumFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->8055],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fibonacci",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fibonacci"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LucasL",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LucasL"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HarmonicNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HarmonicNumber"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BernoulliB",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BernoulliB"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EulerE",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EulerE"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MatrixExp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixExp"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->3393]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integer Decompositions", "GuideFunctionsSubsection",
 CellID->8738],

Cell[TextData[{
 Cell[TextData[ButtonBox["FactorInteger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorInteger"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Divisors",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Divisors"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerPartitions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FrobeniusSolve",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FrobeniusSolve"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->15279]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Digit-Related Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumberDigits"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->19882],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FromDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerLength",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerLength"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DigitCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DigitCount"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerExponent"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumberDigits"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1608]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Bitwise Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/BitwiseOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->12654],

Cell[TextData[{
 Cell[TextData[ButtonBox["BitAnd",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitAnd"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitOr",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitOr"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitXor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitXor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitLength",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitLength"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitShiftLeft",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitShiftLeft"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitSet",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitSet"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/BitwiseOperations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->3822],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["RSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solve integer recurrences"
}], "GuideText",
 CellID->24245],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sum"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find sums of integer functions"
}], "GuideText",
 CellID->1338]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->144],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->182450445],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "GuideTutorial",
 CellID->747475449],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "GuideTutorial",
 CellID->187050304]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23154],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "GuideMoreAbout",
 CellID->24604],

Cell[TextData[ButtonBox["Number Theory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "GuideMoreAbout",
 CellID->4623],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "GuideMoreAboutSub",
 CellID->20078],

Cell[TextData[ButtonBox["Continued Fractions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuedFractionsAndRationalApproximations"]], \
"GuideMoreAboutSub",
 CellID->21724],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->774153742],

Cell[TextData[{
 ButtonBox["Demonstrations related to Integer Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22integers%22+content%3ABellB+OR+BernoulliB+OR+Binomial+OR+BitAnd+OR+\
BitLength+OR+BitOr+OR+BitSet+OR+BitShiftLeft+OR+BitXor+OR+CatalanNumber+OR+\
CoprimeQ+OR+DigitCount+OR+Divisible+OR+Divisors+OR+EulerE+OR+EvenQ+OR+\
Factorial+OR+FactorInteger+OR+Fibonacci+OR+FrobeniusNumber+OR+FrobeniusSolve+\
OR+FromDigits+OR+GCD+OR+HarmonicNumber+OR+IntegerDigits+OR+IntegerExponent+OR+\
IntegerLength+OR+IntegerPartitions+OR+LCM+OR+LucasL+OR+MatrixExp+OR+Mod+OR+\
Multinomial+OR+OddQ+OR+PartitionsP+OR+PowerMod+OR+PrimeQ+OR+Quotient+OR+\
QuotientRemainder+OR+RSolve+OR+StirlingS1+OR+Sum"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->104855362]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integer Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 56.5155508}", "context" -> "", 
    "keywords" -> {
     "aliquant", "arithmetic difference equations", "arrays", "bang", "bases",
       "Bernoulli B", "Bernoulli numbers", "Bernoulli polynomials", 
      "binary digits", "binom", "binomials", "bit and", "bit count", 
      "bit length", "bit or", "bit set", "bit shift left", "bit xor", "carry",
       "Catalan number", "choose", "coin problem", "comb", "combinations", 
      "common denominator", "congruence", "conversion", "coprime", 
      "count of digits", "cyclic indices", "d'Alembert test", 
      "decimal digits", "decode", "decomposition into primes", 
      "difference-algebraic equations", "difference equations", 
      "digital sums", "digit count", "Dirichlet series", "discrete equations",
       "divide-and-conquer equations", "divisibility", "divisible numbers", 
      "division of integers", "encode", "enumeration of permutations", 
      "Euclidean algorithm", "Euclid's algorithm", "Euler numbers", 
      "Euler polynomials", "Euler's pentagonal formula", "even numbers", 
      "exclamation point", "fact", "factorial", "factoring", "factor integer",
       "factors", "fib", "Fibonacci equations", "Fibonacci recurrence", 
      "Fibonacci sequence", "finite difference equations", 
      "Frobenius equation", "Frobenius number", "Frobenius solve", 
      "from digits", "Gaussian integers", "GCF", 
      "geometric difference equations", "greatest common divider", 
      "greatest common divisor", "greatest dividing exponent", "half adder", 
      "harmonic number", "harmonic numbers", "harmonic series", 
      "hexadecimal digits", "highest common factor", "hypergeometric sums", 
      "idiv", "idivide", "ifact", "igcd", "ilcm", "implode", "integer digits",
       "integer exponent", "integer factoring", "integer length", 
      "integer partitions", "integer sequence equations", 
      "integral part of division", "inverses in finite fields", "iquo", 
      "irem", "isOdd", "isprime", "Jordan decomposition", 
      "least common multiple", "lowest common multiple", "Lucas number", 
      "Lucas numbers", "Lucas sequence", "Lucas test", "mask", "matrix exp", 
      "matrix exponential", "Miller-Rabin test", "modp", "mods", 
      "modular inverses", "modular powers", "modulo", "multinomial", 
      "multinomial coefficients", "n-choose-k", "nchoosek", "nCk", 
      "Nim addition", "number conversion", "number of partitions", 
      "number reconstruction", "octal digits", "odd numbers", 
      "one-origin arrays", "ones", "padding", "partial difference equations", 
      "partial recurrence equations", "partitions", "Pollard algorithm", 
      "power mod", "power series", "powers in finite fields", 
      "predicate to test oddness", "primality testing", "prime factors", 
      "pseudoprime test", "quo", "quot", "quotient remainder", 
      "radix conversion", "recurrence equations", "recursion equations", 
      "relative primality", "rem", "remainder", "roman numerals", 
      "secant numbers", "sequence equations", "sequences", "shriek", 
      "Stirling1", "Stirling number of the 1st kind", 
      "Stirling number of the first kind", "Stirling numbers", 
      "Stirling numbers S1", "Stirling s1", "submultiples", "sums", 
      "symbolic sums", "symmetry reduction", "ternary digits", 
      "testing for odd integers", "testing for primality of integers", 
      "testing for prime", "zero-origin arrays", "zeros", "zig numbers"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica contains hundreds of original algorithms for computing \
integer functions involving integers of any size.", "synonyms" -> {}, "title" -> 
    "Integer Functions", "type" -> "Guide", "uri" -> 
    "guide/IntegerFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->17421],
Cell[677, 28, 216, 6, 70, "GuideAbstract",
 CellID->617709603],
Cell[CellGroupData[{
Cell[918, 38, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->15022],
Cell[999, 41, 2671, 74, 70, "InlineGuideFunctionListing",
 CellID->31812]
}, Open  ]],
Cell[CellGroupData[{
Cell[3707, 120, 229, 5, 70, "GuideFunctionsSubsection",
 CellID->29151],
Cell[3939, 127, 2438, 67, 70, "InlineGuideFunctionListing",
 CellID->23015]
}, Open  ]],
Cell[CellGroupData[{
Cell[6414, 199, 238, 6, 70, "GuideFunctionsSubsection",
 CellID->8055],
Cell[6655, 207, 1605, 45, 70, "InlineGuideFunctionListing",
 CellID->3393]
}, Open  ]],
Cell[CellGroupData[{
Cell[8297, 257, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->8738],
Cell[8373, 260, 1356, 35, 70, "InlineGuideFunctionListing",
 CellID->15279]
}, Open  ]],
Cell[CellGroupData[{
Cell[9766, 300, 219, 5, 70, "GuideFunctionsSubsection",
 CellID->19882],
Cell[9988, 307, 1411, 38, 70, "InlineGuideFunctionListing",
 CellID->1608]
}, Open  ]],
Cell[CellGroupData[{
Cell[11436, 350, 218, 5, 70, "GuideFunctionsSubsection",
 CellID->12654],
Cell[11657, 357, 1864, 50, 70, "InlineGuideFunctionListing",
 CellID->3822],
Cell[13524, 409, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[13575, 412, 246, 9, 70, "GuideText",
 CellID->24245],
Cell[13824, 423, 244, 9, 70, "GuideText",
 CellID->1338]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14117, 438, 56, 1, 70, "GuideTutorialsSection",
 CellID->144],
Cell[14176, 441, 206, 4, 70, "GuideTutorial",
 CellID->182450445],
Cell[14385, 447, 171, 3, 70, "GuideTutorial",
 CellID->747475449],
Cell[14559, 452, 164, 3, 70, "GuideTutorial",
 CellID->187050304]
}, Open  ]],
Cell[CellGroupData[{
Cell[14760, 460, 59, 1, 70, "GuideMoreAboutSection",
 CellID->23154],
Cell[14822, 463, 163, 3, 70, "GuideMoreAbout",
 CellID->24604],
Cell[14988, 468, 148, 3, 70, "GuideMoreAbout",
 CellID->4623],
Cell[15139, 473, 164, 3, 70, "GuideMoreAboutSub",
 CellID->20078],
Cell[15306, 478, 183, 5, 70, "GuideMoreAboutSub",
 CellID->21724],
Cell[15492, 485, 203, 4, 70, "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],
Cell[CellGroupData[{
Cell[15732, 494, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->774153742],
Cell[15804, 497, 1017, 22, 70, "GuideRelatedLinks",
 CellID->104855362]
}, Open  ]],
Cell[16836, 522, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

