(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13209,        396]
NotebookOptionsPosition[      7727,        264]
NotebookOutlinePosition[     11265,        331]
CellTagsIndexPosition[     11222,        328]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Integral Transforms", "GuideTitle",
 CellID->31981],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applies its strengths in calculus to the intricacies of integral \
transforms, with a host of original algorithms that probably now reach almost \
any closed form result that can be found, together with full support for \
symbolic generalized functions. "
}], "GuideAbstract",
 CellID->2330],

Cell[CellGroupData[{

Cell["Laplace Transforms", "GuideFunctionsSubsection",
 CellID->29130],

Cell[TextData[{
 Cell[TextData[ButtonBox["LaplaceTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LaplaceTransform"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseLaplaceTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseLaplaceTransform"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->18846]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fourier Transforms", "GuideFunctionsSubsection",
 CellID->4987],

Cell[TextData[{
 Cell[TextData[ButtonBox["FourierTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FourierTransform"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseFourierTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseFourierTransform"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->29445],

Cell[TextData[{
 Cell[TextData[ButtonBox["FourierSinTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FourierSinTransform"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseFourierSinTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseFourierSinTransform"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8616],

Cell[TextData[{
 Cell[TextData[ButtonBox["FourierCosTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FourierCosTransform"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseFourierCosTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseFourierCosTransform"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->5750],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fourier",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fourier"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["InverseFourier",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseFourier"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FourierDCT",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FourierDCT"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[BoxData["..."], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numerical discrete Fourier transforms"
}], "GuideText",
 CellID->18805]
}, Open  ]],

Cell[CellGroupData[{

Cell["Z Transforms", "GuideFunctionsSubsection",
 CellID->20489],

Cell[TextData[{
 Cell[TextData[ButtonBox["ZTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ZTransform"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseZTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseZTransform"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->27338],

Cell["\t", "GuideDelimiterSubsection",
 CellID->21963]
}, Open  ]],

Cell[CellGroupData[{

Cell["Related Functions", "GuideFunctionsSubsection",
 CellID->28135],

Cell[TextData[{
 Cell[TextData[ButtonBox["DiracDelta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DiracDelta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HeavisideTheta",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HeavisideTheta"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Integrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integrate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RSolve"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->14697]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->32209],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "GuideTutorial",\

 CellID->355138256],

Cell[TextData[ButtonBox["Discrete Fourier Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FourierTransforms"]], "GuideTutorial",
 CellID->272341331]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->1908],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "GuideMoreAbout",
 CellID->24474],

Cell[TextData[ButtonBox["Generalized Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedFunctions"]], "GuideMoreAbout",
 CellID->26737],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FourierSeries/guide/FourierSeriesPackage"]], "GuideMoreAboutSub",
 CellID->10293],

Cell[TextData[ButtonBox["Data Transforms & Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "GuideMoreAboutSub",\

 CellID->70319454],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1746008268],

Cell[TextData[{
 ButtonBox["Demonstrations related to Integral Transforms",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
DiracDelta+OR+Fourier+OR+FourierCosTransform+OR+FourierDCT+OR+\
FourierSinTransform+OR+FourierTransform+OR+HeavisideTheta+OR+InverseFourier+\
OR+InverseFourierCosTransform+OR+InverseFourierSinTransform+OR+\
InverseFourierTransform+OR+InverseLaplaceTransform+OR+InverseZTransform+OR+\
LaplaceTransform+OR+RSolve+OR+ZTransform)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->7318345]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integral Transforms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 57.6562050}", "context" -> "", 
    "keywords" -> {
     "Abramov algorithm", "arithmetic difference equations", 
      "Bromwich integral", "Bronstein algorithm", "chirp Z transform", 
      "control theory", "Cooley-Tukey transform", "cosine transform", 
      "delta function", "difference-algebraic equations", 
      "difference equations", "differential equations", "dirac delta", 
      "Dirichlet series", "discrete cosine transform", "discrete equations", 
      "discrete Fourier transform", "discrete Laplace transform", 
      "distribution", "divide-and-conquer equations", "Dwight's tables", 
      "fast cosine transform", "fast Fourier transform", "FFT", 
      "Fibonacci equations", "finite difference equations", 
      "formal power series", "Fourier cosine transform", 
      "Fourier cos transform", "Fourier sine transform", 
      "Fourier sin transform", "Fourier transform", "frequency dimension", 
      "frequency spectrum", "function transform", "generalized functions", 
      "generating function", "geometric difference equations", 
      "Goktas methods", "Gradshteyn-Ryzhik", "Green's functions", 
      "Heaviside theta", "image transform", "improper functions", 
      "impulse function", "impulse response", "integer sequence equations", 
      "integral operator", "integral transform", 
      "inverse cosine Fourier transform", "inverse Fourier", 
      "inverse Fourier cos transform", "inverse Fourier sin transform", 
      "inverse Fourier transform", "inverse Laplace transform", 
      "inverse sine Fourier transform", "inverse transform", 
      "inverse Z-transform", "inverse ztransform", "Laplace transform", 
      "Lebesgue integration", "limiting functions", 
      "Marichev-Adamchik methods", "Mellin transform methods", 
      "multiple integrals", "operational calculus", 
      "partial difference equations", "partial recurrence equations", 
      "power series", "power spectrum", "ramp response", 
      "real Fourier transform", "recurrence equations", "recursion equations",
       "Risch algorithm", "sequence transform", "signal processing", 
      "sine transform", "Slater's Theorem", "spectrum", "spike", 
      "step response", "surface integrals", "symmetry reduction", 
      "time domain", "transfer function", "transfer matrix", 
      "transient analysis", "trigonometric transform", "ztransform"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica applies its strengths in calculus to the intricacies of \
integral transforms, with a host of original algorithms that probably now \
reach almost any closed form result that can be found, together with full \
support for symbolic generalized functions. ", "synonyms" -> {}, "title" -> 
    "Integral Transforms", "type" -> "Guide", "uri" -> 
    "guide/IntegralTransforms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 57, 1, 70, "GuideTitle",
 CellID->31981],
Cell[679, 28, 359, 8, 70, "GuideAbstract",
 CellID->2330],
Cell[CellGroupData[{
Cell[1063, 40, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->29130],
Cell[1136, 43, 438, 11, 70, "InlineGuideFunctionListing",
 CellID->18846]
}, Open  ]],
Cell[CellGroupData[{
Cell[1611, 59, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->4987],
Cell[1683, 62, 438, 11, 70, "InlineGuideFunctionListing",
 CellID->29445],
Cell[2124, 75, 452, 12, 70, "InlineGuideFunctionListing",
 CellID->8616],
Cell[2579, 89, 452, 12, 70, "InlineGuideFunctionListing",
 CellID->5750],
Cell[3034, 103, 723, 21, 70, "GuideText",
 CellID->18805]
}, Open  ]],
Cell[CellGroupData[{
Cell[3794, 129, 64, 1, 70, "GuideFunctionsSubsection",
 CellID->20489],
Cell[3861, 132, 414, 11, 70, "InlineGuideFunctionListing",
 CellID->27338],
Cell[4278, 145, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->21963]
}, Open  ]],
Cell[CellGroupData[{
Cell[4369, 151, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->28135],
Cell[4441, 154, 967, 26, 70, "InlineGuideFunctionListing",
 CellID->14697]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5457, 186, 58, 1, 70, "GuideTutorialsSection",
 CellID->32209],
Cell[5518, 189, 204, 5, 70, "GuideTutorial",
 CellID->355138256],
Cell[5725, 196, 163, 3, 70, "GuideTutorial",
 CellID->272341331]
}, Open  ]],
Cell[CellGroupData[{
Cell[5925, 204, 58, 1, 70, "GuideMoreAboutSection",
 CellID->1908],
Cell[5986, 207, 129, 3, 70, "GuideMoreAbout",
 CellID->24474],
Cell[6118, 212, 154, 3, 70, "GuideMoreAbout",
 CellID->26737],
Cell[6275, 217, 175, 4, 70, "GuideMoreAboutSub",
 CellID->10293],
Cell[6453, 223, 174, 4, 70, "GuideMoreAboutSub",
 CellID->70319454],
Cell[6630, 229, 180, 3, 70, "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],
Cell[CellGroupData[{
Cell[6847, 237, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1746008268],
Cell[6920, 240, 765, 19, 70, "GuideRelatedLinks",
 CellID->7318345]
}, Open  ]],
Cell[7700, 262, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

