(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7391,        245]
NotebookOptionsPosition[      4399,        165]
NotebookOutlinePosition[      6235,        206]
CellTagsIndexPosition[      6192,        203]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Interactive 3D Control", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides real-time view control for all 3D graphics, wherever they may \
appear in a document",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s advanced human interface device system also automatically supports \
joystick and gamepad 3D graphics control, with special features available on \
the Wolfram Research 2+12 degree-of-freedom gamepad."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 StyleBox["Drag", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " interactively rotate a 3D graphic"
}], "GuideText",
 CellID->3432],

Cell[TextData[{
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Drag", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " zoom a 3D graphic"
}], "GuideText",
 CellID->2136],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Drag", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " pan a 3D graphic"
}], "GuideText",
 CellID->4580],

Cell["\t", "GuideDelimiterSubsection",
 CellID->449111604],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Gamepad Controls \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GamepadAndDeviceInterface"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->101190875],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControllerInformation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerInformation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "give information on installed controller devices"
}], "GuideText",
 CellID->90388727],

Cell["\t", "GuideDelimiterSubsection",
 CellID->220234639]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Viewing Geometry Options \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/3DGraphicsOptions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->96602938],

Cell[TextData[{
 Cell[TextData[ButtonBox["ViewPoint",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ViewPoint"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ViewVertical",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ViewVertical"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/3DGraphicsOptions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->711949988],

Cell[TextData[{
 Cell[TextData[ButtonBox["SphericalRegion",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SphericalRegion"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make a graphic rotatable without clipping"
}], "GuideText",
 CellID->16827]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "GuideMoreAbout",
 CellID->26063]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interactive 3D Control - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 58.3280972}", "context" -> "", 
    "keywords" -> {
     "angle of view", "camera position", "centering in 3D", 
      "centering of three-dimensional object", "circumscribing sphere", 
      "controller information", "eye position", "orientation of 3D object", 
      "point of view", "position of observer", "projection point", 
      "rotation in 3D", "rotation of 3D coordinates", 
      "rotation of three-dimensional object", "spherical region", 
      "up direction", "vantage point", "vertical direction", "viewing angle", 
      "viewing point for plots", "view point", "view vertical", "tumble"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica provides real-time view control for all 3D graphics, \
wherever they may appear in a document. Mathematica's advanced human \
interface device system also automatically supports joystick and gamepad 3D \
graphics control, with special features available on the Wolfram Research \
2+12 degree-of-freedom gamepad.", "synonyms" -> {}, "title" -> 
    "Interactive 3D Control", "type" -> "Guide", "uri" -> 
    "guide/Interactive3DControl"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 64, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[686, 28, 468, 12, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1157, 42, 167, 6, 70, "GuideText",
 CellID->3432],
Cell[1327, 50, 220, 8, 70, "GuideText",
 CellID->2136],
Cell[1550, 60, 218, 8, 70, "GuideText",
 CellID->4580],
Cell[1771, 70, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->449111604],
Cell[CellGroupData[{
Cell[1854, 75, 229, 5, 70, "GuideFunctionsSubsection",
 CellID->101190875],
Cell[2086, 82, 447, 12, 70, "GuideText",
 CellID->90388727],
Cell[2536, 96, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->220234639]
}, Open  ]],
Cell[CellGroupData[{
Cell[2631, 102, 230, 6, 70, "GuideFunctionsSubsection",
 CellID->96602938],
Cell[2864, 110, 620, 17, 70, "InlineGuideFunctionListing",
 CellID->711949988],
Cell[3487, 129, 280, 9, 70, "GuideText",
 CellID->16827]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3816, 144, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3881, 147, 152, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[4036, 152, 164, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[4203, 157, 154, 3, 70, "GuideMoreAbout",
 CellID->26063]
}, Open  ]],
Cell[4372, 163, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

