(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6144,        210]
NotebookOptionsPosition[      3626,        139]
NotebookOutlinePosition[      5235,        177]
CellTagsIndexPosition[      5192,        174]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Interval Arithmetic", "GuideTitle",
 CellID->3591],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically uses sophisticated algorithms to track the precision of \
approximate numbers. Particularly for some verification applications, \
however, it is convenient to maintain explicit numerical intervals. All ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s",
 " basic mathematical functions and operations automatically operate on ",
 Cell[TextData[ButtonBox["Interval",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interval"]], "InlineFunctionSans"],
 " objects. "
}], "GuideAbstract",
 CellID->12189],

Cell[TextData[{
 Cell[TextData[ButtonBox["Interval",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interval"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "represent an interval to be used in mathematical operations"
}], "GuideText",
 CellID->14893],

Cell["\t", "GuideDelimiter",
 CellID->3053],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntervalMemberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntervalMemberQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether a number lies within an interval"
}], "GuideText",
 CellID->17063],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntervalUnion",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntervalUnion"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "combine intervals together"
}], "GuideText",
 CellID->10681],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntervalIntersection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntervalIntersection"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find common parts of intervals"
}], "GuideText",
 CellID->25903],

Cell["\t", "GuideDelimiter",
 CellID->107082463],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootIntervals",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RootIntervals"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "give lists of isolating intervals for polynomial roots"
}], "GuideText",
 CellID->643128259]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->27005],

Cell[TextData[ButtonBox["Interval Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntervalArithmetic"]], "GuideTutorial",
 CellID->24176],

Cell[TextData[ButtonBox["Root Isolation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RootIsolation"]], "GuideTutorial",
 CellID->18479]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->1695],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "GuideMoreAbout",
 CellID->6139]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interval Arithmetic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 2.1250694}", "context" -> "", 
    "keywords" -> {
     "common range", "common subinterval", "domains", "interval arithmetic", 
      "interval intersection", "interval member", "interval union", 
      "isolating intervals", "join intervals", "point location", 
      "polynomial roots", "ranges", "region", "root intervals", "spans", 
      "validated numeric computation"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica automatically uses sophisticated algorithms to track the \
precision of approximate numbers. Particularly for some verification \
applications, however, it is convenient to maintain explicit numerical \
intervals. All Mathematica's basic mathematical functions and operations \
automatically operate on Interval objects. ", "synonyms" -> {}, "title" -> 
    "Interval Arithmetic", "type" -> "Guide", "uri" -> 
    "guide/IntervalArithmetic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->3591],
Cell[678, 28, 588, 15, 70, "GuideAbstract",
 CellID->12189],
Cell[1269, 45, 284, 9, 70, "GuideText",
 CellID->14893],
Cell[1556, 56, 43, 1, 70, "GuideDelimiter",
 CellID->3053],
Cell[1602, 59, 284, 9, 70, "GuideText",
 CellID->17063],
Cell[1889, 70, 261, 9, 70, "GuideText",
 CellID->10681],
Cell[2153, 81, 279, 9, 70, "GuideText",
 CellID->25903],
Cell[2435, 92, 48, 1, 70, "GuideDelimiter",
 CellID->107082463],
Cell[2486, 95, 438, 12, 70, "GuideText",
 CellID->643128259]
}, Open  ]],
Cell[CellGroupData[{
Cell[2961, 112, 58, 1, 70, "GuideTutorialsSection",
 CellID->27005],
Cell[3022, 115, 152, 3, 70, "GuideTutorial",
 CellID->24176],
Cell[3177, 120, 142, 3, 70, "GuideTutorial",
 CellID->18479]
}, Open  ]],
Cell[CellGroupData[{
Cell[3356, 128, 58, 1, 70, "GuideMoreAboutSection",
 CellID->1695],
Cell[3417, 131, 167, 3, 70, "GuideMoreAbout",
 CellID->6139]
}, Open  ]],
Cell[3599, 137, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

