(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14245,        442]
NotebookOptionsPosition[      8740,        302]
NotebookOutlinePosition[     11980,        365]
CellTagsIndexPosition[     11937,        362]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Inverse Functions", "GuideTitle",
 CellID->29515],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Root",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Root"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " roots of polynomials"
}], "GuideText",
 CellID->23838],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " symbolic functional inverse"
}], "GuideText",
 CellID->24828],

Cell[CellGroupData[{

Cell["Transcendental Solutions", "GuideFunctionsSubsection",
 CellID->12581],

Cell[TextData[Cell[TextData[ButtonBox["ProductLog",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ref/ProductLog"]], "InlineFunctionSans"]], \
"InlineGuideFunctionListing",
 CellID->24399]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trigonometric and Hyperbolic Functions", "GuideFunctionsSubsection",
 CellID->8978],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArcSin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcSin"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcCos",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcCos"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcTan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcTan"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcSinh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcSinh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcCosh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcCosh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcTanh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcTanh"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->11891]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error Functions", "GuideFunctionsSubsection",
 CellID->1023],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseErf",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseErf"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseErfc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseErfc"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26943]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gamma and Beta Functions", "GuideFunctionsSubsection",
 CellID->24834],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseGammaRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseBetaRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseBetaRegularized"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->14243]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elliptic Functions", "GuideFunctionsSubsection",
 CellID->7349],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseJacobiSN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiSN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiCN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiCN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseWeierstrassP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseWeierstrassP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticNomeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiAmplitude",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->2702]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bessel Function Zeros", "GuideFunctionsSubsection",
 CellID->255925671],

Cell[TextData[{
 Cell[TextData[ButtonBox["BesselJZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BesselJZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselYZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BesselYZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryAiZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AiryAiZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryBiZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AiryBiZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->68241009]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zeta Function Zeros", "GuideFunctionsSubsection",
 CellID->41134610],

Cell[TextData[Cell[TextData[ButtonBox["ZetaZero",
 BaseStyle->"NewInVersionLink",
 ButtonData->"paclet:ref/ZetaZero"]], "InlineFunctionSans",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]]]], "InlineGuideFunctionListing",
 CellID->315843985],

Cell["\t", "GuideDelimiter",
 CellID->8707],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindRoot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindRoot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " invert functions numerically"
}], "GuideText",
 CellID->20502]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->25141],

Cell[TextData[ButtonBox["Solving Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingEquations"]], "GuideTutorial",
 CellID->166390540],

Cell[TextData[ButtonBox["Numerical Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalEquationSolving"]], "GuideTutorial",
 CellID->417993195],

Cell[TextData[ButtonBox["Numerical Root Finding",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalRootFinding"]], "GuideTutorial",
 CellID->136036679],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->589834189]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->15891],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "GuideMoreAbout",
 CellID->24637],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAbout",
 CellID->18413],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "GuideMoreAboutSub",
 CellID->22816]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inverse Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 2.4063266}", "context" -> "", 
    "keywords" -> {
     "acos", "acosh", "Airy Ai zero", "Airy Bi zero", "amplitude", "arcch", 
      "arc cos", "arc cosh", "arccosine", "arch", "arcosh", "arcsh", 
      "arc sin", "arcsine", "arc sinh", "arcsinus", "arc tan", "arctangent", 
      "arc tanh", "arctg", "arcth", "arcus cosinus", "arcus sinus", 
      "arcus tangens", "area cosinus hyperbolicus", "argsinh", "arsh", 
      "arsinh", "artanh", "arth", "asin", "asinh", "atan", "atanh", 
      "Bessel functions", "Bessel zero", "Brent method", 
      "Collins-Krandick algorithm", "common roots of equations", 
      "cylindrical functions", "elliptic functions", "exponential function", 
      "find root", "FunctionInverse", "function inverse", 
      "inverse beta regularized", "inverse cosine", 
      "inverse cosine hyperbolic", "inverse erf", "inverse erfc", 
      "inverse function", "inverse gamma regularized", 
      "inverse hyperbolic tangent", "inverse Jacobi", "inverse Jacobi CN", 
      "inverse Jacobi elliptic function cn", 
      "inverse Jacobi elliptic function sn", "inverse Jacobi SN", 
      "inverse regularized beta function", "inverse regularized gamma", 
      "inverse sin", "inverse sine", "inverse sine hyperbolic function", 
      "inverse sinh", "inverse tan function", "inverse tangent", 
      "inverse tanh", "inverse th", "inverse trigonometric function", 
      "inverse Weierstrass", "inverse Weierstrass elliptic function", 
      "invert", "iterative root finding", "jacobi am", "jacobiam", 
      "Jacobi amplitude", "Jacobi elliptic functions", "Lambert function", 
      "Lambert's W-function", "LambertW", "LambertW function", "logarithm", 
      "Newton-Raphson method", "Newton's method", "numerical root finding", 
      "product log", "roots of equations", "secant method", 
      "solve algebraic equations", "solving systems of equations", 
      "transcendental equations", 
      "transcendental equations numerical solving", 
      "transcendental roots numerical solving", "tree generating function", 
      "Weierstrass elliptic functions", "zero of airy function", 
      "zero of Airy function", "zeros of Bessel functions", 
      "zeta function root", "zeta zero"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Root -- roots of polynomials, InverseFunction -- symbolic functional \
inverse, FindRoot -- invert functions numerically", "synonyms" -> {}, "title" -> 
    "Inverse Functions", "type" -> "Guide", "uri" -> 
    "guide/InverseFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->29515],
Cell[677, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[736, 31, 232, 8, 70, "GuideText",
 CellID->23838],
Cell[971, 41, 261, 8, 70, "GuideText",
 CellID->24828],
Cell[CellGroupData[{
Cell[1257, 53, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->12581],
Cell[1336, 56, 186, 5, 70, "InlineGuideFunctionListing",
 CellID->24399]
}, Open  ]],
Cell[CellGroupData[{
Cell[1559, 66, 89, 1, 70, "GuideFunctionsSubsection",
 CellID->8978],
Cell[1651, 69, 1206, 35, 70, "InlineGuideFunctionListing",
 CellID->11891]
}, Open  ]],
Cell[CellGroupData[{
Cell[2894, 109, 66, 1, 70, "GuideFunctionsSubsection",
 CellID->1023],
Cell[2963, 112, 402, 11, 70, "InlineGuideFunctionListing",
 CellID->26943]
}, Open  ]],
Cell[CellGroupData[{
Cell[3402, 128, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->24834],
Cell[3481, 131, 450, 11, 70, "InlineGuideFunctionListing",
 CellID->14243]
}, Open  ]],
Cell[CellGroupData[{
Cell[3968, 147, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->7349],
Cell[4040, 150, 1089, 29, 70, "InlineGuideFunctionListing",
 CellID->2702]
}, Open  ]],
Cell[CellGroupData[{
Cell[5166, 184, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->255925671],
Cell[5246, 187, 1411, 35, 70, "InlineGuideFunctionListing",
 CellID->68241009]
}, Open  ]],
Cell[CellGroupData[{
Cell[6694, 227, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->41134610],
Cell[6771, 230, 323, 6, 70, "InlineGuideFunctionListing",
 CellID->315843985],
Cell[7097, 238, 43, 1, 70, "GuideDelimiter",
 CellID->8707],
Cell[7143, 241, 248, 8, 70, "GuideText",
 CellID->20502]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7440, 255, 58, 1, 70, "GuideTutorialsSection",
 CellID->25141],
Cell[7501, 258, 152, 3, 70, "GuideTutorial",
 CellID->166390540],
Cell[7656, 263, 169, 3, 70, "GuideTutorial",
 CellID->417993195],
Cell[7828, 268, 161, 3, 70, "GuideTutorial",
 CellID->136036679],
Cell[7992, 273, 152, 3, 70, "GuideTutorial",
 CellID->589834189]
}, Open  ]],
Cell[CellGroupData[{
Cell[8181, 281, 59, 1, 70, "GuideMoreAboutSection",
 CellID->15891],
Cell[8243, 284, 156, 3, 70, "GuideMoreAbout",
 CellID->24637],
Cell[8402, 289, 146, 3, 70, "GuideMoreAbout",
 CellID->18413],
Cell[8551, 294, 147, 3, 70, "GuideMoreAboutSub",
 CellID->22816]
}, Open  ]],
Cell[8713, 300, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

