(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22964,        750]
NotebookOptionsPosition[     18188,        620]
NotebookOutlinePosition[     20407,        665]
CellTagsIndexPosition[     20364,        662]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Language Overview", "GuideTitle",
 CellID->3737],

Cell[TextData[{
 "At the core of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is its highly developed symbolic language, which unifies a broad range of \
programming paradigms, and uses its unique concept of symbolic programming to \
add a new level of flexibility to the very concept of programming."
}], "GuideAbstract",
 CellID->13261],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Symbolic Expressions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Expressions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->517645653],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the basic underlying form of everything in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "GuideText",
 CellID->963972387]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Lists & Expression Manipulation \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ListManipulation"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->143668186],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["{",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"],
  ButtonBox["...",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"],
  ButtonBox["}",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["List",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/List"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[{
  ButtonBox["...",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["...",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Length",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Length"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Take",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Take"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Select",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Select"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ListManipulation"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->129409977]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Functional Operations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionalProgramming"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->584069956],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["...",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"],
  ButtonBox["&",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Function",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Function"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["/@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Map",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Nest"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NestList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FoldList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FoldList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Array",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Array"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FunctionalProgramming"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->584314787]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Pattern Matching \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RulesAndPatterns"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->25547],

Cell[TextData[{
 Cell[TextData[ButtonBox["_",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Blank"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["__",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BlankSequence"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["|",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Alternatives"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["..",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Repeated"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["/;",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Condition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cases"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RulesAndPatterns"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Rules & Transformations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RulesAndPatterns"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->30771],

Cell[TextData[{
 Cell[TextData[ButtonBox["->",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rule"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Rule",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rule"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox[":>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RuleDelayed"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["/.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"]], "InlineFunctionSans"],
 ButtonBox[" (",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"],
 Cell[TextData[ButtonBox["ReplaceAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RulesAndPatterns"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6411]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Definitions & Assignments \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Assignments"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->527446810],

Cell[TextData[{
 Cell[TextData[ButtonBox["=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Set"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox[":=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetDelayed"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["=.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unset"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["^=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/UpSet"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Assignments"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->430451281]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Logic & Tests \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/TestingExpressions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->506052658],

Cell[TextData[{
 Cell[TextData[ButtonBox["==",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["!=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unequal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["&&",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/And"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["||",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Or"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MemberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemberQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/TestingExpressions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->443310157]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Scoping & Modularity \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ScopingConstructs"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->30900],

Cell[TextData[{
 Cell[TextData[ButtonBox["Module",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Module"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["With",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/With"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Block",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Block"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ScopingConstructs"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->17713]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Procedural Programming \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProceduralProgramming"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->14924],

Cell[TextData[{
 Cell[TextData[ButtonBox[";",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CompoundExpression"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["If",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/If"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Do",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Do"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["While",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/While"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sow",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sow"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Reap",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reap"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ProceduralProgramming"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->30188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["String Manipulation \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StringManipulation"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->21763],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"...\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/String"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["String",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/String"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringExpression"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringReplace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringReplace"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringCases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringCases"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StringManipulation"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->4940]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->6439],

Cell[TextData[{
 ButtonBox["The Syntax of the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSyntaxOfTheMathematicaLanguage"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSyntaxOfTheMathematicaLanguage"],
  FontSlant->"Italic"],
 ButtonBox[" Language",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSyntaxOfTheMathematicaLanguage"]
}], "GuideTutorial",
 CellID->2303],

Cell[TextData[ButtonBox["The Meaning of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMeaningOfExpressions"]], "GuideTutorial",
 CellID->12760],

Cell[TextData[{
 ButtonBox["The Four Kinds of Bracketing in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheFourKindsOfBracketingInMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheFourKindsOfBracketingInMathematica"],
  FontSlant->"Italic"]
}], "GuideTutorial",
 CellID->347702687],

Cell[TextData[ButtonBox["Some General Notations and Conventions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SomeGeneralNotationsAndConventions"]], "GuideTutorial",
 CellID->75069282]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->19357],

Cell[TextData[ButtonBox["Syntax",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Syntax"]], "GuideMoreAboutSub",
 CellID->21113],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "GuideMoreAbout",
 CellID->320472611]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Language Overview - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 3.2032220}", "context" -> "", 
    "keywords" -> {
     "`", "~~", ";;", "::", ">>>", "<>", ">>", "<<", "<=", "<", ">=", ">", 
      ";", "}", "{", "]]", "[[", "|", "||", "&&", "&", "___", "__", "_", ":", 
      "/=", "*=", "-=", "+=", "--", "++", "**", "##", "#", "/;", "//.", "/.", 
      "@@@", "@@", "//@", "/@", "...", "..", "%%", "%", "=!=", "!=", "===", 
      "==", "/:", "^:=", "^=", "=.", ":=", "=", ":>", "->", "^^", "/", "!!", 
      "!", "??", "?", "(*", "*)", "//", "anonymous functions", 
      "application of rules", "expressions", "expression elements", 
      "expression tree", "functional composition", "functional programming", 
      "functional language", "immediate rules", "infinite evaluation", 
      "infinite rule application", "iterated functions", 
      "iterated operations", "lambda expression", "module", "patterns", 
      "patterns for string", "pattern match", "production rules", "programs", 
      "pure function", "repeat", "replacement", "replacement rules", 
      "sequential substitution systems", "substitution", "unnamed function"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "At the core of Mathematica is its highly developed symbolic language, \
which unifies a broad range of programming paradigms, and uses its unique \
concept of symbolic programming to add a new level of flexibility to the very \
concept of programming.", "synonyms" -> {}, "title" -> "Language Overview", 
    "type" -> "Guide", "uri" -> "guide/LanguageOverview"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 54, 1, 70, "GuideTitle",
 CellID->3737],
Cell[676, 28, 348, 8, 70, "GuideAbstract",
 CellID->13261],
Cell[CellGroupData[{
Cell[1049, 40, 219, 5, 70, "GuideFunctionsSubsection",
 CellID->517645653],
Cell[1271, 47, 381, 14, 70, "GuideText",
 CellID->963972387]
}, Open  ]],
Cell[CellGroupData[{
Cell[1689, 66, 237, 6, 70, "GuideFunctionsSubsection",
 CellID->143668186],
Cell[1929, 74, 2153, 76, 70, "InlineGuideFunctionListing",
 CellID->129409977]
}, Open  ]],
Cell[CellGroupData[{
Cell[4119, 155, 230, 5, 70, "GuideFunctionsSubsection",
 CellID->584069956],
Cell[4352, 162, 1723, 56, 70, "InlineGuideFunctionListing",
 CellID->584314787]
}, Open  ]],
Cell[CellGroupData[{
Cell[6112, 223, 216, 5, 70, "GuideFunctionsSubsection",
 CellID->25547],
Cell[6331, 230, 1614, 47, 70, "InlineGuideFunctionListing",
 CellID->21153]
}, Open  ]],
Cell[CellGroupData[{
Cell[7982, 282, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->30771],
Cell[8208, 289, 1092, 35, 70, "InlineGuideFunctionListing",
 CellID->6411]
}, Open  ]],
Cell[CellGroupData[{
Cell[9337, 329, 226, 6, 70, "GuideFunctionsSubsection",
 CellID->527446810],
Cell[9566, 337, 986, 29, 70, "InlineGuideFunctionListing",
 CellID->430451281]
}, Open  ]],
Cell[CellGroupData[{
Cell[10589, 371, 219, 5, 70, "GuideFunctionsSubsection",
 CellID->506052658],
Cell[10811, 378, 1194, 35, 70, "InlineGuideFunctionListing",
 CellID->443310157]
}, Open  ]],
Cell[CellGroupData[{
Cell[12042, 418, 221, 5, 70, "GuideFunctionsSubsection",
 CellID->30900],
Cell[12266, 425, 1147, 32, 70, "InlineGuideFunctionListing",
 CellID->17713]
}, Open  ]],
Cell[CellGroupData[{
Cell[13450, 462, 227, 5, 70, "GuideFunctionsSubsection",
 CellID->14924],
Cell[13680, 469, 1397, 41, 70, "InlineGuideFunctionListing",
 CellID->30188]
}, Open  ]],
Cell[CellGroupData[{
Cell[15114, 515, 221, 5, 70, "GuideFunctionsSubsection",
 CellID->21763],
Cell[15338, 522, 1162, 34, 70, "InlineGuideFunctionListing",
 CellID->4940]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16549, 562, 57, 1, 70, "GuideTutorialsSection",
 CellID->6439],
Cell[16609, 565, 433, 12, 70, "GuideTutorial",
 CellID->2303],
Cell[17045, 579, 164, 3, 70, "GuideTutorial",
 CellID->12760],
Cell[17212, 584, 347, 9, 70, "GuideTutorial",
 CellID->347702687],
Cell[17562, 595, 193, 4, 70, "GuideTutorial",
 CellID->75069282]
}, Open  ]],
Cell[CellGroupData[{
Cell[17792, 604, 59, 1, 70, "GuideMoreAboutSection",
 CellID->19357],
Cell[17854, 607, 128, 3, 70, "GuideMoreAboutSub",
 CellID->21113],
Cell[17985, 612, 161, 3, 70, "GuideMoreAbout",
 CellID->320472611]
}, Open  ]],
Cell[18161, 618, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

