(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12417,        398]
NotebookOptionsPosition[      7595,        276]
NotebookOutlinePosition[     10502,        333]
CellTagsIndexPosition[     10459,        330]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Linear Systems", "GuideTitle",
 CellID->13043],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " incorporates the latest algorithms for solving industrial-scale linear \
systems, automatically switching between optimal dense and sparse algorithms\
\[LongDash]and handling exact, symbolic and arbitrary precision as well as \
machine-precision computation. "
}], "GuideAbstract",
 CellID->14522],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinearSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solve a linear system, dense or sparse"
}], "GuideText",
 CellID->9850],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinearSolveFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a function created to repeatedly solve a linear system"
}], "GuideText",
 CellID->17022],

Cell[TextData[{
 Cell[TextData[ButtonBox["Inverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Inverse"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "explicit dense matrix inverse"
}], "GuideText",
 CellID->7240],

Cell["\t", "GuideDelimiter",
 CellID->21911],

Cell[TextData[{
 Cell[TextData[ButtonBox["NullSpace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NullSpace"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "vectors spanning the null space of a matrix"
}], "GuideText",
 CellID->9492],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixRank",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixRank"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "rank of a matrix"
}], "GuideText",
 CellID->5651],

Cell[TextData[{
 Cell[TextData[ButtonBox["Det",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Det"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "determinant"
}], "GuideText",
 CellID->28580],

Cell["\t", "GuideDelimiter",
 CellID->15477],

Cell[TextData[{
 Cell[TextData[ButtonBox["Minors",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minors"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "matrices of minors"
}], "GuideText",
 CellID->27616],

Cell[TextData[{
 Cell[TextData[ButtonBox["RowReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RowReduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generate a row echelon form"
}], "GuideText",
 CellID->29876],

Cell[TextData[{
 Cell[TextData[ButtonBox["LUDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LUDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CholeskyDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CholeskyDecomposition"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->19178],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Minimization Problems \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MatrixBasedMinimization"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->14615],

Cell[TextData[{
 Cell[TextData[ButtonBox["LeastSquares",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LeastSquares"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PseudoInverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PseudoInverse"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Norm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Norm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinearProgramming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearProgramming"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MatrixBasedMinimization"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->22348]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->26798],

Cell[TextData[ButtonBox["Solving Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingLinearSystems"]], "GuideTutorial",
 CellID->119754687],

Cell[TextData[ButtonBox["Basic Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicMatrixOperations"]], "GuideTutorial",
 CellID->122013290],

Cell[TextData[ButtonBox["Matrix Inversion",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MatrixInversion"]], "GuideTutorial",
 CellID->727742971],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "GuideTutorial",
 CellID->859376041],

Cell[TextData[ButtonBox["Constrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationOverview"]], "GuideTutorial",
 CellID->115795587]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->16857],

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixDecompositions"]], "GuideMoreAbout",
 CellID->1662],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "GuideMoreAbout",
 CellID->53559309],

Cell[TextData[ButtonBox["Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SparseArrays"]], "GuideMoreAboutSub",
 CellID->28262],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "GuideMoreAbout",
 CellID->221348293]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->759239984],

Cell[TextData[{
 ButtonBox["Demonstrations related to Linear Systems",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
CholeskyDecomposition+OR+Det+OR+Inverse+OR+LeastSquares+OR+LinearProgramming+\
OR+LinearSolve+OR+LinearSolveFunction+OR+LUDecomposition+OR+MatrixRank+OR+\
Minors+OR+Norm+OR+NullSpace+OR+PseudoInverse+OR+RowReduce)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->20194168]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear Systems - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 4.2657492}", "context" -> "", 
    "keywords" -> {
     "1-norm", "2-norm", "adjoint", "basis dimension", 
      "characteristic polynomials for matrices", "Cholesky decomposition", 
      "cofactors", "column rank", "combinations", 
      "condition number of matrices", "Cramer's rule", "determinant", 
      "determinant of matrix", "direct solver methods", 
      "division of matrices", "echelon form of matrices", "Euclidean norm", 
      "Frobenius norm", "Gaussian elimination", "Gauss-Jordan elimination", 
      "generalized inverse of matrices", "induced matrix norm", 
      "infinity-norm", "inner product norm", "integer programming", 
      "interior point methods", "inverse of a matrix", 
      "inversion of matrices", "invert", "Karmarkar's algorithm", 
      "kernel of matrices", "Krylov methods", "ladder form", "least-squares", 
      "least squares", "linear constraints", "linear equation", 
      "linear objective function", "linear optimization", 
      "linear programming", "linear solve function", "LINPACK", "LP", 
      "matrix equation", "matrix equations", "matrix inverse", 
      "matrix kernel", "matrix norm", "matrix rank", "metric", 
      "minors of matrices", "Moore-Penrose inverse", "multifrontal methods", 
      "norm", "null space", "null spaces of matrices", "operations research", 
      "p-norm", "positive definite matrix", "pseudo-inverse", 
      "pseudo inverse", "rank of matrices", "redundant linear equations", 
      "repeated solution of linear systems", "row elimination", "row rank", 
      "row reduce", "row reduction of matrices", "semi-inverse", 
      "simplex algorithm", "solution of linear system", "sparse matrices", 
      "triangular matrices", "UMFPACK", "vector length", "vector norm"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica incorporates the latest algorithms for solving \
industrial-scale linear systems, automatically switching between optimal \
dense and sparse algorithms--and handling exact, symbolic and arbitrary \
precision as well as machine-precision computation. ", "synonyms" -> {}, 
    "title" -> "Linear Systems", "type" -> "Guide", "uri" -> 
    "guide/LinearSystems"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 52, 1, 70, "GuideTitle",
 CellID->13043],
Cell[674, 28, 365, 8, 70, "GuideAbstract",
 CellID->14522],
Cell[1042, 38, 268, 9, 70, "GuideText",
 CellID->9850],
Cell[1313, 49, 301, 9, 70, "GuideText",
 CellID->17022],
Cell[1617, 60, 251, 9, 70, "GuideText",
 CellID->7240],
Cell[1871, 71, 44, 1, 70, "GuideDelimiter",
 CellID->21911],
Cell[1918, 74, 269, 9, 70, "GuideText",
 CellID->9492],
Cell[2190, 85, 244, 9, 70, "GuideText",
 CellID->5651],
Cell[2437, 96, 226, 9, 70, "GuideText",
 CellID->28580],
Cell[2666, 107, 44, 1, 70, "GuideDelimiter",
 CellID->15477],
Cell[2713, 110, 239, 9, 70, "GuideText",
 CellID->27616],
Cell[2955, 121, 254, 9, 70, "GuideText",
 CellID->29876],
Cell[3212, 132, 432, 11, 70, "InlineGuideFunctionListing",
 CellID->19178],
Cell[CellGroupData[{
Cell[3669, 147, 228, 5, 70, "GuideFunctionsSubsection",
 CellID->14615],
Cell[3900, 154, 1201, 32, 70, "InlineGuideFunctionListing",
 CellID->22348]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5150, 192, 58, 1, 70, "GuideTutorialsSection",
 CellID->26798],
Cell[5211, 195, 161, 3, 70, "GuideTutorial",
 CellID->119754687],
Cell[5375, 200, 163, 3, 70, "GuideTutorial",
 CellID->122013290],
Cell[5541, 205, 150, 3, 70, "GuideTutorial",
 CellID->727742971],
Cell[5694, 210, 169, 3, 70, "GuideTutorial",
 CellID->859376041],
Cell[5866, 215, 177, 4, 70, "GuideTutorial",
 CellID->115795587]
}, Open  ]],
Cell[CellGroupData[{
Cell[6080, 224, 59, 1, 70, "GuideMoreAboutSection",
 CellID->16857],
Cell[6142, 227, 153, 3, 70, "GuideMoreAbout",
 CellID->1662],
Cell[6298, 232, 147, 3, 70, "GuideMoreAbout",
 CellID->53559309],
Cell[6448, 237, 141, 3, 70, "GuideMoreAboutSub",
 CellID->28262],
Cell[6592, 242, 203, 4, 70, "GuideMoreAbout",
 CellID->221348293]
}, Open  ]],
Cell[CellGroupData[{
Cell[6832, 251, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->759239984],
Cell[6904, 254, 649, 17, 70, "GuideRelatedLinks",
 CellID->20194168]
}, Open  ]],
Cell[7568, 274, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

