(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50671,       1903]
NotebookOptionsPosition[     39233,       1543]
NotebookOutlinePosition[     40267,       1572]
CellTagsIndexPosition[     40224,       1569]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Listing of All Formats", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports many formats, with many subformats, variants and options. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"3DS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/3DS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "3D Studio format  (.3ds)"
}], "GuideText",
 CellID->386431044],

Cell["\t", "GuideDelimiter",
 CellID->2375041],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"ACO\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ACO"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Adobe color palette format (.aco)"
}], "GuideText",
 CellID->105849547],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"AIFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AIFF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " AIFF Macintosh sound format (.aif, .aiff)"
}], "GuideText",
 CellID->217956197],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"ApacheLog\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ApacheLog"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Apache access log file format"
}], "GuideText",
 CellID->558966034],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"AU\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AU"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " law encoding Unix Audio Format (.au)"
}], "GuideText",
 CellID->399112026],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"AVI\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AVI"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Microsoft AVI format (.avi)"
}], "GuideText",
 CellID->355187164],

Cell["\t", "GuideDelimiter",
 CellID->5997085],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Base64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Base64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Base64 ASCII encoding"
}], "GuideText",
 CellID->422074656],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Bit\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Bit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of binary bits"
}], "GuideText",
 CellID->246835681],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"BMP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/BMP"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Microsoft bitmap format (.bmp)"
}], "GuideText",
 CellID->67137284],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Byte\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Byte"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of ",
 "8-bit unsigned integers"
}], "GuideText",
 CellID->478450592],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"BYU\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/BYU"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "BYU 3D geometry format (.byu)"
}], "GuideText",
 CellID->170882455],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"BZIP2\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/BZIP2"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "bzip2 compression format (.bz2)"
}], "GuideText",
 CellID->19919406],

Cell["\t", "GuideDelimiter",
 CellID->43787487],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"CDED\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CDED"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Canadian digital elevation data (.dem)"
}], "GuideText",
 CellID->111475460],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"CDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CDF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " NASA common data format (.cdf)"
}], "GuideText",
 CellID->19850643],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Character8\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Character8"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 8-bit characters"
}], "GuideText",
 CellID->3326233],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Character16\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Character16"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 16-bit Unicode characters"
}], "GuideText",
 CellID->360483964],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Complex64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Complex64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " IEEE single-precision complex numbers"
}], "GuideText",
 CellID->189350195],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Complex128\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Complex128"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " IEEE double-precision complex numbers"
}], "GuideText",
 CellID->69939423],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Complex256\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Complex256"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "IEEE quad-precision complex numbers"
}], "GuideText",
 CellID->73888486],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"CSV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CSV"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " comma-separated values (.csv)"
}], "GuideText",
 CellID->691242827],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"CUR\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CUR"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Windows cursor resource format (.cur)"
}], "GuideText",
 CellID->20537147],

Cell["\t", "GuideDelimiter",
 CellID->86489340],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"DBF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DBF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " dBase database file (.dbf)"
}], "GuideText",
 CellID->4107554],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"DICOM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DICOM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "DICOM medical image format (.dcm, .dic)"
}], "GuideText",
 CellID->86637709],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"DIF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DIF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " VisiCalc data interchange format (.dif)"
}], "GuideText",
 CellID->97926459],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Directory\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Directory"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " filesystem directory hierarchy"
}], "GuideText",
 CellID->185655628],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"DXF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DXF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " AutoCAD 2D and 3D format (.dxf)"
}], "GuideText",
 CellID->212484304],

Cell["\t", "GuideDelimiter",
 CellID->166632912],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"EDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/EDF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " European Data Format (.edf)"
}], "GuideText",
 CellID->355005548],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"EMF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/EMF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Windows metafile and enhanced metafile formats"
}], "GuideText",
 CellID->153428630],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"EPS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/EPS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Encapsulated PostScript (.eps)"
}], "GuideText",
 CellID->671701478],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"ExpressionML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression XML format (.xml)"
}], "GuideText",
 CellID->334608905],

Cell["\t", "GuideDelimiter",
 CellID->322903274],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"FASTA\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FASTA"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " bioinformatics sequence format (.fasta, .fa, .fsa, .mpfa)"
}], "GuideText",
 CellID->1964589],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"FITS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FITS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " FITS astronomical data and image format (.fit, .fits)"
}], "GuideText",
 CellID->173880935],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"FLAC\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FLAC"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "FLAC lossless audio codec (.flac)"
}], "GuideText",
 CellID->57139236],

Cell["\t", "GuideDelimiter",
 CellID->14384923],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"GIF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GIF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " static or animated GIF (.gif)"
}], "GuideText",
 CellID->75993501],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Graph6\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Graph6"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " dense graph format (.g6)"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"GTOPO30\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GTOPO30"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "USGS global topographic data (.dem)"
}], "GuideText",
 CellID->195913588],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"GZIP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GZIP"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Unix gzip compression (.gz)"
}], "GuideText",
 CellID->136378392],

Cell["\t", "GuideDelimiter",
 CellID->192184801],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"HarwellBoeing\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HarwellBoeing"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Harwell-Boeing sparse matrix format"
}], "GuideText",
 CellID->420602384],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"HDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HDF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " NCSA hierarchical data format (.hdf)"
}], "GuideText",
 CellID->277607006],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"HDF5\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HDF5"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " NCSA HDF 5 hierarchical data format (.h5)"
}], "GuideText",
 CellID->94080949],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"HTML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HTML"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "HTML format (.htm, .html), including embedded GIFs, CSS, etc."
}], "GuideText",
 CellID->31817183],

Cell["\t", "GuideDelimiter",
 CellID->86018997],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"ICO\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ICO"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Windows icon resource format (.ico)"
}], "GuideText",
 CellID->108736832],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Integer8\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Integer8"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 8-bit signed integers"
}], "GuideText",
 CellID->127377210],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Integer16\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Integer16"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 16-bit signed integers"
}], "GuideText",
 CellID->866695901],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Integer24\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Integer24"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 24-bit signed integers"
}], "GuideText",
 CellID->28955209],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Integer32\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Integer32"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 32-bit signed integers"
}], "GuideText",
 CellID->301782379],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Integer64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Integer64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 64-bit signed integers"
}], "GuideText",
 CellID->41859578],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Integer128\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Integer128"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 128-bit signed integers"
}], "GuideText",
 CellID->199683182],

Cell["\t", "GuideDelimiter",
 CellID->20365760],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"JPEG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JPEG"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "JPEG raster image format  (.jpeg, .jpg)"
}], "GuideText",
 CellID->31288039],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"JPEG2000\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JPEG2000"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " JPEG 2000/JP2 raster image format (.jp2, .j2k)"
}], "GuideText",
 CellID->107589746],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"JVX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JVX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "JavaView format (.jvx)"
}], "GuideText",
 CellID->65009503],

Cell["\t", "GuideDelimiter",
 CellID->131718664],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"LaTeX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/LaTeX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " format (.latex)"
}], "GuideText",
 CellID->444572527],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"List\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/List"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "numbers or strings, one per line"
}], "GuideText",
 CellID->305034716],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"LWO\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/LWO"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "LightWave 3D file format (.lwo)"
}], "GuideText",
 CellID->354380943],

Cell["\t", "GuideDelimiter",
 CellID->7957648],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MAT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MAT"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Matlab/Octave data format (.mat)"
}], "GuideText",
 CellID->288216781],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MathML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MathML"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " MathML math content format"
}], "GuideText",
 CellID->344928077],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Maya\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Maya"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Maya entity files (.ma)"
}], "GuideText",
 CellID->401725784],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MBOX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MBOX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " mbox Unix mailbox format (.mbox)"
}], "GuideText",
 CellID->355388471],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MDB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MDB"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Microsoft Access database file (.mdb)"
}], "GuideText",
 CellID->405256250],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MGF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MGF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " MGF bitmap format (.mgf)"
}], "GuideText",
 CellID->324865854],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MIDI\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MIDI"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "MIDI music format (.mid)"
}], "GuideText",
 CellID->31222266],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MOL\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MOL"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " MDL MOL molecular models and drawings format (.mol)"
}], "GuideText",
 CellID->191613666],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MPS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MPS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " MPS linear programming system format (.mps)"
}], "GuideText",
 CellID->431033167],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MTP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MTP"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Minitab portable worksheet format (.mtp)"
}], "GuideText",
 CellID->4451634],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MTX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MTX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Matrix Market sparse matrix format (.mtx)"
}], "GuideText",
 CellID->46849256],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " serialized package format (.mx)"
}], "GuideText",
 CellID->157400125],

Cell["\t", "GuideDelimiter",
 CellID->446341557],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"NB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/NB"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Wolfram Notebook format (.nb)"
}], "GuideText",
 CellID->240928860],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"NetCDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/NetCDF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Unidata scientific data format"
}], "GuideText",
 CellID->410845883],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"NOFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/NOFF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 3D object file format with normals (.noff, .cnoff)"
}], "GuideText",
 CellID->632795719],

Cell["\t", "GuideDelimiter",
 CellID->132499393],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"OBJ\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/OBJ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Wavefront OBJ format (.obj)"
}], "GuideText",
 CellID->91136457],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"ODS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ODS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "OpenDocument spreadsheet format (.ods)"
}], "GuideText",
 CellID->93362277],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"OFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/OFF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 3D object file format (.off, .coff)"
}], "GuideText",
 CellID->738048793],

Cell["\t", "GuideDelimiter",
 CellID->130638301],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Package\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Package"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package source (.m)"
}], "GuideText",
 CellID->211281197],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PBM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PBM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ASCII portable bitmap format (.pbm)"
}], "GuideText",
 CellID->51352603],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PCX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PCX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Windows Paintbrush format (.pcx)"
}], "GuideText",
 CellID->90844297],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PDB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PDB"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Protein Data Bank format (.pdb)"
}], "GuideText",
 CellID->388694977],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PDF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Adobe Acrobat PDF format (.pdf)"
}], "GuideText",
 CellID->285826059],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PGM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PGM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ASCII portable graymap format (.pgm)"
}], "GuideText",
 CellID->434892357],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PICT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PICT"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Macintosh PICT format (.pict)"
}], "GuideText",
 CellID->220719283],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PLY\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PLY"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "PLY 3D geometry format (.ply)"
}], "GuideText",
 CellID->82887012],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PNG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PNG"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " PNG raster image format (.png)"
}], "GuideText",
 CellID->111607756],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PNM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PNM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ASCII portable raster format (.pnm)"
}], "GuideText",
 CellID->734914930],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"POV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/POV"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " POV-Ray raytracing object description format (.pov)"
}], "GuideText",
 CellID->638836807],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PPM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PPM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ASCII portable color pixmap format (.ppm)"
}], "GuideText",
 CellID->26460465],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"PXR\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PXR"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Pixar raster format (.pxr)"
}], "GuideText",
 CellID->389143930],

Cell["\t", "GuideDelimiter",
 CellID->498939871],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"RawBitmap\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/RawBitmap"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " pure binary bitmap data"
}], "GuideText",
 CellID->356414953],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Real32\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Real32"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " IEEE single-precision real numbers"
}], "GuideText",
 CellID->151306256],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Real64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Real64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " IEEE double-precision real numbers"
}], "GuideText",
 CellID->982103815],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Real128\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Real128"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " IEEE quad-precision real numbers"
}], "GuideText",
 CellID->361373031],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"RIB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/RIB"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Renderman interchange format (.rib)"
}], "GuideText",
 CellID->1460558],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"RSS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/RSS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " RSS feed format (.rss)"
}], "GuideText",
 CellID->120422147],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"RTF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/RTF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Microsoft Rich Text Format (.rtf)"
}], "GuideText",
 CellID->41353539],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SCT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SCT"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Scitex CT prepress format (.sct)"
}], "GuideText",
 CellID->866847377],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SDTS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SDTS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " SDTS DLG and DEM spatial data files"
}], "GuideText",
 CellID->130287981],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SND\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SND"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " SND file format (.snd)"
}], "GuideText",
 CellID->155624515],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Sparse6\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Sparse6"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sparse graph format (.s6)"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"STL\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/STL"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "stereolithography format (.stl)"
}], "GuideText",
 CellID->284979988],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"String\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " arbitrary data as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string"
}], "GuideText",
 CellID->424723],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SVG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SVG"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Scalable Vector Graphics format (.svg)"
}], "GuideText",
 CellID->500346071],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SWF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SWF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Flash multimedia format (.swf)"
}], "GuideText",
 CellID->297500450],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SXC\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SXC"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " OpenOffice 1.0 spreadsheet file (.sxc)"
}], "GuideText",
 CellID->342621516],

Cell["\t", "GuideDelimiter",
 CellID->195664037],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Table\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Table"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " arbitrary tabular data (.dat)"
}], "GuideText",
 CellID->819438194],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"TAR\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TAR"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Unix tar archive (.tar)"
}], "GuideText",
 CellID->711238367],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"TerminatedString\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TerminatedString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "null-terminated string"
}], "GuideText",
 CellID->534950781],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"TeX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TeX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " document format (.tex)"
}], "GuideText",
 CellID->57365892],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Text\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Text"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plain text (.txt)"
}], "GuideText",
 CellID->276957721],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"TGA\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TGA"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "TrueVision Targa format (.tga)"
}], "GuideText",
 CellID->333188110],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"TIFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TIFF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "TIFF raster image format (.tiff, .tif)"
}], "GuideText",
 CellID->68864796],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"TSV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TSV"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " tab-separated values (.tsv)"
}], "GuideText",
 CellID->547206078],

Cell["\t", "GuideDelimiter",
 CellID->190055396],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"UnsignedInteger8\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/UnsignedInteger8"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 8-bit unsigned integers"
}], "GuideText",
 CellID->35356484],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"UnsignedInteger16\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/UnsignedInteger16"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 16-bit unsigned integers"
}], "GuideText",
 CellID->191186752],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"UnsignedInteger24\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/UnsignedInteger24"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 24-bit unsigned integers"
}], "GuideText",
 CellID->564944495],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"UnsignedInteger32\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/UnsignedInteger32"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 32-bit unsigned integers"
}], "GuideText",
 CellID->518014684],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"UnsignedInteger64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/UnsignedInteger64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 64-bit unsigned integers"
}], "GuideText",
 CellID->20792008],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"UnsignedInteger128\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/UnsignedInteger128"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of 128-bit unsigned integers"
}], "GuideText",
 CellID->184538999],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"USGSDEM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/USGSDEM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " USGS ASCII DEM digital elevation file (.dem)"
}], "GuideText",
 CellID->613512998],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"UUE\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/UUE"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Unix uuencode format (.uue, .enc)"
}], "GuideText",
 CellID->287472358],

Cell["\t", "GuideDelimiter",
 CellID->371949360],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"VCF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/VCF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " vCard format (.vcf)"
}], "GuideText",
 CellID->111206568],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"VRML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/VRML"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Virtual Reality Modeling Language format (.vrml)"
}], "GuideText",
 CellID->295474151],

Cell["\t", "GuideDelimiter",
 CellID->626171198],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"WAV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WAV"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Microsoft WAV audio format (.wav)"
}], "GuideText",
 CellID->192844976],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Wave64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Wave64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Sony Wave64 audio format (.w64)"
}], "GuideText",
 CellID->35412431],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"WDX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WDX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Wolfram data exchange format (.wdx)"
}], "GuideText",
 CellID->295741637],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"WMF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WMF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Windows metafile format (.wmf)"
}], "GuideText",
 CellID->480832943],

Cell["\t", "GuideDelimiter",
 CellID->35294763],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"X3D\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/X3D"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "X3D XML geometry format (.x3d)"
}], "GuideText",
 CellID->180780393],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XBM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XBM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " X bitmap format (.xbm)"
}], "GuideText",
 CellID->275956561],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XHTML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XHTML"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " XML-syntax HTML (.xhtml)"
}], "GuideText",
 CellID->1610476],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XHTMLMathML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XHTMLMathML"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " XHTML with embedded MathML"
}], "GuideText",
 CellID->56810358],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XLS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XLS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Excel spreadsheet format (.xls)"
}], "GuideText",
 CellID->54515675],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XML"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " arbitrary XML (.xml)"
}], "GuideText",
 CellID->34510035],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XPORT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XPORT"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " SAS interchange format (.stx, .xpt)"
}], "GuideText",
 CellID->33214036],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XYZ\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XYZ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " XYZ molecule geometry file (.xyz)"
}], "GuideText",
 CellID->6074940],

Cell["\t", "GuideDelimiter",
 CellID->78922005],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"ZIP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ZIP"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Windows ZIP archive (.zip)"
}], "GuideText",
 CellID->279602590],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"ZPR\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ZPR"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Z Corp 3D printer format (.zpr)"
}], "GuideText",
 CellID->733208973]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "GuideTutorial",
 CellID->207014367],

Cell[TextData[ButtonBox["Importing and Exporting Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingFiles"]], "GuideTutorial",
 CellID->60324697],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "GuideTutorial",
 CellID->76300026]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAboutSub",
 CellID->19396]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Listing of All Formats - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 4.9063906}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica supports many formats, with many subformats, variants and \
options. ", "synonyms" -> {}, "title" -> "Listing of All Formats", "type" -> 
    "Guide", "uri" -> "guide/ListingOfAllFormats"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 64, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[686, 28, 178, 5, 70, "GuideAbstract",
 CellID->2001916300],
Cell[867, 35, 254, 9, 70, "GuideText",
 CellID->386431044],
Cell[1124, 46, 46, 1, 70, "GuideDelimiter",
 CellID->2375041],
Cell[1173, 49, 258, 8, 70, "GuideText",
 CellID->105849547],
Cell[1434, 59, 268, 8, 70, "GuideText",
 CellID->217956197],
Cell[1705, 69, 266, 8, 70, "GuideText",
 CellID->558966034],
Cell[1974, 79, 326, 11, 70, "GuideText",
 CellID->399112026],
Cell[2303, 92, 252, 8, 70, "GuideText",
 CellID->355187164],
Cell[2558, 102, 46, 1, 70, "GuideDelimiter",
 CellID->5997085],
Cell[2607, 105, 252, 8, 70, "GuideText",
 CellID->422074656],
Cell[2862, 115, 248, 8, 70, "GuideText",
 CellID->246835681],
Cell[3113, 125, 259, 9, 70, "GuideText",
 CellID->67137284],
Cell[3375, 136, 267, 9, 70, "GuideText",
 CellID->478450592],
Cell[3645, 147, 259, 9, 70, "GuideText",
 CellID->170882455],
Cell[3907, 158, 264, 9, 70, "GuideText",
 CellID->19919406],
Cell[4174, 169, 47, 1, 70, "GuideDelimiter",
 CellID->43787487],
Cell[4224, 172, 265, 8, 70, "GuideText",
 CellID->111475460],
Cell[4492, 182, 254, 8, 70, "GuideText",
 CellID->19850643],
Cell[4749, 192, 265, 8, 70, "GuideText",
 CellID->3326233],
Cell[5017, 202, 278, 8, 70, "GuideText",
 CellID->360483964],
Cell[5298, 212, 274, 8, 70, "GuideText",
 CellID->189350195],
Cell[5575, 222, 275, 8, 70, "GuideText",
 CellID->69939423],
Cell[5853, 232, 278, 9, 70, "GuideText",
 CellID->73888486],
Cell[6134, 243, 254, 8, 70, "GuideText",
 CellID->691242827],
Cell[6391, 253, 261, 8, 70, "GuideText",
 CellID->20537147],
Cell[6655, 263, 47, 1, 70, "GuideDelimiter",
 CellID->86489340],
Cell[6705, 266, 249, 8, 70, "GuideText",
 CellID->4107554],
Cell[6957, 276, 272, 9, 70, "GuideText",
 CellID->86637709],
Cell[7232, 287, 263, 8, 70, "GuideText",
 CellID->97926459],
Cell[7498, 297, 267, 8, 70, "GuideText",
 CellID->185655628],
Cell[7768, 307, 256, 8, 70, "GuideText",
 CellID->212484304],
Cell[8027, 317, 48, 1, 70, "GuideDelimiter",
 CellID->166632912],
Cell[8078, 320, 252, 8, 70, "GuideText",
 CellID->355005548],
Cell[8333, 330, 271, 8, 70, "GuideText",
 CellID->153428630],
Cell[8607, 340, 260, 9, 70, "GuideText",
 CellID->671701478],
Cell[8870, 351, 326, 11, 70, "GuideText",
 CellID->334608905],
Cell[9199, 364, 48, 1, 70, "GuideDelimiter",
 CellID->322903274],
Cell[9250, 367, 284, 8, 70, "GuideText",
 CellID->1964589],
Cell[9537, 377, 280, 8, 70, "GuideText",
 CellID->173880935],
Cell[9820, 387, 264, 9, 70, "GuideText",
 CellID->57139236],
Cell[10087, 398, 47, 1, 70, "GuideDelimiter",
 CellID->14384923],
Cell[10137, 401, 253, 8, 70, "GuideText",
 CellID->75993501],
Cell[10393, 411, 255, 8, 70, "GuideText",
 CellID->203374175],
Cell[10651, 421, 273, 9, 70, "GuideText",
 CellID->195913588],
Cell[10927, 432, 254, 8, 70, "GuideText",
 CellID->136378392],
Cell[11184, 442, 48, 1, 70, "GuideDelimiter",
 CellID->192184801],
Cell[11235, 445, 280, 8, 70, "GuideText",
 CellID->420602384],
Cell[11518, 455, 261, 8, 70, "GuideText",
 CellID->277607006],
Cell[11782, 465, 267, 8, 70, "GuideText",
 CellID->94080949],
Cell[12052, 475, 292, 9, 70, "GuideText",
 CellID->31817183],
Cell[12347, 486, 47, 1, 70, "GuideDelimiter",
 CellID->86018997],
Cell[12397, 489, 260, 8, 70, "GuideText",
 CellID->108736832],
Cell[12660, 499, 268, 8, 70, "GuideText",
 CellID->127377210],
Cell[12931, 509, 271, 8, 70, "GuideText",
 CellID->866695901],
Cell[13205, 519, 270, 8, 70, "GuideText",
 CellID->28955209],
Cell[13478, 529, 271, 8, 70, "GuideText",
 CellID->301782379],
Cell[13752, 539, 270, 8, 70, "GuideText",
 CellID->41859578],
Cell[14025, 549, 274, 8, 70, "GuideText",
 CellID->199683182],
Cell[14302, 559, 47, 1, 70, "GuideDelimiter",
 CellID->20365760],
Cell[14352, 562, 270, 9, 70, "GuideText",
 CellID->31288039],
Cell[14625, 573, 281, 8, 70, "GuideText",
 CellID->107589746],
Cell[14909, 583, 251, 9, 70, "GuideText",
 CellID->65009503],
Cell[15163, 594, 48, 1, 70, "GuideDelimiter",
 CellID->131718664],
Cell[15214, 597, 630, 22, 70, "GuideText",
 CellID->444572527],
Cell[15847, 621, 264, 9, 70, "GuideText",
 CellID->305034716],
Cell[16114, 632, 261, 9, 70, "GuideText",
 CellID->354380943],
Cell[16378, 643, 46, 1, 70, "GuideDelimiter",
 CellID->7957648],
Cell[16427, 646, 257, 8, 70, "GuideText",
 CellID->288216781],
Cell[16687, 656, 257, 8, 70, "GuideText",
 CellID->344928077],
Cell[16947, 666, 255, 9, 70, "GuideText",
 CellID->401725784],
Cell[17205, 677, 259, 8, 70, "GuideText",
 CellID->355388471],
Cell[17467, 687, 262, 8, 70, "GuideText",
 CellID->405256250],
Cell[17732, 697, 312, 11, 70, "GuideText",
 CellID->324865854],
Cell[18047, 710, 255, 9, 70, "GuideText",
 CellID->31222266],
Cell[18305, 721, 276, 8, 70, "GuideText",
 CellID->191613666],
Cell[18584, 731, 268, 8, 70, "GuideText",
 CellID->431033167],
Cell[18855, 741, 263, 8, 70, "GuideText",
 CellID->4451634],
Cell[19121, 751, 265, 8, 70, "GuideText",
 CellID->46849256],
Cell[19389, 761, 309, 11, 70, "GuideText",
 CellID->157400125],
Cell[19701, 774, 48, 1, 70, "GuideDelimiter",
 CellID->446341557],
Cell[19752, 777, 257, 9, 70, "GuideText",
 CellID->240928860],
Cell[20012, 788, 261, 8, 70, "GuideText",
 CellID->410845883],
Cell[20276, 798, 277, 8, 70, "GuideText",
 CellID->632795719],
Cell[20556, 808, 48, 1, 70, "GuideDelimiter",
 CellID->132499393],
Cell[20607, 811, 256, 9, 70, "GuideText",
 CellID->91136457],
Cell[20866, 822, 267, 9, 70, "GuideText",
 CellID->93362277],
Cell[21136, 833, 260, 8, 70, "GuideText",
 CellID->738048793],
Cell[21399, 843, 48, 1, 70, "GuideDelimiter",
 CellID->130638301],
Cell[21450, 846, 307, 11, 70, "GuideText",
 CellID->211281197],
Cell[21760, 859, 259, 8, 70, "GuideText",
 CellID->51352603],
Cell[22022, 869, 256, 8, 70, "GuideText",
 CellID->90844297],
Cell[22281, 879, 256, 8, 70, "GuideText",
 CellID->388694977],
Cell[22540, 889, 261, 9, 70, "GuideText",
 CellID->285826059],
Cell[22804, 900, 261, 8, 70, "GuideText",
 CellID->434892357],
Cell[23068, 910, 261, 9, 70, "GuideText",
 CellID->220719283],
Cell[23332, 921, 258, 9, 70, "GuideText",
 CellID->82887012],
Cell[23593, 932, 255, 8, 70, "GuideText",
 CellID->111607756],
Cell[23851, 942, 260, 8, 70, "GuideText",
 CellID->734914930],
Cell[24114, 952, 276, 8, 70, "GuideText",
 CellID->638836807],
Cell[24393, 962, 265, 8, 70, "GuideText",
 CellID->26460465],
Cell[24661, 972, 256, 9, 70, "GuideText",
 CellID->389143930],
Cell[24920, 983, 48, 1, 70, "GuideDelimiter",
 CellID->498939871],
Cell[24971, 986, 260, 8, 70, "GuideText",
 CellID->356414953],
Cell[25234, 996, 265, 8, 70, "GuideText",
 CellID->151306256],
Cell[25502, 1006, 265, 8, 70, "GuideText",
 CellID->982103815],
Cell[25770, 1016, 265, 8, 70, "GuideText",
 CellID->361373031],
Cell[26038, 1026, 263, 9, 70, "GuideText",
 CellID->1460558],
Cell[26304, 1037, 247, 8, 70, "GuideText",
 CellID->120422147],
Cell[26554, 1047, 262, 9, 70, "GuideText",
 CellID->41353539],
Cell[26819, 1058, 262, 9, 70, "GuideText",
 CellID->866847377],
Cell[27084, 1069, 262, 8, 70, "GuideText",
 CellID->130287981],
Cell[27349, 1079, 247, 8, 70, "GuideText",
 CellID->155624515],
Cell[27599, 1089, 259, 8, 70, "GuideText",
 CellID->1463276848],
Cell[27861, 1099, 261, 9, 70, "GuideText",
 CellID->284979988],
Cell[28125, 1110, 309, 11, 70, "GuideText",
 CellID->424723],
Cell[28437, 1123, 268, 9, 70, "GuideText",
 CellID->500346071],
Cell[28708, 1134, 255, 8, 70, "GuideText",
 CellID->297500450],
Cell[28966, 1144, 263, 8, 70, "GuideText",
 CellID->342621516],
Cell[29232, 1154, 48, 1, 70, "GuideDelimiter",
 CellID->195664037],
Cell[29283, 1157, 258, 8, 70, "GuideText",
 CellID->819438194],
Cell[29544, 1167, 248, 8, 70, "GuideText",
 CellID->711238367],
Cell[29795, 1177, 278, 9, 70, "GuideText",
 CellID->534950781],
Cell[30076, 1188, 485, 17, 70, "GuideText",
 CellID->57365892],
Cell[30564, 1207, 244, 8, 70, "GuideText",
 CellID->276957721],
Cell[30811, 1217, 260, 9, 70, "GuideText",
 CellID->333188110],
Cell[31074, 1228, 269, 9, 70, "GuideText",
 CellID->68864796],
Cell[31346, 1239, 252, 8, 70, "GuideText",
 CellID->547206078],
Cell[31601, 1249, 48, 1, 70, "GuideDelimiter",
 CellID->190055396],
Cell[31652, 1252, 285, 8, 70, "GuideText",
 CellID->35356484],
Cell[31940, 1262, 289, 8, 70, "GuideText",
 CellID->191186752],
Cell[32232, 1272, 289, 8, 70, "GuideText",
 CellID->564944495],
Cell[32524, 1282, 289, 8, 70, "GuideText",
 CellID->518014684],
Cell[32816, 1292, 288, 8, 70, "GuideText",
 CellID->20792008],
Cell[33107, 1302, 295, 9, 70, "GuideText",
 CellID->184538999],
Cell[33405, 1313, 277, 8, 70, "GuideText",
 CellID->613512998],
Cell[33685, 1323, 258, 8, 70, "GuideText",
 CellID->287472358],
Cell[33946, 1333, 48, 1, 70, "GuideDelimiter",
 CellID->371949360],
Cell[33997, 1336, 244, 8, 70, "GuideText",
 CellID->111206568],
Cell[34244, 1346, 275, 8, 70, "GuideText",
 CellID->295474151],
Cell[34522, 1356, 48, 1, 70, "GuideDelimiter",
 CellID->626171198],
Cell[34573, 1359, 258, 8, 70, "GuideText",
 CellID->192844976],
Cell[34834, 1369, 266, 9, 70, "GuideText",
 CellID->35412431],
Cell[35103, 1380, 260, 8, 70, "GuideText",
 CellID->295741637],
Cell[35366, 1390, 255, 8, 70, "GuideText",
 CellID->480832943],
Cell[35624, 1400, 47, 1, 70, "GuideDelimiter",
 CellID->35294763],
Cell[35674, 1403, 260, 9, 70, "GuideText",
 CellID->180780393],
Cell[35937, 1414, 247, 8, 70, "GuideText",
 CellID->275956561],
Cell[36187, 1424, 251, 8, 70, "GuideText",
 CellID->1610476],
Cell[36441, 1434, 266, 8, 70, "GuideText",
 CellID->56810358],
Cell[36710, 1444, 255, 8, 70, "GuideText",
 CellID->54515675],
Cell[36968, 1454, 244, 8, 70, "GuideText",
 CellID->34510035],
Cell[37215, 1464, 263, 8, 70, "GuideText",
 CellID->33214036],
Cell[37481, 1474, 256, 8, 70, "GuideText",
 CellID->6074940],
Cell[37740, 1484, 47, 1, 70, "GuideDelimiter",
 CellID->78922005],
Cell[37790, 1487, 251, 8, 70, "GuideText",
 CellID->279602590],
Cell[38044, 1497, 261, 9, 70, "GuideText",
 CellID->733208973]
}, Open  ]],
Cell[CellGroupData[{
Cell[38342, 1511, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[38407, 1514, 172, 3, 70, "GuideTutorial",
 CellID->207014367],
Cell[38582, 1519, 173, 3, 70, "GuideTutorial",
 CellID->60324697],
Cell[38758, 1524, 173, 3, 70, "GuideTutorial",
 CellID->76300026]
}, Open  ]],
Cell[CellGroupData[{
Cell[38968, 1532, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[39033, 1535, 158, 3, 70, "GuideMoreAboutSub",
 CellID->19396]
}, Open  ]],
Cell[39206, 1541, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

