(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7439,        246]
NotebookOptionsPosition[      4439,        168]
NotebookOutlinePosition[      6328,        209]
CellTagsIndexPosition[      6285,        206]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Low-Level System Spelunking", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is a large and complex software system. Although strongly not supported \
for production purposes, it is sometimes instructive to \"spelunk\" in the \
system, looking at low-level organization and obscure features."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Names",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Names"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "complete lists of symbol names matching a pattern (e.g. ",
 Cell[BoxData["\"\<*`*\>\""], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Contexts",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Contexts"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "give complete lists of contexts for symbol names"
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["SystemOptions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SystemOptions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "low-level system options"
}], "GuideText",
 CellID->428146562],

Cell["\t", "GuideDelimiter",
 CellID->702119280],

Cell[TextData[{
 StyleBox[ButtonBox["Show Expression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ShowExpression"], "MenuName"],
 " (",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["E", "KeyEvent"],
 ") \[LongDash] show the symbolic structure of notebook contents"
}], "GuideText",
 CellID->344174975],

Cell[TextData[{
 StyleBox[ButtonBox["Option Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/OptionInspector"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " inspect lists of front-end options"
}], "GuideText",
 CellID->279183418],

Cell[TextData[{
 Cell[TextData[ButtonBox["Options",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Options"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get a complete list of options for ",
 Cell[TextData[ButtonBox["$FrontEnd",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$FrontEnd"]], "InlineFunctionSans"]
}], "GuideText",
 CellID->357776721],

Cell["\t", "GuideDelimiter",
 CellID->600252607],

Cell[TextData[{
 Cell[TextData[ButtonBox["Trace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Trace"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "trace every step in the evaluation of an expression"
}], "GuideText",
 CellID->249372925],

Cell[TextData[{
 Cell[TextData[ButtonBox["Stack",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Stack"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "show the state of the complete evaluation stack"
}], "GuideText",
 CellID->112071907]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Alphabetical Listing of Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlphabeticalListing"]], "GuideMoreAbout",
 CellID->6610515],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Namespaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Low-Level System Spelunking - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 14.4691354}", "context" -> "", 
    "keywords" -> {
     "call stack", "debug", "default options", "evaluation of functions", 
      "finding options for output", "finding options for streams", 
      "front end options", "function options", "functions being evaluated", 
      "history of computation", "known symbols", "make list of symbols", 
      "names listing", "options for symbol", "search for symbols", 
      "system options", "tracing assignments", "tracing based on tags", 
      "tracing calls to functions", "tracing messages", 
      "tracing of built-in functions", "tracing of conditions", 
      "tracing of recursion", "tracing of rules", 
      "tracing of system functions", "tracing of transformation rules", 
      "hacking"}, "index" -> True, "label" -> "Mathematica Guide", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica is a large and complex software system. Although strongly \
not supported for production purposes, it is sometimes instructive to \
\"spelunk\" in the system, looking at low-level organization and obscure \
features.", "synonyms" -> {}, "title" -> "Low-Level System Spelunking", 
    "type" -> "Guide", "uri" -> "guide/LowLevelSystemSpelunking"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 69, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[691, 28, 325, 7, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1019, 37, 334, 11, 70, "GuideText",
 CellID->1463276848],
Cell[1356, 50, 277, 9, 70, "GuideText",
 CellID->203374175],
Cell[1636, 61, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[1687, 64, 408, 12, 70, "GuideText",
 CellID->428146562],
Cell[2098, 78, 48, 1, 70, "GuideDelimiter",
 CellID->702119280],
Cell[2149, 81, 416, 12, 70, "GuideText",
 CellID->344174975],
Cell[2568, 95, 266, 8, 70, "GuideText",
 CellID->279183418],
Cell[2837, 105, 384, 12, 70, "GuideText",
 CellID->357776721],
Cell[3224, 119, 48, 1, 70, "GuideDelimiter",
 CellID->600252607],
Cell[3275, 122, 274, 9, 70, "GuideText",
 CellID->249372925],
Cell[3552, 133, 270, 9, 70, "GuideText",
 CellID->112071907]
}, Open  ]],
Cell[CellGroupData[{
Cell[3859, 147, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3924, 150, 167, 3, 70, "GuideMoreAbout",
 CellID->6610515],
Cell[4094, 155, 154, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[4251, 160, 146, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[4412, 166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

