(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20991,        686]
NotebookOptionsPosition[     16031,        552]
NotebookOutlinePosition[     18186,        597]
CellTagsIndexPosition[     18143,        594]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " API"
}], "GuideTitle",
 CellID->684],

Cell[TextData[{
 "Extensively used within the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system itself, ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s unique high-level symbolic interface standard for interprogram \
communication",
 ". ",
 "With convenient bindings for a variety of languages, ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " immediately allows arbitrary symbolic objects\[LongDash]representing data, \
programs, or any other construct\[LongDash]to be efficiently exchanged \
between programs, on one computer or across a heterogeneous network."
}], "GuideAbstract",
 CellID->314662902],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["Installable ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"], 
  "GuideFunctionsSubsection"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"], 
  "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 StyleBox[ButtonBox[" Programs \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->33249927],

Cell[TextData[{
 Cell[TextData[ButtonBox["Install",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Install"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "run a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " installable external program"
}], "GuideText",
 CellID->9567],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkPatterns",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkPatterns"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find functions available in a running ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program"
}], "GuideText",
 CellID->22336],

Cell[TextData[{
 Cell[TextData[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["mcc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mcc"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " externally prepare a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " installable program"
}], "GuideText",
 CellID->224666515],

Cell["\t", "GuideDelimiterSubsection",
 CellID->478985425]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"], 
  "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 StyleBox[ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"], 
  "GuideFunctionsSubsection"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"], 
  "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 StyleBox[ButtonBox[" Functions \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->641527257],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkLaunch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkLaunch"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["LinkConnect",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkConnect"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["LinkCreate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkCreate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " initiate ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs and connections"
}], "GuideText",
 CellID->114528703],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkRead"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["LinkWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkWrite"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "read and write expressions on a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection"
}], "GuideText",
 CellID->412391433],

Cell[TextData[{
 Cell[TextData[ButtonBox["Links",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Links"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list all currently open links"
}], "GuideText",
 CellID->287682890],

Cell["\t", "GuideDelimiterSubsection",
 CellID->2944]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["C Language Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathLinkCLanguageFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->356271642],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutInteger32()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger32"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLGetInteger32()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger32"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutFunction"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8597751],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLOpenString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLNextPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLNextPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLTransferExpression()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLTransferExpression"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->670705409]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Java Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/guide/JavaInterface"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->24643],

Cell[TextData[{
 Cell[TextData[ButtonBox["evaluate()",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/java/KernelLink#evaluate"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["evaluateToOutputForm()",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/java/KernelLink#evaluateToOutputForm"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["evaluateToImage()",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/java/KernelLink#evaluateToImage"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/guide/JavaInterface"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->210698340],

Cell[TextData[{
 Cell[TextData[ButtonBox["put()",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/java/KernelLink#put"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["getInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/java/MathLink#getInteger"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["getObject()",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/java/KernelLink#getObject"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->211580680],

Cell[TextData[{
 Cell[TextData[ButtonBox["createKernelLink()",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/java/MathLinkFactory#createKernelLink"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["waitForAnswer()",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/java/KernelLink#waitForAnswer"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->13978740]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["C#/.Net Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/guide/DotNETInterface"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->311548867],

Cell[TextData[{
 Cell[TextData[ButtonBox["Evaluate()",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/IKernelLink/Evaluate"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EvaluateToOutputForm()",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/IKernelLink/EvaluateToOutputForm"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EvaluateToImage()",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/IKernelLink/EvaluateToImage"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/DotNETInterface"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->741190109],

Cell[TextData[{
 Cell[TextData[ButtonBox["Put()",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/IKernelLink/Put"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GetInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/IKernelLink/GetInteger"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GetObject()",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/IKernelLink/GetObject"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->287884158],

Cell[TextData[{
 Cell[TextData[ButtonBox["CreateKernelLink()",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/MathLinkFactory/CreateKernelLink"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WaitForAnswer()",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/IKernelLink/WaitForAnswer"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->48202250]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->119],

Cell[TextData[{
 ButtonBox["The Structure of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheStructureOfMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheStructureOfMathematica"],
  FontSlant->"Italic"]
}], "GuideTutorial",
 CellID->29857],

Cell[TextData[{
 ButtonBox["How ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/HowMathLinkIsUsed"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/HowMathLinkIsUsed"],
  FontSlant->"Italic"],
 ButtonBox[" is Used",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/HowMathLinkIsUsed"]
}], "GuideTutorial",
 CellID->23041],

Cell[TextData[{
 ButtonBox["Installing Existing ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
  
  FontSlant->"Italic"],
 ButtonBox["-Compatible Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"]
}], "GuideTutorial",
 CellID->2035724590],

Cell[TextData[{
 ButtonBox["Setting Up External Functions To Be Called From ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"]
}], "GuideTutorial",
 CellID->713720126],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->8891],

Cell[TextData[ButtonBox["Systems Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SystemsInterfacesAndDeploymentOverview"]], "GuideMoreAbout",
 CellID->431270840],

Cell[TextData[StyleBox[ButtonBox["J/Link",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaInterface"],
 FontSlant->"Italic"]], "GuideMoreAbout",
 CellID->25264],

Cell[TextData[StyleBox[ButtonBox[".NETLink",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/guide/DotNETInterface"],
 FontSlant->"Italic"]], "GuideMoreAbout",
 CellID->1623],

Cell[TextData[ButtonBox["Parallel Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "GuideMoreAbout",
 CellID->17866837],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAboutSub",
 CellID->8072]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink API - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 30.0632846}", "context" -> "", 
    "keywords" -> {
     "active links", "add external function", "bind name", "child processes", 
      "connect link", "ConnectLink", "connect MathLink", "create link", 
      "extend functions", "external MathLink programs", "find link", 
      "get data from MathLink", "information about MathLink program", 
      "install external program", "launching programs", "link connect", 
      "link create", "link launch", "link patterns", "link read", 
      "link write", "listen on link", "MathLink connections", 
      "MathLink program usage", "publish link", "put data", 
      "reading expression from MathLink", "register link", 
      "running external programs", "send data via MathLink", 
      "slave processes", "starting programs", "subscribe to link", 
      "subsidiary processes", "write data to MathLink"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Extensively used within the Mathematica system itself, MathLink is \
Mathematica's unique high-level symbolic interface standard for interprogram \
communication. With convenient bindings for a variety of languages, MathLink \
immediately allows arbitrary symbolic objects--representing data, programs, \
or any other construct--to be efficiently exchanged between programs, on one \
computer or across a heterogeneous network.", "synonyms" -> {}, "title" -> 
    "MathLink API", "type" -> "Guide", "uri" -> "guide/MathLinkAPI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 101, 5, 70, "GuideTitle",
 CellID->684],
Cell[723, 32, 683, 20, 70, "GuideAbstract",
 CellID->314662902],
Cell[CellGroupData[{
Cell[1431, 56, 543, 15, 70, "GuideFunctionsSubsection",
 CellID->33249927],
Cell[1977, 73, 308, 12, 70, "GuideText",
 CellID->9567],
Cell[2288, 87, 330, 12, 70, "GuideText",
 CellID->22336],
Cell[2621, 101, 443, 15, 70, "GuideText",
 CellID->224666515],
Cell[3067, 118, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->478985425]
}, Open  ]],
Cell[CellGroupData[{
Cell[3162, 124, 708, 20, 70, "GuideFunctionsSubsection",
 CellID->641527257],
Cell[3873, 146, 577, 19, 70, "GuideText",
 CellID->114528703],
Cell[4453, 167, 452, 16, 70, "GuideText",
 CellID->412391433],
Cell[4908, 185, 252, 9, 70, "GuideText",
 CellID->287682890],
Cell[5163, 196, 53, 1, 70, "GuideDelimiterSubsection",
 CellID->2944]
}, Open  ]],
Cell[CellGroupData[{
Cell[5253, 202, 234, 5, 70, "GuideFunctionsSubsection",
 CellID->356271642],
Cell[5490, 209, 1092, 30, 70, "InlineGuideFunctionListing",
 CellID->8597751],
Cell[6585, 241, 882, 24, 70, "InlineGuideFunctionListing",
 CellID->670705409]
}, Open  ]],
Cell[CellGroupData[{
Cell[7504, 270, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->24643],
Cell[7724, 277, 939, 26, 70, "InlineGuideFunctionListing",
 CellID->210698340],
Cell[8666, 305, 679, 20, 70, "InlineGuideFunctionListing",
 CellID->211580680],
Cell[9348, 327, 480, 13, 70, "InlineGuideFunctionListing",
 CellID->13978740]
}, Open  ]],
Cell[CellGroupData[{
Cell[9865, 345, 228, 5, 70, "GuideFunctionsSubsection",
 CellID->311548867],
Cell[10096, 352, 949, 26, 70, "InlineGuideFunctionListing",
 CellID->741190109],
Cell[11048, 380, 687, 20, 70, "InlineGuideFunctionListing",
 CellID->287884158],
Cell[11738, 402, 483, 13, 70, "InlineGuideFunctionListing",
 CellID->48202250]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12270, 421, 56, 1, 70, "GuideTutorialsSection",
 CellID->119],
Cell[12329, 424, 304, 9, 70, "GuideTutorial",
 CellID->29857],
Cell[12636, 435, 368, 12, 70, "GuideTutorial",
 CellID->23041],
Cell[13007, 449, 489, 14, 70, "GuideTutorial",
 CellID->2035724590],
Cell[13499, 465, 526, 15, 70, "GuideTutorial",
 CellID->713720126],
Cell[14028, 482, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[14366, 493, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[14700, 504, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[15067, 518, 58, 1, 70, "GuideMoreAboutSection",
 CellID->8891],
Cell[15128, 521, 189, 4, 70, "GuideMoreAbout",
 CellID->431270840],
Cell[15320, 527, 170, 4, 70, "GuideMoreAbout",
 CellID->25264],
Cell[15493, 533, 175, 4, 70, "GuideMoreAbout",
 CellID->1623],
Cell[15671, 539, 158, 3, 70, "GuideMoreAbout",
 CellID->17866837],
Cell[15832, 544, 157, 3, 70, "GuideMoreAboutSub",
 CellID->8072]
}, Open  ]],
Cell[16004, 550, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

