(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15634,        528]
NotebookOptionsPosition[     10757,        397]
NotebookOutlinePosition[     13201,        447]
CellTagsIndexPosition[     13158,        444]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C Functions for Exchanging Multidimensional Arrays"
}], "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Sending Arrays", "GuideFunctionsSubsection",
 CellID->1461705142],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutIntegerArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutIntegerArray"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLPutInteger32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger32Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 32-bit integer array (",
 StyleBox["int *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->1807784080],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutInteger16Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger16Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 16-bit short integer array (",
 StyleBox["short *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutInteger64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger64Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 64-bit integer array"
}], "GuideText",
 CellID->1308785667],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutRealArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutRealArray"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLPutReal32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal32Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of reals (",
 StyleBox["float *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->578250709],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutReal64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal64Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of (",
 StyleBox["double *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->882691455],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutReal128Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutReal128Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of quad-precision floating-point numbers"
}], "GuideText",
 CellID->1296163488],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutByteArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutByteArray"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of 8-bit integers of type char (",
 StyleBox["char *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->1253268890]
}, Open  ]],

Cell[CellGroupData[{

Cell["Receiving Arrays", "GuideFunctionsSubsection",
 CellID->1581152160],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetIntegerArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetIntegerArray"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetInteger32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger32Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 32-bit integer array (",
 StyleBox["int *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->694987327],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetInteger16Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger16Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 16-bit integer array (",
 StyleBox["short *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->488448856],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetInteger64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger64Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 64-bit integer array"
}], "GuideText",
 CellID->1677423958],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutRealArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutRealArray"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetReal32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal32Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " single-precision floating-point numbers"
}], "GuideText",
 CellID->715314550],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetReal64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal64Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " single-precision floating-point numbers"
}], "GuideText",
 CellID->678185944],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetReal128Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal128Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " quad-precision floating-point numbers"
}], "GuideText",
 CellID->1575446179],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetByteArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetByteArray"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of 8-bit integers of type char (",
 StyleBox["char *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->904307963]
}, Open  ]],

Cell[CellGroupData[{

Cell["Releasing Memory for Arrays", "GuideFunctionsSubsection",
 CellID->1027481767],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseInteger32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseInteger32Array"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 32-bit integer array"
}], "GuideText",
 CellID->458864403],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseInteger16Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseInteger16Array"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 16-bit integer array"
}], "GuideText",
 CellID->520244844],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseInteger64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseInteger64Array"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 64-bit integer array"
}], "GuideText",
 CellID->1349166171],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseReal32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseReal32Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " single-precision floating-point numbers",
 StyleBox[" (float *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->50562943],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseReal64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseReal64Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " single-precision floating-point numbers (",
 StyleBox["double *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->1555342436],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseReal128Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseReal128Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " quad-precision floating-point numbers"
}], "GuideText",
 CellID->1469370568],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseByteArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseByteArray"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " array of 8-bit integers of type char (",
 StyleBox["char *", "InlineCode"],
 ")"
}], "GuideText",
 CellID->962164322]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "GuideTutorial",
 CellID->455193277],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], \
"GuideTutorial",
 CellID->358651136],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[{
 ButtonBox["Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink C Functions for Exchanging Multidimensional Arrays - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 35.1102888}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLPutIntegerArray(), MLPutInteger32Array() -- 32-bit integer array (int \
*), MLPutInteger16Array() -- 16-bit short integer array (short *), \
MLPutInteger64Array() -- 64-bit integer array, MLPutRealArray(), \
MLPutReal32Array() -- array of reals (float *), MLPutReal64Array() -- array \
of (double *), MLPutReal128Array() -- array of quad-precision floating-point \
numbers, MLPutByteArray() -- array of 8-bit integers of type char (char *), \
MLGetIntegerArray(), MLGetInteger32Array() -- 32-bit integer array (int *), \
MLGetInteger16Array() -- 16-bit integer array (short *), \
MLGetInteger64Array() -- 64-bit integer array, MLPutRealArray(), \
MLGetReal32Array() -- single-precision floating-point numbers, \
MLGetReal64Array() -- single-precision floating-point numbers, \
MLGetReal128Array() -- quad-precision floating-point numbers, \
MLGetByteArray() -- array of 8-bit integers of type char (char *), \
MLReleaseInteger32Array() -- 32-bit integer array, MLReleaseInteger16Array() \
-- 16-bit integer array, MLReleaseInteger64Array() -- 64-bit integer array, \
MLReleaseReal32Array() -- single-precision floating-point numbers (float *), \
MLReleaseReal64Array() -- single-precision floating-point numbers (double *), \
MLReleaseReal128Array() -- quad-precision floating-point numbers, \
MLReleaseByteArray() -- array of 8-bit integers of type char (char *)", 
    "synonyms" -> {}, "title" -> 
    "MathLink C Functions for Exchanging Multidimensional Arrays", "type" -> 
    "Guide", "uri" -> 
    "guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 154, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[776, 32, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[857, 37, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->1461705142],
Cell[931, 40, 462, 14, 70, "GuideText",
 CellID->1807784080],
Cell[1396, 56, 321, 10, 70, "GuideText",
 CellID->1463276848],
Cell[1720, 68, 271, 8, 70, "GuideText",
 CellID->1308785667],
Cell[1994, 78, 445, 14, 70, "GuideText",
 CellID->578250709],
Cell[2442, 94, 297, 10, 70, "GuideText",
 CellID->882691455],
Cell[2742, 106, 293, 8, 70, "GuideText",
 CellID->1296163488],
Cell[3038, 116, 320, 10, 70, "GuideText",
 CellID->1253268890]
}, Open  ]],
Cell[CellGroupData[{
Cell[3395, 131, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->1581152160],
Cell[3471, 134, 461, 14, 70, "GuideText",
 CellID->694987327],
Cell[3935, 150, 314, 10, 70, "GuideText",
 CellID->488448856],
Cell[4252, 162, 271, 8, 70, "GuideText",
 CellID->1677423958],
Cell[4526, 172, 426, 12, 70, "GuideText",
 CellID->715314550],
Cell[4955, 186, 283, 8, 70, "GuideText",
 CellID->678185944],
Cell[5241, 196, 284, 8, 70, "GuideText",
 CellID->1575446179],
Cell[5528, 206, 319, 10, 70, "GuideText",
 CellID->904307963]
}, Open  ]],
Cell[CellGroupData[{
Cell[5884, 221, 84, 1, 70, "GuideFunctionsSubsection",
 CellID->1027481767],
Cell[5971, 224, 281, 9, 70, "GuideText",
 CellID->458864403],
Cell[6255, 235, 281, 9, 70, "GuideText",
 CellID->520244844],
Cell[6539, 246, 282, 9, 70, "GuideText",
 CellID->1349166171],
Cell[6824, 257, 334, 10, 70, "GuideText",
 CellID->50562943],
Cell[7161, 269, 337, 10, 70, "GuideText",
 CellID->1555342436],
Cell[7501, 281, 292, 8, 70, "GuideText",
 CellID->1469370568],
Cell[7796, 291, 327, 10, 70, "GuideText",
 CellID->962164322]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8172, 307, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8237, 310, 375, 11, 70, "GuideTutorial",
 CellID->455193277],
Cell[8615, 323, 210, 5, 70, "GuideTutorial",
 CellID->358651136],
Cell[8828, 330, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[9166, 341, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[9500, 352, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[9867, 366, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9932, 369, 336, 9, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[10271, 380, 444, 12, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[10730, 395, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

