(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13427,        467]
NotebookOptionsPosition[      9240,        349]
NotebookOutlinePosition[     11124,        390]
CellTagsIndexPosition[     11081,        387]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C Functions for Exchanging Strings"
}], "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Sending Strings", "GuideFunctionsSubsection",
 CellID->1106433345],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " null-terminated ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings"
}], "GuideText",
 CellID->178823978],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutByteString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutByteString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 8-bit character strings"
}], "GuideText",
 CellID->297632447],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutUnicodeString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUnicodeString"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLPutUCS2String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUCS2String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 16-bit UCS-2 strings"
}], "GuideText",
 CellID->1331486310],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutUTF8String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUTF8String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " UTF-8 strings"
}], "GuideText",
 CellID->1975755242],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutUTF16String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUTF16String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " UTF-16 strings"
}], "GuideText",
 CellID->955514580],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutUTF32String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUTF32String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " UTF-32 strings"
}], "GuideText",
 CellID->841269142]
}, Open  ]],

Cell[CellGroupData[{

Cell["Receiving Strings", "GuideFunctionsSubsection",
 CellID->1995323187],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " null-terminated ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings"
}], "GuideText",
 CellID->292172357],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetByteString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetByteString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 8-bit character strings"
}], "GuideText",
 CellID->1393187057],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetUnicodeString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUnicodeString"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MLGetUCS2String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUCS2String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 16-bit UCS-2 strings"
}], "GuideText",
 CellID->1280663758],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetUTF8String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF8String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " UTF-8 strings"
}], "GuideText",
 CellID->1921157945],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetUTF16String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF16String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " UTF-16 strings"
}], "GuideText",
 CellID->866610216],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetUTF32String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF32String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " UTF-32 strings"
}], "GuideText",
 CellID->2136556254]
}, Open  ]],

Cell[CellGroupData[{

Cell["Releasing Memory for Strings", "GuideFunctionsSubsection",
 CellID->177028076],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " release ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " memory allocated to a string"
}], "GuideText",
 CellID->368893104],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseByteString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseByteString"]], "InlineFunctionSans"],
 " 8-bit character strings"
}], "GuideText",
 CellID->201110039],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseUCS2String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseUCS2String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 16-bit UCS-2 strings"
}], "GuideText",
 CellID->2064648742],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseUTF8String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseUTF8String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " UTF-8 strings"
}], "GuideText",
 CellID->1972420847],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseUTF16String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseUTF16String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " UTF-16 strings"
}], "GuideText",
 CellID->1077715778],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLReleaseUTF32String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseUTF32String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " UTF-32 strings"
}], "GuideText",
 CellID->1471265919]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], \
"GuideTutorial",
 CellID->652797756],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "GuideTutorial",\

 CellID->276528130],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "GuideTutorial",
 CellID->288834808],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[{
 ButtonBox["Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink C Functions for Exchanging Strings - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 35.4227968}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLPutString() -- null-terminated Mathematica strings, MLPutByteString() \
-- 8-bit character strings, MLPutUnicodeString(), MLPutUCS2String() -- 16-bit \
UCS-2 strings, MLPutUTF8String() -- UTF-8 strings, MLPutUTF16String() -- \
UTF-16 strings, MLPutUTF32String() -- UTF-32 strings, MLGetString() -- \
null-terminated Mathematica strings, MLGetByteString() -- 8-bit character \
strings, MLGetUnicodeString(), MLGetUCS2String() -- 16-bit UCS-2 strings, \
MLGetUTF8String() -- UTF-8 strings, MLGetUTF16String() -- UTF-16 strings, \
MLGetUTF32String() -- UTF-32 strings, MLReleaseString() -- release MathLink \
memory allocated to a string, MLReleaseByteString()-- 8-bit character \
strings, MLReleaseUCS2String() -- 16-bit UCS-2 strings, MLReleaseUTF8String() \
-- UTF-8 strings, MLReleaseUTF16String() -- UTF-16 strings, \
MLReleaseUTF32String() -- UTF-32 strings", "synonyms" -> {}, "title" -> 
    "MathLink C Functions for Exchanging Strings", "type" -> "Guide", "uri" -> 
    "guide/MathLinkCFunctionsForExchangingStrings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 138, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[760, 32, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[841, 37, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->1106433345],
Cell[916, 40, 312, 11, 70, "GuideText",
 CellID->178823978],
Cell[1231, 53, 265, 8, 70, "GuideText",
 CellID->297632447],
Cell[1499, 63, 414, 12, 70, "GuideText",
 CellID->1331486310],
Cell[1916, 77, 256, 8, 70, "GuideText",
 CellID->1975755242],
Cell[2175, 87, 258, 8, 70, "GuideText",
 CellID->955514580],
Cell[2436, 97, 258, 8, 70, "GuideText",
 CellID->841269142]
}, Open  ]],
Cell[CellGroupData[{
Cell[2731, 110, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->1995323187],
Cell[2808, 113, 312, 11, 70, "GuideText",
 CellID->292172357],
Cell[3123, 126, 266, 8, 70, "GuideText",
 CellID->1393187057],
Cell[3392, 136, 414, 12, 70, "GuideText",
 CellID->1280663758],
Cell[3809, 150, 256, 8, 70, "GuideText",
 CellID->1921157945],
Cell[4068, 160, 258, 8, 70, "GuideText",
 CellID->866610216],
Cell[4329, 170, 259, 8, 70, "GuideText",
 CellID->2136556254]
}, Open  ]],
Cell[CellGroupData[{
Cell[4625, 183, 84, 1, 70, "GuideFunctionsSubsection",
 CellID->177028076],
Cell[4712, 186, 330, 11, 70, "GuideText",
 CellID->368893104],
Cell[5045, 199, 226, 6, 70, "GuideText",
 CellID->201110039],
Cell[5274, 207, 271, 8, 70, "GuideText",
 CellID->2064648742],
Cell[5548, 217, 264, 8, 70, "GuideText",
 CellID->1972420847],
Cell[5815, 227, 267, 8, 70, "GuideText",
 CellID->1077715778],
Cell[6085, 237, 267, 8, 70, "GuideText",
 CellID->1471265919]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6401, 251, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6466, 254, 210, 5, 70, "GuideTutorial",
 CellID->652797756],
Cell[6679, 261, 206, 5, 70, "GuideTutorial",
 CellID->276528130],
Cell[6888, 268, 420, 12, 70, "GuideTutorial",
 CellID->288834808],
Cell[7311, 282, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[7649, 293, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[7983, 304, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[8350, 318, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8415, 321, 336, 9, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[8754, 332, 444, 12, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[9213, 347, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

