(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19551,        638]
NotebookOptionsPosition[     15616,        521]
NotebookOutlinePosition[     16858,        553]
CellTagsIndexPosition[     16815,        550]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C Language Functions"
}], "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library provides a collection of C language functions for interacting with \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". ",
 "These functions allow you not only to handle native C data types, but also \
to construct and deconstruct full ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbolic expressions."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"], 
  "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 StyleBox[ButtonBox[" Template Files \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->317238874],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox[".",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/file.tm"],
  ButtonBox["tm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/file.tm"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " template file for installable C programs"
}], "GuideText",
 CellID->175476437],

Cell["\t", "GuideDelimiterSubsection",
 CellID->6350760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Sending & Receiving Data \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathLinkCFunctionsForExchangingData"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->112923611],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutIntegerList()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutIntegerList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutDouble()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutDouble"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->172112252],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLGetInteger()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLGetIntegerList()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetIntegerList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLGetDouble()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetDouble"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLGetString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->390900511]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Functions & Expressions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->195323479],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutFunction"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLGetFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetFunction"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLCheckFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLCheckFunction"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutSymbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->364325951],

Cell["\t", "GuideDelimiterSubsection",
 CellID->251428935]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["MathLink ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"], 
  "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 StyleBox[ButtonBox["Connection Management \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->91176131],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLOpenString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLOpenArgcArgv()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenArgcArgv"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLInitialize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLInitialize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLClose()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLClose"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->44315181]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Expression Packet Handling \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathLinkExpressionPacketHandling"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->400563794],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLNextPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLNextPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLNewPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLNewPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLEndPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLEndPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->97757022]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Error Handling \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LowLevelMathLinkOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->159696410],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLErrorMessage()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLErrorMessage"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLClearError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLClearError"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->346529431],

Cell["\t", "GuideDelimiterSubsection",
 CellID->325935884]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Expression Storage \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->148900012],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLLoopbackOpen()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLLoopbackOpen"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLTransferExpression()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLTransferExpression"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->2091095127]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["Low-Level ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"], 
  "GuideFunctionsSubsection"],
 StyleBox[ButtonBox["MathLink ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"], 
  "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 StyleBox[ButtonBox["Operations \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->30607445],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutSize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutSize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutData()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutData"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutNext()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutNext"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLGetType()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetType"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLReady()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReady"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->385857818]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "GuideTutorial",\

 CellID->1885805579],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]
}], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["C Language Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CLanguageInterface"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[{
 ButtonBox["Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink C Language Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 35.7353048}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The MathLink library provides a collection of C language functions for \
interacting with Mathematica via MathLink. These functions allow you not only \
to handle native C data types, but also to construct and deconstruct full \
Mathematica symbolic expressions.", "synonyms" -> {}, "title" -> 
    "MathLink C Language Functions", "type" -> "Guide", "uri" -> 
    "guide/MathLinkCLanguageFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 124, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[746, 32, 498, 18, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1269, 54, 402, 11, 70, "GuideFunctionsSubsection",
 CellID->317238874],
Cell[1674, 67, 353, 13, 70, "GuideText",
 CellID->175476437],
Cell[2030, 82, 56, 1, 70, "GuideDelimiterSubsection",
 CellID->6350760]
}, Open  ]],
Cell[CellGroupData[{
Cell[2123, 88, 249, 6, 70, "GuideFunctionsSubsection",
 CellID->112923611],
Cell[2375, 96, 1099, 30, 70, "InlineGuideFunctionListing",
 CellID->172112252],
Cell[3477, 128, 1099, 30, 70, "InlineGuideFunctionListing",
 CellID->390900511]
}, Open  ]],
Cell[CellGroupData[{
Cell[4613, 163, 253, 5, 70, "GuideFunctionsSubsection",
 CellID->195323479],
Cell[4869, 170, 1110, 30, 70, "InlineGuideFunctionListing",
 CellID->364325951],
Cell[5982, 202, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->251428935]
}, Open  ]],
Cell[CellGroupData[{
Cell[6077, 208, 410, 11, 70, "GuideFunctionsSubsection",
 CellID->91176131],
Cell[6490, 221, 1081, 30, 70, "InlineGuideFunctionListing",
 CellID->44315181]
}, Open  ]],
Cell[CellGroupData[{
Cell[7608, 256, 248, 6, 70, "GuideFunctionsSubsection",
 CellID->400563794],
Cell[7859, 264, 867, 24, 70, "InlineGuideFunctionListing",
 CellID->97757022]
}, Open  ]],
Cell[CellGroupData[{
Cell[8763, 293, 228, 5, 70, "GuideFunctionsSubsection",
 CellID->159696410],
Cell[8994, 300, 860, 24, 70, "InlineGuideFunctionListing",
 CellID->346529431],
Cell[9857, 326, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->325935884]
}, Open  ]],
Cell[CellGroupData[{
Cell[9952, 332, 248, 5, 70, "GuideFunctionsSubsection",
 CellID->148900012],
Cell[10203, 339, 683, 18, 70, "InlineGuideFunctionListing",
 CellID->2091095127]
}, Open  ]],
Cell[CellGroupData[{
Cell[10923, 362, 540, 15, 70, "GuideFunctionsSubsection",
 CellID->30607445],
Cell[11466, 379, 1272, 36, 70, "InlineGuideFunctionListing",
 CellID->385857818]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12787, 421, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[12852, 424, 207, 5, 70, "GuideTutorial",
 CellID->1885805579],
Cell[13062, 431, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[13400, 442, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[13734, 453, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[14101, 467, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[14166, 470, 260, 9, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[14429, 481, 536, 16, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[14968, 499, 159, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[15130, 504, 444, 12, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[15589, 519, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

