(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12647,        452]
NotebookOptionsPosition[      8902,        350]
NotebookOutlinePosition[     10841,        393]
CellTagsIndexPosition[     10798,        390]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "Functions"
}], "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is a protocol for exchanging symbolic expressions",
 ". ",
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-level ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions can be used with any ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-enabled external program, including ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " itself. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkLaunch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkLaunch"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "launch an external program and open a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection to it"
}], "GuideText",
 CellID->703130431],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkCreate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkCreate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " link for another program to connect to"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkConnect",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkConnect"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "connect to an existing ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " link"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkClose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkClose"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "close a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " link"
}], "GuideText",
 CellID->1174810813],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["-",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/MathKernel"],
  ButtonBox["mathlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/MathKernel"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " command-line option for launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " mode"
}], "GuideText",
 CellID->53893346],

Cell["\t", "GuideDelimiter",
 CellID->163461988],

Cell[TextData[{
 Cell[TextData[ButtonBox["Links",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Links"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list all currently open ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " links"
}], "GuideText",
 CellID->194863563],

Cell[TextData[{
 Cell[TextData[ButtonBox["$ParentLink",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$ParentLink"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " link that called the current ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel"
}], "GuideText",
 CellID->2122921483],

Cell["\t", "GuideDelimiter",
 CellID->69797987],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkRead"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["LinkWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkWrite"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "read or write an expression to a link"
}], "GuideText",
 CellID->196228596],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkReadyQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkReadyQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " test whether expressions are ready to be read from one or more links"
}], "GuideText",
 CellID->360399618],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkInterrupt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkInterrupt"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " send an interrupt to a link"
}], "GuideText",
 CellID->22673767],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Packet Wrappers \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathLinkPackets"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->123324243],

Cell[TextData[{
 Cell[TextData[ButtonBox["EvaluatePacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReturnPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReturnPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EnterTextPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EnterTextPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReturnTextPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReturnTextPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkPackets"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1054031603]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[StyleBox[ButtonBox["MathLink",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathLink"],
 FontSlant->"Italic"]], "GuideTutorial",
 CellID->7157806],

Cell[TextData[{
 ButtonBox["How ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/HowMathLinkIsUsed"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/HowMathLinkIsUsed"],
  FontSlant->"Italic"],
 ButtonBox[" Is Used",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/HowMathLinkIsUsed"]
}], "GuideTutorial",
 CellID->407240749],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "GuideTutorial",
 CellID->317934977],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "GuideMoreAbout",
 CellID->428745073]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink Mathematica Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 42.3604744}", "context" -> "", 
    "keywords" -> {
     "active links", "bind name", "child processes", "close connection", 
      "close MathLink", "connect link", "ConnectLink", "connect MathLink", 
      "create link", "data available", "external MathLink programs", 
      "find link", "get data from MathLink", "interrupt MathLink program", 
      "launching programs", "link close", "link connect", "link create", 
      "link interrupt", "link launch", "link read", "link ready", 
      "link write", "listen on link", "MathLink connections", 
      "MathLink connection to kernel", "MathLink expression ready", 
      "parent link", "publish link", "put data", 
      "reading expression from MathLink", "register link", 
      "send data via MathLink", "subscribe to link", 
      "write data to MathLink"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "MathLink is a protocol for exchanging symbolic expressions. The \
Mathematica-level MathLink functions can be used with any MathLink-enabled \
external program, including Mathematica itself. ", "synonyms" -> {}, "title" -> 
    "MathLink Mathematica Functions", "type" -> "Guide", "uri" -> 
    "guide/MathLinkMathematicaFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 168, 8, 70, "GuideTitle",
 CellID->942062912],
Cell[790, 35, 468, 19, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1261, 56, 339, 12, 70, "GuideText",
 CellID->703130431],
Cell[1603, 70, 332, 12, 70, "GuideText",
 CellID->203374175],
Cell[1938, 84, 315, 12, 70, "GuideText",
 CellID->1463276848],
Cell[2256, 98, 296, 12, 70, "GuideText",
 CellID->1174810813],
Cell[2555, 112, 478, 19, 70, "GuideText",
 CellID->53893346],
Cell[3036, 133, 48, 1, 70, "GuideDelimiter",
 CellID->163461988],
Cell[3087, 136, 304, 12, 70, "GuideText",
 CellID->194863563],
Cell[3394, 150, 382, 15, 70, "GuideText",
 CellID->2122921483],
Cell[3779, 167, 47, 1, 70, "GuideDelimiter",
 CellID->69797987],
Cell[3829, 170, 395, 13, 70, "GuideText",
 CellID->196228596],
Cell[4227, 185, 296, 8, 70, "GuideText",
 CellID->360399618],
Cell[4526, 195, 260, 8, 70, "GuideText",
 CellID->22673767],
Cell[CellGroupData[{
Cell[4811, 207, 218, 5, 70, "GuideFunctionsSubsection",
 CellID->123324243],
Cell[5032, 214, 1075, 29, 70, "InlineGuideFunctionListing",
 CellID->1054031603]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6156, 249, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6221, 252, 165, 4, 70, "GuideTutorial",
 CellID->7157806],
Cell[6389, 258, 372, 12, 70, "GuideTutorial",
 CellID->407240749],
Cell[6764, 272, 420, 12, 70, "GuideTutorial",
 CellID->317934977],
Cell[7187, 286, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[7525, 297, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[7859, 308, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[8226, 322, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8291, 325, 307, 9, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[8601, 336, 259, 9, 70, "GuideMoreAbout",
 CellID->428745073]
}, Open  ]],
Cell[8875, 348, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

