(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41188,       1166]
NotebookOptionsPosition[     28474,        905]
NotebookOutlinePosition[     37777,       1053]
CellTagsIndexPosition[     37734,       1050]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Mathematical Functions", "GuideTitle",
 CellID->669],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has the most extensive collection of mathematical functions ever \
assembled",
 ". ",
 "Often relying on original results and algorithms developed at Wolfram \
Research over the past two decades, each function supports a full range of \
symbolic operations, as well as efficient numerical evaluation to arbitrary \
precision, for all complex values of parameters. "
}], "GuideAbstract",
 CellID->197069857],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Mathematical Constants \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalConstants"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->24599],

Cell[TextData[{
 Cell[TextData[ButtonBox["Pi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pi"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["\[Pi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pi"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["E",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/E"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["\[ExponentialE]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/E"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Degree",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Degree"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["\[Degree]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Degree"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EulerGamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EulerGamma"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicalConstants"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->20123]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Complex Numbers \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ComplexNumbers"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->1443],

Cell[TextData[{
 Cell[TextData[ButtonBox["I",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["\[ImaginaryI]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Re",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Re"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Im",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Im"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Conjugate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Conjugate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Abs",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Abs"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Arg",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Arg"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ComplexNumbers"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1731]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Arithmetic Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ArithmeticFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->18154],

Cell[TextData[{
 Cell[TextData[ButtonBox["Plus",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plus"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["+",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plus"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Times",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Times"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["\[Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Times"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Power",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Power"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["^",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Power"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sqrt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sqrt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Total",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Total"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ArithmeticFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->22861]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Numerical Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->4434],

Cell[TextData[{
 Cell[TextData[ButtonBox["Abs",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Abs"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Round",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Round"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Floor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Floor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Min",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Min"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Max",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Max"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Clip",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Clip"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rescale",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rescale"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumericalFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->9385]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Elementary Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ElementaryFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->23967],

Cell[TextData[{
 Cell[TextData[ButtonBox["Log",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Log"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Exp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exp"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sqrt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sqrt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sin"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cos",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cos"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tan"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcTan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcTan"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tanh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tanh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sinc",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Sinc"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ElementaryFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->10816]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Special Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SpecialFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->11393],

Cell[TextData[{
 Cell[TextData[ButtonBox["Gamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Gamma"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Erf",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Erf"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselJ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselJ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselK",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselK"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryAi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AiryAi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticK",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticK"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LegendreP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LegendreP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChebyshevT",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ChebyshevT"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HermiteH",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HermiteH"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LaguerreL",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LaguerreL"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalS1",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalS1"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiSN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiSN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WeierstrassP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WeierstrassP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Zeta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Zeta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolyLog",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolyLog"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticTheta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticTheta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hypergeometric2F1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HypergeometricPFQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeijerG",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MeijerG"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AppellF1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AppellF1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SpecialFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->16704]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Generalized Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GeneralizedFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->29866],

Cell[TextData[{
 Cell[TextData[ButtonBox["DiracDelta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DiracDelta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HeavisideTheta",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HeavisideTheta"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->30953]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Integer Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/IntegerFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->30308],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quotient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Quotient"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Divisible",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Divisible"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GCD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GCD"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Factorial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["!",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Binomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Binomial"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Fibonacci",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fibonacci"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BernoulliB",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BernoulliB"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StirlingS1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StirlingS1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DigitCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DigitCount"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitAnd",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitAnd"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/IntegerFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->28223]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Number Theoretic Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumberTheoreticFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->18684],

Cell[TextData[{
 Cell[TextData[ButtonBox["FactorInteger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorInteger"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Prime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Prime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrimePi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrimePi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EulerPhi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EulerPhi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MoebiusMu",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MoebiusMu"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DivisorSigma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DivisorSigma"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiSymbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiSymbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MultiplicativeOrder",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MultiplicativeOrder"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PartitionsP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PartitionsP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SquaresR",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SquaresR"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumberTheoreticFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->30792]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Statistical Distributions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StatisticalDistributions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->27067407],

Cell[TextData[{
 Cell[TextData[ButtonBox["NormalDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NormalDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChiSquareDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChiSquareDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PoissonDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PoissonDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StatisticalDistributions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->146483062]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Random Numbers \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RandomNumberGeneration"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->22667],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomInteger",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomInteger"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomReal",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomReal"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomChoice",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomChoice"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->10048],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["N",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/N"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "numerical evaluation to any precision"
}], "GuideText",
 CellID->13930],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand in terms of simpler functions"
}], "GuideText",
 CellID->30811],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "apply full symbolic simplification "
}], "GuideText",
 CellID->19814]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->16090],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "GuideTutorial",
 CellID->27644],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "GuideTutorial",
 CellID->32627],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "GuideTutorial",
 CellID->412913713],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexNumbers"]], "GuideTutorial",
 CellID->12455]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->1604],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "GuideMoreAbout",
 CellID->10599],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "GuideMoreAboutSub",
 CellID->16474],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsUsedInQuantumMechanics"]], "GuideMoreAbout",
 CellID->7195],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "GuideMoreAbout",
 CellID->506],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MathematicsAndAlgorithms"]], "GuideMoreAbout",
 CellID->6403424],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1218846684],

Cell[TextData[ButtonBox["functions.wolfram.com",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://functions.wolfram.com"], None}]], "GuideRelatedLinks",
 CellID->591464978]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematical Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 20.9849272}", "context" -> "", 
    "keywords" -> {
     "0F0", "1F0", "1F2", "2F1", "2F2", "2F3", "3F2", "4F3", "5F4", "6F5", 
      "absolute value", "addition", "ai", "airy", "Airy Ai", "Airy functions",
       "algebraic simplification", "aliquant", "alog", "angle", 
      "angle measure", "angle measurement", "angular measure", "antilg", 
      "antilog", "antilogarithm", "Appell hypergeometric function", "arc", 
      "arcdegree", "arc tan", "arctangent", "arctg", "arcus tangens", "arg", 
      "argument", "argument of complex number", "arrays", 
      "artificial intelligence", "assertions", "asterisk", "atan", "bang", 
      "Barnes extended hypergeometric function", "bases", "Bernoulli B", 
      "Bernoulli numbers", "Bernoulli polynomials", "Bessel functions", 
      "Bessel function simplification", "Bessel J", "binary digits", "binom", 
      "binomials", "bit and", "bit count", "Brent-McMillan algorithm", 
      "caret", "Chebychev", "Chebyshev functions", "Chebyshev polynomial", 
      "Chebyshov", "chi squared distribution", "chi square distribution", 
      "choose", "Chudnovsky formula", "Clausen function", 
      "cleaning up expressions", "column sum", "comb", "combinations", 
      "combinatorial explosion", "combinatorial simplification", 
      "compensated summation", "complete elliptic integral", 
      "complete simplification", "complex conjugate", "complex number", 
      "complex part", "compound arguments", "compress expression", 
      "concise form", "congruence", "conical functions", "constraints", 
      "conversion", "coprime", "count of digits", "crop", "cubed", 
      "cyclic indices", "cylindrical functions", "decimal digits", 
      "decimal places", "decode", "decomposition into primes", "degree", 
      "degree of arc", "delta function", "differential equations", 
      "digital sums", "digit count", "digits", "digits count", "dilog", 
      "dilogarithm function", "dirac delta", "discrete log", 
      "discrete logarithm", "distribution of primes", "divisibility", 
      "divisible numbers", "division of integers", "divisor function", 
      "divisor sigma", "double-periodic function", "doubly periodic function",
       "efficiency", "elliptic integral", "elliptic Jacobi function", 
      "EllipticK", "elliptic theta", "entier", "entire", 
      "enumeration of permutations", "error", "error function", 
      "Euclidean algorithm", "Euclid's algorithm", "Euler gamma", 
      "Euler gamma function", "Euler-Maclaurin summation", 
      "Euler-Mascheroni constant", "Euler phi", "Euler's constant", 
      "Euler's pentagonal formula", "Euler totient", "exclamation point", 
      "expanding", "expanding special constants", 
      "expanding special functions", "expanding special sequences", "explode",
       "exponent", "exponential", "exponential constant", "expressions", 
      "fact", "factorial", "factorial function", "factorial simplification", 
      "factoring", "factor integer", "factors", "FFT multiplication", "fib", 
      "Fibonacci sequence", "finding maximal element in lists", 
      "finite fields", "formulas", "fractal", "frlog", "function expand", 
      "gamma function", "gamma function simplification", 
      "Gauss hypergeometric function", "Gaussian distribution", 
      "Gaussian integers", "Gaussian integral", "Gauss integral", 
      "Gauss series", "GCF", "generalized functions", 
      "generalized hypergeometric function", "generalized zeta function", 
      "G-function", "greatest common divider", "greatest common divisor", 
      "greatest integer function", "Green's functions", "group order", 
      "half\\[Hyphen]period values", "Hamming weight", 
      "Hardy-Ramanujan-Rademacher algorithm", "Heaviside theta", 
      "Hermite functions", "Hermite H", "hexadecimal digits", "highest", 
      "highest common factor", "Hurwitz zeta function", "hyperbolic tan", 
      "hyperbolic tangent", "hypergeom", "hypergeometric 2F1", 
      "hypergeometric functions", "hyperlogarithm", "hyptan", "identities", 
      "idiv", "idivide", "ifact", "igcd", "ilog", "Im", "imag", 
      "imaginary part", "imaginary unit", "improper functions", 
      "impulse function", "\\Im (TeX)", "incomplete gamma function", 
      "index function", "infrequent events", "integer digits", 
      "integer factoring", "integral part of division", 
      "inverse tan function", "inverse tangent", "iquo", "irem", 
      "Jacobi elliptic functions", "Jacobi elliptic function sn", 
      "Jacobi symbol", "Jacobi theta 1", "Jacobi theta 2", "Jacobi theta 3", 
      "Jacobi theta 4", "Jonquiere's function", "Karatsuba algorithm", 
      "Kummer series", "Lagarias-Miller-Odlyzko algorithm", 
      "Laguerre functions", "largest", "law of big numbers", "ld", "ldexp", 
      "Lebesgue integration", "Legendre functions", "Legendre polynomials", 
      "Legendre symbol", "lg", "limiting function", "lists", "ln", "log10", 
      "logarithm", "logarithms", "lowest", "lowest terms", 
      "magnitude of complex number", "mask", "maximal element", "maximum", 
      "Meijer G", "Meijer G-function", "Meijer's G-function", "min", 
      "minimal element", "minimum", "mixed fractions", "Mo\"bius", 
      "Mo\"bius function", "modp", "mods", "modular root", "modulo", 
      "Moebius", "Moebius function", "Moebius mu", "mu", 
      "multiplicative order", "multiply", 
      "multivariate hypergeometric function", "natural logarithm", 
      "n-choose-k", "nchoosek", "nCk", "nearest integer", 
      "nearest integer function", "Nielsen functions", "nint", 
      "non-frequent events", "normal distribution", "number rounding", 
      "number-theoretic transforms", "number theory", "octal digits", 
      "one-origin arrays", "ones", "Order", "origin", "padding", "partitions",
       "Pearson chi square", "Pearson chi squared", "pendulum problem", "pfq",
       "phase", "phase-angle", "phase shift", "plane angle", "plus", 
      "Poisson distribution", "Poisson process", "Pollard algorithm", 
      "poly log", "polylogarithm", "population count", "pow", "pow10", "pow2",
       "power", "power10", "power2", "predicates", "prime", 
      "prime counting function", "prime factors", "prime pi", "primes", 
      "primitive root", "quo", "quot", "radian", "radic", "radical", 
      "radical simplification", "radix conversion", "raise to a power", 
      "ramp", "rand", "random choice", "randomint", "random integer", 
      "random number", "random prime", "random real", "random selection", 
      "rare events", "Re", "real", "real part", "reduction formulas", 
      "reflection formula", "reflection formulas", "relations", 
      "relative primality", "rem", "remainder", "renormalize", "\\Re (TeX)", 
      "Riemann hypothesis", "Riemann P function", "Riemann-Siegel formula", 
      "Riemann zeta function", "ring functions", "rnd", "Root", "roots", 
      "round down", "rounddown", "round-off", "roundoff", "row sum", 
      "sampling with replacement", "select randomly", "self-similar", "sen", 
      "shriek", "sigma", "sin", "sine", "sinus", "sn", "snoid", 
      "special functions", "speed", "Spence's integral", 
      "spheroidal functions", "spheroidal harmonics", "spheroidal s1", 
      "spike", "sqrt", "sqt", "squared", "square root", "square roots", 
      "square wave", "squash expression", "standard normal distribution", 
      "stirling1", "Stirling number of the 1st kind", 
      "Stirling number of the first kind", "Stirling numbers", 
      "Stirling numbers S1", "stirling s1", "submultiples", 
      "sum of array elements", "sum of list", "supremum", "surd", "tan", 
      "tangent", "tanh", "Tchebycheff ", "ternary digits", "tg", "tgh", "th", 
      "theta1", "theta2", "theta3", "theta4", "theta functions", 
      "toroidal functions", "total of list", "totient function", 
      "transformations", "trigonometric simplification", "trilogarithm", 
      "Tschebyscheff polynomials", "unit step", 
      "Weierstrass elliptic function", "Weierstrass P", "zeta function"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica has the most extensive collection of mathematical functions \
ever assembled. Often relying on original results and algorithms developed at \
Wolfram Research over the past two decades, each function supports a full \
range of symbolic operations, as well as efficient numerical evaluation to \
arbitrary precision, for all complex values of parameters. ", 
    "synonyms" -> {}, "title" -> "Mathematical Functions", "type" -> "Guide", 
    "uri" -> "guide/MathematicalFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->669],
Cell[680, 28, 474, 11, 70, "GuideAbstract",
 CellID->197069857],
Cell[CellGroupData[{
Cell[1179, 43, 227, 5, 70, "GuideFunctionsSubsection",
 CellID->24599],
Cell[1409, 50, 1332, 44, 70, "InlineGuideFunctionListing",
 CellID->20123]
}, Open  ]],
Cell[CellGroupData[{
Cell[2778, 99, 212, 5, 70, "GuideFunctionsSubsection",
 CellID->1443],
Cell[2993, 106, 1490, 46, 70, "InlineGuideFunctionListing",
 CellID->1731]
}, Open  ]],
Cell[CellGroupData[{
Cell[4520, 157, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->18154],
Cell[4746, 164, 1516, 50, 70, "InlineGuideFunctionListing",
 CellID->22861]
}, Open  ]],
Cell[CellGroupData[{
Cell[6299, 219, 220, 5, 70, "GuideFunctionsSubsection",
 CellID->4434],
Cell[6522, 226, 1594, 47, 70, "InlineGuideFunctionListing",
 CellID->9385]
}, Open  ]],
Cell[CellGroupData[{
Cell[8153, 278, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->23967],
Cell[8379, 285, 2131, 62, 70, "InlineGuideFunctionListing",
 CellID->10816]
}, Open  ]],
Cell[CellGroupData[{
Cell[10547, 352, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->11393],
Cell[10767, 359, 4530, 128, 70, "InlineGuideFunctionListing",
 CellID->16704]
}, Open  ]],
Cell[CellGroupData[{
Cell[15334, 492, 225, 5, 70, "GuideFunctionsSubsection",
 CellID->29866],
Cell[15562, 499, 553, 14, 70, "InlineGuideFunctionListing",
 CellID->30953]
}, Open  ]],
Cell[CellGroupData[{
Cell[16152, 518, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->30308],
Cell[16372, 525, 2942, 85, 70, "InlineGuideFunctionListing",
 CellID->28223]
}, Open  ]],
Cell[CellGroupData[{
Cell[19351, 615, 236, 6, 70, "GuideFunctionsSubsection",
 CellID->18684],
Cell[19590, 623, 2473, 69, 70, "InlineGuideFunctionListing",
 CellID->30792]
}, Open  ]],
Cell[CellGroupData[{
Cell[22100, 697, 238, 6, 70, "GuideFunctionsSubsection",
 CellID->27067407],
Cell[22341, 705, 1331, 33, 70, "InlineGuideFunctionListing",
 CellID->146483062]
}, Open  ]],
Cell[CellGroupData[{
Cell[23709, 743, 220, 5, 70, "GuideFunctionsSubsection",
 CellID->22667],
Cell[23932, 750, 1416, 35, 70, "InlineGuideFunctionListing",
 CellID->10048],
Cell[25351, 787, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[25402, 790, 248, 9, 70, "GuideText",
 CellID->13930],
Cell[25653, 801, 273, 9, 70, "GuideText",
 CellID->30811],
Cell[25929, 812, 268, 9, 70, "GuideText",
 CellID->19814]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26246, 827, 58, 1, 70, "GuideTutorialsSection",
 CellID->16090],
Cell[26307, 830, 167, 3, 70, "GuideTutorial",
 CellID->27644],
Cell[26477, 835, 158, 3, 70, "GuideTutorial",
 CellID->32627],
Cell[26638, 840, 156, 3, 70, "GuideTutorial",
 CellID->412913713],
Cell[26797, 845, 144, 3, 70, "GuideTutorial",
 CellID->12455]
}, Open  ]],
Cell[CellGroupData[{
Cell[26978, 853, 58, 1, 70, "GuideMoreAboutSection",
 CellID->1604],
Cell[27039, 856, 196, 4, 70, "GuideMoreAbout",
 CellID->10599],
Cell[27238, 862, 161, 3, 70, "GuideMoreAboutSub",
 CellID->16474],
Cell[27402, 867, 181, 4, 70, "GuideMoreAbout",
 CellID->7195],
Cell[27586, 873, 164, 3, 70, "GuideMoreAbout",
 CellID->506],
Cell[27753, 878, 185, 4, 70, "GuideMoreAbout",
 CellID->6403424],
Cell[27941, 884, 203, 4, 70, "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],
Cell[CellGroupData[{
Cell[28181, 893, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1218846684],
Cell[28254, 896, 178, 4, 70, "GuideRelatedLinks",
 CellID->591464978]
}, Open  ]],
Cell[28447, 903, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

