(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6363,        199]
NotebookOptionsPosition[      3506,        125]
NotebookOutlinePosition[      5509,        168]
CellTagsIndexPosition[      5466,        165]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Mathieu and Related Functions", "GuideTitle",
 CellID->20169],

Cell[TextData[{
 "Important for elliptical shapes and periodic potentials, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " achieves a new level of implementation for Mathieu-related functions, \
supporting arbitrary-precision evaluation for all complex values of \
parameters. "
}], "GuideAbstract",
 CellID->20736],

Cell[CellGroupData[{

Cell["Mathieu Functions and Derivatives", "GuideFunctionsSubsection",
 CellID->18721],

Cell[TextData[{
 Cell[TextData[ButtonBox["MathieuS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MathieuC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MathieuSPrime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuSPrime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MathieuCPrime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuCPrime"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->31426]
}, Open  ]],

Cell[CellGroupData[{

Cell["Characteristic Values and Exponents", "GuideFunctionsSubsection",
 CellID->10663],

Cell[TextData[{
 Cell[TextData[ButtonBox["MathieuCharacteristicA",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuCharacteristicA"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MathieuCharacteristicB",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuCharacteristicB"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MathieuCharacteristicExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuCharacteristicExponent"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1677]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->21575],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathieuAndRelatedFunctions"]], "GuideTutorial",
 CellID->6724]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->27700],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAbout",
 CellID->7961],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DifferentialEquations"]], "GuideMoreAboutSub",
 CellID->18448]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathieu and Related Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 29.7195258}", "context" -> "", 
    "keywords" -> {
     "ar", "band structure calculations", "Blanch's Newton method", "br", 
      "CE", "derivative of Mathieu function C", 
      "derivative of Mathieu function CE", "derivative of Mathieu function S",
       "derivative of Mathieu function SE", "electron wave functions", 
      "elliptical geometries", "Floquet solution", "Hill's equation", 
      "Mathieu characteristic", "Mathieu characteristic exponent", 
      "Mathieu function C", "Mathieu function C prime", "Mathieu function S", 
      "Mathieu functions", "Mathieu function S prime", "Mathieu prime", 
      "MathieuS", "mathueua", "mathueub", "parametric amplifiers", 
      "Paul traps", "penning traps", "Penning traps", "periodic potentials", 
      "Schrodinger equation", "Schro\"dinger equation", "SE", 
      "solid-state physics"}, "index" -> True, "label" -> "Mathematica Guide",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Important for elliptical shapes and periodic potentials, Mathematica \
achieves a new level of implementation for Mathieu-related functions, \
supporting arbitrary-precision evaluation for all complex values of \
parameters. ", "synonyms" -> {}, "title" -> "Mathieu and Related Functions", 
    "type" -> "Guide", "uri" -> "guide/MathieuAndRelatedFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 67, 1, 70, "GuideTitle",
 CellID->20169],
Cell[689, 28, 322, 8, 70, "GuideAbstract",
 CellID->20736],
Cell[CellGroupData[{
Cell[1036, 40, 85, 1, 70, "GuideFunctionsSubsection",
 CellID->18721],
Cell[1124, 43, 828, 23, 70, "InlineGuideFunctionListing",
 CellID->31426]
}, Open  ]],
Cell[CellGroupData[{
Cell[1989, 71, 87, 1, 70, "GuideFunctionsSubsection",
 CellID->10663],
Cell[2079, 74, 700, 18, 70, "InlineGuideFunctionListing",
 CellID->1677]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2828, 98, 58, 1, 70, "GuideTutorialsSection",
 CellID->21575],
Cell[2889, 101, 169, 3, 70, "GuideTutorial",
 CellID->6724]
}, Open  ]],
Cell[CellGroupData[{
Cell[3095, 109, 59, 1, 70, "GuideMoreAboutSection",
 CellID->27700],
Cell[3157, 112, 145, 3, 70, "GuideMoreAbout",
 CellID->7961],
Cell[3305, 117, 159, 3, 70, "GuideMoreAboutSub",
 CellID->18448]
}, Open  ]],
Cell[3479, 123, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

