(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9696,        316]
NotebookOptionsPosition[      5567,        210]
NotebookOutlinePosition[      8088,        261]
CellTagsIndexPosition[      8045,        258]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Matrix-Based Minimization", "GuideTitle",
 CellID->2290],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["LeastSquares",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LeastSquares"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solve an exact or approximate least-squares problem"
}], "GuideText",
 CellID->4632],

Cell[TextData[{
 Cell[TextData[ButtonBox["PseudoInverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PseudoInverse"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pseudoinverse of a square or rectangular matrix"
}], "GuideText",
 CellID->21478],

Cell[TextData[{
 Cell[TextData[ButtonBox["Norm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Norm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " matrix and vector ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "-norms"
}], "GuideText",
 CellID->26814],

Cell[TextData[{
 Cell[TextData[ButtonBox["QRDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/QRDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SingularValueDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SingularValueDecomposition"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->13787],

Cell["\t", "GuideDelimiter",
 CellID->7239],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a linear least-squares fit to a symbolic basis"
}], "GuideText",
 CellID->28074],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindFit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindFit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a general nonlinear least-squares fit"
}], "GuideText",
 CellID->25020],

Cell["\t", "GuideDelimiter",
 CellID->10827],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinearProgramming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearProgramming"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " solve linear-programming problems"
}], "GuideText",
 CellID->2554]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->1988],

Cell[TextData[ButtonBox["Numerical Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalOptimization"]], "GuideTutorial",
 CellID->312921703],

Cell[TextData[ButtonBox["Constrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationOverview"]], "GuideTutorial",
 CellID->115795587],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "GuideTutorial",
 CellID->176200997],

Cell[TextData[ButtonBox["Solving Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingLinearSystems"]], "GuideTutorial",
 CellID->7408920],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "GuideTutorial",
 CellID->51091438],

Cell[TextData[ButtonBox["Curve Fitting",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CurveFitting"]], "GuideTutorial",
 CellID->150108482]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->13642],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "GuideMoreAbout",
 CellID->19002],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/guide/LinearRegressionPackage"]], \
"GuideMoreAboutSub",
 CellID->7056],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "GuideMoreAbout",
 CellID->221348293]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1723742326],

Cell[TextData[{
 ButtonBox["Demonstrations related to Matrix-Based Minimization",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
FindFit+OR+Fit+OR+LeastSquares+OR+LinearProgramming+OR+Norm+OR+PseudoInverse+\
OR+QRDecomposition+OR+SingularValueDecomposition)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->4374435]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Matrix-Based Minimization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 44.7511606}", "context" -> "", 
    "keywords" -> {
     "1-norm", "2-norm", "approximate formulas", "approximation of functions",
       "chi squared", "condition number of matrices", "curves", "data", 
      "Euclidean norm", "FindFit", "fits", "fitting curves", 
      "fitting differential equations", "fitting of data", "fitting surfaces",
       "Frobenius norm", "generalized inverse of matrices", 
      "generalized singular value decomposition", "Givens rotations", 
      "Householder reflections", "induced matrix norm", "infinity-norm", 
      "inner product norm", "integer programming", "interior point methods", 
      "Karmarkar algorithm", "least-squares", "LeastSquares", 
      "least-squares fits", "linear constraints", "linear fits", 
      "linear objective function", "linear optimization", 
      "linear programming", "LP", "matrix norm", "metric", 
      "Moore-Penrose inverse", "nonlinear fitting", "Norm", 
      "operations research", "orthogonal decomposition", "p-norm", 
      "polynomial fit", "pseudo-inverse", "PseudoInverse", "QRDecomposition", 
      "residuals", "semi-inverse", "simplex algorithm", 
      "singular value decomposition", "SVD", "testing models", "trend line", 
      "vector length", "vector norm"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "LeastSquares -- solve an exact or approximate least-squares problem, \
PseudoInverse -- pseudoinverse of a square or rectangular matrix, Norm -- \
matrix and vector p-norms, Fit -- find a linear least-squares fit to a \
symbolic basis, FindFit -- find a general nonlinear least-squares fit, \
LinearProgramming -- solve linear-programming problems", "synonyms" -> {}, 
    "title" -> "Matrix-Based Minimization", "type" -> "Guide", "uri" -> 
    "guide/MatrixBasedMinimization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 62, 1, 70, "GuideTitle",
 CellID->2290],
Cell[684, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[743, 31, 428, 12, 70, "GuideText",
 CellID->4632],
Cell[1174, 45, 282, 9, 70, "GuideText",
 CellID->21478],
Cell[1459, 56, 298, 11, 70, "GuideText",
 CellID->26814],
Cell[1760, 69, 445, 12, 70, "InlineGuideFunctionListing",
 CellID->13787],
Cell[2208, 83, 43, 1, 70, "GuideDelimiter",
 CellID->7239],
Cell[2254, 86, 266, 9, 70, "GuideText",
 CellID->28074],
Cell[2523, 97, 265, 9, 70, "GuideText",
 CellID->25020],
Cell[2791, 108, 44, 1, 70, "GuideDelimiter",
 CellID->10827],
Cell[2838, 111, 270, 8, 70, "GuideText",
 CellID->2554]
}, Open  ]],
Cell[CellGroupData[{
Cell[3145, 124, 57, 1, 70, "GuideTutorialsSection",
 CellID->1988],
Cell[3205, 127, 162, 3, 70, "GuideTutorial",
 CellID->312921703],
Cell[3370, 132, 177, 4, 70, "GuideTutorial",
 CellID->115795587],
Cell[3550, 138, 181, 4, 70, "GuideTutorial",
 CellID->176200997],
Cell[3734, 144, 159, 3, 70, "GuideTutorial",
 CellID->7408920],
Cell[3896, 149, 168, 3, 70, "GuideTutorial",
 CellID->51091438],
Cell[4067, 154, 144, 3, 70, "GuideTutorial",
 CellID->150108482]
}, Open  ]],
Cell[CellGroupData[{
Cell[4248, 162, 59, 1, 70, "GuideMoreAboutSection",
 CellID->13642],
Cell[4310, 165, 137, 3, 70, "GuideMoreAbout",
 CellID->19002],
Cell[4450, 170, 185, 5, 70, "GuideMoreAboutSub",
 CellID->7056],
Cell[4638, 177, 203, 4, 70, "GuideMoreAbout",
 CellID->221348293]
}, Open  ]],
Cell[CellGroupData[{
Cell[4878, 186, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1723742326],
Cell[4951, 189, 574, 16, 70, "GuideRelatedLinks",
 CellID->4374435]
}, Open  ]],
Cell[5540, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

