(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8735,        281]
NotebookOptionsPosition[      5193,        185]
NotebookOutlinePosition[      7272,        230]
CellTagsIndexPosition[      7229,        227]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Matrix Decompositions", "GuideTitle",
 CellID->18509],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Linear Systems", "GuideFunctionsSubsection",
 CellID->20686],

Cell[TextData[{
 Cell[TextData[ButtonBox["LUDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LUDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CholeskyDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CholeskyDecomposition"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->14804]
}, Open  ]],

Cell[CellGroupData[{

Cell["Least Squares", "GuideFunctionsSubsection",
 CellID->26385],

Cell[TextData[{
 Cell[TextData[ButtonBox["QRDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/QRDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SingularValueDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SingularValueDecomposition"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->10142]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigenproblems", "GuideFunctionsSubsection",
 CellID->18842],

Cell[TextData[{
 Cell[TextData[ButtonBox["Eigensystem",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Eigensystem"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SchurDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SchurDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JordanDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JordanDecomposition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HessenbergDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HessenbergDecomposition"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->17260]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integer Systems", "GuideFunctionsSubsection",
 CellID->85047138],

Cell[TextData[{
 Cell[TextData[ButtonBox["HermiteDecomposition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HermiteDecomposition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LatticeReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LatticeReduce"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->436143736]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->22161],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "GuideTutorial",
 CellID->858689428]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->9578],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "GuideMoreAbout",
 CellID->1187],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "GuideMoreAbout",
 CellID->113],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "GuideMoreAbout",
 CellID->221348293]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1382875052],

Cell[TextData[{
 ButtonBox["Demonstrations related to Matrix Decompositions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
CholeskyDecomposition+OR+Eigensystem+OR+HermiteDecomposition+OR+\
HessenbergDecomposition+OR+JordanDecomposition+OR+LatticeReduce+OR+\
LUDecomposition+OR+QRDecomposition+OR+SchurDecomposition+OR+\
SingularValueDecomposition)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->523656100]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Matrix Decompositions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 45.2042972}", "context" -> "", 
    "keywords" -> {
     "basis vectors", "Cholesky decomposition", "combinatorial algorithms", 
      "condition number of matrices", "eigen decomposition", "eigensystem", 
      "EISPACK", "extended GCD", "Gaussian elimination", 
      "generalized eigen decomposition", "generalized eigensystem", 
      "generalized similarity transformation", 
      "generalized singular value decomposition", "Givens rotations", 
      "HermiteDecomposition", "HessenbergDecomposition", 
      "Householder reflections", "invariant subspace problem", 
      "invariant subspaces", "Jordan canonical form", "JordanDecomposition", 
      "Jordan form", "LAPACK", "lattice reduce", 
      "Lenstra-Lenstra-Lovasz algorithm", "linear Diophantine equations", 
      "linear matrix pencils", "LINPACK", "LLL algorithm", 
      "orthogonal decomposition", "positive definite matrix", 
      "QRDecomposition", "repeated solution of linear systems", 
      "row elimination", "Schur decomposition", "similarity transformation", 
      "singular value decomposition", "SVD", "triangular matrices", 
      "upper Hessenberg decomposition", "upper Hessenberg matrix"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> "", "synonyms" -> {}, 
    "title" -> "Matrix Decompositions", "type" -> "Guide", "uri" -> 
    "guide/MatrixDecompositions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 59, 1, 70, "GuideTitle",
 CellID->18509],
Cell[681, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[762, 33, 66, 1, 70, "GuideFunctionsSubsection",
 CellID->20686],
Cell[831, 36, 432, 11, 70, "InlineGuideFunctionListing",
 CellID->14804]
}, Open  ]],
Cell[CellGroupData[{
Cell[1300, 52, 65, 1, 70, "GuideFunctionsSubsection",
 CellID->26385],
Cell[1368, 55, 445, 12, 70, "InlineGuideFunctionListing",
 CellID->10142]
}, Open  ]],
Cell[CellGroupData[{
Cell[1850, 72, 65, 1, 70, "GuideFunctionsSubsection",
 CellID->18842],
Cell[1918, 75, 886, 23, 70, "InlineGuideFunctionListing",
 CellID->17260]
}, Open  ]],
Cell[CellGroupData[{
Cell[2841, 103, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->85047138],
Cell[2914, 106, 575, 14, 70, "InlineGuideFunctionListing",
 CellID->436143736]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3538, 126, 58, 1, 70, "GuideTutorialsSection",
 CellID->22161],
Cell[3599, 129, 169, 3, 70, "GuideTutorial",
 CellID->858689428]
}, Open  ]],
Cell[CellGroupData[{
Cell[3805, 137, 58, 1, 70, "GuideMoreAboutSection",
 CellID->9578],
Cell[3866, 140, 139, 3, 70, "GuideMoreAbout",
 CellID->1187],
Cell[4008, 145, 159, 3, 70, "GuideMoreAbout",
 CellID->113],
Cell[4170, 150, 203, 4, 70, "GuideMoreAbout",
 CellID->221348293]
}, Open  ]],
Cell[CellGroupData[{
Cell[4410, 159, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1382875052],
Cell[4483, 162, 668, 18, 70, "GuideRelatedLinks",
 CellID->523656100]
}, Open  ]],
Cell[5166, 183, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

