(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13867,        451]
NotebookOptionsPosition[      8901,        328]
NotebookOutlinePosition[     11893,        384]
CellTagsIndexPosition[     11850,        381]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Memory Measurement & Optimization", "GuideTitle",
 CellID->21528],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["ByteCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ByteCount"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " number of bytes used to store an expression"
}], "GuideText",
 CellID->32729],

Cell[TextData[{
 Cell[TextData[ButtonBox["LeafCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LeafCount"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " number of \"leaves\" in an expression"
}], "GuideText",
 CellID->17107],

Cell[TextData[{
 Cell[TextData[ButtonBox["Length",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Length"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Depth",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Depth"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitLength",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BitLength"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hash",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hash"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->27892],

Cell["\t", "GuideDelimiter",
 CellID->2451],

Cell[TextData[{
 Cell[TextData[ButtonBox["Clear",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Clear"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " clear main values of a symbol"
}], "GuideText",
 CellID->17953],

Cell[TextData[{
 Cell[TextData[ButtonBox["ClearAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ClearAll"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " clear all values and attributes"
}], "GuideText",
 CellID->28392],

Cell[TextData[{
 Cell[TextData[ButtonBox["$HistoryLength",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$HistoryLength"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " number of previous outputs to store"
}], "GuideText",
 CellID->22570],

Cell[TextData[{
 Cell[TextData[ButtonBox["$RecursionLimit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$IterationLimit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$IterationLimit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MaxNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MaxNumber"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MaxPrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->13519],

Cell["\t", "GuideDelimiter",
 CellID->19472],

Cell[TextData[{
 Cell[TextData[ButtonBox["MemoryConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemoryConstrained"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "abort a computation if it uses too much memory"
}], "GuideText",
 CellID->23407],

Cell[TextData[{
 Cell[TextData[ButtonBox["MemoryInUse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemoryInUse"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "amount of memory currently in use"
}], "GuideText",
 CellID->22494],

Cell[TextData[{
 Cell[TextData[ButtonBox["MaxMemoryUsed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MaxMemoryUsed"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "maximum memory used in this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel"
}], "GuideText",
 CellID->9505],

Cell["\t", "GuideDelimiter",
 CellID->28440],

Cell[TextData[{
 Cell[TextData[ButtonBox["Share",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Share"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "internally share common subexpressions"
}], "GuideText",
 CellID->20383],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileByteCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileByteCount"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "size of an external file"
}], "GuideText",
 CellID->14262],

Cell["\t", "GuideDelimiter",
 CellID->474413354],

Cell[TextData[{
 Cell[TextData[ButtonBox["Compress",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Compress"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generate a compressed string representation of any expression"
}], "GuideText",
 CellID->206279153],

Cell[TextData[{
 Cell[TextData[ButtonBox["Uncompress",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Uncompress"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "recover an expression from its compressed string representation"
}], "GuideText",
 CellID->48650637],

Cell["\t", "GuideDelimiter",
 CellID->629547104],

Cell[TextData[{
 Cell[TextData[ButtonBox["Short",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Short"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display a shortened version of an expression"
}], "GuideText",
 CellID->82946337],

Cell[CellGroupData[{

Cell["Low-Level Optimizations", "GuideFunctionsSubsection",
 CellID->90935767],

Cell[TextData[{
 Cell[TextData[ButtonBox["Remove",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Remove"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ClearSystemCache",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ClearSystemCache"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SystemOptions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SystemOptions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetSystemOptions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SetSystemOptions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->225285579]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->21409],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "GuideTutorial",
 CellID->28607]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->4360],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SessionCustomization"],
  FontSlant->"Italic"],
 ButtonBox[" Session Customization",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SessionCustomization"]
}], "GuideMoreAbout",
 CellID->5471],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"]
}], "GuideMoreAboutSub",
 CellID->29947],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/TimeMeasurementAndOptimization"]], "GuideMoreAboutSub",
 CellID->11514]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Memory Measurement & Optimization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 46.2043228}", "context" -> "", 
    "keywords" -> {
     "available memory", "BitLength", "ByteCount", "cleaning up", "ClearAll", 
      "clearing symbols", "clear system cache", "command history", 
      "common subexpressions", "compacting expressions", "compressed form", 
      "concise form", "constrained memory", "current memory use", 
      "definitions", "deleting functions", "deleting symbols", 
      "elided output", "evaluation chain", "evaluation with limited memory", 
      "fileattrib", "file attributes", "FileByteCount", "file size", 
      "finite memory", "free memory", "history length", "iteration limit", 
      "LeafCount", "maximum memory used", "MaxMemoryUsed", "max number", 
      "max precision", "memory", "memory allocated", "MemoryConstrained", 
      "memory constraints", "memory consumption", "memory in use", 
      "memory used in computation", "nesting level", "number of elements", 
      "number of terms", "one-line output", "process size", 
      "removing functions", "removing symbols", "set system options", 
      "short output", "size", "size of array", "size of computation", 
      "skeleton output", "small output", "stopping iteration", 
      "stopping recursion", "system options", "undefining functions", 
      "workspace", "$RecursionLimit"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "ByteCount -- number of bytes used to store an expression, LeafCount -- \
number of \"leaves\" in an expression, Clear -- clear main values of a \
symbol, ClearAll -- clear all values and attributes, $HistoryLength -- number \
of previous outputs to store, MemoryConstrained -- abort a computation if it \
uses too much memory, MemoryInUse -- amount of memory currently in use, \
MaxMemoryUsed -- maximum memory used in this Mathematica kernel, Share -- \
internally share common subexpressions, FileByteCount -- size of an external \
file, Compress -- generate a compressed string representation of any \
expression, Uncompress -- recover an expression from its compressed string \
representation, Short -- display a shortened version of an expression", 
    "synonyms" -> {}, "title" -> "Memory Measurement & Optimization", "type" -> 
    "Guide", "uri" -> "guide/MemoryMeasurementAndOptimization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 71, 1, 70, "GuideTitle",
 CellID->21528],
Cell[693, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[752, 31, 265, 8, 70, "GuideText",
 CellID->32729],
Cell[1020, 41, 259, 8, 70, "GuideText",
 CellID->17107],
Cell[1282, 51, 937, 26, 70, "InlineGuideFunctionListing",
 CellID->27892],
Cell[2222, 79, 43, 1, 70, "GuideDelimiter",
 CellID->2451],
Cell[2268, 82, 243, 8, 70, "GuideText",
 CellID->17953],
Cell[2514, 92, 251, 8, 70, "GuideText",
 CellID->28392],
Cell[2768, 102, 267, 8, 70, "GuideText",
 CellID->22570],
Cell[3038, 112, 850, 23, 70, "InlineGuideFunctionListing",
 CellID->13519],
Cell[3891, 137, 44, 1, 70, "GuideDelimiter",
 CellID->19472],
Cell[3938, 140, 289, 9, 70, "GuideText",
 CellID->23407],
Cell[4230, 151, 264, 9, 70, "GuideText",
 CellID->22494],
Cell[4497, 162, 323, 12, 70, "GuideText",
 CellID->9505],
Cell[4823, 176, 44, 1, 70, "GuideDelimiter",
 CellID->28440],
Cell[4870, 179, 257, 9, 70, "GuideText",
 CellID->20383],
Cell[5130, 190, 259, 9, 70, "GuideText",
 CellID->14262],
Cell[5392, 201, 48, 1, 70, "GuideDelimiter",
 CellID->474413354],
Cell[5443, 204, 290, 9, 70, "GuideText",
 CellID->206279153],
Cell[5736, 215, 295, 9, 70, "GuideText",
 CellID->48650637],
Cell[6034, 226, 48, 1, 70, "GuideDelimiter",
 CellID->629547104],
Cell[6085, 229, 266, 9, 70, "GuideText",
 CellID->82946337],
Cell[CellGroupData[{
Cell[6376, 242, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->90935767],
Cell[6457, 245, 1285, 32, 70, "InlineGuideFunctionListing",
 CellID->225285579]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7791, 283, 58, 1, 70, "GuideTutorialsSection",
 CellID->21409],
Cell[7852, 286, 148, 3, 70, "GuideTutorial",
 CellID->28607]
}, Open  ]],
Cell[CellGroupData[{
Cell[8037, 294, 58, 1, 70, "GuideMoreAboutSection",
 CellID->4360],
Cell[8098, 297, 293, 9, 70, "GuideMoreAbout",
 CellID->5471],
Cell[8394, 308, 282, 9, 70, "GuideMoreAboutSub",
 CellID->29947],
Cell[8679, 319, 180, 4, 70, "GuideMoreAboutSub",
 CellID->11514]
}, Open  ]],
Cell[8874, 326, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

