(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14130,        417]
NotebookOptionsPosition[      9600,        309]
NotebookOutlinePosition[     12514,        364]
CellTagsIndexPosition[     12471,        361]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["New in 6.0: Function Visualization", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Bringing together ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s powerful capabilities in numerics, algebraic computation and now also \
geometric computation, Version 6.0 takes the state of the art for function \
visualization to a new level\[LongDash]with ubiquitous adaptivity, region- \
and volume-oriented implicit plotting, automated singularity analysis, \
arbitrary plotting regions and mesh overlays\[LongDash]as well as a host of \
innovative automatic aesthetics features."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Plot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plot"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now supports automatic filling, exclusions, etc."
}], "GuideText",
 CellID->5651],

Cell[TextData[{
 Cell[TextData[ButtonBox["LogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogLinearPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogLinearPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogLogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogLogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->34683661],

Cell["\t", "GuideDelimiter",
 CellID->253400953],

Cell[TextData[{
 Cell[TextData[ButtonBox["Plot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plot3D"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now adaptive, with arbitrary meshing, coloring, smoothing etc."
}], "GuideText",
 CellID->2258],

Cell["\t", "GuideDelimiter",
 CellID->7213],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now fully adaptive, with automated contour labeling, etc."
}], "GuideText",
 CellID->9860],

Cell[TextData[{
 Cell[TextData[ButtonBox["DensityPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DensityPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now adaptive, with color functions, region specifications, etc."
}], "GuideText",
 CellID->2742],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContourPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 3D contour plot"
}], "GuideText",
 CellID->25783],

Cell["\t", "GuideDelimiter",
 CellID->8610],

Cell[TextData[{
 Cell[TextData[ButtonBox["ParametricPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ParametricPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now including parametric regions, etc."
}], "GuideText",
 CellID->4472],

Cell[TextData[{
 Cell[TextData[ButtonBox["ParametricPlot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now adaptive, with multiple functions, meshing, etc."
}], "GuideText",
 CellID->7128],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolarPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolarPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RevolutionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->13710843],

Cell["\t", "GuideDelimiter",
 CellID->18434],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 2D regions defined by inequalities"
}], "GuideText",
 CellID->5841],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 3D regions defined by inequalities"
}], "GuideText",
 CellID->20718],

Cell["\t", "GuideDelimiterSubsection",
 CellID->148182735],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Function Visualization Options \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->498859468],

Cell[TextData[{
 Cell[TextData[ButtonBox["Filling",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Filling"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeshFunctions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MeshFunctions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RegionFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Exclusions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Exclusions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->790872759]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FunctionVisualization"],
  FontSlant->"Italic"],
 ButtonBox[" Function Visualization",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FunctionVisualization"]
}], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "GuideMoreAbout",
 CellID->531354033],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60VisualizationAndGraphics"]], "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"New in 6.0: Function Visualization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 32, 59.2984080}", "context" -> "", 
    "keywords" -> {
     "Argand diagrams", "complex plots", "contour levels", "contour lines", 
      "ContourPlot", "contour plot3", "ContourPlot3D", "contour surface", 
      "curve graphing", "curves", "DensityPlot", "double-logarithmic plot", 
      "double logarithmic plot", "false color plots", "fill area", 
      "function graphing", "function plotting", "function visualization", 
      "graph", "graphics", "graphing", "height fields", "implicit curves", 
      "implicit graphs", "implicit plots", "implicit surfaces", 
      "intensity plot", "Lissajous figures", "loglinear", "log-linear plot", 
      "LogLinearPlot", "loglog", "LogLogPlot", "log-log scale plot", 
      "log-normal plot", "log-plot", "LogPlot", "log plots", "mesh functions",
       "parametric curves", "ParametricPlot", "parametric plot3", 
      "ParametricPlot3D", "parametric regions", "parametric surfaces", 
      "plane curves", "plot region", "plots of surfaces", "plotting", 
      "plotting parametric surfaces", "plot volume", "PolarPlot", 
      "polar plots", "RegionFunction", "RegionPlot", "region plot3", 
      "RegionPlot3D", "revolution plot", "RevolutionPlot3D", 
      "revolved surface", "semi-logarithmic", "semi-log plot", "semilog plot",
       "semilog plots", "space curves", "spherical plot3", "SphericalPlot3D", 
      "surface of revolution", "surface plots", "surfaces", 
      "three-dimensional graphics", "three-dimensional plots", 
      "visualization", "volume slice", "volumetric slice"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Bringing together Mathematica's powerful capabilities in numerics, \
algebraic computation and now also geometric computation, Version 6.0 takes \
the state of the art for function visualization to a new level--with \
ubiquitous adaptivity, region- and volume-oriented implicit plotting, \
automated singularity analysis, arbitrary plotting regions and mesh \
overlays--as well as a host of innovative automatic aesthetics features.", 
    "synonyms" -> {}, "title" -> "New in 6.0: Function Visualization", "type" -> 
    "Guide", "uri" -> "guide/NewIn60FunctionVisualization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 76, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[698, 28, 554, 11, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1255, 41, 312, 10, 70, "GuideText",
 CellID->5651],
Cell[1570, 53, 1050, 26, 70, "InlineGuideFunctionListing",
 CellID->34683661],
Cell[2623, 81, 48, 1, 70, "GuideDelimiter",
 CellID->253400953],
Cell[2674, 84, 330, 10, 70, "GuideText",
 CellID->2258],
Cell[3007, 96, 43, 1, 70, "GuideDelimiter",
 CellID->7213],
Cell[3053, 99, 335, 10, 70, "GuideText",
 CellID->9860],
Cell[3391, 111, 341, 10, 70, "GuideText",
 CellID->2742],
Cell[3735, 123, 390, 11, 70, "GuideText",
 CellID->25783],
Cell[4128, 136, 43, 1, 70, "GuideDelimiter",
 CellID->8610],
Cell[4174, 139, 322, 10, 70, "GuideText",
 CellID->4472],
Cell[4499, 151, 340, 10, 70, "GuideText",
 CellID->7128],
Cell[4842, 163, 1070, 26, 70, "InlineGuideFunctionListing",
 CellID->13710843],
Cell[5915, 191, 44, 1, 70, "GuideDelimiter",
 CellID->18434],
Cell[5962, 194, 402, 11, 70, "GuideText",
 CellID->5841],
Cell[6367, 207, 407, 11, 70, "GuideText",
 CellID->20718],
Cell[6777, 220, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->148182735],
Cell[CellGroupData[{
Cell[6860, 225, 262, 6, 70, "GuideFunctionsSubsection",
 CellID->498859468],
Cell[7125, 233, 1654, 42, 70, "InlineGuideFunctionListing",
 CellID->790872759]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8828, 281, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8893, 284, 301, 9, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[9197, 295, 171, 3, 70, "GuideMoreAbout",
 CellID->531354033],
Cell[9371, 300, 187, 4, 70, "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],
Cell[9573, 307, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

