(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15915,        475]
NotebookOptionsPosition[     10746,        354]
NotebookOutlinePosition[     14091,        416]
CellTagsIndexPosition[     14048,        413]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["New in 6.0: Graphics Primitives & Directives", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Version 6.0 pioneers the concept of complete structural integration of \
graphics\[LongDash]with graphics now interleaving seamlessly into all input \
and output, and allowing immediate manipulation using all of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s powerful language and dynamic capabilities",
 ". ",
 "Version 6.0 also greatly extends the core graphics language\[LongDash]with \
opacity, smooth shading, new primitives and richer graphics data structures."
}], "GuideAbstract",
 CellID->298814473],

Cell[TextData[{
 Cell[TextData[ButtonBox["Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Graphics"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now fully integrated into all input and output, and editable"
}], "GuideText",
 CellID->367321070],

Cell[TextData[{
 Cell[TextData[ButtonBox["Graphics3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Graphics3D"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now with full real-time rotation, smooth shading, etc."
}], "GuideText",
 CellID->413959893],

Cell[TextData[{
 StyleBox[ButtonBox["Graphics \[FilledRightTriangle]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsMenu"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " interactive drawing tools and interactive graphics inspector"
}], "GuideText",
 CellID->366140279],

Cell["\t", "GuideDelimiter",
 CellID->861870504],

Cell[TextData[{
 Cell[TextData[ButtonBox["Point",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Point"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Line",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Line"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Polygon",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Polygon"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now support multiple points, lines, polygons"
}], "GuideText",
 CellID->7855228],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rectangle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rectangle"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Disk",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Disk"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Circle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Circle"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now support separate edge and interior styles"
}], "GuideText",
 CellID->462995856],

Cell[TextData[{
 Cell[TextData[ButtonBox["Arrow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Arrow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general arrow primitive, with multiple heads, curved shafts, etc."
}], "GuideText",
 CellID->61704208],

Cell["\t", "GuideDelimiter",
 CellID->369473246],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sphere",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Sphere"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Cylinder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Cylinder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "new 3D graphics primitives"
}], "GuideText",
 CellID->145095859],

Cell[TextData[{
 Cell[TextData[ButtonBox["Polygon",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Polygon"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now supports smooth shading and color gradients"
}], "GuideText",
 CellID->246963426],

Cell["\t", "GuideDelimiter",
 CellID->514941799],

Cell[TextData[{
 Cell[TextData[ButtonBox["Inset",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Inset"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " arbitrary object inset into graphics"
}], "GuideText",
 CellID->11376],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphicsComplex",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "polygonal mesh or general 2D or 3D graphics complex"
}], "GuideText",
 CellID->824794390],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphicsGroup",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsGroup"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "graphics selectable as a group"
}], "GuideText",
 CellID->18963550],

Cell["\t", "GuideDelimiter",
 CellID->105551701],

Cell[TextData[{
 Cell[TextData[ButtonBox["Opacity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Opacity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "transparency in 2D and 3D"
}], "GuideText",
 CellID->81022694],

Cell[TextData[{
 Cell[TextData[ButtonBox["Blend",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Blend"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Lighter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Lighter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Darker",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Darker"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Glow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Glow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Specularity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Specularity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Colors"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->147576741],

Cell[TextData[{
 Cell[TextData[ButtonBox["EdgeForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EdgeForm"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FaceForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FaceForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now work with 2D as well as 3D graphics"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexColors",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VertexColors"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexNormals",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VertexNormals"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->98938354]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Primitives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]], "GuideTutorial",
 CellID->69550799],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "GuideTutorial",
 CellID->563936823]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["New Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"New in 6.0: Graphics Primitives & Directives - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 0.7203194}", "context" -> "", 
    "keywords" -> {
     "2D polygon", "3D graphics", "3D polygon", "3D sphere", "alpha channel", 
      "arc of circle", "arrowhead", "ball", "blending colors", 
      "Blinn shading", "borders of polygons", "canvas", "circle", 
      "circular arc", "color blends", "color dithering", "color gradients", 
      "color interpolation", "continuous shading", "cylinder", "darker", 
      "disk", "dot", "double arrow", "draw", "drawing", "edge form", "edges", 
      "ellipse", "elliptical arc", "elliptical disk", "face", "face form", 
      "facet", "filled circle", "filled ellipse", "filled region", 
      "glow color", "Gouraud shading", "graphics arrow", "graphics complex", 
      "graphics group", "graphics primitives", "graphics rectangle", 
      "inset 3D graphics into graphics", "inset graphic into graphics", 
      "inset text into graphics", "Lambertian diffuse lighting", 
      "light dithering", "lightening colors", "lighter", 
      "light independent color", "lighting", "lighting properties", "lines", 
      "line segments", "material property", "metallic color", 
      "metallic surface", "mixing colors", "opaque", "oval", "pie slices", 
      "plastic color", "plastic surface", "point", "polygonal line", 
      "polygon edges style", "polygon mesh", "polygon normals", "polyhedra", 
      "polyline", "polytope", "rectangle", "reflection", "region", 
      "seams between polygons", "segments", "shading equation", 
      "shading properties", "shininess", "single arrow", "specular color", 
      "specular exponent", "specular reflection", "sphere", "square", 
      "surface data", "surface graphics", "surface lighting", "surface mesh", 
      "surface normals", "surface polygons", "surface reflection", 
      "surface shading", "surface triangulation", "three-dimensional", 
      "transforming graphics", "translucent", "transparent", "tube", "vector",
       "vertex colors", "vertex normals"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Version 6.0 pioneers the concept of complete structural integration of \
graphics--with graphics now interleaving seamlessly into all input and \
output, and allowing immediate manipulation using all of Mathematica's \
powerful language and dynamic capabilities. Version 6.0 also greatly extends \
the core graphics language--with opacity, smooth shading, new primitives and \
richer graphics data structures.", "synonyms" -> {}, "title" -> 
    "New in 6.0: Graphics Primitives & Directives", "type" -> "Guide", "uri" -> 
    "guide/NewIn60GraphicsPrimitivesAndDirectives"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 86, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[708, 28, 536, 11, 70, "GuideAbstract",
 CellID->298814473],
Cell[1247, 41, 337, 10, 70, "GuideText",
 CellID->367321070],
Cell[1587, 53, 335, 10, 70, "GuideText",
 CellID->413959893],
Cell[1925, 65, 297, 8, 70, "GuideText",
 CellID->366140279],
Cell[2225, 75, 48, 1, 70, "GuideDelimiter",
 CellID->861870504],
Cell[2276, 78, 557, 18, 70, "GuideText",
 CellID->7855228],
Cell[2836, 98, 566, 18, 70, "GuideText",
 CellID->462995856],
Cell[3405, 118, 432, 12, 70, "GuideText",
 CellID->61704208],
Cell[3840, 132, 48, 1, 70, "GuideDelimiter",
 CellID->369473246],
Cell[3891, 135, 668, 19, 70, "GuideText",
 CellID->145095859],
Cell[4562, 156, 322, 10, 70, "GuideText",
 CellID->246963426],
Cell[4887, 168, 48, 1, 70, "GuideDelimiter",
 CellID->514941799],
Cell[4938, 171, 395, 11, 70, "GuideText",
 CellID->11376],
Cell[5336, 184, 439, 12, 70, "GuideText",
 CellID->824794390],
Cell[5778, 198, 413, 12, 70, "GuideText",
 CellID->18963550],
Cell[6194, 212, 48, 1, 70, "GuideDelimiter",
 CellID->105551701],
Cell[6245, 215, 396, 12, 70, "GuideText",
 CellID->81022694],
Cell[6644, 229, 1934, 50, 70, "InlineGuideFunctionListing",
 CellID->147576741],
Cell[8581, 281, 444, 14, 70, "GuideText",
 CellID->1463276848],
Cell[9028, 297, 703, 17, 70, "InlineGuideFunctionListing",
 CellID->98938354]
}, Open  ]],
Cell[CellGroupData[{
Cell[9768, 319, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[9833, 322, 200, 4, 70, "GuideTutorial",
 CellID->69550799],
Cell[10036, 328, 201, 4, 70, "GuideTutorial",
 CellID->563936823]
}, Open  ]],
Cell[CellGroupData[{
Cell[10274, 337, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[10339, 340, 168, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[10510, 345, 194, 4, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[10719, 352, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

