(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16482,        533]
NotebookOptionsPosition[     11551,        404]
NotebookOutlinePosition[     14204,        456]
CellTagsIndexPosition[     14161,        453]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["New in 6.0: List Manipulation", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Widely recognized as the world's most powerful list manipulation language, \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " adds in Version 6.0 a number of important new functions",
 ". ",
 "Each function is carefully designed for flexibility, ease of use, wide \
application and tight integration into the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system."
}], "GuideAbstract",
 CellID->408421374],

Cell[CellGroupData[{

Cell["New Part Specification Functions", "GuideFunctionsSubsection",
 CellID->9508724],

Cell[TextData[{
 Cell[TextData[ButtonBox["Span",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Span"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " (",
 Cell[TextData[ButtonBox[";;",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Span"]], "InlineFunctionSans"],
 ") \[LongDash] short notation for sequences of parts, blocks, etc."
}], "GuideText",
 CellID->173361610],

Cell[TextData[{
 Cell[TextData[ButtonBox["Band",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Band"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "arbitrary bands in multidimensional arrays"
}], "GuideText",
 CellID->294573007]
}, Open  ]],

Cell[CellGroupData[{

Cell["New Functions for List & Array Creation", "GuideFunctionsSubsection",
 CellID->277755688],

Cell[TextData[{
 Cell[TextData[ButtonBox["ConstantArray",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ConstantArray"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create a constant array"
}], "GuideText",
 CellID->22655321],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomInteger",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomInteger"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RandomChoice",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomChoice"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[BoxData["\[Ellipsis]"], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create lists or arrays of random elements"
}], "GuideText",
 CellID->75625251]
}, Open  ]],

Cell[CellGroupData[{

Cell["New Functions for Processing Lists", "GuideFunctionsSubsection",
 CellID->212409270],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "tally identical elements with their multiplicities"
}], "GuideText",
 CellID->118494465],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["BinLists",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinLists"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "give counts and lists of elements that lie in bins"
}], "GuideText",
 CellID->355285909],

Cell[TextData[{
 Cell[TextData[ButtonBox["Accumulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Accumulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Differences",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Differences"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "successive sums and differences in lists"
}], "GuideText",
 CellID->513354764],

Cell[TextData[{
 Cell[TextData[ButtonBox["Commonest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Commonest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the commonest elements in a list"
}], "GuideText",
 CellID->126730402]
}, Open  ]],

Cell[CellGroupData[{

Cell["New Functions for Rearranging & Modifying Lists", \
"GuideFunctionsSubsection",
 CellID->536121932],

Cell[TextData[{
 Cell[TextData[ButtonBox["SortBy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SortBy"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sort a list by values of a function"
}], "GuideText",
 CellID->30456809],

Cell[TextData[{
 Cell[TextData[ButtonBox["Riffle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Riffle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "interleave elements into a list"
}], "GuideText",
 CellID->218527675],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now supports general sparse rule specification"
}], "GuideText",
 CellID->400509194],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomSample",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomSample"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "randomly rearrange a list"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Permutations",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Permutations"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now supports selecting any number of elements "
}], "GuideText",
 CellID->159695572]
}, Open  ]],

Cell[CellGroupData[{

Cell["New Functions for Multidimensional Arrays", "GuideFunctionsSubsection",
 CellID->164806735],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayFlatten",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "flatten subarrays in any dimension"
}], "GuideText",
 CellID->60189766],

Cell[TextData[{
 Cell[TextData[ButtonBox["Flatten",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Flatten"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " new forms of multilevel flattening"
}], "GuideText",
 CellID->46834159],

Cell[TextData[{
 Cell[TextData[ButtonBox["Join",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Join"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " join arrays at any level"
}], "GuideText",
 CellID->313984770],

Cell[TextData[{
 Cell[TextData[ButtonBox["PadLeft",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PadLeft"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["PadRight",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PadRight"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " extended to automatically form full arrays"
}], "GuideText",
 CellID->239565585],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reverse"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " extended to arbitrary levels"
}], "GuideText",
 CellID->271372573],

Cell[TextData[{
 Cell[TextData[ButtonBox["Diagonal",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Diagonal"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " extract the diagonal elements in a matrix"
}], "GuideText",
 CellID->71998224]
}, Open  ]],

Cell[CellGroupData[{

Cell["New List-Oriented Functional Programming", "GuideFunctionsSubsection",
 CellID->550901459],

Cell[TextData[{
 Cell[TextData[ButtonBox["LengthWhile",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LengthWhile"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TakeWhile",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TakeWhile"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->431010284]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 ButtonBox["List Manipulation in ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ListManipulation"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ListManipulation"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ListManipulation"]
}], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "GuideMoreAbout",
 CellID->335506323]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"New in 6.0: List Manipulation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 1.7047196}", "context" -> "", 
    "keywords" -> {
     "aggregating data", "array flatten", "array subscript", 
      "array subscripting", "bin counts", "bin lists", "binning", 
      "binning of data", "categorizing data", "category counts", 
      "catenating lists", "census", "changing parts", "concatenating lists", 
      "constant array", "density estimation", "dithering", 
      "equivalence class counting", "expressions", "flat list", 
      "flatten matrix", "frequencies", "gather", "histogram", "interleave", 
      "join block matrices", "join lists", "k-subsets", "length while", 
      "lists", "merging lists", "mode", "most frequent value", 
      "multiple parts", "multiplicities", "one-dimensional list", "padding", 
      "pad left", "pad right", "parts", "perm", "permutations of lists", 
      "permute", "random choice", "randomint", "random integer", 
      "random permutation", "random sample", "random selection", 
      "random subset", "range counts", "ravel in APL", "rearrangements", 
      "reordering of lists", "reorderings", "replacements", "replace part", 
      "sampling without replacement", "sampling with replacement", 
      "selecting objects with ordering", "select randomly", "slice", 
      "splicing", "squash", "statistical mode", "subexpressions", "sublists", 
      "subscript range", "subset permutations", "take while", "tally", 
      "unevaluated expressions", "unravel", "urn problem"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Widely recognized as the world's most powerful list manipulation \
language, Mathematica adds in Version 6.0 a number of important new \
functions. Each function is carefully designed for flexibility, ease of use, \
wide application and tight integration into the Mathematica system.", 
    "synonyms" -> {}, "title" -> "New in 6.0: List Manipulation", "type" -> 
    "Guide", "uri" -> "guide/NewIn60ListManipulation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 71, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[693, 28, 437, 13, 70, "GuideAbstract",
 CellID->408421374],
Cell[CellGroupData[{
Cell[1155, 45, 86, 1, 70, "GuideFunctionsSubsection",
 CellID->9508724],
Cell[1244, 48, 495, 13, 70, "GuideText",
 CellID->173361610],
Cell[1742, 63, 408, 12, 70, "GuideText",
 CellID->294573007]
}, Open  ]],
Cell[CellGroupData[{
Cell[2187, 80, 95, 1, 70, "GuideFunctionsSubsection",
 CellID->277755688],
Cell[2285, 83, 406, 12, 70, "GuideText",
 CellID->22655321],
Cell[2694, 97, 765, 21, 70, "GuideText",
 CellID->75625251]
}, Open  ]],
Cell[CellGroupData[{
Cell[3496, 123, 90, 1, 70, "GuideFunctionsSubsection",
 CellID->212409270],
Cell[3589, 126, 418, 12, 70, "GuideText",
 CellID->118494465],
Cell[4010, 140, 698, 19, 70, "GuideText",
 CellID->355285909],
Cell[4711, 161, 696, 19, 70, "GuideText",
 CellID->513354764],
Cell[5410, 182, 413, 12, 70, "GuideText",
 CellID->126730402]
}, Open  ]],
Cell[CellGroupData[{
Cell[5860, 199, 105, 2, 70, "GuideFunctionsSubsection",
 CellID->536121932],
Cell[5968, 203, 254, 8, 70, "GuideText",
 CellID->30456809],
Cell[6225, 213, 401, 12, 70, "GuideText",
 CellID->218527675],
Cell[6629, 227, 329, 10, 70, "GuideText",
 CellID->400509194],
Cell[6961, 239, 407, 12, 70, "GuideText",
 CellID->203374175],
Cell[7371, 253, 331, 10, 70, "GuideText",
 CellID->159695572]
}, Open  ]],
Cell[CellGroupData[{
Cell[7739, 268, 97, 1, 70, "GuideFunctionsSubsection",
 CellID->164806735],
Cell[7839, 271, 415, 12, 70, "GuideText",
 CellID->60189766],
Cell[8257, 285, 308, 10, 70, "GuideText",
 CellID->46834159],
Cell[8568, 297, 293, 10, 70, "GuideText",
 CellID->313984770],
Cell[8864, 309, 444, 14, 70, "GuideText",
 CellID->239565585],
Cell[9311, 325, 303, 10, 70, "GuideText",
 CellID->271372573],
Cell[9617, 337, 409, 11, 70, "GuideText",
 CellID->71998224]
}, Open  ]],
Cell[CellGroupData[{
Cell[10063, 353, 96, 1, 70, "GuideFunctionsSubsection",
 CellID->550901459],
Cell[10162, 356, 694, 17, 70, "InlineGuideFunctionListing",
 CellID->431010284]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10905, 379, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[10970, 382, 375, 12, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[11348, 396, 161, 3, 70, "GuideMoreAbout",
 CellID->335506323]
}, Open  ]],
Cell[11524, 402, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

