(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14962,        456]
NotebookOptionsPosition[     10564,        341]
NotebookOutlinePosition[     13005,        391]
CellTagsIndexPosition[     12962,        388]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["New in 6.0: Matrix & Linear Algebra Functions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Version 6.0 continues ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s commitment to delivering the latest and most efficient algorithms for \
linear algebra, generalized to arbitrary precision and with full symbolic \
capability. A notable feature is that the symbolic structure of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes possible uniquely flexible specifications for general banded \
matrices."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["New Matrix Structure Functions", "GuideFunctionsSubsection",
 CellID->5044976],

Cell[TextData[{
 Cell[TextData[ButtonBox["Span",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Span"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " (",
 Cell[TextData[ButtonBox[";;",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Span"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " extract sequences and sub-blocks from vectors and matrices"
}], "GuideText",
 CellID->275740365],

Cell[TextData[{
 Cell[TextData[ButtonBox["Band",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Band"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolically specify generalized banded matrix structures"
}], "GuideText",
 CellID->3541816],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayFlatten",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " generalized block-matrix constructor"
}], "GuideText",
 CellID->358742630],

Cell[TextData[{
 Cell[TextData[ButtonBox["Diagonal",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Diagonal"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "extract the diagonal of a matrix"
}], "GuideText",
 CellID->75009885],

Cell[TextData[{
 Cell[TextData[ButtonBox["HermitianMatrixQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HermitianMatrixQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PositiveDefiniteMatrixQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PositiveDefiniteMatrixQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->7493751]
}, Open  ]],

Cell[CellGroupData[{

Cell["New in Matrix Operations", "GuideFunctionsSubsection",
 CellID->198076066],

Cell[TextData[{
 Cell[TextData[ButtonBox["LeastSquares",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LeastSquares"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solve linear least squares problems given in matrix form"
}], "GuideText",
 CellID->364795175],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixExp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixExp"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MatrixPower",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixPower"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now allow application to a vector"
}], "GuideText",
 CellID->639002670],

Cell[TextData[{
 Cell[TextData[ButtonBox["HermiteDecomposition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HermiteDecomposition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Hermite normal form of a matrix"
}], "GuideText",
 CellID->163380791]
}, Open  ]],

Cell[CellGroupData[{

Cell["New Vector Space Functions", "GuideFunctionsSubsection",
 CellID->116799557],

Cell[TextData[{
 Cell[TextData[ButtonBox["Normalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Normalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Orthogonalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Orthogonalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Projection",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Projection"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UnitVector",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/UnitVector"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ConstantArray",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ConstantArray"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->186275040]
}, Open  ]],

Cell[CellGroupData[{

Cell["New Special Matrices", "GuideFunctionsSubsection",
 CellID->85132346],

Cell[TextData[{
 Cell[TextData[ButtonBox["HilbertMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HilbertMatrix"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HankelMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HankelMatrix"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ToeplitzMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToeplitzMatrix"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DiagonalMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DiagonalMatrix"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"]
}], "InlineGuideFunctionListing",
 CellID->289569622]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Geometric Transformations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GeometricTransforms"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->230854708],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotationMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ShearingMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ShearingMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AffineTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AffineTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GeometricTransforms"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->240054275]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Solving Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingLinearSystems"]], "GuideTutorial",
 CellID->119754687],

Cell[TextData[ButtonBox["Basic Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicMatrixOperations"]], "GuideTutorial",
 CellID->122013290],

Cell[TextData[ButtonBox["Matrix Inversion",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MatrixInversion"]], "GuideTutorial",
 CellID->727742971],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "GuideTutorial",
 CellID->859376041]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MathematicsAndAlgorithms"]], "GuideMoreAbout",
 CellID->270774093]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"New in 6.0: Matrix & Linear Algebra Functions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 7.8455018}", "context" -> "", 
    "keywords" -> {
     "affine transform", "affine transformation", "array flatten", 
      "array subscript", "array subscripting", "constant array", 
      "direction vector", "exponentials of matrices", "extended GCD", 
      "flat list", "flatten matrix", 
      "fundamental solution of difference equations", "Gram-Schmidt", 
      "Hermite decomposition", "Hermitian matrix", "inverse matrix power", 
      "join block matrices", "join lists", "Jordan decomposition", 
      "least-squares", "least squares", "length of vector", 
      "linear Diophantine equations", "matrix exp", "matrix exponential", 
      "matrix function", "matrix power", "modified Gram-Schmidt", 
      "normalized vector", "normalize vector", "one-dimensional list", 
      "orthogonalization", "orthonormal basis", "orthonormal matrix", 
      "positive definite matrix", "powers of matrices", 
      "project vector onto vector", "Putzer's method", "rotation matrix", 
      "shearing matrix", "slice", "subscript range", "unitary matrix", 
      "unit vector", "vector projection", "vector space projection"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Version 6.0 continues Mathematica's commitment to delivering the latest \
and most efficient algorithms for linear algebra, generalized to arbitrary \
precision and with full symbolic capability. A notable feature is that the \
symbolic structure of Mathematica makes possible uniquely flexible \
specifications for general banded matrices.", "synonyms" -> {}, "title" -> 
    "New in 6.0: Matrix & Linear Algebra Functions", "type" -> "Guide", "uri" -> 
    "guide/NewIn60MatrixAndLinearAlgebraFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 87, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[709, 28, 485, 12, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1219, 44, 84, 1, 70, "GuideFunctionsSubsection",
 CellID->5044976],
Cell[1306, 47, 542, 16, 70, "GuideText",
 CellID->275740365],
Cell[1851, 65, 421, 12, 70, "GuideText",
 CellID->3541816],
Cell[2275, 79, 413, 11, 70, "GuideText",
 CellID->358742630],
Cell[2691, 92, 405, 12, 70, "GuideText",
 CellID->75009885],
Cell[3099, 106, 440, 11, 70, "InlineGuideFunctionListing",
 CellID->7493751]
}, Open  ]],
Cell[CellGroupData[{
Cell[3576, 122, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->198076066],
Cell[3659, 125, 438, 12, 70, "GuideText",
 CellID->364795175],
Cell[4100, 139, 445, 14, 70, "GuideText",
 CellID->639002670],
Cell[4548, 155, 429, 12, 70, "GuideText",
 CellID->163380791]
}, Open  ]],
Cell[CellGroupData[{
Cell[5014, 172, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->116799557],
Cell[5099, 175, 1775, 44, 70, "InlineGuideFunctionListing",
 CellID->186275040]
}, Open  ]],
Cell[CellGroupData[{
Cell[6911, 224, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->85132346],
Cell[6989, 227, 907, 25, 70, "InlineGuideFunctionListing",
 CellID->289569622]
}, Open  ]],
Cell[CellGroupData[{
Cell[7933, 257, 238, 6, 70, "GuideFunctionsSubsection",
 CellID->230854708],
Cell[8174, 265, 1293, 32, 70, "InlineGuideFunctionListing",
 CellID->240054275]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9516, 303, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[9581, 306, 161, 3, 70, "GuideTutorial",
 CellID->119754687],
Cell[9745, 311, 163, 3, 70, "GuideTutorial",
 CellID->122013290],
Cell[9911, 316, 150, 3, 70, "GuideTutorial",
 CellID->727742971],
Cell[10064, 321, 169, 3, 70, "GuideTutorial",
 CellID->859376041]
}, Open  ]],
Cell[CellGroupData[{
Cell[10270, 329, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[10335, 332, 187, 4, 70, "GuideMoreAbout",
 CellID->270774093]
}, Open  ]],
Cell[10537, 339, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

