(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16828,        478]
NotebookOptionsPosition[     11836,        361]
NotebookOutlinePosition[     15119,        421]
CellTagsIndexPosition[     15076,        418]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["New in 6.0: Numerical Data Handling", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Version 6.0",
 StyleBox[" ",
  FontSlant->"Italic"],
 "adds a collection of carefully optimized functions to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s powerful arsenal of numerical handling capabilities. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["New List-Manipulation Functions", "GuideFunctionsSubsection",
 CellID->25716586],

Cell[TextData[{
 Cell[TextData[ButtonBox["Span",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Span"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " (",
 Cell[TextData[ButtonBox[";;",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Span"]], "InlineFunctionSans"],
 ") \[LongDash] conveniently pick out sequences and sub-blocks from data"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Accumulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Accumulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Differences",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Differences"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Riffle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Riffle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArrayFlatten",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->232222617]
}, Open  ]],

Cell[CellGroupData[{

Cell["New List Analysis Functions", "GuideFunctionsSubsection",
 CellID->400725620],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["BinLists",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinLists"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "count, list elements in particular collections or ranges"
}], "GuideText",
 CellID->140844160]
}, Open  ]],

Cell[CellGroupData[{

Cell["New Data-Handling Functions", "GuideFunctionsSubsection",
 CellID->350520814],

Cell[TextData[{
 Cell[TextData[ButtonBox["MovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MovingMedian",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingMedian"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExponentialMovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExponentialMovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LeastSquares",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LeastSquares"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->685226199],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindFit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindFit"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now supports constrained nonlinear fitting"
}], "GuideText",
 CellID->177737878],

Cell[TextData[{
 Cell[TextData[ButtonBox["FourierDCT",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FourierDCT"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["FourierDST",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FourierDST"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " discrete Fourier transforms"
}], "GuideText",
 CellID->372219011]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Built-in Statistics Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60Statistics"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->532873064],

Cell[TextData[{
 Cell[TextData[ButtonBox["Commonest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Commonest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeanDeviation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MeanDeviation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Skewness",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Skewness"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Kurtosis",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Kurtosis"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExpectedValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExpectedValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60Statistics"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->800684357]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Exploratory Data Analysis \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DataClassification"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->618694587],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NearestFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NearestFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EuclideanDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EuclideanDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataClassification"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->245546090]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "GuideTutorial",
 CellID->30877],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "GuideTutorial",
 CellID->20424]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "GuideMoreAbout",
 CellID->712037839],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60DataHandlingAndDataSources"]], "GuideMoreAbout",
 CellID->681676655]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"New in 6.0: Numerical Data Handling - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 9.8768038}", "context" -> "", 
    "keywords" -> {
     "agglomeration", "aggregating data", "approximation of functions", 
      "array flatten", "array subscript", "array subscripting", "asymmetry", 
      "Be'zier curve", "bilinear interpolation", "bin counts", "bin lists", 
      "binning", "binning of data", "b-spline", "b spline", 
      "categorizing data", "category counts", "census", "cluster", 
      "cluster analysis", "clustering", "clustering of data", "cubic spline", 
      "curve fitting", "curves", "data filter", "data filtering", 
      "data smoother", "data smoothing", "density estimation", "dispersion", 
      "EMA", "equivalence class counting", "Euclidean distance", 
      "Euclidean norm", "EWMA", "expectation", "expected value", 
      "exponential moving average", "exponential smoother", 
      "exponential smoothing", "exponential weighted moving average", 
      "extrapolation", "filter taps", "find clusters", "find fit", 
      "finite impulse response filter", "FIR filter", "Fisher kurtosis", 
      "Fisher's kurtosis", "fits", "fitting curves", 
      "fitting differential equations", "fitting surfaces", "flat list", 
      "flatten matrix", "frequencies", "gather", "grouping of data", 
      "heavy tails", "histogram", "interleave", "interp", "interpolate data", 
      "interpolate equation", "interpolate formula", "interpolate numbers", 
      "interpolate table", "join block matrices", "join lists", "kurtosis", 
      "kurtosis excess", "least-squares", "least squares", 
      "least-squares fits", "linear interpolation", "linear moving average", 
      "long tails", "MA", "mean deviation", "mode", "most frequent value", 
      "moving average", "moving mean", "moving median", "multiplicities", 
      "nearest function", "nonlinear fitting", "one-dimensional list", 
      "partitioning of data", "polynomial fit", "range counts", "residuals", 
      "robust estimates", "robust estimation", "shape", "shape statistic", 
      "simple moving average", "skew", "slice", "SMA", "splines", 
      "statistical expectation", "statistical mode", "subscript range", 
      "tally", "testing models", "trend line", "weighted moving average", 
      "WMA"}, "index" -> True, "label" -> "Mathematica Guide", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Version 6.0 adds a collection of carefully optimized functions to \
Mathematica's powerful arsenal of numerical handling capabilities. ", 
    "synonyms" -> {}, "title" -> "New in 6.0: Numerical Data Handling", 
    "type" -> "Guide", "uri" -> "guide/NewIn60NumericalDataHandling"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 77, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[699, 28, 280, 9, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1004, 41, 86, 1, 70, "GuideFunctionsSubsection",
 CellID->25716586],
Cell[1093, 44, 500, 13, 70, "GuideText",
 CellID->203374175],
Cell[1596, 59, 1753, 44, 70, "InlineGuideFunctionListing",
 CellID->232222617]
}, Open  ]],
Cell[CellGroupData[{
Cell[3386, 108, 83, 1, 70, "GuideFunctionsSubsection",
 CellID->400725620],
Cell[3472, 111, 704, 19, 70, "GuideText",
 CellID->140844160]
}, Open  ]],
Cell[CellGroupData[{
Cell[4213, 135, 83, 1, 70, "GuideFunctionsSubsection",
 CellID->350520814],
Cell[4299, 138, 1450, 35, 70, "InlineGuideFunctionListing",
 CellID->685226199],
Cell[5752, 175, 317, 10, 70, "GuideText",
 CellID->177737878],
Cell[6072, 187, 676, 18, 70, "GuideText",
 CellID->372219011]
}, Open  ]],
Cell[CellGroupData[{
Cell[6785, 210, 240, 6, 70, "GuideFunctionsSubsection",
 CellID->532873064],
Cell[7028, 218, 1981, 50, 70, "InlineGuideFunctionListing",
 CellID->800684357]
}, Open  ]],
Cell[CellGroupData[{
Cell[9046, 273, 237, 6, 70, "GuideFunctionsSubsection",
 CellID->618694587],
Cell[9286, 281, 1645, 41, 70, "InlineGuideFunctionListing",
 CellID->245546090]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10980, 328, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[11045, 331, 146, 3, 70, "GuideTutorial",
 CellID->30877],
Cell[11194, 336, 158, 3, 70, "GuideTutorial",
 CellID->20424]
}, Open  ]],
Cell[CellGroupData[{
Cell[11389, 344, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[11454, 347, 144, 3, 70, "GuideMoreAbout",
 CellID->712037839],
Cell[11601, 352, 193, 4, 70, "GuideMoreAbout",
 CellID->681676655]
}, Open  ]],
Cell[11809, 359, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

