(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42654,       1215]
NotebookOptionsPosition[     32998,        998]
NotebookOutlinePosition[     38812,       1094]
CellTagsIndexPosition[     38769,       1091]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["New in 6.0: Visualization & Graphics", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Version 6.0 represents a major step forward in visualization and graphics, \
with many new and original concepts. Among them is full integration of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbolic graphics with all input and output, immediate real-time graphics, \
automatic adaptivity throughout, and widespread use of automated aesthetics \
methods pioneered at Wolfram Research. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New in Data Visualization \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60DataVisualization"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->380224547],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 ", ",
 Cell[TextData[ButtonBox["ListLinePlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListLinePlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " support multiple datasets"
}], "GuideText",
 CellID->4031009],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListContourPlot"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ListPlot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot3D"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60DataVisualization"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now support irregular data"
}], "GuideText",
 CellID->291000225],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListLogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListLogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListPolarPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListSurfacePlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListSurfacePlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListContourPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListContourPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60DataVisualization"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->267604884],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReliefPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ReliefPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "relief plots"
}], "GuideText",
 CellID->66532567],

Cell[TextData[{
 Cell[TextData[ButtonBox["DateListPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DateListPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " date and time plots"
}], "GuideText",
 CellID->345292699],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["TreePlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TreePlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " graph and tree drawing"
}], "GuideText",
 CellID->279347302]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New in Function Visualization \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60FunctionVisualization"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->385480071],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RegionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot inequalities"
}], "GuideText",
 CellID->153631937],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContourPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot 3D contour levels"
}], "GuideText",
 CellID->686035036],

Cell[TextData[{
 Cell[TextData[ButtonBox["Plot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plot3D"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourPlot"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60FunctionVisualization"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now fully adaptive"
}], "GuideText",
 CellID->8997535],

Cell[TextData[{
 Cell[TextData[ButtonBox["LogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolarPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolarPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RevolutionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60FunctionVisualization"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->308618729]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New in Dynamic Visualization \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DynamicVisualization"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->768618931],

Cell[TextData[{
 Cell[TextData[ButtonBox["Animate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Animate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListAnimate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListAnimate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ControllerManipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerManipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DynamicVisualization"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->254799023]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New in Dynamic Graphics Annotation \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ViewersAndAnnotation"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->591689697],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tooltip",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tooltip"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mouseover",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Mouseover"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Annotation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Annotation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PopupWindow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupWindow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TabView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TabView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ViewersAndAnnotation"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->46024089]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Interactive Drawing & Graphics Editing \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsInteractivityAndDrawing"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->123112482],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["D", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " bring up the ",
 StyleBox["Drawing Tools", "DialogElementName"],
 " palette"
}], "GuideText",
 CellID->16060],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["G", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " bring up the Graphics Inspector"
}], "GuideText",
 CellID->206584097],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell["New in Symbolic Graphics", "GuideFunctionsSubsection",
 CellID->188314883],

Cell[TextData[{
 Cell[TextData[ButtonBox["Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Graphics"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Graphics3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Graphics3D"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now display inline in output, and can be input"
}], "GuideText",
 CellID->171015901],

Cell[TextData[{
 Cell[TextData[ButtonBox["Graphics3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Graphics3D"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " now supports full real-time rotation etc."
}], "GuideText",
 CellID->413959893],

Cell[TextData[{
 StyleBox[ButtonBox["Graphics \[FilledRightTriangle]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsMenu"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " interactive drawing tools and interactive graphics inspector"
}], "GuideText",
 CellID->366140279],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphicsGrid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphicsRow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsRow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphicsColumn",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsColumn"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->889729365]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Graphics Primitives & Directives \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->313195518],

Cell[TextData[{
 Cell[TextData[ButtonBox["Arrow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Arrow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sphere",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Sphere"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cylinder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Cylinder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Inset",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Inset"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphicsComplex",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->61168682],

Cell[TextData[{
 Cell[TextData[ButtonBox["Opacity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Opacity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "transparency in 2D and 3D"
}], "GuideText",
 CellID->81022694],

Cell[TextData[{
 Cell[TextData[ButtonBox["Blend",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Blend"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Lighter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Lighter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Darker",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Darker"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Glow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Glow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Specularity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Specularity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->147576741],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ColorData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "hundreds of color schemes and properties"
}], "GuideText",
 CellID->255168518]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Geometric Transformations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GeometricTransforms"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->16050539],

Cell[TextData[{
 Cell[TextData[ButtonBox["Translate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Translate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Scale",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Scale"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rotate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Rotate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GeometricTransformation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GeometricTransformation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GeometricTransforms"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->304375768],

Cell["\t", "GuideDelimiterSubsection",
 CellID->667356852]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New Graphics & Visualization Options \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->335979371],

Cell[TextData[{
 Cell[TextData[ButtonBox["Filling",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Filling"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PlotMarkers",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PlotMarkers"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Exclusions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Exclusions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RegionFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeshFunctions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MeshFunctions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ContourLabels",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ContourLabels"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NormalsFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NormalsFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PerformanceGoal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BaselinePosition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BaselinePosition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->215124515],

Cell["\t", "GuideDelimiterSubsection",
 CellID->6867195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New in Graphics Import & Export \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsImportingAndExporting"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->298473564],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " new framework for different parts and views of data "
}], "GuideText",
 CellID->415045959],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"FLV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FLV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"SWF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SWF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"PLY\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PLY"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"OFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/OFF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Maya\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Maya"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"ACO\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ACO"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"USGSDEM\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/USGSDEM"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rasterize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Rasterize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->220223095],

Cell["\t", "GuideDelimiterSubsection",
 CellID->167585443]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["New in Sound \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SoundAndSonification"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->241394817],

Cell[TextData[{
 Cell[TextData[ButtonBox["SoundNote",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SoundNote"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "full support for MIDI-style musical notes and structures"
}], "GuideText",
 CellID->59959290],

Cell[TextData[{
 Cell[TextData[ButtonBox["EmitSound",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EmitSound"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Play",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Play"]], "InlineFunctionSans"],
 " ",
 StyleBox["(modified)", "FunctionAnnotation"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Beep",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Beep"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"FLAC\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FLAC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MIDI\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MIDI"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SoundAndSonification"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->47974414]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Overview of Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/VisualizationAndGraphicsOverview"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Index of All New Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlphabeticalListing"]], "GuideMoreAboutSub",\

 CellID->582854384]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"New in 6.0: Visualization & Graphics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 12.6893758}", "context" -> "", 
    "keywords" -> {
     "3D graphics", "3D sphere", "affine transform", "align objects", 
      "alpha channel", "animate sequence of expressions", "animations", 
      "applets", "arrowhead", "audio", "AVI", "ball", "balloon help", 
      "baseline position", "bas-relief", "blend", "blending colors", 
      "Blinn shading", "click-interactive panels", "color blends", 
      "color data", "color gradients", "color interpolation", "color palette",
       "color space", "contour labels", "contour levels", "contour lines", 
      "contour plot", "contour plot 3D", "contour plots from lists", 
      "contour surface", "controller manipulate", "controls", "cylinder", 
      "darker", "date list plot", "date plotting", "digital elevation data", 
      "digraph layout", "direct manipulation", "double arrow", "draw a graph",
       "drawing", "drawing format", "DXF format", "edges", "embossing", 
      "emit sound", "encapsulated PostScript", "Excel format", 
      "exporting graphics", "exporting sounds", "ExpressionML", 
      "external data", "fill area", "financial plots", "gamepad", 
      "geometric transform", "geometric transformation", 
      "geometric transforms", "glow color", "Gouraud shading", 
      "graph drawing", "graph embedding", "graphical user interface", 
      "graphics", "graphics array", "graphics arrow", "graphics column", 
      "graphics complex", "graphics grid", "graphics primitives", 
      "graphics row", "graphics transformations", "graph layout", 
      "graph plot", "graph visualization", "GUI", "hierarchical graph layout",
       "image array", "image capture", "image processing", 
      "inset 3D graphics into graphics", "inset graphic into graphics", 
      "inset text into graphics", "interactive", "interactive panels", 
      "interchange format", "interface builder", "interpolation surface ", 
      "joystick", "lightening colors", "lighter", "light independent color", 
      "lighting", "lighting properties", "list animate", "list contour plot", 
      "list contour plot 3D", "list line plot", "list log plot", 
      "list of frames", "list plot3", "list polar plot", "lists", 
      "list surface plot 3D", "log-plot", "log plot", "make movie", 
      "material property", "mesh functions", "metallic color", 
      "metallic surface", "mixing colors", "mouse interactive", "mouse over", 
      "network layout", "network visualization", "normals function", 
      "objective goal", "opaque", "optimization for accuracy", 
      "optimization for speed", "optimization goal", "performance goal", 
      "picture array", "plastic color", "plastic surface", "plot markers", 
      "plot region", "plots of surfaces", "plotting in time", "plot volume", 
      "point plot", "polar plot", "polygon mesh", "popup box", "popup window",
       "processing images", "quality goal", "quality target", 
      "raster conversion", "reflection", "region function", "region plot", 
      "region plot3", "region plot 3D", "relief plot", "relief shading", 
      "revolution plot", "revolution plot3", "revolved surface", 
      "rotate graphics", "rotation matrix", "rotation transform", 
      "scalable vector graphics", "scale graphics", "scaling matrix", 
      "scaling transform", "scatter plot", "screen tip", "ScreenTip", 
      "semi-logarithmic", "semi-log plot", "semilog plot", "shaded surface", 
      "shading equation", "shading properties", "shininess", "single arrow", 
      "slider", "solid object modeling", "sounds", "spectrum", 
      "specular color", "specular exponent", "specular reflection", 
      "speed accuracy objective", "speed accuracy trade-off", "sphere", 
      "spherical plot3", "spherical plot 3D", "spreadsheets", 
      "stereo-lithography", "STL format", "surface data", "surface graphics", 
      "surface mesh", "surface of revolution", "surface patch", 
      "surface plot", "surface plots", "surface polygons", 
      "surface reflection", "surface triangulation", "SVG", "SymbolicXML", 
      "tab-delimited data", "tables", "tables of graphics", "tab selector", 
      "tabular data", "tab view", "tab view control", "terrain", 
      "terrain data", "three-dimensional", "three-dimensional graphics", 
      "three-dimensional plots", "time series plots", "transforming graphics",
       "translate graphics", "translation matrix", "translation transform", 
      "translucent", "transparent", "tree plot", "user interfaces", 
      "volume slice", "volumetric slice"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Version 6.0 represents a major step forward in visualization and \
graphics, with many new and original concepts. Among them is full integration \
of Mathematica symbolic graphics with all input and output, immediate \
real-time graphics, automatic adaptivity throughout, and widespread use of \
automated aesthetics methods pioneered at Wolfram Research. ", 
    "synonyms" -> {}, "title" -> "New in 6.0: Visualization & Graphics", 
    "type" -> "Guide", "uri" -> "guide/NewIn60VisualizationAndGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 78, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[700, 28, 458, 9, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1183, 41, 239, 6, 70, "GuideFunctionsSubsection",
 CellID->380224547],
Cell[1425, 49, 580, 17, 70, "GuideText",
 CellID->4031009],
Cell[2008, 68, 591, 19, 70, "GuideText",
 CellID->291000225],
Cell[2602, 89, 1668, 42, 70, "InlineGuideFunctionListing",
 CellID->267604884],
Cell[4273, 133, 389, 12, 70, "GuideText",
 CellID->66532567],
Cell[4665, 147, 396, 11, 70, "GuideText",
 CellID->345292699],
Cell[5064, 160, 665, 18, 70, "GuideText",
 CellID->279347302]
}, Open  ]],
Cell[CellGroupData[{
Cell[5766, 183, 247, 6, 70, "GuideFunctionsSubsection",
 CellID->385480071],
Cell[6016, 191, 675, 19, 70, "GuideText",
 CellID->153631937],
Cell[6694, 212, 406, 12, 70, "GuideText",
 CellID->686035036],
Cell[7103, 226, 569, 19, 70, "GuideText",
 CellID->8997535],
Cell[7675, 247, 1650, 42, 70, "InlineGuideFunctionListing",
 CellID->308618729]
}, Open  ]],
Cell[CellGroupData[{
Cell[9362, 294, 238, 6, 70, "GuideFunctionsSubsection",
 CellID->768618931],
Cell[9603, 302, 1641, 41, 70, "InlineGuideFunctionListing",
 CellID->254799023]
}, Open  ]],
Cell[CellGroupData[{
Cell[11281, 348, 244, 6, 70, "GuideFunctionsSubsection",
 CellID->591689697],
Cell[11528, 356, 1969, 50, 70, "InlineGuideFunctionListing",
 CellID->46024089]
}, Open  ]],
Cell[CellGroupData[{
Cell[13534, 411, 263, 6, 70, "GuideFunctionsSubsection",
 CellID->123112482],
Cell[13800, 419, 271, 10, 70, "GuideText",
 CellID->16060],
Cell[14074, 431, 231, 8, 70, "GuideText",
 CellID->206584097],
Cell[14308, 441, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[14403, 447, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->188314883],
Cell[14486, 450, 454, 14, 70, "GuideText",
 CellID->171015901],
Cell[14943, 466, 322, 10, 70, "GuideText",
 CellID->413959893],
Cell[15268, 478, 297, 8, 70, "GuideText",
 CellID->366140279],
Cell[15568, 488, 1065, 26, 70, "InlineGuideFunctionListing",
 CellID->889729365]
}, Open  ]],
Cell[CellGroupData[{
Cell[16670, 519, 264, 6, 70, "GuideFunctionsSubsection",
 CellID->313195518],
Cell[16937, 527, 1980, 51, 70, "InlineGuideFunctionListing",
 CellID->61168682],
Cell[18920, 580, 396, 12, 70, "GuideText",
 CellID->81022694],
Cell[19319, 594, 1969, 51, 70, "InlineGuideFunctionListing",
 CellID->147576741],
Cell[21291, 647, 416, 12, 70, "GuideText",
 CellID->255168518]
}, Open  ]],
Cell[CellGroupData[{
Cell[21744, 664, 237, 6, 70, "GuideFunctionsSubsection",
 CellID->16050539],
Cell[21984, 672, 1630, 41, 70, "InlineGuideFunctionListing",
 CellID->304375768],
Cell[23617, 715, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->667356852]
}, Open  ]],
Cell[CellGroupData[{
Cell[23712, 721, 264, 6, 70, "GuideFunctionsSubsection",
 CellID->335979371],
Cell[23979, 729, 3334, 84, 70, "InlineGuideFunctionListing",
 CellID->215124515],
Cell[27316, 815, 56, 1, 70, "GuideDelimiterSubsection",
 CellID->6867195]
}, Open  ]],
Cell[CellGroupData[{
Cell[27409, 821, 250, 6, 70, "GuideFunctionsSubsection",
 CellID->298473564],
Cell[27662, 829, 448, 14, 70, "GuideText",
 CellID->415045959],
Cell[28113, 845, 2037, 57, 70, "InlineGuideFunctionListing",
 CellID->220223095],
Cell[30153, 904, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->167585443]
}, Open  ]],
Cell[CellGroupData[{
Cell[30248, 910, 220, 5, 70, "GuideFunctionsSubsection",
 CellID->241394817],
Cell[30471, 917, 431, 12, 70, "GuideText",
 CellID->59959290],
Cell[30905, 931, 1571, 43, 70, "InlineGuideFunctionListing",
 CellID->47974414]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32525, 980, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[32590, 983, 189, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[32782, 989, 174, 4, 70, "GuideMoreAboutSub",
 CellID->582854384]
}, Open  ]],
Cell[32971, 996, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

