(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11718,        409]
NotebookOptionsPosition[      8581,        316]
NotebookOutlinePosition[      9850,        348]
CellTagsIndexPosition[      9807,        345]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Non-Printing Characters", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " includes a variety of non-printing characters, some used to fine-tune \
layout, and others used to define precise syntactic interpretations while \
maintaining the traditional look of various mathematical notations."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["Spacing Characters", "GuideFunctionsSubsection",
 CellID->375377852],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[ThickSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ThickSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[MediumSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/MediumSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[ThinSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ThinSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[VeryThinSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/VeryThinSpace"]], "InlineCharacterName"]
}], "InlineGuideFunctionListing",
 CellID->738475396],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[NegativeThinSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/NegativeThinSpace"]], 
  "InlineCharacterName", "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " \"negative space\" to bring objects closer together"
}], "GuideText",
 CellID->140498251],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[NegativeThickSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/NegativeThickSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[NegativeMediumSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/NegativeMediumSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[NegativeVeryThinSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/NegativeVeryThinSpace"]], 
  "InlineCharacterName"]
}], "InlineGuideFunctionListing",
 CellID->603585621],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[LetterSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/LetterSpace"]], "InlineCharacterName", 
  "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " an almost-invisible space treated as a letter, e.g. in a symbol name"
}], "GuideText",
 CellID->516328993],

Cell["\t", "GuideDelimiterSubsection",
 CellID->51674753]
}, Open  ]],

Cell[CellGroupData[{

Cell["Line-Breaking Control", "GuideFunctionsSubsection",
 CellID->540830619],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[NonBreakingSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/NonBreakingSpace"]], 
  "InlineCharacterName", "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " insert a space, but do not allow it to be at a line break"
}], "GuideText",
 CellID->317261949],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[NoBreak]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/NoBreak"]], "InlineCharacterName", 
  "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ensure that no line break occurs at this point"
}], "GuideText",
 CellID->608810945],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[IndentingNewLine]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/IndentingNewLine"]], 
  "InlineCharacterName", "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " insert a new line, with indentation on the next line"
}], "GuideText",
 CellID->200685723],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[DiscretionaryHyphen]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/DiscretionaryHyphen"]], 
  "InlineCharacterName", "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " hyphen to include only at a line break"
}], "GuideText",
 CellID->38416879]
}, Open  ]],

Cell[CellGroupData[{

Cell["Alignment Markers", "GuideFunctionsSubsection",
 CellID->564933562],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[AlignmentMarker]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/AlignmentMarker"]], 
  "InlineCharacterName", "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " represent a position that should be aligned in a grid"
}], "GuideText",
 CellID->367699794],

Cell["\t", "GuideDelimiterSubsection",
 CellID->349864518]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Invisible ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Syntax"
}], "GuideFunctionsSubsection",
 CellID->91926937],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[InvisibleSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/InvisibleSpace"]], "InlineCharacterName",
   "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " invisible character treated like a space in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax"
}], "GuideText",
 CellID->166540243],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[InvisibleComma]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/InvisibleComma"]], "InlineCharacterName",
   "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " invisible character treated like a comma"
}], "GuideText",
 CellID->94761017],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[InvisibleApplication]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/InvisibleApplication"]], 
  "InlineCharacterName", "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " invisible character making ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    RowBox[{
     StyleBox["f", "TI"], " ", 
     StyleBox["x", "TI"]}]], "InlineFormula"]], "InlineFormula"], 
   TraditionalForm]], "InlineMath"],
 " behave like ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]"}]], "InlineFormula"]], "InlineFormula"], 
   TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->464249887],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[ImplicitPlus]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ImplicitPlus"]], "InlineCharacterName", 
  "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " invisible character representing addition (e.g. in compound fractions)"
}], "GuideText",
 CellID->243070947],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[InvisiblePrefixScriptBase]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/InvisiblePrefixScriptBase"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[InvisiblePostfixScriptBase]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/InvisiblePostfixScriptBase"]], 
  "InlineCharacterName"]
}], "InlineGuideFunctionListing",
 CellID->631850351]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialCharacters"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Non-Printing Characters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 14.2519158}", "context" -> "", 
    "keywords" -> {
     "negative space", "negative spacing", "spacing", "tweaking spacing", 
      "typesetting"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "Mathematica includes a variety of non-printing characters, some used to \
fine-tune layout, and others used to define precise syntactic interpretations \
while maintaining the traditional look of various mathematical notations.", 
    "synonyms" -> {}, "title" -> "Non-Printing Characters", "type" -> "Guide",
     "uri" -> "guide/NonPrintingCharacters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[687, 28, 326, 7, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1038, 39, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->375377852],
Cell[1115, 42, 910, 27, 70, "InlineGuideFunctionListing",
 CellID->738475396],
Cell[2028, 71, 338, 10, 70, "GuideText",
 CellID->140498251],
Cell[2369, 83, 738, 23, 70, "InlineGuideFunctionListing",
 CellID->603585621],
Cell[3110, 108, 343, 10, 70, "GuideText",
 CellID->516328993],
Cell[3456, 120, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->51674753]
}, Open  ]],
Cell[CellGroupData[{
Cell[3550, 126, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->540830619],
Cell[3630, 129, 342, 10, 70, "GuideText",
 CellID->317261949],
Cell[3975, 141, 313, 10, 70, "GuideText",
 CellID->608810945],
Cell[4291, 153, 337, 10, 70, "GuideText",
 CellID->200685723],
Cell[4631, 165, 328, 10, 70, "GuideText",
 CellID->38416879]
}, Open  ]],
Cell[CellGroupData[{
Cell[4996, 180, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->564933562],
Cell[5072, 183, 336, 10, 70, "GuideText",
 CellID->367699794],
Cell[5411, 195, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->349864518]
}, Open  ]],
Cell[CellGroupData[{
Cell[5506, 201, 141, 6, 70, "GuideFunctionsSubsection",
 CellID->91926937],
Cell[5650, 209, 386, 13, 70, "GuideText",
 CellID->166540243],
Cell[6039, 224, 320, 10, 70, "GuideText",
 CellID->94761017],
Cell[6362, 236, 747, 23, 70, "GuideText",
 CellID->464249887],
Cell[7112, 261, 347, 10, 70, "GuideText",
 CellID->243070947],
Cell[7462, 273, 510, 15, 70, "InlineGuideFunctionListing",
 CellID->631850351]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8021, 294, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8086, 297, 153, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[8242, 302, 297, 9, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[8554, 314, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

