(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24871,        697]
NotebookOptionsPosition[     19747,        555]
NotebookOutlinePosition[     21906,        600]
CellTagsIndexPosition[     21863,        597]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Notebook Basics", "GuideTitle",
 CellID->26260],

Cell[TextData[{
 "From simple calculations to full publishable documents and sophisticated \
dynamic interfaces, everything you do with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s standard interactive interface is done in a notebook. Carefully designed \
to leverage familiar word-processing metaphors, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks are uniquely powerful computational documents\[LongDash]that \
support live computation, arbitrary dynamic interfaces, full typeset input, \
automatic code annotation, a complete high-level programmatic interface\
\[LongDash]and in all, thousands of carefully organized functions and \
options. "
}], "GuideAbstract",
 CellID->148883666],

Cell[TextData[{
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " do a computation"
}], "GuideText",
 CellID->2066723676],

Cell["\t", "GuideDelimiter",
 CellID->25314],

Cell[TextData[{
 StyleBox["F1", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " get information or help"
}], "GuideText",
 CellID->2024315954],

Cell["\t", "GuideDelimiterSubsection",
 CellID->17117],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Cell Groups and Outlining \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CellGroupsAndOutlining"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->700803684],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 CellMargins->{{37, 3}, {4, 4}},
 ImageSize->{427, 103},
 ImageMargins->0,
 CellID->1329491951],

Cell[TextData[{
 StyleBox["double-click a group bracket", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " open or close a cell group"
}], "GuideText",
 CellID->766314719],

Cell[TextData[{
 StyleBox["double-click cell brackets", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " close all other cells in a group"
}], "GuideText",
 CellID->992051174]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Managing Computations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ManagingComputationsInNotebooks"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->26792],

Cell[TextData[{
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[".", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " abort a computation"
}], "GuideText",
 CellID->341046110],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["L", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " copy input from above"
}], "GuideText",
 CellID->328116927]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Selecting and Typing \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SelectingAndTypingInNotebooks"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->14693],

Cell[TextData[{
 StyleBox["triple-click", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " select a function and its arguments"
}], "GuideText",
 CellID->2070670240],

Cell[TextData[{
 StyleBox["Subscript", "MenuName"],
 " (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Special Character",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/SpecialCharacter"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Convert to StandardForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ConvertTo"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Why the Coloring?",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/WhyTheColoring"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SelectingAndTypingInNotebooks"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->141833517]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Styling & Formatting \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NotebookFormattingAndStyling"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->10943],

Cell[TextData[{
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["7", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " text cell (with default stylesheet) (",
 StyleBox[ButtonBox["Format",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Style",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/menuitem/Style"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["...", "MenuName"],
 ")"
}], "GuideText",
 CellID->1782224045],

Cell[TextData[{
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["4", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " section-heading cell (with default stylesheet)"
}], "GuideText",
 CellID->737615959],

Cell[TextData[{
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " create a new cell of the same style"
}], "GuideText",
 CellID->1835812429],

Cell[TextData[{
 StyleBox[ButtonBox["Format \[FilledRightTriangle]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Stylesheet",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Stylesheet"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NotebookFormattingAndStyling"]
}], "InlineGuideFunctionListing",
 CellID->148509361]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics Operations", "GuideFunctionsSubsection",
 CellID->26957569],

Cell[TextData[{
 StyleBox["drag", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " rotate a 3D graphic"
}], "GuideText",
 CellID->567901892],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["D", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " open graphics drawing tools (",
 StyleBox[ButtonBox["Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Show Drawing Tools",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ShowDrawingTools"], "MenuName"],
 ")"
}], "GuideText",
 CellID->1309771576]
}, Open  ]],

Cell[CellGroupData[{

Cell["Global Notebook Operations", "GuideFunctionsSubsection",
 CellID->52321380],

Cell[TextData[{
 StyleBox[ButtonBox["Save As",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/SaveAs"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["HTML, etc.", "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Notebook History",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/NotebookHistory"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Check Spelling",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CheckSpelling"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Send To",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/SendTo"], "MenuName"]
}], "InlineGuideFunctionListing",
 CellID->241800053]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Notebook Environment Customization \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NotebookAndInterfaceCustomization"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->48652913],

Cell[TextData[{
 StyleBox[ButtonBox["Preferences",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Preferences"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Option Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/OptionInspector"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NotebookAndInterfaceCustomization"]
}], "InlineGuideFunctionListing",
 CellID->859066936]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->11385],

Cell[TextData[{
 ButtonBox["Notebooks as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"]
}], "GuideTutorial",
 CellID->186268048],

Cell[TextData[ButtonBox["Notebooks as Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NotebooksAsDocuments"]], "GuideTutorial",
 CellID->46208142]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->15144],

Cell[TextData[ButtonBox["Notebook Shortcuts",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookShortcuts"]], "GuideMoreAbout",
 CellID->25563],

Cell[TextData[ButtonBox["Graphics Drawing",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsInteractivityAndDrawing"]], "GuideMoreAbout",
 CellID->29561],

Cell[TextData[ButtonBox["Accessibility",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Accessibility"]], "GuideMoreAboutSub",
 CellID->12946],

Cell[TextData[ButtonBox["International Character Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InternationalCharacterSets"]], "GuideMoreAboutSub",\

 CellID->1332054554],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialCharacters"]], "GuideMoreAboutSub",
 CellID->323869103],

Cell[TextData[ButtonBox["Menu Items",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MenuItems"]], "GuideMoreAboutSub",
 CellID->33693614],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "GuideMoreAbout",
 CellID->857364543]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Notebook Basics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 15.1581890}", "context" -> "", 
    "keywords" -> {
     "getting help", "text cell", "input cell", "cell labels", "output", 
      "output cell", "cell brackets", "cell groups", "group brackets", 
      "open group", "close group", "stop computation", "stop calculation", 
      "terminate computation", "text style", "special characters", 
      "cell style", "convert to style", "syntax coloring", "graphics tools", 
      "drawing tools", "drawing palette", "dragging graphics", 
      "rotating graphics", "notebook history", "start evaluation", 
      "evaluate input", "set preferences", "set options", "options inspector",
       "edit preferences", "edit options", "check spelling", 
      "document authoring"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "From simple calculations to full publishable documents and sophisticated \
dynamic interfaces, everything you do with Mathematica's standard interactive \
interface is done in a notebook. Carefully designed to leverage familiar \
word-processing metaphors, Mathematica notebooks are uniquely powerful \
computational documents--that support live computation, arbitrary dynamic \
interfaces, full typeset input, automatic code annotation, a complete \
high-level programmatic interface--and in all, thousands of carefully \
organized functions and options. ", "synonyms" -> {}, "title" -> 
    "Notebook Basics", "type" -> "Guide", "uri" -> "guide/NotebookBasics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 53, 1, 70, "GuideTitle",
 CellID->26260],
Cell[675, 28, 718, 15, 70, "GuideAbstract",
 CellID->148883666],
Cell[1396, 45, 222, 8, 70, "GuideText",
 CellID->2066723676],
Cell[1621, 55, 44, 1, 70, "GuideDelimiter",
 CellID->25314],
Cell[1668, 58, 157, 6, 70, "GuideText",
 CellID->2024315954],
Cell[1828, 66, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->17117],
Cell[CellGroupData[{
Cell[1907, 71, 237, 6, 70, "GuideFunctionsSubsection",
 CellID->700803684],
Cell[2147, 79, 8294, 139, 70, "Picture",
 CellID->1329491951],
Cell[10444, 220, 189, 6, 70, "GuideText",
 CellID->766314719],
Cell[10636, 228, 193, 6, 70, "GuideText",
 CellID->992051174]
}, Open  ]],
Cell[CellGroupData[{
Cell[10866, 239, 236, 5, 70, "GuideFunctionsSubsection",
 CellID->26792],
Cell[11105, 246, 218, 8, 70, "GuideText",
 CellID->341046110],
Cell[11326, 256, 221, 8, 70, "GuideText",
 CellID->328116927]
}, Open  ]],
Cell[CellGroupData[{
Cell[11584, 269, 233, 5, 70, "GuideFunctionsSubsection",
 CellID->14693],
Cell[11820, 276, 183, 6, 70, "GuideText",
 CellID->2070670240],
Cell[12006, 284, 1075, 33, 70, "InlineGuideFunctionListing",
 CellID->141833517]
}, Open  ]],
Cell[CellGroupData[{
Cell[13118, 322, 232, 5, 70, "GuideFunctionsSubsection",
 CellID->10943],
Cell[13353, 329, 618, 18, 70, "GuideText",
 CellID->1782224045],
Cell[13974, 349, 245, 8, 70, "GuideText",
 CellID->737615959],
Cell[14222, 359, 239, 8, 70, "GuideText",
 CellID->1835812429],
Cell[14464, 369, 589, 17, 70, "InlineGuideFunctionListing",
 CellID->148509361]
}, Open  ]],
Cell[CellGroupData[{
Cell[15090, 391, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->26957569],
Cell[15167, 394, 158, 6, 70, "GuideText",
 CellID->567901892],
Cell[15328, 402, 537, 16, 70, "GuideText",
 CellID->1309771576]
}, Open  ]],
Cell[CellGroupData[{
Cell[15902, 423, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->52321380],
Cell[15986, 426, 901, 25, 70, "InlineGuideFunctionListing",
 CellID->241800053]
}, Open  ]],
Cell[CellGroupData[{
Cell[16924, 456, 256, 6, 70, "GuideFunctionsSubsection",
 CellID->48652913],
Cell[17183, 464, 595, 17, 70, "InlineGuideFunctionListing",
 CellID->859066936]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17827, 487, 58, 1, 70, "GuideTutorialsSection",
 CellID->11385],
Cell[17888, 490, 436, 12, 70, "GuideTutorial",
 CellID->186268048],
Cell[18327, 504, 160, 3, 70, "GuideTutorial",
 CellID->46208142]
}, Open  ]],
Cell[CellGroupData[{
Cell[18524, 512, 59, 1, 70, "GuideMoreAboutSection",
 CellID->15144],
Cell[18586, 515, 148, 3, 70, "GuideMoreAbout",
 CellID->25563],
Cell[18737, 520, 163, 4, 70, "GuideMoreAbout",
 CellID->29561],
Cell[18903, 526, 142, 3, 70, "GuideMoreAboutSub",
 CellID->12946],
Cell[19048, 531, 177, 4, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[19228, 537, 155, 3, 70, "GuideMoreAboutSub",
 CellID->323869103],
Cell[19386, 542, 138, 3, 70, "GuideMoreAboutSub",
 CellID->33693614],
Cell[19527, 547, 178, 3, 70, "GuideMoreAbout",
 CellID->857364543]
}, Open  ]],
Cell[19720, 553, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

