(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29312,        832]
NotebookOptionsPosition[     20385,        627]
NotebookOutlinePosition[     25987,        723]
CellTagsIndexPosition[     25944,        720]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Number Theoretic Functions", "GuideTitle",
 CellID->20308],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " contains the world's largest collection of number theoretic functions, \
many based on specially developed algorithms. "
}], "GuideAbstract",
 CellID->12157],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Primes and their Distribution \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PrimeNumbers"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->4074],

Cell[TextData[{
 Cell[TextData[ButtonBox["Prime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Prime"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " prime"
}], "GuideText",
 CellID->4346],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrimeQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " test for primality"
}], "GuideText",
 CellID->13837],

Cell[TextData[{
 Cell[TextData[ButtonBox["NextPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NextPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrimePi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrimePi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogIntegral",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogIntegral"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Zeta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Zeta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ZetaZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ZetaZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->1981]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integer Factorization", "GuideFunctionsSubsection",
 CellID->25318],

Cell[TextData[{
 Cell[TextData[ButtonBox["FactorInteger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorInteger"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find the factors of an integer"
}], "GuideText",
 CellID->26611],

Cell[TextData[{
 Cell[TextData[ButtonBox["SquareFreeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SquareFreeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrimePowerQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PrimePowerQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->91039275]
}, Open  ]],

Cell[CellGroupData[{

Cell["Divisibility", "GuideFunctionsSubsection",
 CellID->16292],

Cell[TextData[{
 Cell[TextData[ButtonBox["GCD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GCD"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LCM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LCM"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Divisible",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Divisible"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CoprimeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CoprimeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExtendedGCD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExtendedGCD"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->17591],

Cell[TextData[{
 Cell[TextData[ButtonBox["EulerPhi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EulerPhi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MoebiusMu",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MoebiusMu"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiSymbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiSymbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KroneckerSymbol",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KroneckerSymbol"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->3832]
}, Open  ]],

Cell[CellGroupData[{

Cell["Congruences", "GuideFunctionsSubsection",
 CellID->27123],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PowerMod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PowerMod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MultiplicativeOrder",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MultiplicativeOrder"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrimitiveRoot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PrimitiveRoot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChineseRemainder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChineseRemainder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PowerModList",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PowerModList"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CarmichaelLambda",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CarmichaelLambda"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6461]
}, Open  ]],

Cell[CellGroupData[{

Cell["Divisors", "GuideFunctionsSubsection",
 CellID->16991],

Cell[TextData[{
 Cell[TextData[ButtonBox["Divisors",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Divisors"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DivisorSigma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DivisorSigma"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DedekindEta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DedekindEta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticTheta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticTheta"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->31461]
}, Open  ]],

Cell[CellGroupData[{

Cell["Partitions", "GuideFunctionsSubsection",
 CellID->27330],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerPartitions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PartitionsP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PartitionsP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StirlingS1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StirlingS1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StirlingS2",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StirlingS2"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BellB",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BellB"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FrobeniusNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FrobeniusNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->28498]
}, Open  ]],

Cell[CellGroupData[{

Cell["Representations as Sums of Powers", "GuideFunctionsSubsection",
 CellID->498607189],

Cell[TextData[{
 Cell[TextData[ButtonBox["SquaresR",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SquaresR"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PowersRepresentations",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PowersRepresentations"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticTheta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticTheta"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->45394729]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Digit Representations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumberDigits"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->17369],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FromDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DigitCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DigitCount"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerExponent"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->17291]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analytic Number Theory", "GuideFunctionsSubsection",
 CellID->67778232],

Cell[TextData[{
 Cell[TextData[ButtonBox["Zeta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Zeta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RiemannSiegelZ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RiemannSiegelZ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RiemannSiegelTheta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RiemannSiegelTheta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LerchPhi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LerchPhi"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->77796261],

Cell[TextData[{
 Cell[TextData[ButtonBox["RamanujanTau",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RamanujanTau"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RamanujanTauL",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RamanujanTauL"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RamanujanTauTheta",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RamanujanTauTheta"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RamanujanTauZ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RamanujanTauZ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->292546494]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Algebraic Number Theory \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AlgebraicNumberTheory"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->27146498],

Cell[TextData[{
 Cell[TextData[ButtonBox["AlgebraicNumberNorm",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicNumberNorm"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberFieldDiscriminant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldDiscriminant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->375456109]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->8400],

Cell[TextData[ButtonBox["Integer and Number-Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->14179],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "GuideTutorial",
 CellID->24117],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->226071423]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->2317],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "GuideMoreAbout",
 CellID->19914],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "GuideMoreAbout",
 CellID->1595],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "GuideMoreAboutSub",
 CellID->5936],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "GuideMoreAboutSub",
 CellID->21867],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "GuideMoreAboutSub",
 CellID->202435821],

Cell[TextData[ButtonBox["Zeta Functions & Polylogarithms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ZetaFunctionsAndPolylogarithms"]], "GuideMoreAboutSub",
 CellID->22926366],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->200610818],

Cell[TextData[{
 ButtonBox["Demonstrations related to Number Theoretic Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22number+theory%22+content%3AAlgebraicNumberNorm+OR+BellB+OR+CarmichaelLambda+\
OR+ChineseRemainder+OR+CoprimeQ+OR+DedekindEta+OR+DigitCount+OR+Divisible+OR+\
Divisors+OR+DivisorSigma+OR+EllipticTheta+OR+EulerPhi+OR+ExtendedGCD+OR+\
FactorInteger+OR+FrobeniusNumber+OR+FromDigits+OR+GCD+OR+IntegerDigits+OR+\
IntegerExponent+OR+IntegerPartitions+OR+JacobiSymbol+OR+KroneckerSymbol+OR+\
LCM+OR+LerchPhi+OR+LogIntegral+OR+Mod+OR+MoebiusMu+OR+MultiplicativeOrder+OR+\
NextPrime+OR+NumberFieldDiscriminant+OR+PartitionsP+OR+PowerMod+OR+\
PowerModList+OR+PowersRepresentations+OR+Prime+OR+PrimePi+OR+PrimePowerQ+OR+\
PrimeQ+OR+PrimitiveRoot+OR+RamanujanTau+OR+RamanujanTauL+OR+RamanujanTauTheta+\
OR+RamanujanTauZ+OR+RiemannSiegelTheta+OR+RiemannSiegelZ+OR+SquareFreeQ+OR+\
SquaresR+OR+StirlingS1+OR+StirlingS2+OR+Zeta+OR+ZetaZero"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->25464186]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Number Theoretic Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 22.2052444}", "context" -> "", 
    "keywords" -> {
     "absolute value of algebraic number", "algebraic number invariant", 
      "algebraic number norm", "aliquant", "arrays", "bases", "binary digits",
       "bit count", "Carmichael lambda", "Catalan beta function", 
      "Chinese remainder", "common denominator", "congruence", "conversion", 
      "coprime", "count of digits", "cyclic indices", "decimal digits", 
      "decode", "decomposition into primes", "Dedekind elliptic function", 
      "Dedekind eta", "density of primes", "digit count", "digital sums", 
      "digits", "digits count", "Dirichlet L series", "discrete log", 
      "discrete logarithm", "distribution of primes", "divisibility", 
      "divisible numbers", "divisor function", "divisor sigma", 
      "double-periodic function", "egcd", "elliptic functions", 
      "elliptic theta", "encode", "enumeration of permutations", 
      "Euclidian algorithm", "Euclid's algorithm", "Euler phi", 
      "Euler totient", "Euler-Maclaurin summation", 
      "Euler's pentagonal formula", "extended Euclidean algorithm", 
      "extended GCD", "factoring", "factors", "factor integer", 
      "Fermi-Dirac integrals", "finite fields", "Frobenius number", 
      "from digits", "Gaussian integers", "GCD extension", "GCF", 
      "generalized zeta function", "greatest common divider", 
      "greatest common divisor", "greatest dividing exponent", 
      "group generator", "group order", "Hamming weight", 
      "Hardy-Ramanujan-Rademacher algorithm", "height", "hexadecimal digits", 
      "highest common factor", "Hurwitz zeta function", "ifact", "igcd", 
      "ilcm", "implode", "index function", "integer digits", 
      "integer exponent", "integer factoring", "integer partitions", 
      "integer representation", "inverses in finite fields", "irem", 
      "isprime", "Jacobi symbol", "Jacobi theta 1", "Jacobi theta 2", 
      "Jacobi theta 3", "Jacobi theta 4", "Kronecker symbol", 
      "Lagarias-Miller-Odlyzko algorithm", "least common multiple", 
      "least universal exponent", "Legendre symbol", "Lerch function Phi", 
      "Lerch phi", "Lerch transcendent", "li", "linear congruences", 
      "log integral", "logarithmic integral", "lowest common multiple", 
      "lowest terms", "L-series in number theory", "Lucas test", 
      "Miller-Rabin test", "mo\"bius", "Mo\"bius function", "modp", "mods", 
      "modular forms", "modular inverses", "modular powers", "modular root", 
      "modulo", "moebius", "Moebius function", "Moebius mu", "mu", 
      "multiplicative order", "next prime", "norm of algebraic number", 
      "number conversion", "number field discriminant", 
      "number of partitions", "number reconstruction", "octal digits", 
      "one-origin arrays", "ones", "Order", "origin", "padding", "partitions",
       "Pollard algorithm", "population count", "power mod", "power mod list",
       "power of a prime", "powers in finite fields", 
      "powers representations", "primality testing", "prime", 
      "prime counting function", "prime factors", "prime pi", "prime power", 
      "primes", "primitive root", "pseudoprime test", "radix conversion", 
      "Ramanujan L function", "Ramanujan tau", 
      "Ramanujan tau-Dirichlet series", "Ramanujan tau function", 
      "Ramanujan tau L-function", "Ramanujan tau L-series", 
      "Ramanujan tau theta", "Ramanujan Tau Theta function", 
      "Ramanujan Tau Z function", "reconstruction of numbers", 
      "relative primality", "rem", "remainder", "Riemann hypothesis", 
      "Riemann-Siegel", "Riemann Siegel", "Riemann-Siegel formula", 
      "Riemann-Siegel theta", "Riemann Siegel theta", "Riemann zeta function",
       "Roman numerals", "Root", "ruler function", "sigma", 
      "smallest universal exponent", "square free", "square-free integers", 
      "square-free polynomials", "Stirling1", "Stirling2", 
      "Stirling number of the 1st kind", "Stirling number of the 2nd kind", 
      "Stirling number of the first kind", 
      "Stirling number of the second kind", "Stirling numbers", 
      "Stirling numbers S1", "Stirling numbers S2", "Stirling s1", 
      "Stirling s2", "submultiples", "sum of powers", "sum of squares", 
      "sums of reciprocal powers", "ternary digits", 
      "testing for primality of integers", "testing for prime", "theta1", 
      "theta2", "theta3", "theta4", "theta functions", "totient function", 
      "universal exponent", "zero-origin arrays", "zeros", "zeta function", 
      "zeta function root", "zeta zero"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica contains the world's largest collection of number theoretic \
functions, many based on specially developed algorithms. ", "synonyms" -> {}, 
    "title" -> "Number Theoretic Functions", "type" -> "Guide", "uri" -> 
    "guide/NumberTheoreticFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 64, 1, 70, "GuideTitle",
 CellID->20308],
Cell[686, 28, 225, 6, 70, "GuideAbstract",
 CellID->12157],
Cell[CellGroupData[{
Cell[936, 38, 226, 6, 70, "GuideFunctionsSubsection",
 CellID->4074],
Cell[1165, 46, 367, 14, 70, "GuideText",
 CellID->4346],
Cell[1535, 62, 234, 8, 70, "GuideText",
 CellID->13837],
Cell[1772, 72, 1303, 35, 70, "InlineGuideFunctionListing",
 CellID->1981]
}, Open  ]],
Cell[CellGroupData[{
Cell[3112, 112, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->25318],
Cell[3188, 115, 260, 8, 70, "GuideText",
 CellID->26611],
Cell[3451, 125, 697, 17, 70, "InlineGuideFunctionListing",
 CellID->91039275]
}, Open  ]],
Cell[CellGroupData[{
Cell[4185, 147, 64, 1, 70, "GuideFunctionsSubsection",
 CellID->16292],
Cell[4252, 150, 1294, 35, 70, "InlineGuideFunctionListing",
 CellID->17591],
Cell[5549, 187, 976, 26, 70, "InlineGuideFunctionListing",
 CellID->3832]
}, Open  ]],
Cell[CellGroupData[{
Cell[6562, 218, 63, 1, 70, "GuideFunctionsSubsection",
 CellID->27123],
Cell[6628, 221, 1928, 50, 70, "InlineGuideFunctionListing",
 CellID->6461]
}, Open  ]],
Cell[CellGroupData[{
Cell[8593, 276, 60, 1, 70, "GuideFunctionsSubsection",
 CellID->16991],
Cell[8656, 279, 832, 23, 70, "InlineGuideFunctionListing",
 CellID->31461]
}, Open  ]],
Cell[CellGroupData[{
Cell[9525, 307, 62, 1, 70, "GuideFunctionsSubsection",
 CellID->27330],
Cell[9590, 310, 1699, 44, 70, "InlineGuideFunctionListing",
 CellID->28498]
}, Open  ]],
Cell[CellGroupData[{
Cell[11326, 359, 89, 1, 70, "GuideFunctionsSubsection",
 CellID->498607189],
Cell[11418, 362, 929, 23, 70, "InlineGuideFunctionListing",
 CellID->45394729]
}, Open  ]],
Cell[CellGroupData[{
Cell[12384, 390, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->17369],
Cell[12604, 397, 840, 23, 70, "InlineGuideFunctionListing",
 CellID->17291]
}, Open  ]],
Cell[CellGroupData[{
Cell[13481, 425, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->67778232],
Cell[13561, 428, 835, 23, 70, "InlineGuideFunctionListing",
 CellID->77796261],
Cell[14399, 453, 1438, 35, 70, "InlineGuideFunctionListing",
 CellID->292546494]
}, Open  ]],
Cell[CellGroupData[{
Cell[15874, 493, 231, 5, 70, "GuideFunctionsSubsection",
 CellID->27146498],
Cell[16108, 500, 956, 23, 70, "InlineGuideFunctionListing",
 CellID->375456109]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17113, 529, 57, 1, 70, "GuideTutorialsSection",
 CellID->8400],
Cell[17173, 532, 194, 4, 70, "GuideTutorial",
 CellID->14179],
Cell[17370, 538, 160, 3, 70, "GuideTutorial",
 CellID->24117],
Cell[17533, 543, 152, 3, 70, "GuideTutorial",
 CellID->226071423]
}, Open  ]],
Cell[CellGroupData[{
Cell[17722, 551, 58, 1, 70, "GuideMoreAboutSection",
 CellID->2317],
Cell[17783, 554, 138, 3, 70, "GuideMoreAbout",
 CellID->19914],
Cell[17924, 559, 145, 3, 70, "GuideMoreAbout",
 CellID->1595],
Cell[18072, 564, 167, 3, 70, "GuideMoreAboutSub",
 CellID->5936],
Cell[18242, 569, 164, 3, 70, "GuideMoreAboutSub",
 CellID->21867],
Cell[18409, 574, 161, 3, 70, "GuideMoreAboutSub",
 CellID->202435821],
Cell[18573, 579, 183, 4, 70, "GuideMoreAboutSub",
 CellID->22926366],
Cell[18759, 585, 203, 4, 70, "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],
Cell[CellGroupData[{
Cell[18999, 594, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->200610818],
Cell[19071, 597, 1272, 25, 70, "GuideRelatedLinks",
 CellID->25464186]
}, Open  ]],
Cell[20358, 625, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

