(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24794,        723]
NotebookOptionsPosition[     17241,        549]
NotebookOutlinePosition[     21893,        630]
CellTagsIndexPosition[     21850,        627]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Numerical Data", "GuideTitle",
 CellID->16586],

Cell[TextData[{
 "Huge numerical datasets are routine for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Its powerful array primitives make large-scale array manipulation both \
easy to specify and highly efficient. And its integrated collection of \
state-of-the-art algorithms make a broad range of sophisticated data analysis \
immediately accessible. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic architecture gives a new level of flexibility in representing \
results in forms that can be used for further computation."
}], "GuideAbstract",
 CellID->75823573],

Cell[CellGroupData[{

Cell["Basic Operations", "GuideFunctionsSubsection",
 CellID->107401972],

Cell[TextData[{
 Cell[TextData[ButtonBox["Min",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Min"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Max",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Max"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Total",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Total"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Accumulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Accumulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Differences",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Differences"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->8388],

Cell[TextData[{
 Cell[TextData[ButtonBox["Take",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Take"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Count",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Count"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Select",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Select"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sort"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SortBy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SortBy"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Union",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Union"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->26610],

Cell["\t", "GuideDelimiterSubsection",
 CellID->201491804]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Statistics \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Statistics"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->18718],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mean",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mean"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Variance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Variance"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StandardDeviation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StandardDeviation"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Median",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Median"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quantile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Quantile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Covariance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Covariance"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Statistics"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26919]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Curve Fitting & Approximate Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->83747156],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindFit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindFit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Fit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Interpolation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interpolation"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CurveFittingAndApproximateFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->14609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Transforms and Smoothing \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DataTransformsAndSmoothing"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->22716],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rescale",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rescale"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListConvolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListConvolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Fourier",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fourier"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6300]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Exploratory Data Analysis \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DataClassification"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->28119],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataClassification"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21479],

Cell["\t", "GuideDelimiterSubsection",
 CellID->181436894]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tabular Layout", "GuideFunctionsSubsection",
 CellID->21396],

Cell[TextData[{
 Cell[TextData[ButtonBox["Grid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Grid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Column",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Column"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Row",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Row"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->16853]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Data Visualization \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DataVisualization"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->11458],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListPlot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot3D"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListContourPlot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArrayPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayPlot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataVisualization"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->20830],

Cell["\t", "GuideDelimiterSubsection",
 CellID->43329300]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Import & Export \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ImportingAndExporting"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->24593],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->30806],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Table\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Table"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"CSV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CSV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"TSV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TSV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"XLS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XLS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"HDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"HTML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HTML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"GIF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GIF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"WAV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WAV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ImportingAndExporting"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->56395184]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->14854],

Cell[TextData[ButtonBox["Manipulating Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingNumericalData"]], "GuideTutorial",
 CellID->47245040],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "GuideTutorial",
 CellID->90757774],

Cell[TextData[ButtonBox["Approximate Functions and Interpolation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApproximateFunctionsAndInterpolation"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Convolutions and Correlations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConvolutionsAndCorrelations"]], "GuideTutorial",\

 CellID->48047092],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "GuideTutorial",\

 CellID->59433604]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->12294],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "GuideMoreAbout",
 CellID->128597556],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "GuideMoreAbout",
 CellID->12054],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "GuideMoreAbout",
 CellID->26333],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "GuideMoreAboutSub",
 CellID->4229],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "GuideMoreAbout",
 CellID->266856104],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60VisualizationAndGraphics"]], "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 25.3928260}", "context" -> "", 
    "keywords" -> {
     "2D layout", "2nd quartile", "50th percentile", "agglomeration", 
      "approximate formulas", "approximation of functions", "arrange", 
      "array", "array plot", "arrays", "ascending order", "average", "avg", 
      "banded matrices", "bezier curve", "bilinear interpolation", 
      "bin counts", "binning", "bits", "block matrices", "b-spline", 
      "b spline", "canonical order", "category counts", "CDF", "census", 
      "central value", "chi squared", "choose elements", 
      "circulant matrix multiplication", "cluster", "cluster analysis", 
      "clustering", "clustering of data", "column sum", "combining lists", 
      "comma-separated values", "compress in APL", "confidence intervals", 
      "conversions", "converting", "convolutions", "Cooley-Tukey transform", 
      "criteria", "CSV format", "cubic spline", "curve fitting", "curves", 
      "data", "data filter", "data filtering", "data smoother", 
      "data smoothing", "deciles", "decreasing order", "density estimation", 
      "descending order", "discard list elements", 
      "discrete Fourier transform", "dispersion", 
      "distinct elements in lists", "elements", "empirical distribution", 
      "Excel format", "expectation", "expected value", "ExpressionML", 
      "external data", "extrapolation", "FFT", "filtering", "filtering lists",
       "filter taps", "find clusters", "find fit", 
      "finding maximal element in lists", "finite difference methods", 
      "finite impulse response filter", "FIR filter", "FIR filters", 
      "first occurrence", "fitting curves", "fitting differential equations", 
      "fitting of data", "fitting surfaces", "Fourier transforms", 
      "frequencies", "frequency spectrum", "gather", "grade in APL", 
      "highest", "histogram", "increasing order", "infimum", "interp", 
      "interpolate data", "interpolate equation", "interpolate formula", 
      "interpolate numbers", "interpolate table", "interquartile range", 
      "inverse CDF", "kernel", "largest", "least-squares fits", "linear fits",
       "linear interpolation", "linear moving average", "list convolve", 
      "lists ordering", "location", "lowest", "MA", "matrices", 
      "maximal element", "maximum", "mean", "median", "min", 
      "minimal element", "minimum", "models", "moving average", "moving mean",
       "multiplicities", "mu operator", "nonlinear fitting", 
      "number of occurrences", "order statistics", "partitioning of data", 
      "percentiles", "picking elements of lists", "polynomial fit", 
      "power spectrum", "quantile", "quartiles", "range counts", 
      "remove duplicates", "residuals", "row sum", 
      "sample standard deviation", "sample variance", "segments of lists", 
      "sequence of elements", "signal processing", "simple moving average", 
      "SMA", "smallest", "smoothing", "splines", "spread", 
      "standard deviation", "standard error", "stride", 
      "sum of array elements", "sum of list", "tab-delimited data", "table", 
      "tables", "tabular data", "tabular layout", "tabulation", "tally", 
      "testing models", "time series", "Toeplitz matrix multiplication", 
      "total of list", "trend line", "VAR", "variance", 
      "Weibull quantile method", "weighted moving average"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Huge numerical datasets are routine for Mathematica. Its powerful array \
primitives make large-scale array manipulation both easy to specify and \
highly efficient. And its integrated collection of state-of-the-art \
algorithms make a broad range of sophisticated data analysis immediately \
accessible. Mathematica's symbolic architecture gives a new level of \
flexibility in representing results in forms that can be used for further \
computation.", "synonyms" -> {}, "title" -> "Numerical Data", "type" -> 
    "Guide", "uri" -> "guide/NumericalData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 52, 1, 70, "GuideTitle",
 CellID->16586],
Cell[674, 28, 593, 13, 70, "GuideAbstract",
 CellID->75823573],
Cell[CellGroupData[{
Cell[1292, 45, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->107401972],
Cell[1367, 48, 1289, 35, 70, "InlineGuideFunctionListing",
 CellID->8388],
Cell[2659, 85, 1535, 44, 70, "InlineGuideFunctionListing",
 CellID->26610],
Cell[4197, 131, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->201491804]
}, Open  ]],
Cell[CellGroupData[{
Cell[4292, 137, 204, 5, 70, "GuideFunctionsSubsection",
 CellID->18718],
Cell[4499, 144, 1441, 41, 70, "InlineGuideFunctionListing",
 CellID->26919]
}, Open  ]],
Cell[CellGroupData[{
Cell[5977, 190, 261, 6, 70, "GuideFunctionsSubsection",
 CellID->83747156],
Cell[6241, 198, 833, 24, 70, "InlineGuideFunctionListing",
 CellID->14609]
}, Open  ]],
Cell[CellGroupData[{
Cell[7111, 227, 236, 6, 70, "GuideFunctionsSubsection",
 CellID->22716],
Cell[7350, 235, 1192, 33, 70, "InlineGuideFunctionListing",
 CellID->6300]
}, Open  ]],
Cell[CellGroupData[{
Cell[8579, 273, 229, 6, 70, "GuideFunctionsSubsection",
 CellID->28119],
Cell[8811, 281, 1258, 32, 70, "InlineGuideFunctionListing",
 CellID->21479],
Cell[10072, 315, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->181436894]
}, Open  ]],
Cell[CellGroupData[{
Cell[10167, 321, 66, 1, 70, "GuideFunctionsSubsection",
 CellID->21396],
Cell[10236, 324, 1013, 26, 70, "InlineGuideFunctionListing",
 CellID->16853]
}, Open  ]],
Cell[CellGroupData[{
Cell[11286, 355, 219, 5, 70, "GuideFunctionsSubsection",
 CellID->11458],
Cell[11508, 362, 1042, 29, 70, "InlineGuideFunctionListing",
 CellID->20830],
Cell[12553, 393, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->43329300]
}, Open  ]],
Cell[CellGroupData[{
Cell[12647, 399, 220, 5, 70, "GuideFunctionsSubsection",
 CellID->24593],
Cell[12870, 406, 384, 11, 70, "InlineGuideFunctionListing",
 CellID->30806],
Cell[13257, 419, 1875, 53, 70, "InlineGuideFunctionListing",
 CellID->56395184]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15181, 478, 58, 1, 70, "GuideTutorialsSection",
 CellID->14854],
Cell[15242, 481, 170, 3, 70, "GuideTutorial",
 CellID->47245040],
Cell[15415, 486, 155, 3, 70, "GuideTutorial",
 CellID->90757774],
Cell[15573, 491, 198, 4, 70, "GuideTutorial",
 CellID->1885805579],
Cell[15774, 497, 176, 4, 70, "GuideTutorial",
 CellID->48047092],
Cell[15953, 503, 179, 4, 70, "GuideTutorial",
 CellID->59433604]
}, Open  ]],
Cell[CellGroupData[{
Cell[16169, 512, 59, 1, 70, "GuideMoreAboutSection",
 CellID->12294],
Cell[16231, 515, 162, 3, 70, "GuideMoreAbout",
 CellID->128597556],
Cell[16396, 520, 146, 3, 70, "GuideMoreAbout",
 CellID->12054],
Cell[16545, 525, 133, 3, 70, "GuideMoreAbout",
 CellID->26333],
Cell[16681, 530, 145, 3, 70, "GuideMoreAboutSub",
 CellID->4229],
Cell[16829, 535, 180, 3, 70, "GuideMoreAbout",
 CellID->266856104],
Cell[17012, 540, 187, 4, 70, "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],
Cell[17214, 547, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

